/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;

/**
 * The extended model base implementation for the UserGroupGroupRole service. Represents a row in the &quot;UserGroupGroupRole&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserGroupGroupRoleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserGroupGroupRoleImpl
 * @see UserGroupGroupRole
 * @generated
 */
public abstract class UserGroupGroupRoleBaseImpl
	extends UserGroupGroupRoleModelImpl implements UserGroupGroupRole {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user group group role model instance should use the <code>UserGroupGroupRole</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			UserGroupGroupRoleLocalServiceUtil.addUserGroupGroupRole(this);
		}
		else {
			UserGroupGroupRoleLocalServiceUtil.updateUserGroupGroupRole(this);
		}
	}

}