/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.UserIdMapper;
import com.liferay.portal.kernel.service.UserIdMapperLocalServiceUtil;

/**
 * The extended model base implementation for the UserIdMapper service. Represents a row in the &quot;UserIdMapper&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserIdMapperImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserIdMapperImpl
 * @see UserIdMapper
 * @generated
 */
public abstract class UserIdMapperBaseImpl
	extends UserIdMapperModelImpl implements UserIdMapper {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user ID mapper model instance should use the <code>UserIdMapper</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			UserIdMapperLocalServiceUtil.addUserIdMapper(this);
		}
		else {
			UserIdMapperLocalServiceUtil.updateUserIdMapper(this);
		}
	}

}