/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.security.auth.ScreenNameValidator;
import com.liferay.portal.kernel.util.ServiceProxyFactory;

/**
 * @author Brian Wing Shun Chan
 * @author Shuyang Zhou
 * @author Peter Fellwock
 */
public class ScreenNameValidatorFactory {

	public static ScreenNameValidator getInstance() {
		return _screenNameValidator;
	}

	private ScreenNameValidatorFactory() {
	}

	private static volatile ScreenNameValidator _screenNameValidator =
		ServiceProxyFactory.newServiceTrackedInstance(
			ScreenNameValidator.class, ScreenNameValidatorFactory.class,
			"_screenNameValidator", false, true);

}