/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.social.model.impl;

import com.liferay.social.kernel.model.SocialRelation;
import com.liferay.social.kernel.service.SocialRelationLocalServiceUtil;

/**
 * The extended model base implementation for the SocialRelation service. Represents a row in the &quot;SocialRelation&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SocialRelationImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialRelationImpl
 * @see SocialRelation
 * @generated
 */
public abstract class SocialRelationBaseImpl
	extends SocialRelationModelImpl implements SocialRelation {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a social relation model instance should use the <code>SocialRelation</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SocialRelationLocalServiceUtil.addSocialRelation(this);
		}
		else {
			SocialRelationLocalServiceUtil.updateSocialRelation(this);
		}
	}

}