/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.translation.translator;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * @author Adolfo Pérez
 */
@ProviderType
public interface TranslatorPacket {

	public long getCompanyId();

	public Map<String, String> getFieldsMap();

	public Map<String, Boolean> getHTMLMap();

	public String getSourceLanguageId();

	public String getTargetLanguageId();

}