package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkPolicyPortBuilder extends io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>{
  public NetworkPolicyPortBuilder() {
    this(false);
  }
  public NetworkPolicyPortBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndPort(instance.getEndPort()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance) {
    this(instance,false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndPort(instance.getEndPort()); 
    this.withPort(instance.getPort()); 
    this.withProtocol(instance.getProtocol()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort build() {
    NetworkPolicyPort buildable = new NetworkPolicyPort(fluent.getEndPort(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyPortBuilder that = (NetworkPolicyPortBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}