/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.adaptive.media.handler;

import com.liferay.adaptive.media.AdaptiveMedia;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/**
 * Handles upcoming requests for a particular kind of media (i.e., media
 * generated by one type of processor).
 *
 * @author Adolfo Pérez
 */
public interface AMRequestHandler<T> {

	/**
	 * Returns the requested {@link AdaptiveMedia} instance. If no media is found matching the request, or an
	 * application error is raised while fetching the media, a null value is
	 * returned.
	 *
	 * @param  httpServletRequest the request to process
	 * @return a {@link AdaptiveMedia} instance or null.
	 * @throws IOException if an IO error occurred while processing the request
	 * @throws ServletException if any other processing error occurred
	 */
	public AdaptiveMedia<T> handleRequest(HttpServletRequest httpServletRequest)
		throws IOException, ServletException;

}