/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.asset.kernel.service;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.List;

/**
 * Provides the remote service utility for AssetEntry. This utility wraps
 * <code>com.liferay.portlet.asset.service.impl.AssetEntryServiceImpl</code> and is an
 * access point for service operations in application layer code running on a
 * remote server. Methods of this service are expected to have security checks
 * based on the propagated JAAS credentials because this service can be
 * accessed remotely.
 *
 * @author Brian Wing Shun Chan
 * @see AssetEntryService
 * @generated
 */
public class AssetEntryServiceUtil {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to <code>com.liferay.portlet.asset.service.impl.AssetEntryServiceImpl</code> and rerun ServiceBuilder to regenerate this class.
	 */
	public static AssetEntry fetchEntry(long entryId) throws PortalException {
		return getService().fetchEntry(entryId);
	}

	public static List<AssetEntry> getCompanyEntries(
		long companyId, int start, int end) {

		return getService().getCompanyEntries(companyId, start, end);
	}

	public static int getCompanyEntriesCount(long companyId) {
		return getService().getCompanyEntriesCount(companyId);
	}

	public static List<AssetEntry> getEntries(
			com.liferay.asset.kernel.service.persistence.AssetEntryQuery
				entryQuery)
		throws PortalException {

		return getService().getEntries(entryQuery);
	}

	public static int getEntriesCount(
			com.liferay.asset.kernel.service.persistence.AssetEntryQuery
				entryQuery)
		throws PortalException {

		return getService().getEntriesCount(entryQuery);
	}

	public static AssetEntry getEntry(long entryId) throws PortalException {
		return getService().getEntry(entryId);
	}

	public static AssetEntry getEntry(String className, long classPK)
		throws PortalException {

		return getService().getEntry(className, classPK);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	public static String getOSGiServiceIdentifier() {
		return getService().getOSGiServiceIdentifier();
	}

	public static void incrementViewCounter(AssetEntry assetEntry)
		throws PortalException {

		getService().incrementViewCounter(assetEntry);
	}

	public static AssetEntry incrementViewCounter(
			long companyId, String className, long classPK)
		throws PortalException {

		return getService().incrementViewCounter(companyId, className, classPK);
	}

	public static AssetEntry updateEntry(
			long groupId, java.util.Date createDate,
			java.util.Date modifiedDate, String className, long classPK,
			String classUuid, long classTypeId, long[] categoryIds,
			String[] tagNames, boolean listable, boolean visible,
			java.util.Date startDate, java.util.Date endDate,
			java.util.Date publishDate, java.util.Date expirationDate,
			String mimeType, String title, String description, String summary,
			String url, String layoutUuid, int height, int width,
			Double priority)
		throws PortalException {

		return getService().updateEntry(
			groupId, createDate, modifiedDate, className, classPK, classUuid,
			classTypeId, categoryIds, tagNames, listable, visible, startDate,
			endDate, publishDate, expirationDate, mimeType, title, description,
			summary, url, layoutUuid, height, width, priority);
	}

	public static AssetEntryService getService() {
		return _service;
	}

	public static void setService(AssetEntryService service) {
		_service = service;
	}

	private static volatile AssetEntryService _service;

}