/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.batch.planner.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the BatchPlannerPolicy service. Represents a row in the &quot;BatchPlannerPolicy&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.batch.planner.model.impl.BatchPlannerPolicyModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.batch.planner.model.impl.BatchPlannerPolicyImpl</code>.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerPolicy
 * @generated
 */
@ProviderType
public interface BatchPlannerPolicyModel
	extends AuditedModel, BaseModel<BatchPlannerPolicy>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a batch planner policy model instance should use the {@link BatchPlannerPolicy} interface instead.
	 */

	/**
	 * Returns the primary key of this batch planner policy.
	 *
	 * @return the primary key of this batch planner policy
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this batch planner policy.
	 *
	 * @param primaryKey the primary key of this batch planner policy
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this batch planner policy.
	 *
	 * @return the mvcc version of this batch planner policy
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this batch planner policy.
	 *
	 * @param mvccVersion the mvcc version of this batch planner policy
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the batch planner policy ID of this batch planner policy.
	 *
	 * @return the batch planner policy ID of this batch planner policy
	 */
	public long getBatchPlannerPolicyId();

	/**
	 * Sets the batch planner policy ID of this batch planner policy.
	 *
	 * @param batchPlannerPolicyId the batch planner policy ID of this batch planner policy
	 */
	public void setBatchPlannerPolicyId(long batchPlannerPolicyId);

	/**
	 * Returns the company ID of this batch planner policy.
	 *
	 * @return the company ID of this batch planner policy
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this batch planner policy.
	 *
	 * @param companyId the company ID of this batch planner policy
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this batch planner policy.
	 *
	 * @return the user ID of this batch planner policy
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this batch planner policy.
	 *
	 * @param userId the user ID of this batch planner policy
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this batch planner policy.
	 *
	 * @return the user uuid of this batch planner policy
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this batch planner policy.
	 *
	 * @param userUuid the user uuid of this batch planner policy
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this batch planner policy.
	 *
	 * @return the user name of this batch planner policy
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this batch planner policy.
	 *
	 * @param userName the user name of this batch planner policy
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this batch planner policy.
	 *
	 * @return the create date of this batch planner policy
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this batch planner policy.
	 *
	 * @param createDate the create date of this batch planner policy
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this batch planner policy.
	 *
	 * @return the modified date of this batch planner policy
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this batch planner policy.
	 *
	 * @param modifiedDate the modified date of this batch planner policy
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the batch planner plan ID of this batch planner policy.
	 *
	 * @return the batch planner plan ID of this batch planner policy
	 */
	public long getBatchPlannerPlanId();

	/**
	 * Sets the batch planner plan ID of this batch planner policy.
	 *
	 * @param batchPlannerPlanId the batch planner plan ID of this batch planner policy
	 */
	public void setBatchPlannerPlanId(long batchPlannerPlanId);

	/**
	 * Returns the name of this batch planner policy.
	 *
	 * @return the name of this batch planner policy
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this batch planner policy.
	 *
	 * @param name the name of this batch planner policy
	 */
	public void setName(String name);

	/**
	 * Returns the value of this batch planner policy.
	 *
	 * @return the value of this batch planner policy
	 */
	@AutoEscape
	public String getValue();

	/**
	 * Sets the value of this batch planner policy.
	 *
	 * @param value the value of this batch planner policy
	 */
	public void setValue(String value);

	@Override
	public BatchPlannerPolicy cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}