/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTRemote service. Represents a row in the &quot;CTRemote&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.model.impl.CTRemoteModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.model.impl.CTRemoteImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTRemote
 * @generated
 */
@ProviderType
public interface CTRemoteModel
	extends BaseModel<CTRemote>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ct remote model instance should use the {@link CTRemote} interface instead.
	 */

	/**
	 * Returns the primary key of this ct remote.
	 *
	 * @return the primary key of this ct remote
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ct remote.
	 *
	 * @param primaryKey the primary key of this ct remote
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ct remote.
	 *
	 * @return the mvcc version of this ct remote
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ct remote.
	 *
	 * @param mvccVersion the mvcc version of this ct remote
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct remote ID of this ct remote.
	 *
	 * @return the ct remote ID of this ct remote
	 */
	public long getCtRemoteId();

	/**
	 * Sets the ct remote ID of this ct remote.
	 *
	 * @param ctRemoteId the ct remote ID of this ct remote
	 */
	public void setCtRemoteId(long ctRemoteId);

	/**
	 * Returns the company ID of this ct remote.
	 *
	 * @return the company ID of this ct remote
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ct remote.
	 *
	 * @param companyId the company ID of this ct remote
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this ct remote.
	 *
	 * @return the user ID of this ct remote
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this ct remote.
	 *
	 * @param userId the user ID of this ct remote
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this ct remote.
	 *
	 * @return the user uuid of this ct remote
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this ct remote.
	 *
	 * @param userUuid the user uuid of this ct remote
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this ct remote.
	 *
	 * @return the create date of this ct remote
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this ct remote.
	 *
	 * @param createDate the create date of this ct remote
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this ct remote.
	 *
	 * @return the modified date of this ct remote
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this ct remote.
	 *
	 * @param modifiedDate the modified date of this ct remote
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the name of this ct remote.
	 *
	 * @return the name of this ct remote
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this ct remote.
	 *
	 * @param name the name of this ct remote
	 */
	public void setName(String name);

	/**
	 * Returns the description of this ct remote.
	 *
	 * @return the description of this ct remote
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this ct remote.
	 *
	 * @param description the description of this ct remote
	 */
	public void setDescription(String description);

	/**
	 * Returns the url of this ct remote.
	 *
	 * @return the url of this ct remote
	 */
	@AutoEscape
	public String getUrl();

	/**
	 * Sets the url of this ct remote.
	 *
	 * @param url the url of this ct remote
	 */
	public void setUrl(String url);

	/**
	 * Returns the client ID of this ct remote.
	 *
	 * @return the client ID of this ct remote
	 */
	@AutoEscape
	public String getClientId();

	/**
	 * Sets the client ID of this ct remote.
	 *
	 * @param clientId the client ID of this ct remote
	 */
	public void setClientId(String clientId);

	/**
	 * Returns the client secret of this ct remote.
	 *
	 * @return the client secret of this ct remote
	 */
	@AutoEscape
	public String getClientSecret();

	/**
	 * Sets the client secret of this ct remote.
	 *
	 * @param clientSecret the client secret of this ct remote
	 */
	public void setClientSecret(String clientSecret);

	@Override
	public CTRemote cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}