/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.io.Serializable;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTSchemaVersion service. Represents a row in the &quot;CTSchemaVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.model.impl.CTSchemaVersionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.model.impl.CTSchemaVersionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTSchemaVersion
 * @generated
 */
@ProviderType
public interface CTSchemaVersionModel
	extends BaseModel<CTSchemaVersion>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ct schema version model instance should use the {@link CTSchemaVersion} interface instead.
	 */

	/**
	 * Returns the primary key of this ct schema version.
	 *
	 * @return the primary key of this ct schema version
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ct schema version.
	 *
	 * @param primaryKey the primary key of this ct schema version
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ct schema version.
	 *
	 * @return the mvcc version of this ct schema version
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ct schema version.
	 *
	 * @param mvccVersion the mvcc version of this ct schema version
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the schema version ID of this ct schema version.
	 *
	 * @return the schema version ID of this ct schema version
	 */
	public long getSchemaVersionId();

	/**
	 * Sets the schema version ID of this ct schema version.
	 *
	 * @param schemaVersionId the schema version ID of this ct schema version
	 */
	public void setSchemaVersionId(long schemaVersionId);

	/**
	 * Returns the company ID of this ct schema version.
	 *
	 * @return the company ID of this ct schema version
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ct schema version.
	 *
	 * @param companyId the company ID of this ct schema version
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the schema context of this ct schema version.
	 *
	 * @return the schema context of this ct schema version
	 */
	public Map<String, Serializable> getSchemaContext();

	/**
	 * Sets the schema context of this ct schema version.
	 *
	 * @param schemaContext the schema context of this ct schema version
	 */
	public void setSchemaContext(Map<String, Serializable> schemaContext);

	@Override
	public CTSchemaVersion cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}