/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the CommerceShippingOptionAccountEntryRel service. Represents a row in the &quot;CSOptionAccountEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingOptionAccountEntryRelModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelImpl"
)
@ProviderType
public interface CommerceShippingOptionAccountEntryRel
	extends CommerceShippingOptionAccountEntryRelModel, PersistedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<CommerceShippingOptionAccountEntryRel, Long>
		COMMERCE_SHIPPING_OPTION_ACCOUNT_ENTRY_REL_ID_ACCESSOR =
			new Accessor<CommerceShippingOptionAccountEntryRel, Long>() {

				@Override
				public Long get(
					CommerceShippingOptionAccountEntryRel
						commerceShippingOptionAccountEntryRel) {

					return commerceShippingOptionAccountEntryRel.
						getCommerceShippingOptionAccountEntryRelId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<CommerceShippingOptionAccountEntryRel>
					getTypeClass() {

					return CommerceShippingOptionAccountEntryRel.class;
				}

			};

}