/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.product.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.math.BigDecimal;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPInstanceUnitOfMeasure service. Represents a row in the &quot;CPInstanceUOM&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.model.impl.CPInstanceUnitOfMeasureModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.model.impl.CPInstanceUnitOfMeasureImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CPInstanceUnitOfMeasure
 * @generated
 */
@ProviderType
public interface CPInstanceUnitOfMeasureModel
	extends BaseModel<CPInstanceUnitOfMeasure>,
			CTModel<CPInstanceUnitOfMeasure>, LocalizedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp instance unit of measure model instance should use the {@link CPInstanceUnitOfMeasure} interface instead.
	 */

	/**
	 * Returns the primary key of this cp instance unit of measure.
	 *
	 * @return the primary key of this cp instance unit of measure
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp instance unit of measure.
	 *
	 * @param primaryKey the primary key of this cp instance unit of measure
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this cp instance unit of measure.
	 *
	 * @return the mvcc version of this cp instance unit of measure
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this cp instance unit of measure.
	 *
	 * @param mvccVersion the mvcc version of this cp instance unit of measure
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this cp instance unit of measure.
	 *
	 * @return the ct collection ID of this cp instance unit of measure
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this cp instance unit of measure.
	 *
	 * @param ctCollectionId the ct collection ID of this cp instance unit of measure
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this cp instance unit of measure.
	 *
	 * @return the uuid of this cp instance unit of measure
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cp instance unit of measure.
	 *
	 * @param uuid the uuid of this cp instance unit of measure
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cp instance unit of measure ID of this cp instance unit of measure.
	 *
	 * @return the cp instance unit of measure ID of this cp instance unit of measure
	 */
	public long getCPInstanceUnitOfMeasureId();

	/**
	 * Sets the cp instance unit of measure ID of this cp instance unit of measure.
	 *
	 * @param CPInstanceUnitOfMeasureId the cp instance unit of measure ID of this cp instance unit of measure
	 */
	public void setCPInstanceUnitOfMeasureId(long CPInstanceUnitOfMeasureId);

	/**
	 * Returns the company ID of this cp instance unit of measure.
	 *
	 * @return the company ID of this cp instance unit of measure
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp instance unit of measure.
	 *
	 * @param companyId the company ID of this cp instance unit of measure
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp instance unit of measure.
	 *
	 * @return the user ID of this cp instance unit of measure
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp instance unit of measure.
	 *
	 * @param userId the user ID of this cp instance unit of measure
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp instance unit of measure.
	 *
	 * @return the user uuid of this cp instance unit of measure
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp instance unit of measure.
	 *
	 * @param userUuid the user uuid of this cp instance unit of measure
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp instance unit of measure.
	 *
	 * @return the user name of this cp instance unit of measure
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp instance unit of measure.
	 *
	 * @param userName the user name of this cp instance unit of measure
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp instance unit of measure.
	 *
	 * @return the create date of this cp instance unit of measure
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp instance unit of measure.
	 *
	 * @param createDate the create date of this cp instance unit of measure
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp instance unit of measure.
	 *
	 * @return the modified date of this cp instance unit of measure
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp instance unit of measure.
	 *
	 * @param modifiedDate the modified date of this cp instance unit of measure
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp instance ID of this cp instance unit of measure.
	 *
	 * @return the cp instance ID of this cp instance unit of measure
	 */
	public long getCPInstanceId();

	/**
	 * Sets the cp instance ID of this cp instance unit of measure.
	 *
	 * @param CPInstanceId the cp instance ID of this cp instance unit of measure
	 */
	public void setCPInstanceId(long CPInstanceId);

	/**
	 * Returns the active of this cp instance unit of measure.
	 *
	 * @return the active of this cp instance unit of measure
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this cp instance unit of measure is active.
	 *
	 * @return <code>true</code> if this cp instance unit of measure is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this cp instance unit of measure is active.
	 *
	 * @param active the active of this cp instance unit of measure
	 */
	public void setActive(boolean active);

	/**
	 * Returns the incremental order quantity of this cp instance unit of measure.
	 *
	 * @return the incremental order quantity of this cp instance unit of measure
	 */
	public BigDecimal getIncrementalOrderQuantity();

	/**
	 * Sets the incremental order quantity of this cp instance unit of measure.
	 *
	 * @param incrementalOrderQuantity the incremental order quantity of this cp instance unit of measure
	 */
	public void setIncrementalOrderQuantity(
		BigDecimal incrementalOrderQuantity);

	/**
	 * Returns the key of this cp instance unit of measure.
	 *
	 * @return the key of this cp instance unit of measure
	 */
	@AutoEscape
	public String getKey();

	/**
	 * Sets the key of this cp instance unit of measure.
	 *
	 * @param key the key of this cp instance unit of measure
	 */
	public void setKey(String key);

	/**
	 * Returns the name of this cp instance unit of measure.
	 *
	 * @return the name of this cp instance unit of measure
	 */
	public String getName();

	/**
	 * Returns the localized name of this cp instance unit of measure in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this cp instance unit of measure
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this cp instance unit of measure in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this cp instance unit of measure. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this cp instance unit of measure in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this cp instance unit of measure
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this cp instance unit of measure in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this cp instance unit of measure
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this cp instance unit of measure.
	 *
	 * @return the locales and localized names of this cp instance unit of measure
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this cp instance unit of measure.
	 *
	 * @param name the name of this cp instance unit of measure
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this cp instance unit of measure in the language.
	 *
	 * @param name the localized name of this cp instance unit of measure
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this cp instance unit of measure in the language, and sets the default locale.
	 *
	 * @param name the localized name of this cp instance unit of measure
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this cp instance unit of measure from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this cp instance unit of measure
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this cp instance unit of measure from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this cp instance unit of measure
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	/**
	 * Returns the precision of this cp instance unit of measure.
	 *
	 * @return the precision of this cp instance unit of measure
	 */
	public int getPrecision();

	/**
	 * Sets the precision of this cp instance unit of measure.
	 *
	 * @param precision the precision of this cp instance unit of measure
	 */
	public void setPrecision(int precision);

	/**
	 * Returns the primary of this cp instance unit of measure.
	 *
	 * @return the primary of this cp instance unit of measure
	 */
	public boolean getPrimary();

	/**
	 * Returns <code>true</code> if this cp instance unit of measure is primary.
	 *
	 * @return <code>true</code> if this cp instance unit of measure is primary; <code>false</code> otherwise
	 */
	public boolean isPrimary();

	/**
	 * Sets whether this cp instance unit of measure is primary.
	 *
	 * @param primary the primary of this cp instance unit of measure
	 */
	public void setPrimary(boolean primary);

	/**
	 * Returns the priority of this cp instance unit of measure.
	 *
	 * @return the priority of this cp instance unit of measure
	 */
	public double getPriority();

	/**
	 * Sets the priority of this cp instance unit of measure.
	 *
	 * @param priority the priority of this cp instance unit of measure
	 */
	public void setPriority(double priority);

	/**
	 * Returns the rate of this cp instance unit of measure.
	 *
	 * @return the rate of this cp instance unit of measure
	 */
	public BigDecimal getRate();

	/**
	 * Sets the rate of this cp instance unit of measure.
	 *
	 * @param rate the rate of this cp instance unit of measure
	 */
	public void setRate(BigDecimal rate);

	/**
	 * Returns the sku of this cp instance unit of measure.
	 *
	 * @return the sku of this cp instance unit of measure
	 */
	@AutoEscape
	public String getSku();

	/**
	 * Sets the sku of this cp instance unit of measure.
	 *
	 * @param sku the sku of this cp instance unit of measure
	 */
	public void setSku(String sku);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public CPInstanceUnitOfMeasure cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}