/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.page.template.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LayoutPageTemplateStructure service. Represents a row in the &quot;LayoutPageTemplateStructure&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.layout.page.template.model.impl.LayoutPageTemplateStructureModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.layout.page.template.model.impl.LayoutPageTemplateStructureImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutPageTemplateStructure
 * @generated
 */
@ProviderType
public interface LayoutPageTemplateStructureModel
	extends BaseModel<LayoutPageTemplateStructure>,
			CTModel<LayoutPageTemplateStructure>, GroupedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a layout page template structure model instance should use the {@link LayoutPageTemplateStructure} interface instead.
	 */

	/**
	 * Returns the primary key of this layout page template structure.
	 *
	 * @return the primary key of this layout page template structure
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this layout page template structure.
	 *
	 * @param primaryKey the primary key of this layout page template structure
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this layout page template structure.
	 *
	 * @return the mvcc version of this layout page template structure
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this layout page template structure.
	 *
	 * @param mvccVersion the mvcc version of this layout page template structure
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this layout page template structure.
	 *
	 * @return the ct collection ID of this layout page template structure
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this layout page template structure.
	 *
	 * @param ctCollectionId the ct collection ID of this layout page template structure
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this layout page template structure.
	 *
	 * @return the uuid of this layout page template structure
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this layout page template structure.
	 *
	 * @param uuid the uuid of this layout page template structure
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the layout page template structure ID of this layout page template structure.
	 *
	 * @return the layout page template structure ID of this layout page template structure
	 */
	public long getLayoutPageTemplateStructureId();

	/**
	 * Sets the layout page template structure ID of this layout page template structure.
	 *
	 * @param layoutPageTemplateStructureId the layout page template structure ID of this layout page template structure
	 */
	public void setLayoutPageTemplateStructureId(
		long layoutPageTemplateStructureId);

	/**
	 * Returns the group ID of this layout page template structure.
	 *
	 * @return the group ID of this layout page template structure
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this layout page template structure.
	 *
	 * @param groupId the group ID of this layout page template structure
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this layout page template structure.
	 *
	 * @return the company ID of this layout page template structure
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this layout page template structure.
	 *
	 * @param companyId the company ID of this layout page template structure
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this layout page template structure.
	 *
	 * @return the user ID of this layout page template structure
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this layout page template structure.
	 *
	 * @param userId the user ID of this layout page template structure
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this layout page template structure.
	 *
	 * @return the user uuid of this layout page template structure
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this layout page template structure.
	 *
	 * @param userUuid the user uuid of this layout page template structure
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this layout page template structure.
	 *
	 * @return the user name of this layout page template structure
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this layout page template structure.
	 *
	 * @param userName the user name of this layout page template structure
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this layout page template structure.
	 *
	 * @return the create date of this layout page template structure
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this layout page template structure.
	 *
	 * @param createDate the create date of this layout page template structure
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this layout page template structure.
	 *
	 * @return the modified date of this layout page template structure
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this layout page template structure.
	 *
	 * @param modifiedDate the modified date of this layout page template structure
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the plid of this layout page template structure.
	 *
	 * @return the plid of this layout page template structure
	 */
	public long getPlid();

	/**
	 * Sets the plid of this layout page template structure.
	 *
	 * @param plid the plid of this layout page template structure
	 */
	public void setPlid(long plid);

	@Override
	public LayoutPageTemplateStructure cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}