/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.list.type.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ListTypeDefinition service. Represents a row in the &quot;ListTypeDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.list.type.model.impl.ListTypeDefinitionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.list.type.model.impl.ListTypeDefinitionImpl</code>.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see ListTypeDefinition
 * @generated
 */
@ProviderType
public interface ListTypeDefinitionModel
	extends BaseModel<ListTypeDefinition>, LocalizedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a list type definition model instance should use the {@link ListTypeDefinition} interface instead.
	 */

	/**
	 * Returns the primary key of this list type definition.
	 *
	 * @return the primary key of this list type definition
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this list type definition.
	 *
	 * @param primaryKey the primary key of this list type definition
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this list type definition.
	 *
	 * @return the mvcc version of this list type definition
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this list type definition.
	 *
	 * @param mvccVersion the mvcc version of this list type definition
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this list type definition.
	 *
	 * @return the uuid of this list type definition
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this list type definition.
	 *
	 * @param uuid the uuid of this list type definition
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this list type definition.
	 *
	 * @return the external reference code of this list type definition
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this list type definition.
	 *
	 * @param externalReferenceCode the external reference code of this list type definition
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the list type definition ID of this list type definition.
	 *
	 * @return the list type definition ID of this list type definition
	 */
	public long getListTypeDefinitionId();

	/**
	 * Sets the list type definition ID of this list type definition.
	 *
	 * @param listTypeDefinitionId the list type definition ID of this list type definition
	 */
	public void setListTypeDefinitionId(long listTypeDefinitionId);

	/**
	 * Returns the company ID of this list type definition.
	 *
	 * @return the company ID of this list type definition
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this list type definition.
	 *
	 * @param companyId the company ID of this list type definition
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this list type definition.
	 *
	 * @return the user ID of this list type definition
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this list type definition.
	 *
	 * @param userId the user ID of this list type definition
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this list type definition.
	 *
	 * @return the user uuid of this list type definition
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this list type definition.
	 *
	 * @param userUuid the user uuid of this list type definition
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this list type definition.
	 *
	 * @return the user name of this list type definition
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this list type definition.
	 *
	 * @param userName the user name of this list type definition
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this list type definition.
	 *
	 * @return the create date of this list type definition
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this list type definition.
	 *
	 * @param createDate the create date of this list type definition
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this list type definition.
	 *
	 * @return the modified date of this list type definition
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this list type definition.
	 *
	 * @param modifiedDate the modified date of this list type definition
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the name of this list type definition.
	 *
	 * @return the name of this list type definition
	 */
	public String getName();

	/**
	 * Returns the localized name of this list type definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized name of this list type definition
	 */
	@AutoEscape
	public String getName(Locale locale);

	/**
	 * Returns the localized name of this list type definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this list type definition. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getName(Locale locale, boolean useDefault);

	/**
	 * Returns the localized name of this list type definition in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized name of this list type definition
	 */
	@AutoEscape
	public String getName(String languageId);

	/**
	 * Returns the localized name of this list type definition in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized name of this list type definition
	 */
	@AutoEscape
	public String getName(String languageId, boolean useDefault);

	@AutoEscape
	public String getNameCurrentLanguageId();

	@AutoEscape
	public String getNameCurrentValue();

	/**
	 * Returns a map of the locales and localized names of this list type definition.
	 *
	 * @return the locales and localized names of this list type definition
	 */
	public Map<Locale, String> getNameMap();

	/**
	 * Sets the name of this list type definition.
	 *
	 * @param name the name of this list type definition
	 */
	public void setName(String name);

	/**
	 * Sets the localized name of this list type definition in the language.
	 *
	 * @param name the localized name of this list type definition
	 * @param locale the locale of the language
	 */
	public void setName(String name, Locale locale);

	/**
	 * Sets the localized name of this list type definition in the language, and sets the default locale.
	 *
	 * @param name the localized name of this list type definition
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setName(String name, Locale locale, Locale defaultLocale);

	public void setNameCurrentLanguageId(String languageId);

	/**
	 * Sets the localized names of this list type definition from the map of locales and localized names.
	 *
	 * @param nameMap the locales and localized names of this list type definition
	 */
	public void setNameMap(Map<Locale, String> nameMap);

	/**
	 * Sets the localized names of this list type definition from the map of locales and localized names, and sets the default locale.
	 *
	 * @param nameMap the locales and localized names of this list type definition
	 * @param defaultLocale the default locale
	 */
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public ListTypeDefinition cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}