/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ObjectValidationRuleSetting service. Represents a row in the &quot;ObjectValidationRuleSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.object.model.impl.ObjectValidationRuleSettingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.object.model.impl.ObjectValidationRuleSettingImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRuleSetting
 * @generated
 */
@ProviderType
public interface ObjectValidationRuleSettingModel
	extends BaseModel<ObjectValidationRuleSetting>, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a object validation rule setting model instance should use the {@link ObjectValidationRuleSetting} interface instead.
	 */

	/**
	 * Returns the primary key of this object validation rule setting.
	 *
	 * @return the primary key of this object validation rule setting
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this object validation rule setting.
	 *
	 * @param primaryKey the primary key of this object validation rule setting
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this object validation rule setting.
	 *
	 * @return the mvcc version of this object validation rule setting
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this object validation rule setting.
	 *
	 * @param mvccVersion the mvcc version of this object validation rule setting
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this object validation rule setting.
	 *
	 * @return the uuid of this object validation rule setting
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this object validation rule setting.
	 *
	 * @param uuid the uuid of this object validation rule setting
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the object validation rule setting ID of this object validation rule setting.
	 *
	 * @return the object validation rule setting ID of this object validation rule setting
	 */
	public long getObjectValidationRuleSettingId();

	/**
	 * Sets the object validation rule setting ID of this object validation rule setting.
	 *
	 * @param objectValidationRuleSettingId the object validation rule setting ID of this object validation rule setting
	 */
	public void setObjectValidationRuleSettingId(
		long objectValidationRuleSettingId);

	/**
	 * Returns the company ID of this object validation rule setting.
	 *
	 * @return the company ID of this object validation rule setting
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this object validation rule setting.
	 *
	 * @param companyId the company ID of this object validation rule setting
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this object validation rule setting.
	 *
	 * @return the user ID of this object validation rule setting
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this object validation rule setting.
	 *
	 * @param userId the user ID of this object validation rule setting
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this object validation rule setting.
	 *
	 * @return the user uuid of this object validation rule setting
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this object validation rule setting.
	 *
	 * @param userUuid the user uuid of this object validation rule setting
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this object validation rule setting.
	 *
	 * @return the user name of this object validation rule setting
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this object validation rule setting.
	 *
	 * @param userName the user name of this object validation rule setting
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this object validation rule setting.
	 *
	 * @return the create date of this object validation rule setting
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this object validation rule setting.
	 *
	 * @param createDate the create date of this object validation rule setting
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this object validation rule setting.
	 *
	 * @return the modified date of this object validation rule setting
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this object validation rule setting.
	 *
	 * @param modifiedDate the modified date of this object validation rule setting
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the object validation rule ID of this object validation rule setting.
	 *
	 * @return the object validation rule ID of this object validation rule setting
	 */
	public long getObjectValidationRuleId();

	/**
	 * Sets the object validation rule ID of this object validation rule setting.
	 *
	 * @param objectValidationRuleId the object validation rule ID of this object validation rule setting
	 */
	public void setObjectValidationRuleId(long objectValidationRuleId);

	/**
	 * Returns the name of this object validation rule setting.
	 *
	 * @return the name of this object validation rule setting
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this object validation rule setting.
	 *
	 * @param name the name of this object validation rule setting
	 */
	public void setName(String name);

	/**
	 * Returns the value of this object validation rule setting.
	 *
	 * @return the value of this object validation rule setting
	 */
	@AutoEscape
	public String getValue();

	/**
	 * Sets the value of this object validation rule setting.
	 *
	 * @param value the value of this object validation rule setting
	 */
	public void setValue(String value);

	@Override
	public ObjectValidationRuleSetting cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}