/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.model;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the PortalPreferences service. Represents a row in the &quot;PortalPreferences&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.PortalPreferencesModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.PortalPreferencesImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PortalPreferences
 * @generated
 */
@ProviderType
public interface PortalPreferencesModel
	extends BaseModel<PortalPreferences>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a portal preferences model instance should use the {@link PortalPreferences} interface instead.
	 */

	/**
	 * Returns the primary key of this portal preferences.
	 *
	 * @return the primary key of this portal preferences
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this portal preferences.
	 *
	 * @param primaryKey the primary key of this portal preferences
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this portal preferences.
	 *
	 * @return the mvcc version of this portal preferences
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this portal preferences.
	 *
	 * @param mvccVersion the mvcc version of this portal preferences
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the portal preferences ID of this portal preferences.
	 *
	 * @return the portal preferences ID of this portal preferences
	 */
	public long getPortalPreferencesId();

	/**
	 * Sets the portal preferences ID of this portal preferences.
	 *
	 * @param portalPreferencesId the portal preferences ID of this portal preferences
	 */
	public void setPortalPreferencesId(long portalPreferencesId);

	/**
	 * Returns the company ID of this portal preferences.
	 *
	 * @return the company ID of this portal preferences
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this portal preferences.
	 *
	 * @param companyId the company ID of this portal preferences
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the owner ID of this portal preferences.
	 *
	 * @return the owner ID of this portal preferences
	 */
	public long getOwnerId();

	/**
	 * Sets the owner ID of this portal preferences.
	 *
	 * @param ownerId the owner ID of this portal preferences
	 */
	public void setOwnerId(long ownerId);

	/**
	 * Returns the owner type of this portal preferences.
	 *
	 * @return the owner type of this portal preferences
	 */
	public int getOwnerType();

	/**
	 * Sets the owner type of this portal preferences.
	 *
	 * @param ownerType the owner type of this portal preferences
	 */
	public void setOwnerType(int ownerType);

	@Override
	public PortalPreferences cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}