/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the ResourcePermission service. Represents a row in the &quot;ResourcePermission&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.ResourcePermissionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.ResourcePermissionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ResourcePermission
 * @generated
 */
@ProviderType
public interface ResourcePermissionModel
	extends BaseModel<ResourcePermission>, CTModel<ResourcePermission>,
			MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a resource permission model instance should use the {@link ResourcePermission} interface instead.
	 */

	/**
	 * Returns the primary key of this resource permission.
	 *
	 * @return the primary key of this resource permission
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this resource permission.
	 *
	 * @param primaryKey the primary key of this resource permission
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this resource permission.
	 *
	 * @return the mvcc version of this resource permission
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this resource permission.
	 *
	 * @param mvccVersion the mvcc version of this resource permission
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this resource permission.
	 *
	 * @return the ct collection ID of this resource permission
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this resource permission.
	 *
	 * @param ctCollectionId the ct collection ID of this resource permission
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the resource permission ID of this resource permission.
	 *
	 * @return the resource permission ID of this resource permission
	 */
	public long getResourcePermissionId();

	/**
	 * Sets the resource permission ID of this resource permission.
	 *
	 * @param resourcePermissionId the resource permission ID of this resource permission
	 */
	public void setResourcePermissionId(long resourcePermissionId);

	/**
	 * Returns the company ID of this resource permission.
	 *
	 * @return the company ID of this resource permission
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this resource permission.
	 *
	 * @param companyId the company ID of this resource permission
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the name of this resource permission.
	 *
	 * @return the name of this resource permission
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this resource permission.
	 *
	 * @param name the name of this resource permission
	 */
	public void setName(String name);

	/**
	 * Returns the scope of this resource permission.
	 *
	 * @return the scope of this resource permission
	 */
	public int getScope();

	/**
	 * Sets the scope of this resource permission.
	 *
	 * @param scope the scope of this resource permission
	 */
	public void setScope(int scope);

	/**
	 * Returns the prim key of this resource permission.
	 *
	 * @return the prim key of this resource permission
	 */
	@AutoEscape
	public String getPrimKey();

	/**
	 * Sets the prim key of this resource permission.
	 *
	 * @param primKey the prim key of this resource permission
	 */
	public void setPrimKey(String primKey);

	/**
	 * Returns the prim key ID of this resource permission.
	 *
	 * @return the prim key ID of this resource permission
	 */
	public long getPrimKeyId();

	/**
	 * Sets the prim key ID of this resource permission.
	 *
	 * @param primKeyId the prim key ID of this resource permission
	 */
	public void setPrimKeyId(long primKeyId);

	/**
	 * Returns the role ID of this resource permission.
	 *
	 * @return the role ID of this resource permission
	 */
	public long getRoleId();

	/**
	 * Sets the role ID of this resource permission.
	 *
	 * @param roleId the role ID of this resource permission
	 */
	public void setRoleId(long roleId);

	/**
	 * Returns the owner ID of this resource permission.
	 *
	 * @return the owner ID of this resource permission
	 */
	public long getOwnerId();

	/**
	 * Sets the owner ID of this resource permission.
	 *
	 * @param ownerId the owner ID of this resource permission
	 */
	public void setOwnerId(long ownerId);

	/**
	 * Returns the action IDs of this resource permission.
	 *
	 * @return the action IDs of this resource permission
	 */
	public long getActionIds();

	/**
	 * Sets the action IDs of this resource permission.
	 *
	 * @param actionIds the action IDs of this resource permission
	 */
	public void setActionIds(long actionIds);

	/**
	 * Returns the view action ID of this resource permission.
	 *
	 * @return the view action ID of this resource permission
	 */
	public boolean getViewActionId();

	/**
	 * Returns <code>true</code> if this resource permission is view action ID.
	 *
	 * @return <code>true</code> if this resource permission is view action ID; <code>false</code> otherwise
	 */
	public boolean isViewActionId();

	/**
	 * Sets whether this resource permission is view action ID.
	 *
	 * @param viewActionId the view action ID of this resource permission
	 */
	public void setViewActionId(boolean viewActionId);

	@Override
	public ResourcePermission cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}