/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.service.persistence.BasePersistence;

/**
 * Provides a wrapper for {@link PluginSettingLocalService}.
 *
 * @author Brian Wing Shun Chan
 * @see PluginSettingLocalService
 * @generated
 */
public class PluginSettingLocalServiceWrapper
	implements PluginSettingLocalService,
			   ServiceWrapper<PluginSettingLocalService> {

	public PluginSettingLocalServiceWrapper() {
		this(null);
	}

	public PluginSettingLocalServiceWrapper(
		PluginSettingLocalService pluginSettingLocalService) {

		_pluginSettingLocalService = pluginSettingLocalService;
	}

	/**
	 * Adds the plugin setting to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PluginSettingLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param pluginSetting the plugin setting
	 * @return the plugin setting that was added
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting addPluginSetting(
		com.liferay.portal.kernel.model.PluginSetting pluginSetting) {

		return _pluginSettingLocalService.addPluginSetting(pluginSetting);
	}

	@Override
	public void checkPermission(long userId, String pluginId, String pluginType)
		throws com.liferay.portal.kernel.exception.PortalException {

		_pluginSettingLocalService.checkPermission(
			userId, pluginId, pluginType);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel createPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _pluginSettingLocalService.createPersistedModel(primaryKeyObj);
	}

	/**
	 * Creates a new plugin setting with the primary key. Does not add the plugin setting to the database.
	 *
	 * @param pluginSettingId the primary key for the new plugin setting
	 * @return the new plugin setting
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting createPluginSetting(
		long pluginSettingId) {

		return _pluginSettingLocalService.createPluginSetting(pluginSettingId);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel deletePersistedModel(
			com.liferay.portal.kernel.model.PersistedModel persistedModel)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _pluginSettingLocalService.deletePersistedModel(persistedModel);
	}

	/**
	 * Deletes the plugin setting with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PluginSettingLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param pluginSettingId the primary key of the plugin setting
	 * @return the plugin setting that was removed
	 * @throws PortalException if a plugin setting with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting deletePluginSetting(
			long pluginSettingId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _pluginSettingLocalService.deletePluginSetting(pluginSettingId);
	}

	/**
	 * Deletes the plugin setting from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PluginSettingLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param pluginSetting the plugin setting
	 * @return the plugin setting that was removed
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting deletePluginSetting(
		com.liferay.portal.kernel.model.PluginSetting pluginSetting) {

		return _pluginSettingLocalService.deletePluginSetting(pluginSetting);
	}

	@Override
	public <T> T dslQuery(com.liferay.petra.sql.dsl.query.DSLQuery dslQuery) {
		return _pluginSettingLocalService.dslQuery(dslQuery);
	}

	@Override
	public int dslQueryCount(
		com.liferay.petra.sql.dsl.query.DSLQuery dslQuery) {

		return _pluginSettingLocalService.dslQueryCount(dslQuery);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _pluginSettingLocalService.dynamicQuery();
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _pluginSettingLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PluginSettingModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) {

		return _pluginSettingLocalService.dynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PluginSettingModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator<T> orderByComparator) {

		return _pluginSettingLocalService.dynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _pluginSettingLocalService.dynamicQueryCount(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
		com.liferay.portal.kernel.dao.orm.Projection projection) {

		return _pluginSettingLocalService.dynamicQueryCount(
			dynamicQuery, projection);
	}

	@Override
	public com.liferay.portal.kernel.model.PluginSetting fetchPluginSetting(
		long pluginSettingId) {

		return _pluginSettingLocalService.fetchPluginSetting(pluginSettingId);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery
		getActionableDynamicQuery() {

		return _pluginSettingLocalService.getActionableDynamicQuery();
	}

	@Override
	public com.liferay.portal.kernel.model.PluginSetting
		getDefaultPluginSetting() {

		return _pluginSettingLocalService.getDefaultPluginSetting();
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		return _pluginSettingLocalService.getIndexableActionableDynamicQuery();
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return _pluginSettingLocalService.getOSGiServiceIdentifier();
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel getPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _pluginSettingLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	 * Returns the plugin setting with the primary key.
	 *
	 * @param pluginSettingId the primary key of the plugin setting
	 * @return the plugin setting
	 * @throws PortalException if a plugin setting with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting getPluginSetting(
			long pluginSettingId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _pluginSettingLocalService.getPluginSetting(pluginSettingId);
	}

	@Override
	public com.liferay.portal.kernel.model.PluginSetting getPluginSetting(
		long companyId, String pluginId, String pluginType) {

		return _pluginSettingLocalService.getPluginSetting(
			companyId, pluginId, pluginType);
	}

	/**
	 * Returns a range of all the plugin settings.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PluginSettingModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of plugin settings
	 * @param end the upper bound of the range of plugin settings (not inclusive)
	 * @return the range of plugin settings
	 */
	@Override
	public java.util.List<com.liferay.portal.kernel.model.PluginSetting>
		getPluginSettings(int start, int end) {

		return _pluginSettingLocalService.getPluginSettings(start, end);
	}

	/**
	 * Returns the number of plugin settings.
	 *
	 * @return the number of plugin settings
	 */
	@Override
	public int getPluginSettingsCount() {
		return _pluginSettingLocalService.getPluginSettingsCount();
	}

	@Override
	public boolean hasPermission(
		long userId, String pluginId, String pluginType) {

		return _pluginSettingLocalService.hasPermission(
			userId, pluginId, pluginType);
	}

	@Override
	public com.liferay.portal.kernel.model.PluginSetting updatePluginSetting(
		long companyId, String pluginId, String pluginType, String roles,
		boolean active) {

		return _pluginSettingLocalService.updatePluginSetting(
			companyId, pluginId, pluginType, roles, active);
	}

	/**
	 * Updates the plugin setting in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PluginSettingLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param pluginSetting the plugin setting
	 * @return the plugin setting that was updated
	 */
	@Override
	public com.liferay.portal.kernel.model.PluginSetting updatePluginSetting(
		com.liferay.portal.kernel.model.PluginSetting pluginSetting) {

		return _pluginSettingLocalService.updatePluginSetting(pluginSetting);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _pluginSettingLocalService.getBasePersistence();
	}

	@Override
	public PluginSettingLocalService getWrappedService() {
		return _pluginSettingLocalService;
	}

	@Override
	public void setWrappedService(
		PluginSettingLocalService pluginSettingLocalService) {

		_pluginSettingLocalService = pluginSettingLocalService;
	}

	private PluginSettingLocalService _pluginSettingLocalService;

}