/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ContactModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Contact service. Represents a row in the &quot;Contact_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ContactModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ContactImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ContactImpl
 * @generated
 */
@JSON(strict = true)
public class ContactModelImpl
	extends BaseModelImpl<Contact> implements ContactModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a contact model instance should use the <code>Contact</code> interface instead.
	 */
	public static final String TABLE_NAME = "Contact_";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"contactId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"parentContactId", Types.BIGINT},
		{"emailAddress", Types.VARCHAR}, {"firstName", Types.VARCHAR},
		{"middleName", Types.VARCHAR}, {"lastName", Types.VARCHAR},
		{"prefixListTypeId", Types.BIGINT}, {"suffixListTypeId", Types.BIGINT},
		{"male", Types.BOOLEAN}, {"birthday", Types.TIMESTAMP},
		{"smsSn", Types.VARCHAR}, {"facebookSn", Types.VARCHAR},
		{"jabberSn", Types.VARCHAR}, {"skypeSn", Types.VARCHAR},
		{"twitterSn", Types.VARCHAR}, {"employeeStatusId", Types.VARCHAR},
		{"employeeNumber", Types.VARCHAR}, {"jobTitle", Types.VARCHAR},
		{"jobClass", Types.VARCHAR}, {"hoursOfOperation", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("contactId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentContactId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("emailAddress", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("firstName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("middleName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("prefixListTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("suffixListTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("male", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("birthday", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("smsSn", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("facebookSn", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("jabberSn", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("skypeSn", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("twitterSn", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("employeeStatusId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("employeeNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("jobTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("jobClass", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("hoursOfOperation", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Contact_ (mvccVersion LONG default 0 not null,contactId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,parentContactId LONG,emailAddress VARCHAR(254) null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,lastName VARCHAR(75) null,prefixListTypeId LONG,suffixListTypeId LONG,male BOOLEAN,birthday DATE null,smsSn VARCHAR(75) null,facebookSn VARCHAR(75) null,jabberSn VARCHAR(75) null,skypeSn VARCHAR(75) null,twitterSn VARCHAR(75) null,employeeStatusId VARCHAR(75) null,employeeNumber VARCHAR(75) null,jobTitle VARCHAR(100) null,jobClass VARCHAR(75) null,hoursOfOperation VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table Contact_";

	public static final String ORDER_BY_JPQL =
		" ORDER BY contact.contactId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY Contact_.contactId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CONTACTID_COLUMN_BITMASK = 16L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Contact"));

	public ContactModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _contactId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setContactId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _contactId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Contact.class;
	}

	@Override
	public String getModelClassName() {
		return Contact.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Contact, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Contact, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Contact, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Contact)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Contact, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Contact, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Contact)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Contact, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Contact, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<Contact, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<Contact, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<Contact, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", Contact::getMvccVersion);
			attributeGetterFunctions.put("contactId", Contact::getContactId);
			attributeGetterFunctions.put("companyId", Contact::getCompanyId);
			attributeGetterFunctions.put("userId", Contact::getUserId);
			attributeGetterFunctions.put("userName", Contact::getUserName);
			attributeGetterFunctions.put("createDate", Contact::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", Contact::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", Contact::getClassNameId);
			attributeGetterFunctions.put("classPK", Contact::getClassPK);
			attributeGetterFunctions.put(
				"parentContactId", Contact::getParentContactId);
			attributeGetterFunctions.put(
				"emailAddress", Contact::getEmailAddress);
			attributeGetterFunctions.put("firstName", Contact::getFirstName);
			attributeGetterFunctions.put("middleName", Contact::getMiddleName);
			attributeGetterFunctions.put("lastName", Contact::getLastName);
			attributeGetterFunctions.put(
				"prefixListTypeId", Contact::getPrefixListTypeId);
			attributeGetterFunctions.put(
				"suffixListTypeId", Contact::getSuffixListTypeId);
			attributeGetterFunctions.put("male", Contact::getMale);
			attributeGetterFunctions.put("birthday", Contact::getBirthday);
			attributeGetterFunctions.put("smsSn", Contact::getSmsSn);
			attributeGetterFunctions.put("facebookSn", Contact::getFacebookSn);
			attributeGetterFunctions.put("jabberSn", Contact::getJabberSn);
			attributeGetterFunctions.put("skypeSn", Contact::getSkypeSn);
			attributeGetterFunctions.put("twitterSn", Contact::getTwitterSn);
			attributeGetterFunctions.put(
				"employeeStatusId", Contact::getEmployeeStatusId);
			attributeGetterFunctions.put(
				"employeeNumber", Contact::getEmployeeNumber);
			attributeGetterFunctions.put("jobTitle", Contact::getJobTitle);
			attributeGetterFunctions.put("jobClass", Contact::getJobClass);
			attributeGetterFunctions.put(
				"hoursOfOperation", Contact::getHoursOfOperation);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<Contact, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<Contact, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<Contact, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<Contact, Long>)Contact::setMvccVersion);
			attributeSetterBiConsumers.put(
				"contactId", (BiConsumer<Contact, Long>)Contact::setContactId);
			attributeSetterBiConsumers.put(
				"companyId", (BiConsumer<Contact, Long>)Contact::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<Contact, Long>)Contact::setUserId);
			attributeSetterBiConsumers.put(
				"userName", (BiConsumer<Contact, String>)Contact::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<Contact, Date>)Contact::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<Contact, Date>)Contact::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<Contact, Long>)Contact::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK", (BiConsumer<Contact, Long>)Contact::setClassPK);
			attributeSetterBiConsumers.put(
				"parentContactId",
				(BiConsumer<Contact, Long>)Contact::setParentContactId);
			attributeSetterBiConsumers.put(
				"emailAddress",
				(BiConsumer<Contact, String>)Contact::setEmailAddress);
			attributeSetterBiConsumers.put(
				"firstName",
				(BiConsumer<Contact, String>)Contact::setFirstName);
			attributeSetterBiConsumers.put(
				"middleName",
				(BiConsumer<Contact, String>)Contact::setMiddleName);
			attributeSetterBiConsumers.put(
				"lastName", (BiConsumer<Contact, String>)Contact::setLastName);
			attributeSetterBiConsumers.put(
				"prefixListTypeId",
				(BiConsumer<Contact, Long>)Contact::setPrefixListTypeId);
			attributeSetterBiConsumers.put(
				"suffixListTypeId",
				(BiConsumer<Contact, Long>)Contact::setSuffixListTypeId);
			attributeSetterBiConsumers.put(
				"male", (BiConsumer<Contact, Boolean>)Contact::setMale);
			attributeSetterBiConsumers.put(
				"birthday", (BiConsumer<Contact, Date>)Contact::setBirthday);
			attributeSetterBiConsumers.put(
				"smsSn", (BiConsumer<Contact, String>)Contact::setSmsSn);
			attributeSetterBiConsumers.put(
				"facebookSn",
				(BiConsumer<Contact, String>)Contact::setFacebookSn);
			attributeSetterBiConsumers.put(
				"jabberSn", (BiConsumer<Contact, String>)Contact::setJabberSn);
			attributeSetterBiConsumers.put(
				"skypeSn", (BiConsumer<Contact, String>)Contact::setSkypeSn);
			attributeSetterBiConsumers.put(
				"twitterSn",
				(BiConsumer<Contact, String>)Contact::setTwitterSn);
			attributeSetterBiConsumers.put(
				"employeeStatusId",
				(BiConsumer<Contact, String>)Contact::setEmployeeStatusId);
			attributeSetterBiConsumers.put(
				"employeeNumber",
				(BiConsumer<Contact, String>)Contact::setEmployeeNumber);
			attributeSetterBiConsumers.put(
				"jobTitle", (BiConsumer<Contact, String>)Contact::setJobTitle);
			attributeSetterBiConsumers.put(
				"jobClass", (BiConsumer<Contact, String>)Contact::setJobClass);
			attributeSetterBiConsumers.put(
				"hoursOfOperation",
				(BiConsumer<Contact, String>)Contact::setHoursOfOperation);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getContactId() {
		return _contactId;
	}

	@Override
	public void setContactId(long contactId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_contactId = contactId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getParentContactId() {
		return _parentContactId;
	}

	@Override
	public void setParentContactId(long parentContactId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentContactId = parentContactId;
	}

	@JSON
	@Override
	public String getEmailAddress() {
		if (_emailAddress == null) {
			return "";
		}
		else {
			return _emailAddress;
		}
	}

	@Override
	public void setEmailAddress(String emailAddress) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_emailAddress = emailAddress;
	}

	@JSON
	@Override
	public String getFirstName() {
		if (_firstName == null) {
			return "";
		}
		else {
			return _firstName;
		}
	}

	@Override
	public void setFirstName(String firstName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_firstName = firstName;
	}

	@JSON
	@Override
	public String getMiddleName() {
		if (_middleName == null) {
			return "";
		}
		else {
			return _middleName;
		}
	}

	@Override
	public void setMiddleName(String middleName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_middleName = middleName;
	}

	@JSON
	@Override
	public String getLastName() {
		if (_lastName == null) {
			return "";
		}
		else {
			return _lastName;
		}
	}

	@Override
	public void setLastName(String lastName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastName = lastName;
	}

	@JSON
	@Override
	public long getPrefixListTypeId() {
		return _prefixListTypeId;
	}

	@Override
	public void setPrefixListTypeId(long prefixListTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_prefixListTypeId = prefixListTypeId;
	}

	@JSON
	@Override
	public long getSuffixListTypeId() {
		return _suffixListTypeId;
	}

	@Override
	public void setSuffixListTypeId(long suffixListTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_suffixListTypeId = suffixListTypeId;
	}

	@JSON
	@Override
	public boolean getMale() {
		return _male;
	}

	@JSON
	@Override
	public boolean isMale() {
		return _male;
	}

	@Override
	public void setMale(boolean male) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_male = male;
	}

	@JSON
	@Override
	public Date getBirthday() {
		return _birthday;
	}

	@Override
	public void setBirthday(Date birthday) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_birthday = birthday;
	}

	@JSON
	@Override
	public String getSmsSn() {
		if (_smsSn == null) {
			return "";
		}
		else {
			return _smsSn;
		}
	}

	@Override
	public void setSmsSn(String smsSn) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smsSn = smsSn;
	}

	@JSON
	@Override
	public String getFacebookSn() {
		if (_facebookSn == null) {
			return "";
		}
		else {
			return _facebookSn;
		}
	}

	@Override
	public void setFacebookSn(String facebookSn) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_facebookSn = facebookSn;
	}

	@JSON
	@Override
	public String getJabberSn() {
		if (_jabberSn == null) {
			return "";
		}
		else {
			return _jabberSn;
		}
	}

	@Override
	public void setJabberSn(String jabberSn) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_jabberSn = jabberSn;
	}

	@JSON
	@Override
	public String getSkypeSn() {
		if (_skypeSn == null) {
			return "";
		}
		else {
			return _skypeSn;
		}
	}

	@Override
	public void setSkypeSn(String skypeSn) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_skypeSn = skypeSn;
	}

	@JSON
	@Override
	public String getTwitterSn() {
		if (_twitterSn == null) {
			return "";
		}
		else {
			return _twitterSn;
		}
	}

	@Override
	public void setTwitterSn(String twitterSn) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_twitterSn = twitterSn;
	}

	@JSON
	@Override
	public String getEmployeeStatusId() {
		if (_employeeStatusId == null) {
			return "";
		}
		else {
			return _employeeStatusId;
		}
	}

	@Override
	public void setEmployeeStatusId(String employeeStatusId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_employeeStatusId = employeeStatusId;
	}

	@JSON
	@Override
	public String getEmployeeNumber() {
		if (_employeeNumber == null) {
			return "";
		}
		else {
			return _employeeNumber;
		}
	}

	@Override
	public void setEmployeeNumber(String employeeNumber) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_employeeNumber = employeeNumber;
	}

	@JSON
	@Override
	public String getJobTitle() {
		if (_jobTitle == null) {
			return "";
		}
		else {
			return _jobTitle;
		}
	}

	@Override
	public void setJobTitle(String jobTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_jobTitle = jobTitle;
	}

	@JSON
	@Override
	public String getJobClass() {
		if (_jobClass == null) {
			return "";
		}
		else {
			return _jobClass;
		}
	}

	@Override
	public void setJobClass(String jobClass) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_jobClass = jobClass;
	}

	@JSON
	@Override
	public String getHoursOfOperation() {
		if (_hoursOfOperation == null) {
			return "";
		}
		else {
			return _hoursOfOperation;
		}
	}

	@Override
	public void setHoursOfOperation(String hoursOfOperation) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_hoursOfOperation = hoursOfOperation;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Contact.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Contact toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Contact>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ContactImpl contactImpl = new ContactImpl();

		contactImpl.setMvccVersion(getMvccVersion());
		contactImpl.setContactId(getContactId());
		contactImpl.setCompanyId(getCompanyId());
		contactImpl.setUserId(getUserId());
		contactImpl.setUserName(getUserName());
		contactImpl.setCreateDate(getCreateDate());
		contactImpl.setModifiedDate(getModifiedDate());
		contactImpl.setClassNameId(getClassNameId());
		contactImpl.setClassPK(getClassPK());
		contactImpl.setParentContactId(getParentContactId());
		contactImpl.setEmailAddress(getEmailAddress());
		contactImpl.setFirstName(getFirstName());
		contactImpl.setMiddleName(getMiddleName());
		contactImpl.setLastName(getLastName());
		contactImpl.setPrefixListTypeId(getPrefixListTypeId());
		contactImpl.setSuffixListTypeId(getSuffixListTypeId());
		contactImpl.setMale(isMale());
		contactImpl.setBirthday(getBirthday());
		contactImpl.setSmsSn(getSmsSn());
		contactImpl.setFacebookSn(getFacebookSn());
		contactImpl.setJabberSn(getJabberSn());
		contactImpl.setSkypeSn(getSkypeSn());
		contactImpl.setTwitterSn(getTwitterSn());
		contactImpl.setEmployeeStatusId(getEmployeeStatusId());
		contactImpl.setEmployeeNumber(getEmployeeNumber());
		contactImpl.setJobTitle(getJobTitle());
		contactImpl.setJobClass(getJobClass());
		contactImpl.setHoursOfOperation(getHoursOfOperation());

		contactImpl.resetOriginalValues();

		return contactImpl;
	}

	@Override
	public Contact cloneWithOriginalValues() {
		ContactImpl contactImpl = new ContactImpl();

		contactImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		contactImpl.setContactId(
			this.<Long>getColumnOriginalValue("contactId"));
		contactImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		contactImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		contactImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		contactImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		contactImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		contactImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		contactImpl.setClassPK(this.<Long>getColumnOriginalValue("classPK"));
		contactImpl.setParentContactId(
			this.<Long>getColumnOriginalValue("parentContactId"));
		contactImpl.setEmailAddress(
			this.<String>getColumnOriginalValue("emailAddress"));
		contactImpl.setFirstName(
			this.<String>getColumnOriginalValue("firstName"));
		contactImpl.setMiddleName(
			this.<String>getColumnOriginalValue("middleName"));
		contactImpl.setLastName(
			this.<String>getColumnOriginalValue("lastName"));
		contactImpl.setPrefixListTypeId(
			this.<Long>getColumnOriginalValue("prefixListTypeId"));
		contactImpl.setSuffixListTypeId(
			this.<Long>getColumnOriginalValue("suffixListTypeId"));
		contactImpl.setMale(this.<Boolean>getColumnOriginalValue("male"));
		contactImpl.setBirthday(this.<Date>getColumnOriginalValue("birthday"));
		contactImpl.setSmsSn(this.<String>getColumnOriginalValue("smsSn"));
		contactImpl.setFacebookSn(
			this.<String>getColumnOriginalValue("facebookSn"));
		contactImpl.setJabberSn(
			this.<String>getColumnOriginalValue("jabberSn"));
		contactImpl.setSkypeSn(this.<String>getColumnOriginalValue("skypeSn"));
		contactImpl.setTwitterSn(
			this.<String>getColumnOriginalValue("twitterSn"));
		contactImpl.setEmployeeStatusId(
			this.<String>getColumnOriginalValue("employeeStatusId"));
		contactImpl.setEmployeeNumber(
			this.<String>getColumnOriginalValue("employeeNumber"));
		contactImpl.setJobTitle(
			this.<String>getColumnOriginalValue("jobTitle"));
		contactImpl.setJobClass(
			this.<String>getColumnOriginalValue("jobClass"));
		contactImpl.setHoursOfOperation(
			this.<String>getColumnOriginalValue("hoursOfOperation"));

		return contactImpl;
	}

	@Override
	public int compareTo(Contact contact) {
		int value = 0;

		if (getContactId() < contact.getContactId()) {
			value = -1;
		}
		else if (getContactId() > contact.getContactId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Contact)) {
			return false;
		}

		Contact contact = (Contact)object;

		long primaryKey = contact.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Contact> toCacheModel() {
		ContactCacheModel contactCacheModel = new ContactCacheModel();

		contactCacheModel.mvccVersion = getMvccVersion();

		contactCacheModel.contactId = getContactId();

		contactCacheModel.companyId = getCompanyId();

		contactCacheModel.userId = getUserId();

		contactCacheModel.userName = getUserName();

		String userName = contactCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			contactCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			contactCacheModel.createDate = createDate.getTime();
		}
		else {
			contactCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			contactCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			contactCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		contactCacheModel.classNameId = getClassNameId();

		contactCacheModel.classPK = getClassPK();

		contactCacheModel.parentContactId = getParentContactId();

		contactCacheModel.emailAddress = getEmailAddress();

		String emailAddress = contactCacheModel.emailAddress;

		if ((emailAddress != null) && (emailAddress.length() == 0)) {
			contactCacheModel.emailAddress = null;
		}

		contactCacheModel.firstName = getFirstName();

		String firstName = contactCacheModel.firstName;

		if ((firstName != null) && (firstName.length() == 0)) {
			contactCacheModel.firstName = null;
		}

		contactCacheModel.middleName = getMiddleName();

		String middleName = contactCacheModel.middleName;

		if ((middleName != null) && (middleName.length() == 0)) {
			contactCacheModel.middleName = null;
		}

		contactCacheModel.lastName = getLastName();

		String lastName = contactCacheModel.lastName;

		if ((lastName != null) && (lastName.length() == 0)) {
			contactCacheModel.lastName = null;
		}

		contactCacheModel.prefixListTypeId = getPrefixListTypeId();

		contactCacheModel.suffixListTypeId = getSuffixListTypeId();

		contactCacheModel.male = isMale();

		Date birthday = getBirthday();

		if (birthday != null) {
			contactCacheModel.birthday = birthday.getTime();
		}
		else {
			contactCacheModel.birthday = Long.MIN_VALUE;
		}

		contactCacheModel.smsSn = getSmsSn();

		String smsSn = contactCacheModel.smsSn;

		if ((smsSn != null) && (smsSn.length() == 0)) {
			contactCacheModel.smsSn = null;
		}

		contactCacheModel.facebookSn = getFacebookSn();

		String facebookSn = contactCacheModel.facebookSn;

		if ((facebookSn != null) && (facebookSn.length() == 0)) {
			contactCacheModel.facebookSn = null;
		}

		contactCacheModel.jabberSn = getJabberSn();

		String jabberSn = contactCacheModel.jabberSn;

		if ((jabberSn != null) && (jabberSn.length() == 0)) {
			contactCacheModel.jabberSn = null;
		}

		contactCacheModel.skypeSn = getSkypeSn();

		String skypeSn = contactCacheModel.skypeSn;

		if ((skypeSn != null) && (skypeSn.length() == 0)) {
			contactCacheModel.skypeSn = null;
		}

		contactCacheModel.twitterSn = getTwitterSn();

		String twitterSn = contactCacheModel.twitterSn;

		if ((twitterSn != null) && (twitterSn.length() == 0)) {
			contactCacheModel.twitterSn = null;
		}

		contactCacheModel.employeeStatusId = getEmployeeStatusId();

		String employeeStatusId = contactCacheModel.employeeStatusId;

		if ((employeeStatusId != null) && (employeeStatusId.length() == 0)) {
			contactCacheModel.employeeStatusId = null;
		}

		contactCacheModel.employeeNumber = getEmployeeNumber();

		String employeeNumber = contactCacheModel.employeeNumber;

		if ((employeeNumber != null) && (employeeNumber.length() == 0)) {
			contactCacheModel.employeeNumber = null;
		}

		contactCacheModel.jobTitle = getJobTitle();

		String jobTitle = contactCacheModel.jobTitle;

		if ((jobTitle != null) && (jobTitle.length() == 0)) {
			contactCacheModel.jobTitle = null;
		}

		contactCacheModel.jobClass = getJobClass();

		String jobClass = contactCacheModel.jobClass;

		if ((jobClass != null) && (jobClass.length() == 0)) {
			contactCacheModel.jobClass = null;
		}

		contactCacheModel.hoursOfOperation = getHoursOfOperation();

		String hoursOfOperation = contactCacheModel.hoursOfOperation;

		if ((hoursOfOperation != null) && (hoursOfOperation.length() == 0)) {
			contactCacheModel.hoursOfOperation = null;
		}

		return contactCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Contact, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Contact, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Contact, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Contact)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Contact>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					Contact.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _contactId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _parentContactId;
	private String _emailAddress;
	private String _firstName;
	private String _middleName;
	private String _lastName;
	private long _prefixListTypeId;
	private long _suffixListTypeId;
	private boolean _male;
	private Date _birthday;
	private String _smsSn;
	private String _facebookSn;
	private String _jabberSn;
	private String _skypeSn;
	private String _twitterSn;
	private String _employeeStatusId;
	private String _employeeNumber;
	private String _jobTitle;
	private String _jobClass;
	private String _hoursOfOperation;

	public <T> T getColumnValue(String columnName) {
		Function<Contact, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Contact)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("contactId", _contactId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("parentContactId", _parentContactId);
		_columnOriginalValues.put("emailAddress", _emailAddress);
		_columnOriginalValues.put("firstName", _firstName);
		_columnOriginalValues.put("middleName", _middleName);
		_columnOriginalValues.put("lastName", _lastName);
		_columnOriginalValues.put("prefixListTypeId", _prefixListTypeId);
		_columnOriginalValues.put("suffixListTypeId", _suffixListTypeId);
		_columnOriginalValues.put("male", _male);
		_columnOriginalValues.put("birthday", _birthday);
		_columnOriginalValues.put("smsSn", _smsSn);
		_columnOriginalValues.put("facebookSn", _facebookSn);
		_columnOriginalValues.put("jabberSn", _jabberSn);
		_columnOriginalValues.put("skypeSn", _skypeSn);
		_columnOriginalValues.put("twitterSn", _twitterSn);
		_columnOriginalValues.put("employeeStatusId", _employeeStatusId);
		_columnOriginalValues.put("employeeNumber", _employeeNumber);
		_columnOriginalValues.put("jobTitle", _jobTitle);
		_columnOriginalValues.put("jobClass", _jobClass);
		_columnOriginalValues.put("hoursOfOperation", _hoursOfOperation);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("contactId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("classNameId", 128L);

		columnBitmasks.put("classPK", 256L);

		columnBitmasks.put("parentContactId", 512L);

		columnBitmasks.put("emailAddress", 1024L);

		columnBitmasks.put("firstName", 2048L);

		columnBitmasks.put("middleName", 4096L);

		columnBitmasks.put("lastName", 8192L);

		columnBitmasks.put("prefixListTypeId", 16384L);

		columnBitmasks.put("suffixListTypeId", 32768L);

		columnBitmasks.put("male", 65536L);

		columnBitmasks.put("birthday", 131072L);

		columnBitmasks.put("smsSn", 262144L);

		columnBitmasks.put("facebookSn", 524288L);

		columnBitmasks.put("jabberSn", 1048576L);

		columnBitmasks.put("skypeSn", 2097152L);

		columnBitmasks.put("twitterSn", 4194304L);

		columnBitmasks.put("employeeStatusId", 8388608L);

		columnBitmasks.put("employeeNumber", 16777216L);

		columnBitmasks.put("jobTitle", 33554432L);

		columnBitmasks.put("jobClass", 67108864L);

		columnBitmasks.put("hoursOfOperation", 134217728L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Contact _escapedModel;

}