/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutFriendlyURL service. Represents a row in the &quot;LayoutFriendlyURL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutFriendlyURLImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutFriendlyURLImpl
 * @see LayoutFriendlyURL
 * @generated
 */
public abstract class LayoutFriendlyURLBaseImpl
	extends LayoutFriendlyURLModelImpl implements LayoutFriendlyURL {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout friendly url model instance should use the <code>LayoutFriendlyURL</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutFriendlyURLLocalServiceUtil.addLayoutFriendlyURL(this);
		}
		else {
			LayoutFriendlyURLLocalServiceUtil.updateLayoutFriendlyURL(this);
		}
	}

}