/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutPrototype service. Represents a row in the &quot;LayoutPrototype&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutPrototypeImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutPrototypeImpl
 * @see LayoutPrototype
 * @generated
 */
public abstract class LayoutPrototypeBaseImpl
	extends LayoutPrototypeModelImpl implements LayoutPrototype {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout prototype model instance should use the <code>LayoutPrototype</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutPrototypeLocalServiceUtil.addLayoutPrototype(this);
		}
		else {
			LayoutPrototypeLocalServiceUtil.updateLayoutPrototype(this);
		}
	}

}