/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutSetPrototype service. Represents a row in the &quot;LayoutSetPrototype&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutSetPrototypeImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutSetPrototypeImpl
 * @see LayoutSetPrototype
 * @generated
 */
public abstract class LayoutSetPrototypeBaseImpl
	extends LayoutSetPrototypeModelImpl implements LayoutSetPrototype {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout set prototype model instance should use the <code>LayoutSetPrototype</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype(this);
		}
		else {
			LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype(this);
		}
	}

}