/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.service.PortalPreferenceValueLocalServiceUtil;

/**
 * The extended model base implementation for the PortalPreferenceValue service. Represents a row in the &quot;PortalPreferenceValue&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PortalPreferenceValueImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PortalPreferenceValueImpl
 * @see PortalPreferenceValue
 * @generated
 */
public abstract class PortalPreferenceValueBaseImpl
	extends PortalPreferenceValueModelImpl implements PortalPreferenceValue {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a portal preference value model instance should use the <code>PortalPreferenceValue</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PortalPreferenceValueLocalServiceUtil.addPortalPreferenceValue(
				this);
		}
		else {
			PortalPreferenceValueLocalServiceUtil.updatePortalPreferenceValue(
				this);
		}
	}

}