/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;

/**
 * The extended model base implementation for the PortalPreferences service. Represents a row in the &quot;PortalPreferences&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PortalPreferencesImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PortalPreferencesImpl
 * @see PortalPreferences
 * @generated
 */
public abstract class PortalPreferencesBaseImpl
	extends PortalPreferencesModelImpl implements PortalPreferences {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a portal preferences model instance should use the <code>PortalPreferences</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PortalPreferencesLocalServiceUtil.addPortalPreferences(this);
		}
		else {
			PortalPreferencesLocalServiceUtil.updatePortalPreferences(this);
		}
	}

}