/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.TicketModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Ticket service. Represents a row in the &quot;Ticket&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>TicketModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link TicketImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TicketImpl
 * @generated
 */
public class TicketModelImpl
	extends BaseModelImpl<Ticket> implements TicketModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ticket model instance should use the <code>Ticket</code> interface instead.
	 */
	public static final String TABLE_NAME = "Ticket";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ticketId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"createDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"key_", Types.VARCHAR}, {"type_", Types.INTEGER},
		{"extraInfo", Types.CLOB}, {"expirationDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ticketId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("key_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("extraInfo", Types.CLOB);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Ticket (mvccVersion LONG default 0 not null,ticketId LONG not null primary key,companyId LONG,createDate DATE null,classNameId LONG,classPK LONG,key_ VARCHAR(75) null,type_ INTEGER,extraInfo TEXT null,expirationDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table Ticket";

	public static final String ORDER_BY_JPQL = " ORDER BY ticket.ticketId ASC";

	public static final String ORDER_BY_SQL = " ORDER BY Ticket.ticketId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long KEY_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TICKETID_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Ticket"));

	public TicketModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _ticketId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setTicketId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _ticketId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Ticket.class;
	}

	@Override
	public String getModelClassName() {
		return Ticket.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Ticket, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Ticket, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Ticket, Object> attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Ticket)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Ticket, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Ticket, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Ticket)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Ticket, Object>> getAttributeGetterFunctions() {
		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Ticket, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<Ticket, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<Ticket, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<Ticket, Object>>();

			attributeGetterFunctions.put("mvccVersion", Ticket::getMvccVersion);
			attributeGetterFunctions.put("ticketId", Ticket::getTicketId);
			attributeGetterFunctions.put("companyId", Ticket::getCompanyId);
			attributeGetterFunctions.put("createDate", Ticket::getCreateDate);
			attributeGetterFunctions.put("classNameId", Ticket::getClassNameId);
			attributeGetterFunctions.put("classPK", Ticket::getClassPK);
			attributeGetterFunctions.put("key", Ticket::getKey);
			attributeGetterFunctions.put("type", Ticket::getType);
			attributeGetterFunctions.put("extraInfo", Ticket::getExtraInfo);
			attributeGetterFunctions.put(
				"expirationDate", Ticket::getExpirationDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<Ticket, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<Ticket, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<Ticket, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<Ticket, Long>)Ticket::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ticketId", (BiConsumer<Ticket, Long>)Ticket::setTicketId);
			attributeSetterBiConsumers.put(
				"companyId", (BiConsumer<Ticket, Long>)Ticket::setCompanyId);
			attributeSetterBiConsumers.put(
				"createDate", (BiConsumer<Ticket, Date>)Ticket::setCreateDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<Ticket, Long>)Ticket::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK", (BiConsumer<Ticket, Long>)Ticket::setClassPK);
			attributeSetterBiConsumers.put(
				"key", (BiConsumer<Ticket, String>)Ticket::setKey);
			attributeSetterBiConsumers.put(
				"type", (BiConsumer<Ticket, Integer>)Ticket::setType);
			attributeSetterBiConsumers.put(
				"extraInfo", (BiConsumer<Ticket, String>)Ticket::setExtraInfo);
			attributeSetterBiConsumers.put(
				"expirationDate",
				(BiConsumer<Ticket, Date>)Ticket::setExpirationDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getTicketId() {
		return _ticketId;
	}

	@Override
	public void setTicketId(long ticketId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ticketId = ticketId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@Override
	public String getKey() {
		if (_key == null) {
			return "";
		}
		else {
			return _key;
		}
	}

	@Override
	public void setKey(String key) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_key = key;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalKey() {
		return getColumnOriginalValue("key_");
	}

	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@Override
	public String getExtraInfo() {
		if (_extraInfo == null) {
			return "";
		}
		else {
			return _extraInfo;
		}
	}

	@Override
	public void setExtraInfo(String extraInfo) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extraInfo = extraInfo;
	}

	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Ticket.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Ticket toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Ticket>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		TicketImpl ticketImpl = new TicketImpl();

		ticketImpl.setMvccVersion(getMvccVersion());
		ticketImpl.setTicketId(getTicketId());
		ticketImpl.setCompanyId(getCompanyId());
		ticketImpl.setCreateDate(getCreateDate());
		ticketImpl.setClassNameId(getClassNameId());
		ticketImpl.setClassPK(getClassPK());
		ticketImpl.setKey(getKey());
		ticketImpl.setType(getType());
		ticketImpl.setExtraInfo(getExtraInfo());
		ticketImpl.setExpirationDate(getExpirationDate());

		ticketImpl.resetOriginalValues();

		return ticketImpl;
	}

	@Override
	public Ticket cloneWithOriginalValues() {
		TicketImpl ticketImpl = new TicketImpl();

		ticketImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		ticketImpl.setTicketId(this.<Long>getColumnOriginalValue("ticketId"));
		ticketImpl.setCompanyId(this.<Long>getColumnOriginalValue("companyId"));
		ticketImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		ticketImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		ticketImpl.setClassPK(this.<Long>getColumnOriginalValue("classPK"));
		ticketImpl.setKey(this.<String>getColumnOriginalValue("key_"));
		ticketImpl.setType(this.<Integer>getColumnOriginalValue("type_"));
		ticketImpl.setExtraInfo(
			this.<String>getColumnOriginalValue("extraInfo"));
		ticketImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));

		return ticketImpl;
	}

	@Override
	public int compareTo(Ticket ticket) {
		int value = 0;

		if (getTicketId() < ticket.getTicketId()) {
			value = -1;
		}
		else if (getTicketId() > ticket.getTicketId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Ticket)) {
			return false;
		}

		Ticket ticket = (Ticket)object;

		long primaryKey = ticket.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Ticket> toCacheModel() {
		TicketCacheModel ticketCacheModel = new TicketCacheModel();

		ticketCacheModel.mvccVersion = getMvccVersion();

		ticketCacheModel.ticketId = getTicketId();

		ticketCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			ticketCacheModel.createDate = createDate.getTime();
		}
		else {
			ticketCacheModel.createDate = Long.MIN_VALUE;
		}

		ticketCacheModel.classNameId = getClassNameId();

		ticketCacheModel.classPK = getClassPK();

		ticketCacheModel.key = getKey();

		String key = ticketCacheModel.key;

		if ((key != null) && (key.length() == 0)) {
			ticketCacheModel.key = null;
		}

		ticketCacheModel.type = getType();

		ticketCacheModel.extraInfo = getExtraInfo();

		String extraInfo = ticketCacheModel.extraInfo;

		if ((extraInfo != null) && (extraInfo.length() == 0)) {
			ticketCacheModel.extraInfo = null;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			ticketCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			ticketCacheModel.expirationDate = Long.MIN_VALUE;
		}

		return ticketCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Ticket, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Ticket, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Ticket, Object> attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((Ticket)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Ticket>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					Ticket.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ticketId;
	private long _companyId;
	private Date _createDate;
	private long _classNameId;
	private long _classPK;
	private String _key;
	private int _type;
	private String _extraInfo;
	private Date _expirationDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Ticket, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Ticket)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ticketId", _ticketId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("key_", _key);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("extraInfo", _extraInfo);
		_columnOriginalValues.put("expirationDate", _expirationDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("key_", "key");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ticketId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("createDate", 8L);

		columnBitmasks.put("classNameId", 16L);

		columnBitmasks.put("classPK", 32L);

		columnBitmasks.put("key_", 64L);

		columnBitmasks.put("type_", 128L);

		columnBitmasks.put("extraInfo", 256L);

		columnBitmasks.put("expirationDate", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Ticket _escapedModel;

}