/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;

/**
 * The extended model base implementation for the WorkflowDefinitionLink service. Represents a row in the &quot;WorkflowDefinitionLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorkflowDefinitionLinkImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WorkflowDefinitionLinkImpl
 * @see WorkflowDefinitionLink
 * @generated
 */
public abstract class WorkflowDefinitionLinkBaseImpl
	extends WorkflowDefinitionLinkModelImpl implements WorkflowDefinitionLink {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a workflow definition link model instance should use the <code>WorkflowDefinitionLink</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			WorkflowDefinitionLinkLocalServiceUtil.addWorkflowDefinitionLink(
				this);
		}
		else {
			WorkflowDefinitionLinkLocalServiceUtil.updateWorkflowDefinitionLink(
				this);
		}
	}

}