/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.service.base;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.PortletPreferenceValuePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;

import java.io.Serializable;

import java.util.List;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the portlet preference value local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.portal.service.impl.PortletPreferenceValueLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.portal.service.impl.PortletPreferenceValueLocalServiceImpl
 * @generated
 */
public abstract class PortletPreferenceValueLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements IdentifiableOSGiService, PortletPreferenceValueLocalService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>PortletPreferenceValueLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>PortletPreferenceValueLocalServiceUtil</code>.
	 */

	/**
	 * Adds the portlet preference value to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PortletPreferenceValueLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param portletPreferenceValue the portlet preference value
	 * @return the portlet preference value that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public PortletPreferenceValue addPortletPreferenceValue(
		PortletPreferenceValue portletPreferenceValue) {

		portletPreferenceValue.setNew(true);

		return portletPreferenceValuePersistence.update(portletPreferenceValue);
	}

	/**
	 * Creates a new portlet preference value with the primary key. Does not add the portlet preference value to the database.
	 *
	 * @param portletPreferenceValueId the primary key for the new portlet preference value
	 * @return the new portlet preference value
	 */
	@Override
	@Transactional(enabled = false)
	public PortletPreferenceValue createPortletPreferenceValue(
		long portletPreferenceValueId) {

		return portletPreferenceValuePersistence.create(
			portletPreferenceValueId);
	}

	/**
	 * Deletes the portlet preference value with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PortletPreferenceValueLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param portletPreferenceValueId the primary key of the portlet preference value
	 * @return the portlet preference value that was removed
	 * @throws PortalException if a portlet preference value with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public PortletPreferenceValue deletePortletPreferenceValue(
			long portletPreferenceValueId)
		throws PortalException {

		return portletPreferenceValuePersistence.remove(
			portletPreferenceValueId);
	}

	/**
	 * Deletes the portlet preference value from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PortletPreferenceValueLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param portletPreferenceValue the portlet preference value
	 * @return the portlet preference value that was removed
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public PortletPreferenceValue deletePortletPreferenceValue(
		PortletPreferenceValue portletPreferenceValue) {

		return portletPreferenceValuePersistence.remove(portletPreferenceValue);
	}

	@Override
	public <T> T dslQuery(DSLQuery dslQuery) {
		return portletPreferenceValuePersistence.dslQuery(dslQuery);
	}

	@Override
	public int dslQueryCount(DSLQuery dslQuery) {
		Long count = dslQuery(dslQuery);

		return count.intValue();
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			PortletPreferenceValue.class, clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return portletPreferenceValuePersistence.findWithDynamicQuery(
			dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PortletPreferenceValueModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return portletPreferenceValuePersistence.findWithDynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PortletPreferenceValueModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return portletPreferenceValuePersistence.findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return portletPreferenceValuePersistence.countWithDynamicQuery(
			dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return portletPreferenceValuePersistence.countWithDynamicQuery(
			dynamicQuery, projection);
	}

	@Override
	public PortletPreferenceValue fetchPortletPreferenceValue(
		long portletPreferenceValueId) {

		return portletPreferenceValuePersistence.fetchByPrimaryKey(
			portletPreferenceValueId);
	}

	/**
	 * Returns the portlet preference value with the primary key.
	 *
	 * @param portletPreferenceValueId the primary key of the portlet preference value
	 * @return the portlet preference value
	 * @throws PortalException if a portlet preference value with the primary key could not be found
	 */
	@Override
	public PortletPreferenceValue getPortletPreferenceValue(
			long portletPreferenceValueId)
		throws PortalException {

		return portletPreferenceValuePersistence.findByPrimaryKey(
			portletPreferenceValueId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(
			portletPreferenceValueLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(PortletPreferenceValue.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"portletPreferenceValueId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			portletPreferenceValueLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(
			PortletPreferenceValue.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"portletPreferenceValueId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(
			portletPreferenceValueLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(PortletPreferenceValue.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName(
			"portletPreferenceValueId");
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel createPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return portletPreferenceValuePersistence.create(
			((Long)primaryKeyObj).longValue());
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		if (_log.isWarnEnabled()) {
			_log.warn(
				"Implement PortletPreferenceValueLocalServiceImpl#deletePortletPreferenceValue(PortletPreferenceValue) to avoid orphaned data");
		}

		return portletPreferenceValueLocalService.deletePortletPreferenceValue(
			(PortletPreferenceValue)persistedModel);
	}

	@Override
	public BasePersistence<PortletPreferenceValue> getBasePersistence() {
		return portletPreferenceValuePersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return portletPreferenceValuePersistence.findByPrimaryKey(
			primaryKeyObj);
	}

	/**
	 * Returns a range of all the portlet preference values.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.PortletPreferenceValueModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of portlet preference values
	 * @param end the upper bound of the range of portlet preference values (not inclusive)
	 * @return the range of portlet preference values
	 */
	@Override
	public List<PortletPreferenceValue> getPortletPreferenceValues(
		int start, int end) {

		return portletPreferenceValuePersistence.findAll(start, end);
	}

	/**
	 * Returns the number of portlet preference values.
	 *
	 * @return the number of portlet preference values
	 */
	@Override
	public int getPortletPreferenceValuesCount() {
		return portletPreferenceValuePersistence.countAll();
	}

	/**
	 * Updates the portlet preference value in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect PortletPreferenceValueLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param portletPreferenceValue the portlet preference value
	 * @return the portlet preference value that was updated
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public PortletPreferenceValue updatePortletPreferenceValue(
		PortletPreferenceValue portletPreferenceValue) {

		return portletPreferenceValuePersistence.update(portletPreferenceValue);
	}

	/**
	 * Returns the portlet preference value local service.
	 *
	 * @return the portlet preference value local service
	 */
	public PortletPreferenceValueLocalService
		getPortletPreferenceValueLocalService() {

		return portletPreferenceValueLocalService;
	}

	/**
	 * Sets the portlet preference value local service.
	 *
	 * @param portletPreferenceValueLocalService the portlet preference value local service
	 */
	public void setPortletPreferenceValueLocalService(
		PortletPreferenceValueLocalService portletPreferenceValueLocalService) {

		this.portletPreferenceValueLocalService =
			portletPreferenceValueLocalService;
	}

	/**
	 * Returns the portlet preference value persistence.
	 *
	 * @return the portlet preference value persistence
	 */
	public PortletPreferenceValuePersistence
		getPortletPreferenceValuePersistence() {

		return portletPreferenceValuePersistence;
	}

	/**
	 * Sets the portlet preference value persistence.
	 *
	 * @param portletPreferenceValuePersistence the portlet preference value persistence
	 */
	public void setPortletPreferenceValuePersistence(
		PortletPreferenceValuePersistence portletPreferenceValuePersistence) {

		this.portletPreferenceValuePersistence =
			portletPreferenceValuePersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		persistedModelLocalServiceRegistry.register(
			"com.liferay.portal.kernel.model.PortletPreferenceValue",
			portletPreferenceValueLocalService);

		PortletPreferenceValueLocalServiceUtil.setService(
			portletPreferenceValueLocalService);
	}

	public void destroy() {
		persistedModelLocalServiceRegistry.unregister(
			"com.liferay.portal.kernel.model.PortletPreferenceValue");

		PortletPreferenceValueLocalServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return PortletPreferenceValueLocalService.class.getName();
	}

	@Override
	public CTPersistence<PortletPreferenceValue> getCTPersistence() {
		return portletPreferenceValuePersistence;
	}

	@Override
	public Class<PortletPreferenceValue> getModelClass() {
		return PortletPreferenceValue.class;
	}

	@Override
	public <R, E extends Throwable> R updateWithUnsafeFunction(
			UnsafeFunction<CTPersistence<PortletPreferenceValue>, R, E>
				updateUnsafeFunction)
		throws E {

		return updateUnsafeFunction.apply(portletPreferenceValuePersistence);
	}

	protected String getModelClassName() {
		return PortletPreferenceValue.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource =
				portletPreferenceValuePersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(type = PortletPreferenceValueLocalService.class)
	protected PortletPreferenceValueLocalService
		portletPreferenceValueLocalService;

	@BeanReference(type = PortletPreferenceValuePersistence.class)
	protected PortletPreferenceValuePersistence
		portletPreferenceValuePersistence;

	@BeanReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		PortletPreferenceValueLocalServiceBaseImpl.class);

	@BeanReference(type = PersistedModelLocalServiceRegistry.class)
	protected PersistedModelLocalServiceRegistry
		persistedModelLocalServiceRegistry;

}