/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.kaleo.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the KaleoTaskAssignmentInstance service. Represents a row in the &quot;KaleoTaskAssignmentInstance&quot; database table, with each column mapped to a property of this class.
 *
 * @author Brian Wing Shun Chan
 * @see KaleoTaskAssignmentInstanceModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.portal.workflow.kaleo.model.impl.KaleoTaskAssignmentInstanceImpl"
)
@ProviderType
public interface KaleoTaskAssignmentInstance
	extends KaleoTaskAssignmentInstanceModel, PersistedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.portal.workflow.kaleo.model.impl.KaleoTaskAssignmentInstanceImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<KaleoTaskAssignmentInstance, Long>
		KALEO_TASK_ASSIGNMENT_INSTANCE_ID_ACCESSOR =
			new Accessor<KaleoTaskAssignmentInstance, Long>() {

				@Override
				public Long get(
					KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance) {

					return kaleoTaskAssignmentInstance.
						getKaleoTaskAssignmentInstanceId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<KaleoTaskAssignmentInstance> getTypeClass() {
					return KaleoTaskAssignmentInstance.class;
				}

			};

}