/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLFileEntry service. Represents a row in the &quot;DLFileEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLFileEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLFileEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileEntryImpl
 * @generated
 */
@JSON(strict = true)
public class DLFileEntryModelImpl
	extends BaseModelImpl<DLFileEntry> implements DLFileEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library file entry model instance should use the <code>DLFileEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLFileEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"fileEntryId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"repositoryId", Types.BIGINT},
		{"folderId", Types.BIGINT}, {"treePath", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"fileName", Types.VARCHAR},
		{"extension", Types.VARCHAR}, {"mimeType", Types.VARCHAR},
		{"title", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"extraSettings", Types.CLOB}, {"fileEntryTypeId", Types.BIGINT},
		{"version", Types.VARCHAR}, {"size_", Types.BIGINT},
		{"smallImageId", Types.BIGINT}, {"largeImageId", Types.BIGINT},
		{"custom1ImageId", Types.BIGINT}, {"custom2ImageId", Types.BIGINT},
		{"manualCheckInRequired", Types.BOOLEAN},
		{"expirationDate", Types.TIMESTAMP}, {"reviewDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("folderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extension", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extraSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("fileEntryTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("size_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("smallImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("largeImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("custom1ImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("custom2ImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("manualCheckInRequired", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("reviewDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLFileEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,fileEntryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,repositoryId LONG,folderId LONG,treePath STRING null,name VARCHAR(255) null,fileName VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,smallImageId LONG,largeImageId LONG,custom1ImageId LONG,custom2ImageId LONG,manualCheckInRequired BOOLEAN,expirationDate DATE null,reviewDate DATE null,lastPublishDate DATE null,primary key (fileEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table DLFileEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlFileEntry.folderId ASC, dlFileEntry.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLFileEntry.folderId ASC, DLFileEntry.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CUSTOM1IMAGEID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CUSTOM2IMAGEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FILEENTRYTYPEID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FILENAME_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FOLDERID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LARGEIMAGEID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MIMETYPE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REPOSITORYID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SMALLIMAGEID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TITLE_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 16384L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 32768L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.document.library.kernel.model.DLFileEntry"));

	public DLFileEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fileEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFileEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fileEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLFileEntry.class;
	}

	@Override
	public String getModelClassName() {
		return DLFileEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLFileEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DLFileEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLFileEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLFileEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLFileEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLFileEntry, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLFileEntry, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<DLFileEntry, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<DLFileEntry, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<DLFileEntry, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", DLFileEntry::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", DLFileEntry::getCtCollectionId);
			attributeGetterFunctions.put("uuid", DLFileEntry::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode", DLFileEntry::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"fileEntryId", DLFileEntry::getFileEntryId);
			attributeGetterFunctions.put("groupId", DLFileEntry::getGroupId);
			attributeGetterFunctions.put(
				"companyId", DLFileEntry::getCompanyId);
			attributeGetterFunctions.put("userId", DLFileEntry::getUserId);
			attributeGetterFunctions.put("userName", DLFileEntry::getUserName);
			attributeGetterFunctions.put(
				"createDate", DLFileEntry::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", DLFileEntry::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", DLFileEntry::getClassNameId);
			attributeGetterFunctions.put("classPK", DLFileEntry::getClassPK);
			attributeGetterFunctions.put(
				"repositoryId", DLFileEntry::getRepositoryId);
			attributeGetterFunctions.put("folderId", DLFileEntry::getFolderId);
			attributeGetterFunctions.put("treePath", DLFileEntry::getTreePath);
			attributeGetterFunctions.put("name", DLFileEntry::getName);
			attributeGetterFunctions.put("fileName", DLFileEntry::getFileName);
			attributeGetterFunctions.put(
				"extension", DLFileEntry::getExtension);
			attributeGetterFunctions.put("mimeType", DLFileEntry::getMimeType);
			attributeGetterFunctions.put("title", DLFileEntry::getTitle);
			attributeGetterFunctions.put(
				"description", DLFileEntry::getDescription);
			attributeGetterFunctions.put(
				"extraSettings", DLFileEntry::getExtraSettings);
			attributeGetterFunctions.put(
				"fileEntryTypeId", DLFileEntry::getFileEntryTypeId);
			attributeGetterFunctions.put("version", DLFileEntry::getVersion);
			attributeGetterFunctions.put("size", DLFileEntry::getSize);
			attributeGetterFunctions.put(
				"smallImageId", DLFileEntry::getSmallImageId);
			attributeGetterFunctions.put(
				"largeImageId", DLFileEntry::getLargeImageId);
			attributeGetterFunctions.put(
				"custom1ImageId", DLFileEntry::getCustom1ImageId);
			attributeGetterFunctions.put(
				"custom2ImageId", DLFileEntry::getCustom2ImageId);
			attributeGetterFunctions.put(
				"manualCheckInRequired", DLFileEntry::getManualCheckInRequired);
			attributeGetterFunctions.put(
				"expirationDate", DLFileEntry::getExpirationDate);
			attributeGetterFunctions.put(
				"reviewDate", DLFileEntry::getReviewDate);
			attributeGetterFunctions.put(
				"lastPublishDate", DLFileEntry::getLastPublishDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<DLFileEntry, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<DLFileEntry, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<DLFileEntry, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<DLFileEntry, String>)DLFileEntry::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<DLFileEntry, String>)
					DLFileEntry::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"fileEntryId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFileEntryId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<DLFileEntry, Date>)DLFileEntry::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<DLFileEntry, Date>)DLFileEntry::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setClassPK);
			attributeSetterBiConsumers.put(
				"repositoryId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setRepositoryId);
			attributeSetterBiConsumers.put(
				"folderId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFolderId);
			attributeSetterBiConsumers.put(
				"treePath",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setTreePath);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<DLFileEntry, String>)DLFileEntry::setName);
			attributeSetterBiConsumers.put(
				"fileName",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setFileName);
			attributeSetterBiConsumers.put(
				"extension",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setExtension);
			attributeSetterBiConsumers.put(
				"mimeType",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setMimeType);
			attributeSetterBiConsumers.put(
				"title",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setTitle);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setDescription);
			attributeSetterBiConsumers.put(
				"extraSettings",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setExtraSettings);
			attributeSetterBiConsumers.put(
				"fileEntryTypeId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFileEntryTypeId);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<DLFileEntry, String>)DLFileEntry::setVersion);
			attributeSetterBiConsumers.put(
				"size", (BiConsumer<DLFileEntry, Long>)DLFileEntry::setSize);
			attributeSetterBiConsumers.put(
				"smallImageId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setSmallImageId);
			attributeSetterBiConsumers.put(
				"largeImageId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setLargeImageId);
			attributeSetterBiConsumers.put(
				"custom1ImageId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCustom1ImageId);
			attributeSetterBiConsumers.put(
				"custom2ImageId",
				(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCustom2ImageId);
			attributeSetterBiConsumers.put(
				"manualCheckInRequired",
				(BiConsumer<DLFileEntry, Boolean>)
					DLFileEntry::setManualCheckInRequired);
			attributeSetterBiConsumers.put(
				"expirationDate",
				(BiConsumer<DLFileEntry, Date>)DLFileEntry::setExpirationDate);
			attributeSetterBiConsumers.put(
				"reviewDate",
				(BiConsumer<DLFileEntry, Date>)DLFileEntry::setReviewDate);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<DLFileEntry, Date>)DLFileEntry::setLastPublishDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getFileEntryId() {
		return _fileEntryId;
	}

	@Override
	public void setFileEntryId(long fileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileEntryId = fileEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	@JSON
	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_repositoryId = repositoryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRepositoryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("repositoryId"));
	}

	@JSON
	@Override
	public long getFolderId() {
		return _folderId;
	}

	@Override
	public void setFolderId(long folderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_folderId = folderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("folderId"));
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getFileName() {
		if (_fileName == null) {
			return "";
		}
		else {
			return _fileName;
		}
	}

	@Override
	public void setFileName(String fileName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileName = fileName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFileName() {
		return getColumnOriginalValue("fileName");
	}

	@JSON
	@Override
	public String getExtension() {
		if (_extension == null) {
			return "";
		}
		else {
			return _extension;
		}
	}

	@Override
	public void setExtension(String extension) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extension = extension;
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return "";
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mimeType = mimeType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalMimeType() {
		return getColumnOriginalValue("mimeType");
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTitle() {
		return getColumnOriginalValue("title");
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getExtraSettings() {
		if (_extraSettings == null) {
			return "";
		}
		else {
			return _extraSettings;
		}
	}

	@Override
	public void setExtraSettings(String extraSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extraSettings = extraSettings;
	}

	@JSON
	@Override
	public long getFileEntryTypeId() {
		return _fileEntryTypeId;
	}

	@Override
	public void setFileEntryTypeId(long fileEntryTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fileEntryTypeId = fileEntryTypeId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalFileEntryTypeId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("fileEntryTypeId"));
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	@JSON
	@Override
	public long getSize() {
		return _size;
	}

	@Override
	public void setSize(long size) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_size = size;
	}

	@JSON
	@Override
	public long getSmallImageId() {
		return _smallImageId;
	}

	@Override
	public void setSmallImageId(long smallImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallImageId = smallImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalSmallImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("smallImageId"));
	}

	@JSON
	@Override
	public long getLargeImageId() {
		return _largeImageId;
	}

	@Override
	public void setLargeImageId(long largeImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_largeImageId = largeImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLargeImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("largeImageId"));
	}

	@JSON
	@Override
	public long getCustom1ImageId() {
		return _custom1ImageId;
	}

	@Override
	public void setCustom1ImageId(long custom1ImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_custom1ImageId = custom1ImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCustom1ImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("custom1ImageId"));
	}

	@JSON
	@Override
	public long getCustom2ImageId() {
		return _custom2ImageId;
	}

	@Override
	public void setCustom2ImageId(long custom2ImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_custom2ImageId = custom2ImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCustom2ImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("custom2ImageId"));
	}

	@JSON
	@Override
	public boolean getManualCheckInRequired() {
		return _manualCheckInRequired;
	}

	@JSON
	@Override
	public boolean isManualCheckInRequired() {
		return _manualCheckInRequired;
	}

	@Override
	public void setManualCheckInRequired(boolean manualCheckInRequired) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manualCheckInRequired = manualCheckInRequired;
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getReviewDate() {
		return _reviewDate;
	}

	@Override
	public void setReviewDate(Date reviewDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reviewDate = reviewDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(DLFileEntry.class.getName()),
			getClassNameId());
	}

	@Override
	public int getStatus() {
		return 0;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLFileEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLFileEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLFileEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLFileEntryImpl dlFileEntryImpl = new DLFileEntryImpl();

		dlFileEntryImpl.setMvccVersion(getMvccVersion());
		dlFileEntryImpl.setCtCollectionId(getCtCollectionId());
		dlFileEntryImpl.setUuid(getUuid());
		dlFileEntryImpl.setExternalReferenceCode(getExternalReferenceCode());
		dlFileEntryImpl.setFileEntryId(getFileEntryId());
		dlFileEntryImpl.setGroupId(getGroupId());
		dlFileEntryImpl.setCompanyId(getCompanyId());
		dlFileEntryImpl.setUserId(getUserId());
		dlFileEntryImpl.setUserName(getUserName());
		dlFileEntryImpl.setCreateDate(getCreateDate());
		dlFileEntryImpl.setModifiedDate(getModifiedDate());
		dlFileEntryImpl.setClassNameId(getClassNameId());
		dlFileEntryImpl.setClassPK(getClassPK());
		dlFileEntryImpl.setRepositoryId(getRepositoryId());
		dlFileEntryImpl.setFolderId(getFolderId());
		dlFileEntryImpl.setTreePath(getTreePath());
		dlFileEntryImpl.setName(getName());
		dlFileEntryImpl.setFileName(getFileName());
		dlFileEntryImpl.setExtension(getExtension());
		dlFileEntryImpl.setMimeType(getMimeType());
		dlFileEntryImpl.setTitle(getTitle());
		dlFileEntryImpl.setDescription(getDescription());
		dlFileEntryImpl.setExtraSettings(getExtraSettings());
		dlFileEntryImpl.setFileEntryTypeId(getFileEntryTypeId());
		dlFileEntryImpl.setVersion(getVersion());
		dlFileEntryImpl.setSize(getSize());
		dlFileEntryImpl.setSmallImageId(getSmallImageId());
		dlFileEntryImpl.setLargeImageId(getLargeImageId());
		dlFileEntryImpl.setCustom1ImageId(getCustom1ImageId());
		dlFileEntryImpl.setCustom2ImageId(getCustom2ImageId());
		dlFileEntryImpl.setManualCheckInRequired(isManualCheckInRequired());
		dlFileEntryImpl.setExpirationDate(getExpirationDate());
		dlFileEntryImpl.setReviewDate(getReviewDate());
		dlFileEntryImpl.setLastPublishDate(getLastPublishDate());

		dlFileEntryImpl.resetOriginalValues();

		return dlFileEntryImpl;
	}

	@Override
	public DLFileEntry cloneWithOriginalValues() {
		DLFileEntryImpl dlFileEntryImpl = new DLFileEntryImpl();

		dlFileEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		dlFileEntryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		dlFileEntryImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		dlFileEntryImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		dlFileEntryImpl.setFileEntryId(
			this.<Long>getColumnOriginalValue("fileEntryId"));
		dlFileEntryImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		dlFileEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		dlFileEntryImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		dlFileEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		dlFileEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		dlFileEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		dlFileEntryImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		dlFileEntryImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		dlFileEntryImpl.setRepositoryId(
			this.<Long>getColumnOriginalValue("repositoryId"));
		dlFileEntryImpl.setFolderId(
			this.<Long>getColumnOriginalValue("folderId"));
		dlFileEntryImpl.setTreePath(
			this.<String>getColumnOriginalValue("treePath"));
		dlFileEntryImpl.setName(this.<String>getColumnOriginalValue("name"));
		dlFileEntryImpl.setFileName(
			this.<String>getColumnOriginalValue("fileName"));
		dlFileEntryImpl.setExtension(
			this.<String>getColumnOriginalValue("extension"));
		dlFileEntryImpl.setMimeType(
			this.<String>getColumnOriginalValue("mimeType"));
		dlFileEntryImpl.setTitle(this.<String>getColumnOriginalValue("title"));
		dlFileEntryImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		dlFileEntryImpl.setExtraSettings(
			this.<String>getColumnOriginalValue("extraSettings"));
		dlFileEntryImpl.setFileEntryTypeId(
			this.<Long>getColumnOriginalValue("fileEntryTypeId"));
		dlFileEntryImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		dlFileEntryImpl.setSize(this.<Long>getColumnOriginalValue("size_"));
		dlFileEntryImpl.setSmallImageId(
			this.<Long>getColumnOriginalValue("smallImageId"));
		dlFileEntryImpl.setLargeImageId(
			this.<Long>getColumnOriginalValue("largeImageId"));
		dlFileEntryImpl.setCustom1ImageId(
			this.<Long>getColumnOriginalValue("custom1ImageId"));
		dlFileEntryImpl.setCustom2ImageId(
			this.<Long>getColumnOriginalValue("custom2ImageId"));
		dlFileEntryImpl.setManualCheckInRequired(
			this.<Boolean>getColumnOriginalValue("manualCheckInRequired"));
		dlFileEntryImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		dlFileEntryImpl.setReviewDate(
			this.<Date>getColumnOriginalValue("reviewDate"));
		dlFileEntryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return dlFileEntryImpl;
	}

	@Override
	public int compareTo(DLFileEntry dlFileEntry) {
		int value = 0;

		if (getFolderId() < dlFileEntry.getFolderId()) {
			value = -1;
		}
		else if (getFolderId() > dlFileEntry.getFolderId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getName().compareTo(dlFileEntry.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLFileEntry)) {
			return false;
		}

		DLFileEntry dlFileEntry = (DLFileEntry)object;

		long primaryKey = dlFileEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLFileEntry> toCacheModel() {
		DLFileEntryCacheModel dlFileEntryCacheModel =
			new DLFileEntryCacheModel();

		dlFileEntryCacheModel.mvccVersion = getMvccVersion();

		dlFileEntryCacheModel.ctCollectionId = getCtCollectionId();

		dlFileEntryCacheModel.uuid = getUuid();

		String uuid = dlFileEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			dlFileEntryCacheModel.uuid = null;
		}

		dlFileEntryCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			dlFileEntryCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			dlFileEntryCacheModel.externalReferenceCode = null;
		}

		dlFileEntryCacheModel.fileEntryId = getFileEntryId();

		dlFileEntryCacheModel.groupId = getGroupId();

		dlFileEntryCacheModel.companyId = getCompanyId();

		dlFileEntryCacheModel.userId = getUserId();

		dlFileEntryCacheModel.userName = getUserName();

		String userName = dlFileEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			dlFileEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			dlFileEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			dlFileEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			dlFileEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			dlFileEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		dlFileEntryCacheModel.classNameId = getClassNameId();

		dlFileEntryCacheModel.classPK = getClassPK();

		dlFileEntryCacheModel.repositoryId = getRepositoryId();

		dlFileEntryCacheModel.folderId = getFolderId();

		dlFileEntryCacheModel.treePath = getTreePath();

		String treePath = dlFileEntryCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			dlFileEntryCacheModel.treePath = null;
		}

		dlFileEntryCacheModel.name = getName();

		String name = dlFileEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			dlFileEntryCacheModel.name = null;
		}

		dlFileEntryCacheModel.fileName = getFileName();

		String fileName = dlFileEntryCacheModel.fileName;

		if ((fileName != null) && (fileName.length() == 0)) {
			dlFileEntryCacheModel.fileName = null;
		}

		dlFileEntryCacheModel.extension = getExtension();

		String extension = dlFileEntryCacheModel.extension;

		if ((extension != null) && (extension.length() == 0)) {
			dlFileEntryCacheModel.extension = null;
		}

		dlFileEntryCacheModel.mimeType = getMimeType();

		String mimeType = dlFileEntryCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			dlFileEntryCacheModel.mimeType = null;
		}

		dlFileEntryCacheModel.title = getTitle();

		String title = dlFileEntryCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			dlFileEntryCacheModel.title = null;
		}

		dlFileEntryCacheModel.description = getDescription();

		String description = dlFileEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			dlFileEntryCacheModel.description = null;
		}

		dlFileEntryCacheModel.extraSettings = getExtraSettings();

		String extraSettings = dlFileEntryCacheModel.extraSettings;

		if ((extraSettings != null) && (extraSettings.length() == 0)) {
			dlFileEntryCacheModel.extraSettings = null;
		}

		dlFileEntryCacheModel.fileEntryTypeId = getFileEntryTypeId();

		dlFileEntryCacheModel.version = getVersion();

		String version = dlFileEntryCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			dlFileEntryCacheModel.version = null;
		}

		dlFileEntryCacheModel.size = getSize();

		dlFileEntryCacheModel.smallImageId = getSmallImageId();

		dlFileEntryCacheModel.largeImageId = getLargeImageId();

		dlFileEntryCacheModel.custom1ImageId = getCustom1ImageId();

		dlFileEntryCacheModel.custom2ImageId = getCustom2ImageId();

		dlFileEntryCacheModel.manualCheckInRequired = isManualCheckInRequired();

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			dlFileEntryCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			dlFileEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date reviewDate = getReviewDate();

		if (reviewDate != null) {
			dlFileEntryCacheModel.reviewDate = reviewDate.getTime();
		}
		else {
			dlFileEntryCacheModel.reviewDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			dlFileEntryCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			dlFileEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return dlFileEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLFileEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DLFileEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLFileEntry>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DLFileEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _fileEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _repositoryId;
	private long _folderId;
	private String _treePath;
	private String _name;
	private String _fileName;
	private String _extension;
	private String _mimeType;
	private String _title;
	private String _description;
	private String _extraSettings;
	private long _fileEntryTypeId;
	private String _version;
	private long _size;
	private long _smallImageId;
	private long _largeImageId;
	private long _custom1ImageId;
	private long _custom2ImageId;
	private boolean _manualCheckInRequired;
	private Date _expirationDate;
	private Date _reviewDate;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DLFileEntry, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DLFileEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("fileEntryId", _fileEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("repositoryId", _repositoryId);
		_columnOriginalValues.put("folderId", _folderId);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("fileName", _fileName);
		_columnOriginalValues.put("extension", _extension);
		_columnOriginalValues.put("mimeType", _mimeType);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("extraSettings", _extraSettings);
		_columnOriginalValues.put("fileEntryTypeId", _fileEntryTypeId);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("size_", _size);
		_columnOriginalValues.put("smallImageId", _smallImageId);
		_columnOriginalValues.put("largeImageId", _largeImageId);
		_columnOriginalValues.put("custom1ImageId", _custom1ImageId);
		_columnOriginalValues.put("custom2ImageId", _custom2ImageId);
		_columnOriginalValues.put(
			"manualCheckInRequired", _manualCheckInRequired);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("reviewDate", _reviewDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("size_", "size");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("fileEntryId", 16L);

		columnBitmasks.put("groupId", 32L);

		columnBitmasks.put("companyId", 64L);

		columnBitmasks.put("userId", 128L);

		columnBitmasks.put("userName", 256L);

		columnBitmasks.put("createDate", 512L);

		columnBitmasks.put("modifiedDate", 1024L);

		columnBitmasks.put("classNameId", 2048L);

		columnBitmasks.put("classPK", 4096L);

		columnBitmasks.put("repositoryId", 8192L);

		columnBitmasks.put("folderId", 16384L);

		columnBitmasks.put("treePath", 32768L);

		columnBitmasks.put("name", 65536L);

		columnBitmasks.put("fileName", 131072L);

		columnBitmasks.put("extension", 262144L);

		columnBitmasks.put("mimeType", 524288L);

		columnBitmasks.put("title", 1048576L);

		columnBitmasks.put("description", 2097152L);

		columnBitmasks.put("extraSettings", 4194304L);

		columnBitmasks.put("fileEntryTypeId", 8388608L);

		columnBitmasks.put("version", 16777216L);

		columnBitmasks.put("size_", 33554432L);

		columnBitmasks.put("smallImageId", 67108864L);

		columnBitmasks.put("largeImageId", 134217728L);

		columnBitmasks.put("custom1ImageId", 268435456L);

		columnBitmasks.put("custom2ImageId", 536870912L);

		columnBitmasks.put("manualCheckInRequired", 1073741824L);

		columnBitmasks.put("expirationDate", 2147483648L);

		columnBitmasks.put("reviewDate", 4294967296L);

		columnBitmasks.put("lastPublishDate", 8589934592L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DLFileEntry _escapedModel;

}