/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.ratings.model.impl;

import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalServiceUtil;

/**
 * The extended model base implementation for the RatingsEntry service. Represents a row in the &quot;RatingsEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RatingsEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RatingsEntryImpl
 * @see RatingsEntry
 * @generated
 */
public abstract class RatingsEntryBaseImpl
	extends RatingsEntryModelImpl implements RatingsEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ratings entry model instance should use the <code>RatingsEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			RatingsEntryLocalServiceUtil.addRatingsEntry(this);
		}
		else {
			RatingsEntryLocalServiceUtil.updateRatingsEntry(this);
		}
	}

}