/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.social.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.SocialActivitySet;
import com.liferay.social.kernel.model.SocialActivitySetModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SocialActivitySet service. Represents a row in the &quot;SocialActivitySet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SocialActivitySetModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SocialActivitySetImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialActivitySetImpl
 * @generated
 */
public class SocialActivitySetModelImpl
	extends BaseModelImpl<SocialActivitySet> implements SocialActivitySetModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a social activity set model instance should use the <code>SocialActivitySet</code> interface instead.
	 */
	public static final String TABLE_NAME = "SocialActivitySet";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"activitySetId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"createDate", Types.BIGINT}, {"modifiedDate", Types.BIGINT},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"type_", Types.INTEGER}, {"extraData", Types.VARCHAR},
		{"activityCount", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("activitySetId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("extraData", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("activityCount", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SocialActivitySet (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,activitySetId LONG not null,groupId LONG,companyId LONG,userId LONG,createDate LONG,modifiedDate LONG,classNameId LONG,classPK LONG,type_ INTEGER,extraData STRING null,activityCount INTEGER,primary key (activitySetId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table SocialActivitySet";

	public static final String ORDER_BY_JPQL =
		" ORDER BY socialActivitySet.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SocialActivitySet.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.social.kernel.model.SocialActivitySet"));

	public SocialActivitySetModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _activitySetId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setActivitySetId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _activitySetId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SocialActivitySet.class;
	}

	@Override
	public String getModelClassName() {
		return SocialActivitySet.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SocialActivitySet, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SocialActivitySet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivitySet, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SocialActivitySet)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SocialActivitySet, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SocialActivitySet, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SocialActivitySet)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SocialActivitySet, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SocialActivitySet, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<SocialActivitySet, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<SocialActivitySet, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<SocialActivitySet, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", SocialActivitySet::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", SocialActivitySet::getCtCollectionId);
			attributeGetterFunctions.put(
				"activitySetId", SocialActivitySet::getActivitySetId);
			attributeGetterFunctions.put(
				"groupId", SocialActivitySet::getGroupId);
			attributeGetterFunctions.put(
				"companyId", SocialActivitySet::getCompanyId);
			attributeGetterFunctions.put(
				"userId", SocialActivitySet::getUserId);
			attributeGetterFunctions.put(
				"createDate", SocialActivitySet::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", SocialActivitySet::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", SocialActivitySet::getClassNameId);
			attributeGetterFunctions.put(
				"classPK", SocialActivitySet::getClassPK);
			attributeGetterFunctions.put("type", SocialActivitySet::getType);
			attributeGetterFunctions.put(
				"extraData", SocialActivitySet::getExtraData);
			attributeGetterFunctions.put(
				"activityCount", SocialActivitySet::getActivityCount);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<SocialActivitySet, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<SocialActivitySet, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<SocialActivitySet, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"activitySetId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setActivitySetId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setUserId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK",
				(BiConsumer<SocialActivitySet, Long>)
					SocialActivitySet::setClassPK);
			attributeSetterBiConsumers.put(
				"type",
				(BiConsumer<SocialActivitySet, Integer>)
					SocialActivitySet::setType);
			attributeSetterBiConsumers.put(
				"extraData",
				(BiConsumer<SocialActivitySet, String>)
					SocialActivitySet::setExtraData);
			attributeSetterBiConsumers.put(
				"activityCount",
				(BiConsumer<SocialActivitySet, Integer>)
					SocialActivitySet::setActivityCount);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getActivitySetId() {
		return _activitySetId;
	}

	@Override
	public void setActivitySetId(long activitySetId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_activitySetId = activitySetId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public long getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(long createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public long getModifiedDate() {
		return _modifiedDate;
	}

	@Override
	public void setModifiedDate(long modifiedDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@Override
	public String getExtraData() {
		if (_extraData == null) {
			return "";
		}
		else {
			return _extraData;
		}
	}

	@Override
	public void setExtraData(String extraData) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extraData = extraData;
	}

	@Override
	public int getActivityCount() {
		return _activityCount;
	}

	@Override
	public void setActivityCount(int activityCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_activityCount = activityCount;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SocialActivitySet.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SocialActivitySet toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SocialActivitySet>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SocialActivitySetImpl socialActivitySetImpl =
			new SocialActivitySetImpl();

		socialActivitySetImpl.setMvccVersion(getMvccVersion());
		socialActivitySetImpl.setCtCollectionId(getCtCollectionId());
		socialActivitySetImpl.setActivitySetId(getActivitySetId());
		socialActivitySetImpl.setGroupId(getGroupId());
		socialActivitySetImpl.setCompanyId(getCompanyId());
		socialActivitySetImpl.setUserId(getUserId());
		socialActivitySetImpl.setCreateDate(getCreateDate());
		socialActivitySetImpl.setModifiedDate(getModifiedDate());
		socialActivitySetImpl.setClassNameId(getClassNameId());
		socialActivitySetImpl.setClassPK(getClassPK());
		socialActivitySetImpl.setType(getType());
		socialActivitySetImpl.setExtraData(getExtraData());
		socialActivitySetImpl.setActivityCount(getActivityCount());

		socialActivitySetImpl.resetOriginalValues();

		return socialActivitySetImpl;
	}

	@Override
	public SocialActivitySet cloneWithOriginalValues() {
		SocialActivitySetImpl socialActivitySetImpl =
			new SocialActivitySetImpl();

		socialActivitySetImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		socialActivitySetImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		socialActivitySetImpl.setActivitySetId(
			this.<Long>getColumnOriginalValue("activitySetId"));
		socialActivitySetImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		socialActivitySetImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		socialActivitySetImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		socialActivitySetImpl.setCreateDate(
			this.<Long>getColumnOriginalValue("createDate"));
		socialActivitySetImpl.setModifiedDate(
			this.<Long>getColumnOriginalValue("modifiedDate"));
		socialActivitySetImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		socialActivitySetImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		socialActivitySetImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		socialActivitySetImpl.setExtraData(
			this.<String>getColumnOriginalValue("extraData"));
		socialActivitySetImpl.setActivityCount(
			this.<Integer>getColumnOriginalValue("activityCount"));

		return socialActivitySetImpl;
	}

	@Override
	public int compareTo(SocialActivitySet socialActivitySet) {
		int value = 0;

		if (getModifiedDate() < socialActivitySet.getModifiedDate()) {
			value = -1;
		}
		else if (getModifiedDate() > socialActivitySet.getModifiedDate()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SocialActivitySet)) {
			return false;
		}

		SocialActivitySet socialActivitySet = (SocialActivitySet)object;

		long primaryKey = socialActivitySet.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SocialActivitySet> toCacheModel() {
		SocialActivitySetCacheModel socialActivitySetCacheModel =
			new SocialActivitySetCacheModel();

		socialActivitySetCacheModel.mvccVersion = getMvccVersion();

		socialActivitySetCacheModel.ctCollectionId = getCtCollectionId();

		socialActivitySetCacheModel.activitySetId = getActivitySetId();

		socialActivitySetCacheModel.groupId = getGroupId();

		socialActivitySetCacheModel.companyId = getCompanyId();

		socialActivitySetCacheModel.userId = getUserId();

		socialActivitySetCacheModel.createDate = getCreateDate();

		socialActivitySetCacheModel.modifiedDate = getModifiedDate();

		socialActivitySetCacheModel.classNameId = getClassNameId();

		socialActivitySetCacheModel.classPK = getClassPK();

		socialActivitySetCacheModel.type = getType();

		socialActivitySetCacheModel.extraData = getExtraData();

		String extraData = socialActivitySetCacheModel.extraData;

		if ((extraData != null) && (extraData.length() == 0)) {
			socialActivitySetCacheModel.extraData = null;
		}

		socialActivitySetCacheModel.activityCount = getActivityCount();

		return socialActivitySetCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SocialActivitySet, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SocialActivitySet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SocialActivitySet, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SocialActivitySet)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SocialActivitySet>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SocialActivitySet.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _activitySetId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private long _createDate;
	private long _modifiedDate;
	private long _classNameId;
	private long _classPK;
	private int _type;
	private String _extraData;
	private int _activityCount;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<SocialActivitySet, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SocialActivitySet)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("activitySetId", _activitySetId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("extraData", _extraData);
		_columnOriginalValues.put("activityCount", _activityCount);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("activitySetId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("classNameId", 256L);

		columnBitmasks.put("classPK", 512L);

		columnBitmasks.put("type_", 1024L);

		columnBitmasks.put("extraData", 2048L);

		columnBitmasks.put("activityCount", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SocialActivitySet _escapedModel;

}