/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassInvoker;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.ActionCommand;
import com.liferay.util.bridges.mvc.ActionCommandCache;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;

public class MVCPortlet
extends LiferayPortlet {
    private static Log _log = LogFactoryUtil.getLog(MVCPortlet.class);
    protected ActionCommandCache _actionCommandCache;
    protected String aboutJSP;
    protected boolean clearRequestParameters;
    protected String configJSP;
    protected boolean copyRequestParameters;
    protected String editDefaultsJSP;
    protected String editGuestJSP;
    protected String editJSP;
    protected String helpJSP;
    protected String jspPath;
    protected String previewJSP;
    protected String printJSP;
    protected String viewJSP;

    public void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.aboutJSP, renderRequest, renderResponse);
    }

    public void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.configJSP, renderRequest, renderResponse);
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editJSP, renderRequest, renderResponse);
        }
    }

    public void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editDefaultsJSP, renderRequest, renderResponse);
        }
    }

    public void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editGuestJSP, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.helpJSP, renderRequest, renderResponse);
    }

    public void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.previewJSP, renderRequest, renderResponse);
    }

    public void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.printJSP, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.viewJSP, renderRequest, renderResponse);
    }

    public void init() throws PortletException {
        super.init();
        this.jspPath = this.getInitParameter("jsp-path");
        if (Validator.isNull((String)this.jspPath)) {
            this.jspPath = "/";
        } else {
            if (this.jspPath.contains("\\") || this.jspPath.contains("//") || this.jspPath.contains(".") || this.jspPath.contains(" ")) {
                throw new PortletException("jsp-path " + this.jspPath + " has invalid characters");
            }
            if (!this.jspPath.startsWith("/") || !this.jspPath.endsWith("/")) {
                throw new PortletException("jsp-path " + this.jspPath + " must start and end with a /");
            }
        }
        this.aboutJSP = this.getInitParameter("about-jsp");
        this.configJSP = this.getInitParameter("config-jsp");
        this.editJSP = this.getInitParameter("edit-jsp");
        this.editDefaultsJSP = this.getInitParameter("edit-defaults-jsp");
        this.editGuestJSP = this.getInitParameter("edit-guest-jsp");
        this.helpJSP = this.getInitParameter("help-jsp");
        this.previewJSP = this.getInitParameter("preview-jsp");
        this.printJSP = this.getInitParameter("print-jsp");
        this.viewJSP = this.getInitParameter("view-jsp");
        this.clearRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("clear-request-parameters"));
        this.copyRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("copy-request-parameters"));
        String packagePrefix = this.getInitParameter("action.package.prefix");
        if (Validator.isNotNull((String)packagePrefix)) {
            this._actionCommandCache = new ActionCommandCache(packagePrefix);
        }
    }

    public void invokeTaglibDiscussion(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Object[] arguments = new Object[]{new NullWrapper("org.apache.struts.action.ActionMapping"), new NullWrapper("org.apache.struts.action.ActionForm"), this.getPortletConfig(), actionRequest, actionResponse};
        PortalClassInvoker.invoke((String)"com.liferay.portlet.messageboards.action.EditDiscussionAction", (String)"processAction", (Object[])arguments);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        if (this.copyRequestParameters) {
            PortalUtil.copyRequestParameters((ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String jspPage = resourceRequest.getParameter("jspPage");
        if (jspPage != null) {
            this.include(jspPage, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    protected boolean callActionMethod(ActionRequest request, ActionResponse response) throws PortletException {
        if (this._actionCommandCache == null || this._actionCommandCache.isEmpty()) {
            return super.callActionMethod(request, response);
        }
        String actionName = ParamUtil.getString((PortletRequest)request, (String)"javax.portlet.action");
        if (!actionName.contains(",")) {
            ActionCommand actionCommand = this._actionCommandCache.getActionCommand(actionName);
            if (actionCommand != ActionCommandCache.EMPTY) {
                return actionCommand.processCommand((PortletRequest)request, (PortletResponse)response);
            }
        } else {
            List<ActionCommand> actionCommands = this._actionCommandCache.getActionCommandChain(actionName);
            if (actionCommands.isEmpty()) {
                return false;
            }
            for (ActionCommand actionCommand : actionCommands) {
                if (actionCommand.processCommand((PortletRequest)request, (PortletResponse)response)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void checkJSPPath(String path) throws PortletException {
        if (!path.startsWith(this.jspPath) || path.contains("..") || !PortalUtil.isValidResourceId((String)path)) {
            throw new PortletException("Path " + path + " is not accessible by this portlet");
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String jspPage = renderRequest.getParameter("jspPage");
        if (jspPage != null) {
            if (!this.isProcessRenderRequest(renderRequest)) {
                renderRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
                return;
            }
            WindowState windowState = renderRequest.getWindowState();
            if (windowState.equals((Object)WindowState.MINIMIZED)) {
                return;
            }
            this.include(jspPage, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected void include(String path, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse, "ACTION_PHASE");
    }

    protected void include(String path, EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)eventRequest, (PortletResponse)eventResponse, "EVENT_PHASE");
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(path + " is not a valid include"));
        } else {
            this.checkJSPPath(path);
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", "true");
        }
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse, "RENDER_PHASE");
    }

    protected void include(String path, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
    }
}

