/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheResponseData
implements Serializable {
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private byte[] _content;
    private int _contentLength;
    private String _contentType;
    private Map<String, List<Header>> _headers;

    public CacheResponseData(StringServletResponse stringResponse) {
        if (stringResponse.isCalledGetOutputStream()) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = stringResponse.getUnsyncByteArrayOutputStream();
            this._content = unsyncByteArrayOutputStream.unsafeGetByteArray();
            this._contentLength = unsyncByteArrayOutputStream.size();
        } else {
            String content = stringResponse.getString();
            ByteBuffer contentByteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (String)content);
            this._content = contentByteBuffer.array();
            this._contentLength = contentByteBuffer.limit();
        }
        this._contentType = stringResponse.getContentType();
        this._headers = stringResponse.getHeaders();
    }

    public CacheResponseData(byte[] content, int contentLength, String contentType, Map<String, List<Header>> headers) {
        this._content = content;
        this._contentLength = contentLength;
        this._contentType = contentType;
        this._headers = headers;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public byte[] getContent() {
        return this._content;
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public String getContentType() {
        return this._contentType;
    }

    public Map<String, List<Header>> getHeaders() {
        return this._headers;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }
}

