/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portletmvc4spring.security;

import com.liferay.portletmvc4spring.context.PortletApplicationContextUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderParameters;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.pluto.portlet.servlet.adapter.HttpServletRequestAdapter;
import org.apache.pluto.portlet.servlet.adapter.HttpServletResponseAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.filter.DelegatingFilterProxy;

public class SpringSecurityPortletFilter
implements ActionFilter,
RenderFilter,
ResourceFilter {
    private static final String ACCESS_DENIED = SpringSecurityPortletFilter.class.getName() + "_ACCESS_DENIED";
    private PortletContext portletContext;

    public void destroy() {
    }

    public void doFilter(ActionRequest actionRequest, ActionResponse actionResponse, FilterChain portletFilterChain) throws IOException, PortletException {
        ApplicationContext applicationContext = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.portletContext);
        DelegatingFilterProxy delegatingFilterProxy = this._getBean(applicationContext, DelegatingFilterProxy.class);
        if (delegatingFilterProxy != null) {
            try {
                delegatingFilterProxy.doFilter((ServletRequest)new HttpServletRequestAdapter((PortletRequest)actionRequest), (ServletResponse)new HttpServletResponseAdapter((PortletResponse)actionResponse), (javax.servlet.FilterChain)EmptyServletFilterChain.INSTANCE);
            }
            catch (AccessDeniedException e) {
                MutableRenderParameters mutableRenderParameters = actionResponse.getRenderParameters();
                mutableRenderParameters.setValue(ACCESS_DENIED, Boolean.TRUE.toString());
                return;
            }
            catch (ServletException e) {
                throw new PortletException((Throwable)e);
            }
        }
        portletFilterChain.doFilter(actionRequest, actionResponse);
    }

    public void doFilter(ResourceRequest resourceRequest, ResourceResponse resourceResponse, FilterChain portletFilterChain) throws IOException, PortletException {
        ApplicationContext applicationContext;
        DelegatingFilterProxy delegatingFilterProxy;
        if ("post".equalsIgnoreCase(resourceRequest.getMethod()) && (delegatingFilterProxy = this._getBean(applicationContext = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.portletContext), DelegatingFilterProxy.class)) != null) {
            try {
                delegatingFilterProxy.doFilter((ServletRequest)new HttpServletRequestAdapter((PortletRequest)resourceRequest), (ServletResponse)new HttpServletResponseAdapter((PortletResponse)resourceResponse), (javax.servlet.FilterChain)EmptyServletFilterChain.INSTANCE);
            }
            catch (AccessDeniedException e) {
                resourceResponse.setStatus(403);
                return;
            }
            catch (ServletException e) {
                throw new PortletException((Throwable)e);
            }
        }
        portletFilterChain.doFilter(resourceRequest, resourceResponse);
    }

    public void doFilter(RenderRequest renderRequest, RenderResponse renderResponse, FilterChain filterChain) throws IOException, PortletException {
        RenderParameters renderParameters = renderRequest.getRenderParameters();
        if (renderParameters.getValue(ACCESS_DENIED) != null) {
            this.renderError(PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.portletContext), renderRequest.getLocale(), renderResponse.getWriter(), "access-denied", "Access Denied");
        } else {
            filterChain.doFilter(renderRequest, renderResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws PortletException {
        this.portletContext = filterConfig.getPortletContext();
    }

    protected void renderError(Writer writer, String message) throws IOException {
        writer.write("<span class=\"portlet-msg-error\">");
        writer.write(message);
        writer.write("</span>");
    }

    protected void renderError(ApplicationContext applicationContext, Locale locale, Writer writer, String messageKey, String defaultMessage) throws IOException {
        String message = defaultMessage;
        AbstractMessageSource messageSource = this._getBean(applicationContext, AbstractMessageSource.class);
        if (messageSource != null) {
            message = messageSource.getMessage(messageKey, null, message, locale);
        }
        this.renderError(writer, message);
    }

    private <T> T _getBean(ApplicationContext applicationContext, Class<T> beanType) {
        String[] beanNamesForType = applicationContext.getBeanNamesForType(beanType);
        if (beanNamesForType.length > 0) {
            return (T)applicationContext.getBean(beanType);
        }
        return null;
    }

    private static class EmptyServletFilterChain
    implements javax.servlet.FilterChain {
        public static EmptyServletFilterChain INSTANCE = new EmptyServletFilterChain();

        private EmptyServletFilterChain() {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        }
    }
}

