/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.spring.mock.web.portlet;

import com.liferay.spring.mock.web.portlet.MockMutableRenderParameters;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletSecurityException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class MockBaseURL
implements BaseURL {
    public static final String URL_TYPE_RENDER = "render";
    public static final String URL_TYPE_ACTION = "action";
    private static final String ENCODING = "UTF-8";
    protected final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private MutableRenderParameters mutableRenderParameters;
    private boolean secure = false;
    private final Map<String, String[]> properties = new LinkedHashMap<String, String[]>();

    public void addProperty(String key, String value) {
        String[] values = this.properties.get(key);
        if (values != null) {
            this.properties.put(key, StringUtils.addStringToArray((String[])values, (String)value));
        } else {
            this.properties.put(key, new String[]{value});
        }
    }

    public Appendable append(Appendable appendable) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Appendable append(Appendable appendable, boolean b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public MutableRenderParameters getRenderParameters() {
        if (this.mutableRenderParameters == null) {
            this.mutableRenderParameters = new MockMutableRenderParameters();
        }
        return this.mutableRenderParameters;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setParameter(String key, String value) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)value, (String)"Parameter value must not be null");
        this.parameters.put(key, new String[]{value});
    }

    public void setParameter(String key, String[] values) {
        Assert.notNull((Object)key, (String)"Parameter key must be null");
        Assert.notNull((Object)values, (String)"Parameter values must not be null");
        this.parameters.put(key, values);
    }

    public void setParameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, (String)"Parameters Map must not be null");
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, new String[]{value});
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this.secure = secure;
    }

    public void write(Writer out) throws IOException {
        out.write(this.toString());
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        out.write(this.toString());
    }

    protected String encodeParameter(String name, String value) {
        try {
            return URLEncoder.encode(name, ENCODING) + "=" + URLEncoder.encode(value, ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    protected String encodeParameter(String name, String[] values) {
        try {
            StringBuilder sb = new StringBuilder();
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                sb.append(i > 0 ? ";" : "").append(URLEncoder.encode(name, ENCODING)).append("=").append(URLEncoder.encode(values[i], ENCODING));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

