/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.spring.mock.web.portlet;

import com.liferay.spring.mock.web.portlet.MockMutableRenderParameters;
import com.liferay.spring.mock.web.portlet.MockPortletResponse;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MockStateAwareResponse
extends MockPortletResponse
implements StateAwareResponse {
    private final Map<QName, Serializable> events = new HashMap<QName, Serializable>();
    private MutableRenderParameters mutableRenderParameters;
    private PortletMode portletMode;
    private final Map<String, String[]> renderParameters = new LinkedHashMap<String, String[]>();
    private WindowState windowState;

    public MockStateAwareResponse() {
    }

    public MockStateAwareResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public Serializable getEvent(QName name) {
        return this.events.get(name);
    }

    public Serializable getEvent(String name) {
        return this.events.get(new QName(name));
    }

    public Iterator<QName> getEventNames() {
        return this.events.keySet().iterator();
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public String getRenderParameter(String key) {
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        String[] arr = this.renderParameters.get(key);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Map<String, String[]> getRenderParameterMap() {
        return Collections.unmodifiableMap(this.renderParameters);
    }

    public Iterator<String> getRenderParameterNames() {
        return this.renderParameters.keySet().iterator();
    }

    public MutableRenderParameters getRenderParameters() {
        if (this.mutableRenderParameters == null) {
            this.mutableRenderParameters = new MockMutableRenderParameters();
        }
        return this.mutableRenderParameters;
    }

    public String[] getRenderParameterValues(String key) {
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        return this.renderParameters.get(key);
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void removePublicRenderParameter(String name) {
        this.renderParameters.remove(name);
    }

    public void setEvent(QName name, Serializable value) {
        this.events.put(name, value);
    }

    public void setEvent(String name, Serializable value) {
        this.events.put(new QName(name), value);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!CollectionUtils.contains((Enumeration)this.getPortalContext().getSupportedPortletModes(), (Object)portletMode)) {
            throw new PortletModeException("PortletMode not supported", portletMode);
        }
        this.portletMode = portletMode;
    }

    public void setRenderParameter(String key, String value) {
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        Assert.notNull((Object)value, (String)"Parameter value must not be null");
        this.renderParameters.put(key, new String[]{value});
    }

    public void setRenderParameter(String key, String[] values) {
        Assert.notNull((Object)key, (String)"Parameter key must not be null");
        Assert.notNull((Object)values, (String)"Parameter values must not be null");
        this.renderParameters.put(key, values);
    }

    public void setRenderParameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, (String)"Parameters Map must not be null");
        this.renderParameters.clear();
        this.renderParameters.putAll(parameters);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!CollectionUtils.contains((Enumeration)this.getPortalContext().getSupportedWindowStates(), (Object)windowState)) {
            throw new WindowStateException("WindowState not supported", windowState);
        }
        this.windowState = windowState;
    }
}

