/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.internal;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Extension;
import akka.actor.typed.ExtensionId;
import akka.actor.typed.pubsub.Topic;
import akka.actor.typed.pubsub.Topic$;
import akka.annotation.InternalApi;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.PersistentRepr;
import akka.persistence.query.Offset;
import akka.persistence.query.TimestampOffset;
import akka.persistence.query.typed.EventEnvelope;
import akka.persistence.r2dbc.internal.PubSub$;
import akka.persistence.typed.PersistenceId$;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005EtAB\b\u0011\u0011\u00031\u0002D\u0002\u0004\u001b!!\u0005ac\u0007\u0005\u0007\u0001\u0006!\t!a\u0013\t\u000f\u00055\u0013\u0001\"\u0001\u0002P!9\u0011QL\u0001\u0005\u0002\u0005}c!\u0002\u000e\u0011\u0001Y)\u0003\u0002C\u0018\u0006\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\u0001+A\u0011A!\t\u000f\u001d+!\u0019!C\u0005\u0011\"1\u0011-\u0002Q\u0001\n%CqAY\u0003C\u0002\u0013%1\r\u0003\u0004i\u000b\u0001\u0006I\u0001\u001a\u0005\u0006S\u0016!\tA\u001b\u0005\b\u0003#)A\u0011BA\n\u0011\u001d\tI\"\u0002C\u0001\u00037\ta\u0001U;c'V\u0014'BA\t\u0013\u0003!Ig\u000e^3s]\u0006d'BA\n\u0015\u0003\u0015\u0011(\u0007\u001a2d\u0015\t)b#A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"A\f\u0002\t\u0005\\7.\u0019\t\u00033\u0005i\u0011\u0001\u0005\u0002\u0007!V\u00147+\u001e2\u0014\u0005\u0005a\u0002cA\u000f#I5\taD\u0003\u0002 A\u0005)A/\u001f9fI*\u0011\u0011EF\u0001\u0006C\u000e$xN]\u0005\u0003Gy\u00111\"\u0012=uK:\u001c\u0018n\u001c8JIB\u0011\u0011$B\n\u0004\u000b\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002\u001e[%\u0011aF\b\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016l7\u0001\u0001\u0019\u0003e]\u00022!H\u001a6\u0013\t!dDA\u0006BGR|'oU=ti\u0016l\u0007C\u0001\u001c8\u0019\u0001!\u0011\u0002\u000f\u0004\u0002\u0002\u0003\u0005)\u0011A\u001d\u0003\u0007}#3'\u0005\u0002;{A\u0011qeO\u0005\u0003y!\u0012qAT8uQ&tw\r\u0005\u0002(}%\u0011q\b\u000b\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002%\u0005\")qf\u0002a\u0001\u0007B\u0012AI\u0012\t\u0004;M*\u0005C\u0001\u001cG\t%A$)!A\u0001\u0002\u000b\u0005\u0011(\u0001\u0004u_BL7m]\u000b\u0002\u0013B!!*U*_\u001b\u0005Y%B\u0001'N\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001d>\u000bA!\u001e;jY*\t\u0001+\u0001\u0003kCZ\f\u0017B\u0001*L\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003)ns!!V-\u0011\u0005YCS\"A,\u000b\u0005a\u0003\u0014A\u0002\u001fs_>$h(\u0003\u0002[Q\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ\u0006\u0006E\u0002\u001e?vJ!\u0001\u0019\u0010\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fq\u0001^8qS\u000e\u001c\b%\u0001\bqKJ\u001c\u0018n\u001d;f]\u000e,W\t\u001f;\u0016\u0003\u0011\u0004\"!\u001a4\u000e\u0003QI!a\u001a\u000b\u0003\u0017A+'o]5ti\u0016t7-Z\u0001\u0010a\u0016\u00148/[:uK:\u001cW-\u0012=uA\u0005QQM^3oiR{\u0007/[2\u0016\u0005-|H#\u00027\u0002\u0004\u0005\u001d\u0001cA\u000f`[B\u0019a\u000e^<\u000f\u0005=\u0014X\"\u00019\u000b\u0005Et\u0012A\u00029vEN,(-\u0003\u0002ta\u0006)Ak\u001c9jG&\u0011QO\u001e\u0002\b\u0007>lW.\u00198e\u0015\t\u0019\b\u000fE\u0002yyzl\u0011!\u001f\u0006\u0003?iT!a\u001f\u000b\u0002\u000bE,XM]=\n\u0005uL(!D#wK:$XI\u001c<fY>\u0004X\r\u0005\u00027\u007f\u00121\u0011\u0011\u0001\u0007C\u0002e\u0012Q!\u0012<f]RDa!!\u0002\r\u0001\u0004\u0019\u0016AC3oi&$\u0018\u0010V=qK\"9\u0011\u0011\u0002\u0007A\u0002\u0005-\u0011!B:mS\u000e,\u0007cA\u0014\u0002\u000e%\u0019\u0011q\u0002\u0015\u0003\u0007%sG/A\u0005u_BL7MT1nKR)1+!\u0006\u0002\u0018!1\u0011QA\u0007A\u0002MCq!!\u0003\u000e\u0001\u0004\tY!A\u0004qk\nd\u0017n\u001d5\u0015\r\u0005u\u00111EA\u0017!\r9\u0013qD\u0005\u0004\u0003CA#\u0001B+oSRDq!!\n\u000f\u0001\u0004\t9#\u0001\u0002qeB\u0019Q-!\u000b\n\u0007\u0005-BC\u0001\bQKJ\u001c\u0018n\u001d;f]R\u0014V\r\u001d:\t\u000f\u0005=b\u00021\u0001\u00022\u0005IA/[7fgR\fW\u000e\u001d\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG(\u0002\tQLW.Z\u0005\u0005\u0003w\t)DA\u0004J]N$\u0018M\u001c;)\u0007\u0015\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)EF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA%\u0003\u0007\u00121\"\u00138uKJt\u0017\r\\!qSR\t\u0001$A\bde\u0016\fG/Z#yi\u0016t7/[8o)\r!\u0013\u0011\u000b\u0005\u0007_\r\u0001\r!a\u00151\t\u0005U\u0013\u0011\f\t\u0005;M\n9\u0006E\u00027\u00033\"1\"a\u0017\u0002R\u0005\u0005\t\u0011!B\u0001s\t\u0019q\fJ\u0019\u0002\u0007\u001d,G\u000fF\u0002%\u0003CBaa\f\u0003A\u0002\u0005\r\u0004\u0007BA3\u0003S\u0002B!H\u001a\u0002hA\u0019a'!\u001b\u0005\u0017\u0005-\u0014\u0011MA\u0001\u0002\u0003\u0015\t!\u000f\u0002\u0004?\u0012\u0012\u0004fA\u0001\u0002@!\u001a\u0001!a\u0010")
@InternalApi
public class PubSub
implements Extension {
    private final ActorSystem<?> system;
    private final ConcurrentHashMap<String, ActorRef<Object>> topics;
    private final Persistence persistenceExt;

    public static PubSub get(ActorSystem<?> system) {
        return PubSub$.MODULE$.get(system);
    }

    public static PubSub createExtension(ActorSystem<?> system) {
        return PubSub$.MODULE$.createExtension((ActorSystem)system);
    }

    public static ExtensionId<PubSub> id() {
        return PubSub$.MODULE$.id();
    }

    public static Extension apply(ActorSystem system) {
        return PubSub$.MODULE$.apply(system);
    }

    private ConcurrentHashMap<String, ActorRef<Object>> topics() {
        return this.topics;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    public <Event> ActorRef<Topic.Command<EventEnvelope<Event>>> eventTopic(String entityType, int slice) {
        String name = this.topicName(entityType, slice);
        return this.topics().computeIfAbsent(name, x$1 -> $this.system.systemActorOf(Topic$.MODULE$.apply(name, ClassTag$.MODULE$.apply(EventEnvelope.class)), name, $this.system.systemActorOf$default$3()).unsafeUpcast()).narrow();
    }

    private String topicName(String entityType, int slice) {
        return URLEncoder.encode(new StringBuilder(7).append("r2dbc-").append(entityType).append("-").append(slice).toString(), StandardCharsets.UTF_8.name());
    }

    public void publish(PersistentRepr pr, Instant timestamp) {
        String pid = pr.persistenceId();
        String entityType = PersistenceId$.MODULE$.extractEntityType(pid);
        int slice = this.persistenceExt().sliceForPersistenceId(pid);
        TimestampOffset offset = new TimestampOffset(timestamp, timestamp, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)pr.sequenceNr()))})));
        EventEnvelope envelope = new EventEnvelope((Offset)offset, pid, pr.sequenceNr(), Option$.MODULE$.apply(pr.payload()), timestamp.toEpochMilli(), pr.metadata(), entityType, slice);
        ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(this.eventTopic(entityType, slice)), (Object)Topic.Publish$.MODULE$.apply((Object)envelope));
    }

    public PubSub(ActorSystem<?> system) {
        this.system = system;
        this.topics = new ConcurrentHashMap();
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
    }
}

