/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.query.scaladsl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.r2dbc.Dialect;
import akka.persistence.r2dbc.Dialect$Postgres$;
import akka.persistence.r2dbc.Dialect$Yugabyte$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.BySliceQuery$Buckets$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.journal.JournalDao;
import akka.persistence.r2dbc.journal.JournalDao$;
import akka.persistence.r2dbc.query.scaladsl.QueryDao$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t]u!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%\ta\u0010\u0005\u0007\u0011\u0006\u0001\u000b\u0011\u0002!\u0007\u000bQ:\u0003aK%\t\u0011!,!\u0011!Q\u0001\n%D\u0001\"\\\u0003\u0003\u0002\u0003\u0006IA\u001c\u0005\to\u0016\u0011\t\u0011)A\u0006q\"Aa0\u0002B\u0001B\u0003-q\u0010\u0003\u0004=\u000b\u0011\u0005\u0011q\u0005\u0005\n\u0003{)!\u0019!C\u0005\u0003\u007fA\u0001\"!\u0015\u0006A\u0003%\u0011\u0011\t\u0005\n\u0003'*!\u0019!C\u0005\u0003+B\u0001\"!\u001a\u0006A\u0003%\u0011q\u000b\u0005\b\u0003O*A\u0011BA5\u0011\u001d\t9*\u0002C\u0005\u00033Cq!a(\u0006\t\u0013\t\t\u000bC\u0005\u0002(\u0016\u0011\r\u0011\"\u0003\u0002@!A\u0011\u0011V\u0003!\u0002\u0013\t\t\u0005C\u0005\u0002,\u0016\u0011\r\u0011\"\u0003\u0002@!A\u0011QV\u0003!\u0002\u0013\t\t\u0005C\u0005\u00020\u0016\u0011\r\u0011\"\u0003\u0002@!A\u0011\u0011W\u0003!\u0002\u0013\t\t\u0005C\u0005\u00024\u0016\u0011\r\u0011\"\u0003\u0002@!A\u0011QW\u0003!\u0002\u0013\t\t\u0005C\u0005\u00028\u0016\u0011\r\u0011\"\u0003\u0002@!A\u0011\u0011X\u0003!\u0002\u0013\t\t\u0005C\u0005\u0002<\u0016\u0011\r\u0011\"\u0003\u0002>\"A\u0011QY\u0003!\u0002\u0013\ty\fC\u0004\u0002H\u0016!\t!!3\t\u000f\u0005uW\u0001\"\u0001\u0002`\"9!\u0011C\u0003\u0005B\tM\u0001b\u0002B%\u000b\u0011\u0005#1\n\u0005\b\u0005\u001b*A\u0011\u0001B(\u0011\u001d\u0011\t'\u0002C\u0001\u0005GBqA!\u001c\u0006\t\u0003\u0011y\u0007C\u0004\u0003|\u0015!\tA! \u0002\u0011E+XM]=EC>T!\u0001K\u0015\u0002\u0011M\u001c\u0017\r\\1eg2T!AK\u0016\u0002\u000bE,XM]=\u000b\u00051j\u0013!\u0002:3I\n\u001c'B\u0001\u00180\u0003-\u0001XM]:jgR,gnY3\u000b\u0003A\nA!Y6lC\u000e\u0001\u0001CA\u001a\u0002\u001b\u00059#\u0001C)vKJLH)Y8\u0014\u0005\u00051\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002e\u0005\u0019An\\4\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9%I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007eE\u0002\u0006m)\u00032aS)U\u001d\tau*D\u0001N\u0015\tq5&\u0001\u0005j]R,'O\\1m\u0013\t\u0001V*\u0001\u0007CsNc\u0017nY3Rk\u0016\u0014\u00180\u0003\u0002S'\n\u0019A)Y8\u000b\u0005Ak\u0005CA+f\u001d\t1&M\u0004\u0002XA:\u0011\u0001l\u0018\b\u00033zs!AW/\u000e\u0003mS!\u0001X\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002bW\u00059!n\\;s]\u0006d\u0017BA2e\u0003)Qu.\u001e:oC2$\u0015m\u001c\u0006\u0003C.J!AZ4\u0003)M+'/[1mSj,GMS8ve:\fGNU8x\u0015\t\u0019G-\u0001\u0005tKR$\u0018N\\4t!\tQ7.D\u0001,\u0013\ta7FA\u0007Se\u0011\u00147mU3ui&twm]\u0001\u0012G>tg.Z2uS>tg)Y2u_JL\bCA8v\u001b\u0005\u0001(BA9s\u0003\r\u0019\b/\u001b\u0006\u0003YMT\u0011\u0001^\u0001\u0003S>L!A\u001e9\u0003#\r{gN\\3di&|gNR1di>\u0014\u00180\u0001\u0002fGB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010O\u0001\u000bG>t7-\u001e:sK:$\u0018BA?{\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004tsN$X-\u001c\u0019\u0005\u0003\u0003\t)\u0002\u0005\u0004\u0002\u0004\u00055\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005)A/\u001f9fI*\u0019\u00111B\u0018\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005=\u0011Q\u0001\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\f\u0003/I\u0011\u0011!A\u0001\u0006\u0003\tIBA\u0002`IE\nB!a\u0007\u0002\"A\u0019q'!\b\n\u0007\u0005}\u0001HA\u0004O_RD\u0017N\\4\u0011\u0007]\n\u0019#C\u0002\u0002&a\u00121!\u00118z)\u0019\tI#!\u000f\u0002<Q1\u00111FA\u0017\u0003_\u0001\"aM\u0003\t\u000b]T\u00019\u0001=\t\ryT\u00019AA\u0019a\u0011\t\u0019$a\u000e\u0011\r\u0005\r\u0011QBA\u001b!\u0011\t\u0019\"a\u000e\u0005\u0019\u0005]\u0011qFA\u0001\u0002\u0003\u0015\t!!\u0007\t\u000b!T\u0001\u0019A5\t\u000b5T\u0001\u0019\u00018\u0002\u0019)|WO\u001d8bYR\u000b'\r\\3\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0017rA!!\u0012\u0002HA\u0011!\fO\u0005\u0004\u0003\u0013B\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#AB*ue&twMC\u0002\u0002Ja\nQB[8ve:\fG\u000eV1cY\u0016\u0004\u0013!F2veJ,g\u000e\u001e#c)&lWm\u001d;b[B\u001c\u0016\u000f\\\u000b\u0003\u0003/\u0002B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0003mC:<'BAA1\u0003\u0011Q\u0017M^1\n\t\u00055\u00131L\u0001\u0017GV\u0014(/\u001a8u\t\n$\u0016.\\3ti\u0006l\u0007oU9mA\u00051RM^3oiN\u0014\u0015p\u00157jG\u0016\u001c(+\u00198hKN\u000bH\u000e\u0006\u0007\u0002B\u0005-\u0014QOAC\u0003\u0013\u000b\u0019\nC\u0004\u0002n=\u0001\r!a\u001c\u0002%Q|GI\u0019+j[\u0016\u001cH/Y7q!\u0006\u0014\u0018-\u001c\t\u0004o\u0005E\u0014bAA:q\t9!i\\8mK\u0006t\u0007bBA<\u001f\u0001\u0007\u0011\u0011P\u0001\u0012E\u0016D\u0017N\u001c3DkJ\u0014XM\u001c;US6,\u0007\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}$0\u0001\u0005ekJ\fG/[8o\u0013\u0011\t\u0019)! \u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011qQ\bA\u0002\u0005=\u0014\u0001\u00042bG.$(/Y2lS:<\u0007bBAF\u001f\u0001\u0007\u0011QR\u0001\t[&t7\u000b\\5dKB\u0019q'a$\n\u0007\u0005E\u0005HA\u0002J]RDq!!&\u0010\u0001\u0004\ti)\u0001\u0005nCb\u001cF.[2f\u00039\u0019H.[2f\u0007>tG-\u001b;j_:$b!!\u0011\u0002\u001c\u0006u\u0005bBAF!\u0001\u0007\u0011Q\u0012\u0005\b\u0003+\u0003\u0002\u0019AAG\u0003A\u0019X\r\\3di\n+8m[3ugN\u000bH\u000e\u0006\u0004\u0002B\u0005\r\u0016Q\u0015\u0005\b\u0003\u0017\u000b\u0002\u0019AAG\u0011\u001d\t)*\u0005a\u0001\u0003\u001b\u000b\u0011d]3mK\u000e$H+[7fgR\fW\u000e](g\u000bZ,g\u000e^*rY\u0006Q2/\u001a7fGR$\u0016.\\3ti\u0006l\u0007o\u00144Fm\u0016tGoU9mA\u0005\t2/\u001a7fGR|e.Z#wK:$8+\u001d7\u0002%M,G.Z2u\u001f:,WI^3oiN\u000bH\u000eI\u0001\u0010g\u0016dWm\u0019;Fm\u0016tGo]*rY\u0006\u00012/\u001a7fGR,e/\u001a8ugN\u000bH\u000eI\u0001\u0015C2d\u0007+\u001a:tSN$XM\\2f\u0013\u0012\u001c8+\u001d7\u0002+\u0005dG\u000eU3sg&\u001cH/\u001a8dK&#7oU9mA\u0005I\u0012\r\u001c7QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ:BMR,'oU9m\u0003i\tG\u000e\u001c)feNL7\u000f^3oG\u0016LEm]!gi\u0016\u00148+\u001d7!\u00035\u0011(\u0007\u001a2d\u000bb,7-\u001e;peV\u0011\u0011q\u0018\t\u0004\u0019\u0006\u0005\u0017bAAb\u001b\ni!K\r3cG\u0016CXmY;u_J\faB\u001d\u001aeE\u000e,\u00050Z2vi>\u0014\b%\u0001\ndkJ\u0014XM\u001c;EERKW.Z:uC6\u0004HCAAf!\u0015I\u0018QZAi\u0013\r\tyM\u001f\u0002\u0007\rV$XO]3\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+TA!a6\u0002`\u0005!A/[7f\u0013\u0011\tY.!6\u0003\u000f%s7\u000f^1oi\u0006a!o\\<t\u0005f\u001cF.[2fgR\u0001\u0012\u0011]A|\u0003w\fi0a@\u0003\u0004\t5!q\u0002\t\b\u0003G\fY\u000fVAx\u001b\t\t)OC\u0002)\u0003OT1!!;0\u0003\u0019\u0019HO]3b[&!\u0011Q^As\u0005\u0019\u0019v.\u001e:dKB!\u0011\u0011_Az\u001b\u0005y\u0013bAA{_\t9aj\u001c;Vg\u0016$\u0007bBA}?\u0001\u0007\u0011\u0011I\u0001\u000bK:$\u0018\u000e^=UsB,\u0007bBAF?\u0001\u0007\u0011Q\u0012\u0005\b\u0003+{\u0002\u0019AAG\u0011\u001d\u0011\ta\ba\u0001\u0003#\fQB\u001a:p[RKW.Z:uC6\u0004\bb\u0002B\u0003?\u0001\u0007!qA\u0001\fi>$\u0016.\\3ti\u0006l\u0007\u000fE\u00038\u0005\u0013\t\t.C\u0002\u0003\fa\u0012aa\u00149uS>t\u0007bBA<?\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u000f{\u0002\u0019AA8\u00031\u0019w.\u001e8u\u0005V\u001c7.\u001a;t)1\u0011)B!\u0010\u0003@\t\u0005#1\tB#!\u0015I\u0018Q\u001aB\f!\u0019\u0011IBa\t\u0003*9!!1\u0004B\u0010\u001d\rQ&QD\u0005\u0002s%\u0019!\u0011\u0005\u001d\u0002\u000fA\f7m[1hK&!!Q\u0005B\u0014\u0005\r\u0019V-\u001d\u0006\u0004\u0005CA\u0004\u0003\u0002B\u0016\u0005oqAA!\f\u000349\u0019!qF(\u000f\u0007]\u0013\t$\u0003\u0002OW%\u0019!QG*\u0002\u000f\t+8m[3ug&!!\u0011\bB\u001e\u0005\u0019\u0011UoY6fi*\u0019!QG*\t\u000f\u0005e\b\u00051\u0001\u0002B!9\u00111\u0012\u0011A\u0002\u00055\u0005bBAKA\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u0003\u0001\u0003\u0019AAi\u0011\u001d\u00119\u0005\ta\u0001\u0003\u001b\u000bQ\u0001\\5nSR\fQcY8v]R\u0014UoY6fiNl\u0015-_\"iC:<W-\u0006\u0002\u0002p\u0005\u0001B/[7fgR\fW\u000e](g\u000bZ,g\u000e\u001e\u000b\u0007\u0005#\u0012\u0019Fa\u0016\u0011\u000be\fiMa\u0002\t\u000f\tU#\u00051\u0001\u0002B\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012DqA!\u0017#\u0001\u0004\u0011Y&A\u0003tKFt%\u000fE\u00028\u0005;J1Aa\u00189\u0005\u0011auN\\4\u0002\u00131|\u0017\rZ#wK:$HC\u0002B3\u0005S\u0012Y\u0007E\u0003z\u0003\u001b\u00149\u0007\u0005\u00038\u0005\u0013!\u0006b\u0002B+G\u0001\u0007\u0011\u0011\t\u0005\b\u00053\u001a\u0003\u0019\u0001B.\u0003U)g/\u001a8ug\nK\b+\u001a:tSN$XM\\2f\u0013\u0012$\u0002\"!9\u0003r\tM$q\u000f\u0005\b\u0005+\"\u0003\u0019AA!\u0011\u001d\u0011)\b\na\u0001\u00057\naB\u001a:p[N+\u0017/^3oG\u0016t%\u000fC\u0004\u0003z\u0011\u0002\rAa\u0017\u0002\u0019Q|7+Z9vK:\u001cWM\u0014:\u0002\u001dA,'o]5ti\u0016t7-Z%egR1!q\u0010BA\u0005\u000f\u0003\u0002\"a9\u0002l\u0006\u0005\u0013q\u001e\u0005\b\u0005\u0007+\u0003\u0019\u0001BC\u0003\u001d\tg\r^3s\u0013\u0012\u0004Ra\u000eB\u0005\u0003\u0003BqAa\u0012&\u0001\u0004\u0011Y\u0006K\u0002\u0006\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005#{\u0013AC1o]>$\u0018\r^5p]&!!Q\u0013BH\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public class QueryDao
implements BySliceQuery.Dao<JournalDao.SerializedJournalRow> {
    private final R2dbcSettings settings;
    private final ExecutionContext ec;
    private final String journalTable;
    private final String currentDbTimestampSql;
    private final String selectTimestampOfEventSql;
    private final String selectOneEventSql;
    private final String selectEventsSql;
    private final String allPersistenceIdsSql;
    private final String allPersistenceIdsAfterSql;
    private final R2dbcExecutor r2dbcExecutor;

    public static Logger log() {
        return QueryDao$.MODULE$.log();
    }

    private String journalTable() {
        return this.journalTable;
    }

    private String currentDbTimestampSql() {
        return this.currentDbTimestampSql;
    }

    private String eventsBySlicesRangeSql(boolean toDbTimestampParam, FiniteDuration behindCurrentTime, boolean backtracking, int minSlice, int maxSlice) {
        String selectColumns = backtracking ? "SELECT slice, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp " : "SELECT slice, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp, event_ser_id, event_ser_manifest, event_payload, meta_ser_id, meta_ser_manifest, meta_payload ";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      FROM ", "\n      WHERE entity_type = ?\n      AND ", "\n      AND db_timestamp >= ? ", " ", "\n      AND deleted = false\n      ORDER BY db_timestamp, seq_nr\n      LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{selectColumns, this.journalTable(), this.sliceCondition(minSlice, maxSlice), QueryDao.toDbTimestampParamCondition$1(toDbTimestampParam), QueryDao.behindCurrentTimeIntervalCondition$1(behindCurrentTime)}));
    }

    private String sliceCondition(int minSlice, int maxSlice) {
        String string;
        Dialect dialect = this.settings.dialect();
        if (Dialect$Yugabyte$.MODULE$.equals(dialect)) {
            string = new StringBuilder(19).append("slice BETWEEN ").append(minSlice).append(" AND ").append(maxSlice).toString();
        } else if (Dialect$Postgres$.MODULE$.equals(dialect)) {
            string = new StringBuilder(11).append("slice in (").append(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(minSlice), maxSlice).mkString(",")).append(")").toString();
        } else {
            throw new MatchError((Object)dialect);
        }
        return string;
    }

    private String selectBucketsSql(int minSlice, int maxSlice) {
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT extract(EPOCH from db_timestamp)::BIGINT / 10 AS bucket, count(*) AS count\n      FROM ", "\n      WHERE entity_type = ?\n      AND ", "\n      AND db_timestamp >= ? AND db_timestamp <= ?\n      AND deleted = false\n      GROUP BY bucket ORDER BY bucket LIMIT ?\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable(), this.sliceCondition(minSlice, maxSlice)}));
    }

    private String selectTimestampOfEventSql() {
        return this.selectTimestampOfEventSql;
    }

    private String selectOneEventSql() {
        return this.selectOneEventSql;
    }

    private String selectEventsSql() {
        return this.selectEventsSql;
    }

    private String allPersistenceIdsSql() {
        return this.allPersistenceIdsSql;
    }

    private String allPersistenceIdsAfterSql() {
        return this.allPersistenceIdsAfterSql;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    @Override
    public Future<Instant> currentDbTimestamp() {
        return this.r2dbcExecutor().selectOne("select current db timestamp", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.currentDbTimestampSql()), (Function1 & Serializable)row -> (Instant)row.get("db_timestamp", Instant.class)).map((Function1 & Serializable)x0$1 -> {
            Instant time;
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(22).append("Expected one row for: ").append(this.currentDbTimestampSql()).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Instant instant = time = (Instant)some.value();
            return instant;
        }, this.ec);
    }

    @Override
    public Source<JournalDao.SerializedJournalRow, NotUsed> rowsBySlices(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, Option<Instant> toTimestamp, FiniteDuration behindCurrentTime, boolean backtracking) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(27).append("select eventsBySlices [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement statement;
                Statement stmt = connection.createStatement(this.eventsBySlicesRangeSql(toTimestamp.isDefined(), behindCurrentTime, backtracking, minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp);
                Option option = toTimestamp;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant until = (Instant)some.value();
                    stmt.bind(2, (Object)until);
                    statement = stmt.bind(3, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else if (None$.MODULE$.equals(option)) {
                    statement = stmt.bind(2, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else {
                    throw new MatchError((Object)option);
                }
                return stmt;
            }, (Function1 & Serializable)row -> backtracking ? new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), entityType, (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)None$.MODULE$, 0, "", "", (Set<String>)Predef$.MODULE$.Set().empty(), (Option<JournalDao.SerializedEventMetadata>)None$.MODULE$) : new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), entityType, (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some(row.get("event_payload", byte[].class)), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), "", (Set<String>)Predef$.MODULE$.Set().empty(), JournalDao$.MODULE$.readMetadata((Row)row)));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$rowsBySlices$3(minSlice, maxSlice, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$1 -> Source$.MODULE$.apply((Iterable)x$1), this.ec)).mapMaterializedValue((Function1 & Serializable)x$2 -> NotUsed$.MODULE$);
    }

    @Override
    public Future<Seq<BySliceQuery.Buckets.Bucket>> countBuckets(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, int limit) {
        Future result;
        block2: {
            Instant instant;
            Instant now = Instant.now();
            Instant instant2 = fromTimestamp;
            Instant instant3 = Instant.EPOCH;
            if (!(instant2 != null ? !((Object)instant2).equals(instant3) : instant3 != null)) {
                instant = now;
            } else {
                Instant t = fromTimestamp.plusSeconds(BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds() * limit + BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds());
                instant = t.isAfter(now) ? now : t;
            }
            Instant toTimestamp = instant;
            result = this.r2dbcExecutor().select(new StringBuilder(26).append("select bucket counts [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectBucketsSql(minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp).bind(2, (Object)toTimestamp).bind(3, (Object)BoxesRunTime.boxToInteger((int)limit)), (Function1 & Serializable)row -> {
                long bucketStartEpochSeconds = Predef$.MODULE$.Long2long((Long)row.get("bucket", Long.class)) * 10L;
                long count = Predef$.MODULE$.Long2long((Long)row.get("count", Long.class));
                return new BySliceQuery.Buckets.Bucket(bucketStartEpochSeconds, count);
            });
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block2;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$countBuckets$3(minSlice, maxSlice, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return result;
    }

    @Override
    public boolean countBucketsMayChange() {
        return false;
    }

    public Future<Option<Instant>> timestampOfEvent(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().selectOne("select timestampOfEvent", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectTimestampOfEventSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr)), (Function1 & Serializable)row -> (Instant)row.get("db_timestamp", Instant.class));
    }

    public Future<Option<JournalDao.SerializedJournalRow>> loadEvent(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().selectOne("select one event", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectOneEventSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr)), (Function1 & Serializable)row -> new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), (String)row.get("entity_type", String.class), persistenceId, seqNr, (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some(row.get("event_payload", byte[].class)), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), "", (Set<String>)Predef$.MODULE$.Set().empty(), JournalDao$.MODULE$.readMetadata((Row)row)));
    }

    public Source<JournalDao.SerializedJournalRow, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(31).append("select eventsByPersistenceId [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectEventsSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr)).bind(2, (Object)BoxesRunTime.boxToLong((long)toSequenceNr)).bind(3, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize())), (Function1 & Serializable)row -> new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), (String)row.get("entity_type", String.class), (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some(row.get("event_payload", byte[].class)), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), (String)row.get("writer", String.class), (Set<String>)Predef$.MODULE$.Set().empty(), JournalDao$.MODULE$.readMetadata((Row)row)));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$eventsByPersistenceId$3(persistenceId, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$3 -> Source$.MODULE$.apply((Iterable)x$3), this.ec)).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public Source<String, NotUsed> persistenceIds(Option<String> afterId, long limit) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select("select persistenceIds", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement statement;
                Option option = afterId;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String after = (String)some.value();
                    statement = connection.createStatement(this.allPersistenceIdsAfterSql()).bind(0, (Object)after).bind(1, (Object)BoxesRunTime.boxToLong((long)limit));
                } else if (None$.MODULE$.equals(option)) {
                    statement = connection.createStatement(this.allPersistenceIdsSql()).bind(0, (Object)BoxesRunTime.boxToLong((long)limit));
                } else {
                    throw new MatchError((Object)option);
                }
                return statement;
            }, (Function1 & Serializable)row -> (String)row.get("persistence_id", String.class));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$persistenceIds$3(rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$5 -> Source$.MODULE$.apply((Iterable)x$5), this.ec)).mapMaterializedValue((Function1 & Serializable)x$6 -> NotUsed$.MODULE$);
    }

    private static final String toDbTimestampParamCondition$1(boolean toDbTimestampParam$1) {
        return toDbTimestampParam$1 ? "AND db_timestamp <= ?" : "";
    }

    private static final String behindCurrentTimeIntervalCondition$1(FiniteDuration behindCurrentTime$1) {
        return behindCurrentTime$1.$greater((Object)Duration$.MODULE$.Zero()) ? new StringBuilder(69).append("AND db_timestamp < transaction_timestamp() - interval '").append(behindCurrentTime$1.toMillis()).append(" milliseconds'").toString() : "";
    }

    public static final /* synthetic */ void $anonfun$rowsBySlices$3(int minSlice$1, int maxSlice$1, IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] events from slices [{} - {}]", new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice$1), BoxesRunTime.boxToInteger((int)maxSlice$1)});
    }

    public static final /* synthetic */ void $anonfun$countBuckets$3(int minSlice$2, int maxSlice$2, IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] bucket counts from slices [{} - {}]", new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice$2), BoxesRunTime.boxToInteger((int)maxSlice$2)});
    }

    public static final /* synthetic */ void $anonfun$eventsByPersistenceId$3(String persistenceId$3, IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)rows.size()), (Object)persistenceId$3);
    }

    public static final /* synthetic */ void $anonfun$persistenceIds$3(IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] persistence ids", (Object)BoxesRunTime.boxToInteger((int)rows.size()));
    }

    public QueryDao(R2dbcSettings settings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.settings = settings;
        this.ec = ec;
        this.journalTable = settings.journalTableWithSchema();
        this.currentDbTimestampSql = "SELECT transaction_timestamp() AS db_timestamp";
        this.selectTimestampOfEventSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT db_timestamp FROM ", "\n    WHERE persistence_id = ? AND seq_nr = ? AND deleted = false"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.selectOneEventSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT slice, entity_type, db_timestamp, statement_timestamp() AS read_db_timestamp, event_ser_id, event_ser_manifest, event_payload, meta_ser_id, meta_ser_manifest, meta_payload\n    FROM ", "\n    WHERE persistence_id = ? AND seq_nr = ? AND deleted = false"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.selectEventsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT slice, entity_type, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp, event_ser_id, event_ser_manifest, event_payload, writer, adapter_manifest, meta_ser_id, meta_ser_manifest, meta_payload\n    from ", "\n    WHERE persistence_id = ? AND seq_nr >= ? AND seq_nr <= ?\n    AND deleted = false\n    ORDER BY seq_nr\n    LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.allPersistenceIdsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.allPersistenceIdsAfterSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " WHERE persistence_id > ? ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, QueryDao$.MODULE$.log(), settings.logDbCallsExceeding(), ec, system);
    }
}

