/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.snapshot;

import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.snapshot.SnapshotDao$;
import akka.persistence.typed.PersistenceId$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rmuAB/_\u0011\u0003\u0001gM\u0002\u0004i=\"\u0005\u0001-\u001b\u0005\u0006a\u0006!\tA\u001d\u0005\bg\u0006\u0011\r\u0011\"\u0003u\u0011\u0019i\u0018\u0001)A\u0005k\u001a!a0\u0001\"\u0000\u0011)\ty\"\u0002BK\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003g)!\u0011#Q\u0001\n\u0005\r\u0002BCA\u001b\u000b\tU\r\u0011\"\u0001\u00028!Q\u0011qH\u0003\u0003\u0012\u0003\u0006I!!\u000f\t\u0015\u0005\u0005SA!f\u0001\n\u0003\t9\u0004\u0003\u0006\u0002D\u0015\u0011\t\u0012)A\u0005\u0003sA\u0011bX\u0003\u0003\u0016\u0004%\t!!\u0012\t\u0015\u0005MSA!E!\u0002\u0013\t9\u0005\u0003\u0006\u0002V\u0015\u0011)\u001a!C\u0001\u0003/B!\"a\u0018\u0006\u0005#\u0005\u000b\u0011BA-\u0011)\t\t'\u0002BK\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003G*!\u0011#Q\u0001\n\u0005\r\u0002BCA3\u000b\tU\r\u0011\"\u0001\u0002h!Q!1A\u0003\u0003\u0012\u0003\u0006I!!\u001b\t\rA,A\u0011\u0001B\u0003\u0011%\t\u0019)BA\u0001\n\u0003\u00119\u0002C\u0005\u0002\u000e\u0016\t\n\u0011\"\u0001\u0002.\"I\u0011QU\u0003\u0012\u0002\u0013\u0005!q\u0005\u0005\n\u0003W+\u0011\u0013!C\u0001\u0005OA\u0011Ba\u000b\u0006#\u0003%\t!a$\t\u0013\t5R!%A\u0005\u0002\u0005\u001d\u0006\"\u0003B\u0018\u000bE\u0005I\u0011AAW\u0011%\u0011\t$BI\u0001\n\u0003\u0011\u0019\u0004C\u0005\u00022\u0016\t\t\u0011\"\u0011\u00024\"I\u00111Y\u0003\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003\u000b,\u0011\u0011!C\u0001\u0005oA\u0011\"a5\u0006\u0003\u0003%\t%!6\t\u0013\u0005\rX!!A\u0005\u0002\tm\u0002\"CAx\u000b\u0005\u0005I\u0011\tB \u0011%\t)0BA\u0001\n\u0003\n9\u0010C\u0005\u0002z\u0016\t\t\u0011\"\u0011\u0002|\"I\u0011Q`\u0003\u0002\u0002\u0013\u0005#1I\u0004\n\u0005\u000f\n\u0011\u0011!E\u0001\u0005\u00132\u0001B`\u0001\u0002\u0002#\u0005!1\n\u0005\u0007a\u001e\"\tAa\u0019\t\u0013\u0005ex%!A\u0005F\u0005m\b\"\u0003B3O\u0005\u0005I\u0011\u0011B4\u0011%\u00119hJA\u0001\n\u0003\u0013I\bC\u0005\u0003\b\u001e\n\t\u0011\"\u0003\u0003\n\u001a1\u00111O\u0001C\u0003kB!\"a\u001e.\u0005+\u0007I\u0011AA#\u0011)\tI(\fB\tB\u0003%\u0011q\t\u0005\u000b\u0003+j#Q3A\u0005\u0002\u0005]\u0003BCA0[\tE\t\u0015!\u0003\u0002Z!Q\u0011\u0011M\u0017\u0003\u0016\u0004%\t!!\t\t\u0015\u0005\rTF!E!\u0002\u0013\t\u0019\u0003\u0003\u0004q[\u0011\u0005\u00111\u0010\u0005\n\u0003\u0007k\u0013\u0011!C\u0001\u0003\u000bC\u0011\"!$.#\u0003%\t!a$\t\u0013\u0005\u0015V&%A\u0005\u0002\u0005\u001d\u0006\"CAV[E\u0005I\u0011AAW\u0011%\t\t,LA\u0001\n\u0003\n\u0019\fC\u0005\u0002D6\n\t\u0011\"\u0001\u0002X!I\u0011QY\u0017\u0002\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003'l\u0013\u0011!C!\u0003+D\u0011\"a9.\u0003\u0003%\t!!:\t\u0013\u0005=X&!A\u0005B\u0005E\b\"CA{[\u0005\u0005I\u0011IA|\u0011%\tI0LA\u0001\n\u0003\nY\u0010C\u0005\u0002~6\n\t\u0011\"\u0011\u0002\u0000\u001eI!\u0011S\u0001\u0002\u0002#\u0005!1\u0013\u0004\n\u0003g\n\u0011\u0011!E\u0001\u0005+Ca\u0001]\"\u0005\u0002\tu\u0005\"CA}\u0007\u0006\u0005IQIA~\u0011%\u0011)gQA\u0001\n\u0003\u0013y\nC\u0005\u0003x\r\u000b\t\u0011\"!\u0003(\"I!qQ\"\u0002\u0002\u0013%!\u0011\u0012\u0005\b\u0005g\u000bA\u0011\u0002B[\r\u0019AgL\u00011\u0003L\"Q!Q\u001a&\u0003\u0002\u0003\u0006IAa4\t\u0015\t]'J!A!\u0002\u0013\u0011I\u000e\u0003\u0006\u0003`*\u0013\t\u0011)A\u0006\u0005CD!B!<K\u0005\u0003\u0005\u000b1\u0002Bx\u0011\u0019\u0001(\n\"\u0001\u0004\u0012!I1q\u0005&C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0007SQ\u0005\u0015!\u0003\u0002$!I11\u0006&C\u0002\u0013%1Q\u0006\u0005\t\u0007oQ\u0005\u0015!\u0003\u00040!I1\u0011\b&C\u0002\u0013%11\b\u0005\t\u0007\u0013R\u0005\u0015!\u0003\u0004>!I11\n&C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0007\u001bR\u0005\u0015!\u0003\u0002$!91q\n&\u0005\n\rE\u0003bBB/\u0015\u0012%1q\f\u0005\b\u0007GRE\u0011AB3\u0011\u001d\u00199H\u0013C\u0001\u0007sBqaa\"K\t\u0003\u0019I)A\u0006T]\u0006\u00048\u000f[8u\t\u0006|'BA0a\u0003!\u0019h.\u00199tQ>$(BA1c\u0003\u0015\u0011(\u0007\u001a2d\u0015\t\u0019G-A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"A3\u0002\t\u0005\\7.\u0019\t\u0003O\u0006i\u0011A\u0018\u0002\f':\f\u0007o\u001d5pi\u0012\u000bwn\u0005\u0002\u0002UB\u00111N\\\u0007\u0002Y*\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pY\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002M\u0006\u0019An\\4\u0016\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u000bMdg\r\u000e6\u000b\u0003i\f1a\u001c:h\u0013\taxO\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007EA\u000bTKJL\u0017\r\\5{K\u0012\u001cf.\u00199tQ>$(k\\<\u0014\r\u0015Q\u0017\u0011AA\u0004!\rY\u00171A\u0005\u0004\u0003\u000ba'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0013\tIB\u0004\u0003\u0002\f\u0005Ua\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0011/\u0001\u0004=e>|GOP\u0005\u0002[&\u0019\u0011q\u00037\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t9\u0002\\\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003[qA!a\n\u0002*A\u0019\u0011Q\u00027\n\u0007\u0005-B.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Wa\u0017A\u00049feNL7\u000f^3oG\u0016LE\rI\u0001\u0006g\u0016\fhJ]\u000b\u0003\u0003s\u00012a[A\u001e\u0013\r\ti\u0004\u001c\u0002\u0005\u0019>tw-\u0001\u0004tKFt%\u000fI\u0001\u000foJLG/\u001a+j[\u0016\u001cH/Y7q\u0003=9(/\u001b;f)&lWm\u001d;b[B\u0004SCAA$!\u0015Y\u0017\u0011JA'\u0013\r\tY\u0005\u001c\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004W\u0006=\u0013bAA)Y\n!!)\u001f;f\u0003%\u0019h.\u00199tQ>$\b%\u0001\u0007tKJL\u0017\r\\5{KJLE-\u0006\u0002\u0002ZA\u00191.a\u0017\n\u0007\u0005uCNA\u0002J]R\fQb]3sS\u0006d\u0017N_3s\u0013\u0012\u0004\u0013AE:fe&\fG.\u001b>fe6\u000bg.\u001b4fgR\f1c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017NZ3ti\u0002\n\u0001\"\\3uC\u0012\fG/Y\u000b\u0003\u0003S\u0002Ra[A6\u0003_J1!!\u001cm\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011\u0011O\u0017\u000e\u0003\u0005\u0011!dU3sS\u0006d\u0017N_3e':\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u001cb!\f6\u0002\u0002\u0005\u001d\u0011a\u00029bs2|\u0017\rZ\u0001\ta\u0006LHn\\1eAQA\u0011qNA?\u0003\u007f\n\t\tC\u0004\u0002xQ\u0002\r!a\u0012\t\u000f\u0005UC\u00071\u0001\u0002Z!9\u0011\u0011\r\u001bA\u0002\u0005\r\u0012\u0001B2paf$\u0002\"a\u001c\u0002\b\u0006%\u00151\u0012\u0005\n\u0003o*\u0004\u0013!a\u0001\u0003\u000fB\u0011\"!\u00166!\u0003\u0005\r!!\u0017\t\u0013\u0005\u0005T\u0007%AA\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#SC!a\u0012\u0002\u0014.\u0012\u0011Q\u0013\t\u0005\u0003/\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003%)hn\u00195fG.,GMC\u0002\u0002 2\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019+!'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%&\u0006BA-\u0003'\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00020*\"\u00111EAJ\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0017\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0016\u0001\u00026bm\u0006LA!a\f\u0002:\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAe\u0003\u001f\u00042a[Af\u0013\r\ti\r\u001c\u0002\u0004\u0003:L\b\"CAiw\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001b\t\u0007\u00033\fy.!3\u000e\u0005\u0005m'bAAoY\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00181\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\u00065\bcA6\u0002j&\u0019\u00111\u001e7\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011[\u001f\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00026\u0006M\b\"CAi}\u0005\u0005\t\u0019AA-\u0003!A\u0017m\u001d5D_\u0012,GCAA-\u0003!!xn\u0015;sS:<GCAA[\u0003\u0019)\u0017/^1mgR!\u0011q\u001dB\u0001\u0011%\t\t.QA\u0001\u0002\u0004\tI-A\u0005nKR\fG-\u0019;bAQ\u0001\"q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\u0003\u0012\tM!Q\u0003\t\u0004\u0003c*\u0001bBA\u0010)\u0001\u0007\u00111\u0005\u0005\b\u0003k!\u0002\u0019AA\u001d\u0011\u001d\t\t\u0005\u0006a\u0001\u0003sAaa\u0018\u000bA\u0002\u0005\u001d\u0003bBA+)\u0001\u0007\u0011\u0011\f\u0005\b\u0003C\"\u0002\u0019AA\u0012\u0011\u001d\t)\u0007\u0006a\u0001\u0003S\"\u0002Ca\u0002\u0003\u001a\tm!Q\u0004B\u0010\u0005C\u0011\u0019C!\n\t\u0013\u0005}Q\u0003%AA\u0002\u0005\r\u0002\"CA\u001b+A\u0005\t\u0019AA\u001d\u0011%\t\t%\u0006I\u0001\u0002\u0004\tI\u0004\u0003\u0005`+A\u0005\t\u0019AA$\u0011%\t)&\u0006I\u0001\u0002\u0004\tI\u0006C\u0005\u0002bU\u0001\n\u00111\u0001\u0002$!I\u0011QM\u000b\u0011\u0002\u0003\u0007\u0011\u0011N\u000b\u0003\u0005SQC!!\u000f\u0002\u0014\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]*\"A!\u000e+\t\u0005%\u00141\u0013\u000b\u0005\u0003\u0013\u0014I\u0004C\u0005\u0002R~\t\t\u00111\u0001\u0002ZQ!\u0011q\u001dB\u001f\u0011%\t\t.IA\u0001\u0002\u0004\tI\r\u0006\u0003\u00026\n\u0005\u0003\"CAiE\u0005\u0005\t\u0019AA-)\u0011\t9O!\u0012\t\u0013\u0005EW%!AA\u0002\u0005%\u0017!F*fe&\fG.\u001b>fINs\u0017\r]:i_R\u0014vn\u001e\t\u0004\u0003c:3#B\u0014\u0003N\te\u0003\u0003\u0006B(\u0005+\n\u0019#!\u000f\u0002:\u0005\u001d\u0013\u0011LA\u0012\u0003S\u00129!\u0004\u0002\u0003R)\u0019!1\u000b7\u0002\u000fI,h\u000e^5nK&!!q\u000bB)\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\u000e\t\u0005\u00057\u0012\t'\u0004\u0002\u0003^)!!qLA_\u0003\tIw.\u0003\u0003\u0002\u001c\tuCC\u0001B%\u0003\u0015\t\u0007\u000f\u001d7z)A\u00119A!\u001b\u0003l\t5$q\u000eB9\u0005g\u0012)\bC\u0004\u0002 )\u0002\r!a\t\t\u000f\u0005U\"\u00061\u0001\u0002:!9\u0011\u0011\t\u0016A\u0002\u0005e\u0002BB0+\u0001\u0004\t9\u0005C\u0004\u0002V)\u0002\r!!\u0017\t\u000f\u0005\u0005$\u00061\u0001\u0002$!9\u0011Q\r\u0016A\u0002\u0005%\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005w\u0012\u0019\tE\u0003l\u0003W\u0012i\bE\tl\u0005\u007f\n\u0019#!\u000f\u0002:\u0005\u001d\u0013\u0011LA\u0012\u0003SJ1A!!m\u0005\u0019!V\u000f\u001d7fo!I!QQ\u0016\u0002\u0002\u0003\u0007!qA\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BF!\u0011\t9L!$\n\t\t=\u0015\u0011\u0018\u0002\u0007\u001f\nTWm\u0019;\u00025M+'/[1mSj,Gm\u00158baNDw\u000e^'fi\u0006$\u0017\r^1\u0011\u0007\u0005E4iE\u0003D\u0005/\u0013I\u0006\u0005\u0007\u0003P\te\u0015qIA-\u0003G\ty'\u0003\u0003\u0003\u001c\nE#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!1\u0013\u000b\t\u0003_\u0012\tKa)\u0003&\"9\u0011q\u000f$A\u0002\u0005\u001d\u0003bBA+\r\u0002\u0007\u0011\u0011\f\u0005\b\u0003C2\u0005\u0019AA\u0012)\u0011\u0011IK!-\u0011\u000b-\fYGa+\u0011\u0013-\u0014i+a\u0012\u0002Z\u0005\r\u0012b\u0001BXY\n1A+\u001e9mKNB\u0011B!\"H\u0003\u0003\u0005\r!a\u001c\u00023\r|G\u000e\\3diN+'/[1mSj,Gm\u00158baNDw\u000e\u001e\u000b\u0005\u0005\u000f\u00119\fC\u0004\u0003:&\u0003\rAa/\u0002\u0007I|w\u000f\u0005\u0003\u0003>\n\u001dWB\u0001B`\u0015\u0011\u0011\tMa1\u0002\u0007M\u0004\u0018NC\u0002b\u0005\u000bT!Aa\u0018\n\t\t%'q\u0018\u0002\u0004%><8C\u0001&k\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003\u0002Bi\u0005'l\u0011\u0001Y\u0005\u0004\u0005+\u0004'!\u0004*3I\n\u001c7+\u001a;uS:<7/A\td_:tWm\u0019;j_:4\u0015m\u0019;pef\u0004BA!0\u0003\\&!!Q\u001cB`\u0005E\u0019uN\u001c8fGRLwN\u001c$bGR|'/_\u0001\u0003K\u000e\u0004BAa9\u0003j6\u0011!Q\u001d\u0006\u0004\u0005Od\u0017AC2p]\u000e,(O]3oi&!!1\u001eBs\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004tsN$X-\u001c\u0019\u0005\u0005c\u001c)\u0001\u0005\u0004\u0003t\nu8\u0011A\u0007\u0003\u0005kTAAa>\u0003z\u0006)A/\u001f9fI*\u0019!1 3\u0002\u000b\u0005\u001cGo\u001c:\n\t\t}(Q\u001f\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0005\u0003\u0004\u0004\r\u0015A\u0002\u0001\u0003\f\u0007\u000fq\u0015\u0011!A\u0001\u0006\u0003\u0019IAA\u0002`IE\nBaa\u0003\u0002JB\u00191n!\u0004\n\u0007\r=ANA\u0004O_RD\u0017N\\4\u0015\r\rM11EB\u0013)\u0019\u0019)ba\u0006\u0004\u001aA\u0011qM\u0013\u0005\b\u0005?|\u00059\u0001Bq\u0011\u001d\u0011io\u0014a\u0002\u00077\u0001Da!\b\u0004\"A1!1\u001fB\u007f\u0007?\u0001Baa\u0001\u0004\"\u0011a1qAB\r\u0003\u0003\u0005\tQ!\u0001\u0004\n!9!QZ(A\u0002\t=\u0007b\u0002Bl\u001f\u0002\u0007!\u0011\\\u0001\u000eg:\f\u0007o\u001d5piR\u000b'\r\\3\u0002\u001dMt\u0017\r]:i_R$\u0016M\u00197fA\u0005q\u0001/\u001a:tSN$XM\\2f\u000bb$XCAB\u0018!\u0011\u0019\tda\r\u000e\u0003\tL1a!\u000ec\u0005-\u0001VM]:jgR,gnY3\u0002\u001fA,'o]5ti\u0016t7-Z#yi\u0002\nQB\u001d\u001aeE\u000e,\u00050Z2vi>\u0014XCAB\u001f!\u0011\u0019yd!\u0012\u000e\u0005\r\u0005#bAB\"A\u0006A\u0011N\u001c;fe:\fG.\u0003\u0003\u0004H\r\u0005#!\u0004*3I\n\u001cW\t_3dkR|'/\u0001\bse\u0011\u00147-\u0012=fGV$xN\u001d\u0011\u0002\u0013U\u00048/\u001a:u'Fd\u0017AC;qg\u0016\u0014HoU9mA\u0005I1/\u001a7fGR\u001c\u0016\u000f\u001c\u000b\u0005\u0003G\u0019\u0019\u0006C\u0004\u0004Va\u0003\raa\u0016\u0002\u0011\r\u0014\u0018\u000e^3sS\u0006\u0004Ba!\r\u0004Z%\u001911\f2\u00033Ms\u0017\r]:i_R\u001cV\r\\3di&|gn\u0011:ji\u0016\u0014\u0018.Y\u0001\nI\u0016dW\r^3Tc2$B!a\t\u0004b!91QK-A\u0002\r]\u0013\u0001\u00027pC\u0012$baa\u001a\u0004t\rU\u0004C\u0002Br\u0007S\u001ai'\u0003\u0003\u0004l\t\u0015(A\u0002$viV\u0014X\rE\u0003l\u0003W\u001ay\u0007E\u0002\u0004r\u0015q!a\u001a\u0001\t\u000f\u0005}!\f1\u0001\u0002$!91Q\u000b.A\u0002\r]\u0013!B:u_J,G\u0003BB>\u0007\u0007\u0003bAa9\u0004j\ru\u0004cA6\u0004\u0000%\u00191\u0011\u00117\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\u000b[\u0006\u0019AB8\u00035\u0019XM]5bY&TX\r\u001a*po\u00061A-\u001a7fi\u0016$baa\u001f\u0004\f\u000e5\u0005bBA\u00109\u0002\u0007\u00111\u0005\u0005\b\u0007+b\u0006\u0019AB,Q\rQ5\u0011\u0013\t\u0005\u0007'\u001b9*\u0004\u0002\u0004\u0016*\u0019\u0011q\u00143\n\t\re5Q\u0013\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public final class SnapshotDao {
    private final String snapshotTable;
    private final Persistence persistenceExt;
    private final R2dbcExecutor r2dbcExecutor;
    private final String upsertSql;

    private String snapshotTable() {
        return this.snapshotTable;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    private String upsertSql() {
        return this.upsertSql;
    }

    private String selectSql(SnapshotSelectionCriteria criteria) {
        String maxSeqNrCondition = criteria.maxSequenceNr() != Long.MAX_VALUE ? " AND seq_nr <= ?" : "";
        String minSeqNrCondition = criteria.minSequenceNr() > 0L ? " AND seq_nr >= ?" : "";
        String maxTimestampCondition = criteria.maxTimestamp() != Long.MAX_VALUE ? " AND write_timestamp <= ?" : "";
        String minTimestampCondition = criteria.minTimestamp() != 0L ? " AND write_timestamp >= ?" : "";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT persistence_id, seq_nr, write_timestamp, snapshot, ser_id, ser_manifest, meta_payload, meta_ser_id, meta_ser_manifest\n      FROM ", "\n      WHERE persistence_id = ?\n      ", " ", " ", " ", "\n      LIMIT 1"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable(), maxSeqNrCondition, minSeqNrCondition, maxTimestampCondition, minTimestampCondition}));
    }

    private String deleteSql(SnapshotSelectionCriteria criteria) {
        String maxSeqNrCondition = criteria.maxSequenceNr() != Long.MAX_VALUE ? " AND seq_nr <= ?" : "";
        String minSeqNrCondition = criteria.minSequenceNr() > 0L ? " AND seq_nr >= ?" : "";
        String maxTimestampCondition = criteria.maxTimestamp() != Long.MAX_VALUE ? " AND write_timestamp <= ?" : "";
        String minTimestampCondition = criteria.minTimestamp() != 0L ? " AND write_timestamp >= ?" : "";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      DELETE FROM ", "\n      WHERE persistence_id = ?\n      ", " ", " ", " ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable(), maxSeqNrCondition, minSeqNrCondition, maxTimestampCondition, minTimestampCondition}));
    }

    public Future<Option<SerializedSnapshotRow>> load(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.r2dbcExecutor().select(new StringBuilder(32).append("select snapshot [").append(persistenceId).append("], criteria: [").append(criteria).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Statement statement = connection.createStatement(this.selectSql(criteria)).bind(0, (Object)persistenceId);
            int bindIdx = 0;
            Object object = criteria.maxSequenceNr() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxSequenceNr())) : BoxedUnit.UNIT;
            Object object2 = criteria.minSequenceNr() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minSequenceNr())) : BoxedUnit.UNIT;
            Object object3 = criteria.maxTimestamp() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxTimestamp())) : BoxedUnit.UNIT;
            Object object4 = criteria.minTimestamp() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minTimestamp())) : BoxedUnit.UNIT;
            return statement;
        }, (Function1 & Serializable)row -> SnapshotDao$.MODULE$.akka$persistence$r2dbc$snapshot$SnapshotDao$$collectSerializedSnapshot((Row)row)).map((Function1 & Serializable)x$1 -> x$1.headOption(), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<BoxedUnit> store(SerializedSnapshotRow serializedRow) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(serializedRow.persistenceId());
        int slice = this.persistenceExt().sliceForPersistenceId(serializedRow.persistenceId());
        return this.r2dbcExecutor().updateOne(new StringBuilder(38).append("upsert snapshot [").append(serializedRow.persistenceId()).append("], sequence number [").append(serializedRow.seqNr()).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Statement statement;
            Some some;
            SerializedSnapshotMetadata serializedSnapshotMetadata;
            Statement statement2 = connection.createStatement(this.upsertSql()).bind(0, (Object)BoxesRunTime.boxToInteger((int)slice)).bind(1, (Object)entityType).bind(2, (Object)serializedRow.persistenceId()).bind(3, (Object)BoxesRunTime.boxToLong((long)serializedRow.seqNr())).bind(4, (Object)BoxesRunTime.boxToLong((long)serializedRow.writeTimestamp())).bind(5, (Object)serializedRow.snapshot()).bind(6, (Object)BoxesRunTime.boxToInteger((int)serializedRow.serializerId())).bind(7, (Object)serializedRow.serializerManifest());
            Option<SerializedSnapshotMetadata> option = serializedRow.metadata();
            if (option instanceof Some && (serializedSnapshotMetadata = (SerializedSnapshotMetadata)(some = (Some)option).value()) != null) {
                byte[] serializedMeta = serializedSnapshotMetadata.payload();
                int serializerId = serializedSnapshotMetadata.serializerId();
                String serializerManifest = serializedSnapshotMetadata.serializerManifest();
                statement = statement2.bind(8, (Object)serializedMeta).bind(9, (Object)BoxesRunTime.boxToInteger((int)serializerId)).bind(10, (Object)serializerManifest);
            } else if (None$.MODULE$.equals(option)) {
                statement = statement2.bindNull(8, byte[].class).bindNull(9, Integer.class).bindNull(10, String.class);
            } else {
                throw new MatchError(option);
            }
            return statement2;
        }).map((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<BoxedUnit> delete(String persistenceId, SnapshotSelectionCriteria criteria) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(persistenceId);
        int slice = this.persistenceExt().sliceForPersistenceId(persistenceId);
        return this.r2dbcExecutor().updateOne(new StringBuilder(31).append("delete snapshot [").append(persistenceId).append("], criteria [").append(criteria).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Statement statement = connection.createStatement(this.deleteSql(criteria)).bind(0, (Object)persistenceId);
            int bindIdx = 0;
            Object object = criteria.maxSequenceNr() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxSequenceNr())) : BoxedUnit.UNIT;
            Object object2 = criteria.minSequenceNr() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minSequenceNr())) : BoxedUnit.UNIT;
            Object object3 = criteria.maxTimestamp() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxTimestamp())) : BoxedUnit.UNIT;
            Object object4 = criteria.minTimestamp() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minTimestamp())) : BoxedUnit.UNIT;
            return statement;
        }).map((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public SnapshotDao(R2dbcSettings settings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.snapshotTable = settings.snapshotsTableWithSchema();
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, SnapshotDao$.MODULE$.akka$persistence$r2dbc$snapshot$SnapshotDao$$log(), settings.logDbCallsExceeding(), ec, system);
        this.upsertSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    INSERT INTO ", "\n    (slice, entity_type, persistence_id, seq_nr, write_timestamp, snapshot, ser_id, ser_manifest, meta_payload, meta_ser_id, meta_ser_manifest)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (persistence_id)\n    DO UPDATE SET\n      seq_nr = excluded.seq_nr,\n      write_timestamp = excluded.write_timestamp,\n      snapshot = excluded.snapshot,\n      ser_id = excluded.ser_id,\n      ser_manifest = excluded.ser_manifest,\n      meta_payload = excluded.meta_payload,\n      meta_ser_id = excluded.meta_ser_id,\n      meta_ser_manifest = excluded.meta_ser_manifest"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable()}));
    }

    public static final class SerializedSnapshotMetadata
    implements Product,
    Serializable {
        private final byte[] payload;
        private final int serializerId;
        private final String serializerManifest;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public byte[] payload() {
            return this.payload;
        }

        public int serializerId() {
            return this.serializerId;
        }

        public String serializerManifest() {
            return this.serializerManifest;
        }

        public SerializedSnapshotMetadata copy(byte[] payload, int serializerId, String serializerManifest) {
            return new SerializedSnapshotMetadata(payload, serializerId, serializerManifest);
        }

        public byte[] copy$default$1() {
            return this.payload();
        }

        public int copy$default$2() {
            return this.serializerId();
        }

        public String copy$default$3() {
            return this.serializerManifest();
        }

        public String productPrefix() {
            return "SerializedSnapshotMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.payload();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.serializerId());
                    break;
                }
                case 2: {
                    object = this.serializerManifest();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedSnapshotMetadata;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "payload";
                    break;
                }
                case 1: {
                    string = "serializerId";
                    break;
                }
                case 2: {
                    string = "serializerManifest";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            n = Statics.mix((int)n, (int)this.serializerId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serializerManifest()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedSnapshotMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedSnapshotMetadata serializedSnapshotMetadata = (SerializedSnapshotMetadata)x$1;
            if (this.serializerId() != serializedSnapshotMetadata.serializerId()) return false;
            if (this.payload() != serializedSnapshotMetadata.payload()) return false;
            String string = this.serializerManifest();
            String string2 = serializedSnapshotMetadata.serializerManifest();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public SerializedSnapshotMetadata(byte[] payload, int serializerId, String serializerManifest) {
            this.payload = payload;
            this.serializerId = serializerId;
            this.serializerManifest = serializerManifest;
            Product.$init$((Product)this);
        }
    }

    public static final class SerializedSnapshotRow
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long seqNr;
        private final long writeTimestamp;
        private final byte[] snapshot;
        private final int serializerId;
        private final String serializerManifest;
        private final Option<SerializedSnapshotMetadata> metadata;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long seqNr() {
            return this.seqNr;
        }

        public long writeTimestamp() {
            return this.writeTimestamp;
        }

        public byte[] snapshot() {
            return this.snapshot;
        }

        public int serializerId() {
            return this.serializerId;
        }

        public String serializerManifest() {
            return this.serializerManifest;
        }

        public Option<SerializedSnapshotMetadata> metadata() {
            return this.metadata;
        }

        public SerializedSnapshotRow copy(String persistenceId, long seqNr, long writeTimestamp, byte[] snapshot, int serializerId, String serializerManifest, Option<SerializedSnapshotMetadata> metadata) {
            return new SerializedSnapshotRow(persistenceId, seqNr, writeTimestamp, snapshot, serializerId, serializerManifest, metadata);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.seqNr();
        }

        public long copy$default$3() {
            return this.writeTimestamp();
        }

        public byte[] copy$default$4() {
            return this.snapshot();
        }

        public int copy$default$5() {
            return this.serializerId();
        }

        public String copy$default$6() {
            return this.serializerManifest();
        }

        public Option<SerializedSnapshotMetadata> copy$default$7() {
            return this.metadata();
        }

        public String productPrefix() {
            return "SerializedSnapshotRow";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.persistenceId();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.seqNr());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.writeTimestamp());
                    break;
                }
                case 3: {
                    object = this.snapshot();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.serializerId());
                    break;
                }
                case 5: {
                    object = this.serializerManifest();
                    break;
                }
                case 6: {
                    object = this.metadata();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedSnapshotRow;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "persistenceId";
                    break;
                }
                case 1: {
                    string = "seqNr";
                    break;
                }
                case 2: {
                    string = "writeTimestamp";
                    break;
                }
                case 3: {
                    string = "snapshot";
                    break;
                }
                case 4: {
                    string = "serializerId";
                    break;
                }
                case 5: {
                    string = "serializerManifest";
                    break;
                }
                case 6: {
                    string = "metadata";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.writeTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.snapshot()));
            n = Statics.mix((int)n, (int)this.serializerId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serializerManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedSnapshotRow)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedSnapshotRow serializedSnapshotRow = (SerializedSnapshotRow)x$1;
            if (this.seqNr() != serializedSnapshotRow.seqNr()) return false;
            if (this.writeTimestamp() != serializedSnapshotRow.writeTimestamp()) return false;
            if (this.serializerId() != serializedSnapshotRow.serializerId()) return false;
            String string = this.persistenceId();
            String string2 = serializedSnapshotRow.persistenceId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.snapshot() != serializedSnapshotRow.snapshot()) return false;
            String string3 = this.serializerManifest();
            String string4 = serializedSnapshotRow.serializerManifest();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<SerializedSnapshotMetadata> option = this.metadata();
            Option<SerializedSnapshotMetadata> option2 = serializedSnapshotRow.metadata();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public SerializedSnapshotRow(String persistenceId, long seqNr, long writeTimestamp, byte[] snapshot, int serializerId, String serializerManifest, Option<SerializedSnapshotMetadata> metadata) {
            this.persistenceId = persistenceId;
            this.seqNr = seqNr;
            this.writeTimestamp = writeTimestamp;
            this.snapshot = snapshot;
            this.serializerId = serializerId;
            this.serializerManifest = serializerManifest;
            this.metadata = metadata;
            Product.$init$((Product)this);
        }
    }
}

