/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.journal;

import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.journal.JournalDao$;
import akka.persistence.typed.PersistenceId$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00115sAB;w\u0011\u0003AhP\u0002\u0005\u0002\u0002YD\t\u0001_A\u0002\u0011\u001d\t\t\"\u0001C\u0001\u0003+A\u0011\"a\u0006\u0002\u0005\u0004%\t!!\u0007\t\u0011\u0005-\u0012\u0001)A\u0005\u00037A\u0011\"!\f\u0002\u0005\u0004%\t!a\f\t\u0011\u0005\u0005\u0013\u0001)A\u0005\u0003c1a!a\u0011\u0002\u0005\u0006\u0015\u0003BCA=\u000f\tU\r\u0011\"\u0001\u0002|!Q\u00111Q\u0004\u0003\u0012\u0003\u0006I!! \t\u0015\u0005\u0015uA!f\u0001\n\u0003\t9\t\u0003\u0006\u0002\u001a\u001e\u0011\t\u0012)A\u0005\u0003\u0013C!\"a'\b\u0005+\u0007I\u0011AAD\u0011)\tij\u0002B\tB\u0003%\u0011\u0011\u0012\u0005\u000b\u0003?;!Q3A\u0005\u0002\u0005\u0005\u0006BCAU\u000f\tE\t\u0015!\u0003\u0002$\"Q\u00111V\u0004\u0003\u0016\u0004%\t!a\f\t\u0015\u00055vA!E!\u0002\u0013\t\t\u0004\u0003\u0006\u00020\u001e\u0011)\u001a!C\u0001\u0003_A!\"!-\b\u0005#\u0005\u000b\u0011BA\u0019\u0011)\t\u0019l\u0002BK\u0002\u0013\u0005\u0011Q\u0017\u0005\u000b\u0003\u0013<!\u0011#Q\u0001\n\u0005]\u0006BCAf\u000f\tU\r\u0011\"\u0001\u0002|!Q\u0011QZ\u0004\u0003\u0012\u0003\u0006I!! \t\u0015\u0005=wA!f\u0001\n\u0003\t9\t\u0003\u0006\u0002R\u001e\u0011\t\u0012)A\u0005\u0003\u0013C!\"a5\b\u0005+\u0007I\u0011AAD\u0011)\t)n\u0002B\tB\u0003%\u0011\u0011\u0012\u0005\u000b\u0003/<!Q3A\u0005\u0002\u0005e\u0007BCAq\u000f\tE\t\u0015!\u0003\u0002\\\"Q\u00111]\u0004\u0003\u0016\u0004%\t!!:\t\u0015\t]tA!E!\u0002\u0013\t9\u000fC\u0004\u0002\u0012\u001d!\tA!\u001f\t\u0013\u0005mx!!A\u0005\u0002\tU\u0005\"\u0003B\u0003\u000fE\u0005I\u0011\u0001B\u0004\u0011%\u0011ibBI\u0001\n\u0003\u0011y\u0002C\u0005\u0003$\u001d\t\n\u0011\"\u0001\u0003 !I!qV\u0004\u0012\u0002\u0013\u0005!\u0011\u0017\u0005\n\u0005k;\u0011\u0013!C\u0001\u0005oC\u0011Ba/\b#\u0003%\tAa.\t\u0013\tuv!%A\u0005\u0002\t}\u0006\"\u0003Bb\u000fE\u0005I\u0011\u0001B\u0004\u0011%\u0011)mBI\u0001\n\u0003\u0011y\u0002C\u0005\u0003H\u001e\t\n\u0011\"\u0001\u0003 !I!\u0011Z\u0004\u0012\u0002\u0013\u0005!1\u001a\u0005\n\u0005\u001f<\u0011\u0013!C\u0001\u0005#D\u0011B!\u000b\b\u0003\u0003%\tEa\u000b\t\u0013\t]r!!A\u0005\u0002\u0005m\u0004\"\u0003B\u001d\u000f\u0005\u0005I\u0011\u0001Bk\u0011%\u00119eBA\u0001\n\u0003\u0012I\u0005C\u0005\u0003X\u001d\t\t\u0011\"\u0001\u0003Z\"I!1M\u0004\u0002\u0002\u0013\u0005#Q\u001c\u0005\n\u0005S:\u0011\u0011!C!\u0005WB\u0011B!\u001c\b\u0003\u0003%\tEa\u001c\t\u0013\tEt!!A\u0005B\t\u0005x!\u0003Bs\u0003\u0005\u0005\t\u0012\u0001Bt\r%\t\u0019%AA\u0001\u0012\u0003\u0011I\u000fC\u0004\u0002\u0012a\"\ta!\u0001\t\u0013\t5\u0004(!A\u0005F\t=\u0004\"CB\u0002q\u0005\u0005I\u0011QB\u0003\u0011%\u0019y\u0002OA\u0001\n\u0003\u001b\t\u0003C\u0005\u00040a\n\t\u0011\"\u0003\u00042\u00191\u0011Q^\u0001C\u0003_D!\"a3?\u0005+\u0007I\u0011AA>\u0011)\tiM\u0010B\tB\u0003%\u0011Q\u0010\u0005\u000b\u0003\u001ft$Q3A\u0005\u0002\u0005\u001d\u0005BCAi}\tE\t\u0015!\u0003\u0002\n\"Q\u00111\u0017 \u0003\u0016\u0004%\t!!=\t\u0015\u0005%gH!E!\u0002\u0013\ti\fC\u0004\u0002\u0012y\"\t!a=\t\u0013\u0005mh(!A\u0005\u0002\u0005u\b\"\u0003B\u0003}E\u0005I\u0011\u0001B\u0004\u0011%\u0011iBPI\u0001\n\u0003\u0011y\u0002C\u0005\u0003$y\n\n\u0011\"\u0001\u0003&!I!\u0011\u0006 \u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005oq\u0014\u0011!C\u0001\u0003wB\u0011B!\u000f?\u0003\u0003%\tAa\u000f\t\u0013\t\u001dc(!A\u0005B\t%\u0003\"\u0003B,}\u0005\u0005I\u0011\u0001B-\u0011%\u0011\u0019GPA\u0001\n\u0003\u0012)\u0007C\u0005\u0003jy\n\t\u0011\"\u0011\u0003l!I!Q\u000e \u0002\u0002\u0013\u0005#q\u000e\u0005\n\u0005cr\u0014\u0011!C!\u0005g:\u0011b!\u000f\u0002\u0003\u0003E\taa\u000f\u0007\u0013\u00055\u0018!!A\t\u0002\ru\u0002bBA\t)\u0012\u00051Q\t\u0005\n\u0005[\"\u0016\u0011!C#\u0005_B\u0011ba\u0001U\u0003\u0003%\tia\u0012\t\u0013\r}A+!A\u0005\u0002\u000e=\u0003\"CB\u0018)\u0006\u0005I\u0011BB\u0019\u0011\u001d\u0019Y&\u0001C\u0001\u0007;2q!!\u0001w\u0001a\u001c\t\t\u0003\u0006\u0004\u0004n\u0013\t\u0011)A\u0005\u0007\u000bC!b!$\\\u0005\u0003\u0005\u000b\u0011BBH\u0011)\u0019)j\u0017B\u0001B\u0003-1q\u0013\u0005\u000b\u0007G[&\u0011!Q\u0001\f\r\u0015\u0006bBA\t7\u0012\u00051q\u0019\u0005\n\u0007;\\&\u0019!C\u0005\u0007?D\u0001b!;\\A\u0003%1\u0011\u001d\u0005\n\u0007W\\&\u0019!C\u0005\u0007[D\u0001b!>\\A\u0003%1q\u001e\u0005\n\u0007o\\&\u0019!C\u0005\u0003\u000fC\u0001b!?\\A\u0003%\u0011\u0011\u0012\u0005\r\u0005\u000bZ\u0006\u0013!A\u0002B\u0003%11 \u0005\n\t\u0003Y&\u0019!C\u0005\u0003\u000fC\u0001\u0002b\u0001\\A\u0003%\u0011\u0011\u0012\u0005\n\t\u000bY&\u0019!C\u0005\u0003\u000fC\u0001\u0002b\u0002\\A\u0003%\u0011\u0011\u0012\u0005\n\t\u0013Y&\u0019!C\u0005\u0003\u000fC\u0001\u0002b\u0003\\A\u0003%\u0011\u0011\u0012\u0005\n\t\u001bY&\u0019!C\u0005\u0003\u000fC\u0001\u0002b\u0004\\A\u0003%\u0011\u0011\u0012\u0005\n\t#Y&\u0019!C\u0005\u0003\u000fC\u0001\u0002b\u0005\\A\u0003%\u0011\u0011\u0012\u0005\b\t+YF\u0011\u0001C\f\u0011\u001d!ic\u0017C\u0001\t_Aq\u0001\"\u000f\\\t\u0003!Y$\u0001\u0006K_V\u0014h.\u00197EC>T!a\u001e=\u0002\u000f)|WO\u001d8bY*\u0011\u0011P_\u0001\u0006eJ\"'m\u0019\u0006\u0003wr\f1\u0002]3sg&\u001cH/\u001a8dK*\tQ0\u0001\u0003bW.\f\u0007CA@\u0002\u001b\u00051(A\u0003&pkJt\u0017\r\u001c#b_N\u0019\u0011!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q!!a\u0003\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005=\u0011\u0011\u0002\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A`\u0001\u0004Y><WCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tQa\u001d7gi)T!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005}!A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013\u0001E#naRLHI\u0019+j[\u0016\u001cH/Y7q+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\tQLW.\u001a\u0006\u0003\u0003w\tAA[1wC&!\u0011qHA\u001b\u0005\u001dIen\u001d;b]R\f\u0011#R7qif$%\rV5nKN$\u0018-\u001c9!\u0005Q\u0019VM]5bY&TX\r\u001a&pkJt\u0017\r\u001c*poNIq!!\u0002\u0002H\u0005m\u0013\u0011\r\t\u0005\u0003\u0013\n)F\u0004\u0003\u0002L\u0005ESBAA'\u0015\r\ty\u0005_\u0001\tS:$XM\u001d8bY&!\u00111KA'\u00031\u0011\u0015p\u00157jG\u0016\fV/\u001a:z\u0013\u0011\t9&!\u0017\u0003\u001bM+'/[1mSj,GMU8x\u0015\u0011\t\u0019&!\u0014\u0011\t\u0005\u001d\u0011QL\u0005\u0005\u0003?\nIAA\u0004Qe>$Wo\u0019;\u0011\t\u0005\r\u00141\u000f\b\u0005\u0003K\nyG\u0004\u0003\u0002h\u00055TBAA5\u0015\u0011\tY'a\u0005\u0002\rq\u0012xn\u001c;?\u0013\t\tY!\u0003\u0003\u0002r\u0005%\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003k\n9H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0003\u0002r\u0005%\u0011!B:mS\u000e,WCAA?!\u0011\t9!a \n\t\u0005\u0005\u0015\u0011\u0002\u0002\u0004\u0013:$\u0018AB:mS\u000e,\u0007%\u0001\u0006f]RLG/\u001f+za\u0016,\"!!#\u0011\t\u0005-\u00151\u0013\b\u0005\u0003\u001b\u000by\t\u0005\u0003\u0002h\u0005%\u0011\u0002BAI\u0003\u0013\ta\u0001\u0015:fI\u00164\u0017\u0002BAK\u0003/\u0013aa\u0015;sS:<'\u0002BAI\u0003\u0013\t1\"\u001a8uSRLH+\u001f9fA\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\fa\u0002]3sg&\u001cH/\u001a8dK&#\u0007%A\u0003tKFt%/\u0006\u0002\u0002$B!\u0011qAAS\u0013\u0011\t9+!\u0003\u0003\t1{gnZ\u0001\u0007g\u0016\fhJ\u001d\u0011\u0002\u0017\u0011\u0014G+[7fgR\fW\u000e]\u0001\rI\n$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0010e\u0016\fG\r\u00122US6,7\u000f^1na\u0006\u0001\"/Z1e\t\n$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\ba\u0006LHn\\1e+\t\t9\f\u0005\u0004\u0002\b\u0005e\u0016QX\u0005\u0005\u0003w\u000bIA\u0001\u0004PaRLwN\u001c\t\u0007\u0003\u000f\ty,a1\n\t\u0005\u0005\u0017\u0011\u0002\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u000f\t)-\u0003\u0003\u0002H\u0006%!\u0001\u0002\"zi\u0016\f\u0001\u0002]1zY>\fG\rI\u0001\u0006g\u0016\u0014\u0018\nZ\u0001\u0007g\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017M,'/T1oS\u001a,7\u000f^\u0001\rg\u0016\u0014X*\u00198jM\u0016\u001cH\u000fI\u0001\u000boJLG/\u001a:Vk&$\u0017aC<sSR,'/V;jI\u0002\nA\u0001^1hgV\u0011\u00111\u001c\t\u0007\u0003\u0017\u000bi.!#\n\t\u0005}\u0017q\u0013\u0002\u0004'\u0016$\u0018!\u0002;bON\u0004\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005\u001d\bCBA\u0004\u0003s\u000bI\u000fE\u0002\u0002lzj\u0011!\u0001\u0002\u0018'\u0016\u0014\u0018.\u00197ju\u0016$WI^3oi6+G/\u00193bi\u0006\u001crAPA\u0003\u00037\n\t'\u0006\u0002\u0002>RA\u0011\u0011^A{\u0003o\fI\u0010C\u0004\u0002L\u0016\u0003\r!! \t\u000f\u0005=W\t1\u0001\u0002\n\"9\u00111W#A\u0002\u0005u\u0016\u0001B2paf$\u0002\"!;\u0002\u0000\n\u0005!1\u0001\u0005\n\u0003\u00174\u0005\u0013!a\u0001\u0003{B\u0011\"a4G!\u0003\u0005\r!!#\t\u0013\u0005Mf\t%AA\u0002\u0005u\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0013QC!! \u0003\f-\u0012!Q\u0002\t\u0005\u0005\u001f\u0011I\"\u0004\u0002\u0003\u0012)!!1\u0003B\u000b\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\u0018\u0005%\u0011AC1o]>$\u0018\r^5p]&!!1\u0004B\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tC\u000b\u0003\u0002\n\n-\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005OQC!!0\u0003\f\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\f\u0011\t\t=\"QG\u0007\u0003\u0005cQAAa\r\u0002:\u0005!A.\u00198h\u0013\u0011\t)J!\r\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\bB\"!\u0011\t9Aa\u0010\n\t\t\u0005\u0013\u0011\u0002\u0002\u0004\u0003:L\b\"\u0003B#\u0019\u0006\u0005\t\u0019AA?\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\n\t\u0007\u0005\u001b\u0012\u0019F!\u0010\u000e\u0005\t=#\u0002\u0002B)\u0003\u0013\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Fa\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00057\u0012\t\u0007\u0005\u0003\u0002\b\tu\u0013\u0002\u0002B0\u0003\u0013\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0003F9\u000b\t\u00111\u0001\u0003>\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011iCa\u001a\t\u0013\t\u0015s*!AA\u0002\u0005u\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003\\\tU\u0004\"\u0003B#%\u0006\u0005\t\u0019\u0001B\u001f\u0003%iW\r^1eCR\f\u0007\u0005\u0006\u000e\u0003|\tu$q\u0010BA\u0005\u0007\u0013)Ia\"\u0003\n\n-%Q\u0012BH\u0005#\u0013\u0019\nE\u0002\u0002l\u001eAq!!\u001f!\u0001\u0004\ti\bC\u0004\u0002\u0006\u0002\u0002\r!!#\t\u000f\u0005m\u0005\u00051\u0001\u0002\n\"9\u0011q\u0014\u0011A\u0002\u0005\r\u0006bBAVA\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003_\u0003\u0003\u0019AA\u0019\u0011\u001d\t\u0019\f\ta\u0001\u0003oCq!a3!\u0001\u0004\ti\bC\u0004\u0002P\u0002\u0002\r!!#\t\u000f\u0005M\u0007\u00051\u0001\u0002\n\"9\u0011q\u001b\u0011A\u0002\u0005m\u0007bBArA\u0001\u0007\u0011q\u001d\u000b\u001b\u0005w\u00129J!'\u0003\u001c\nu%q\u0014BQ\u0005G\u0013)Ka*\u0003*\n-&Q\u0016\u0005\n\u0003s\n\u0003\u0013!a\u0001\u0003{B\u0011\"!\"\"!\u0003\u0005\r!!#\t\u0013\u0005m\u0015\u0005%AA\u0002\u0005%\u0005\"CAPCA\u0005\t\u0019AAR\u0011%\tY+\tI\u0001\u0002\u0004\t\t\u0004C\u0005\u00020\u0006\u0002\n\u00111\u0001\u00022!I\u00111W\u0011\u0011\u0002\u0003\u0007\u0011q\u0017\u0005\n\u0003\u0017\f\u0003\u0013!a\u0001\u0003{B\u0011\"a4\"!\u0003\u0005\r!!#\t\u0013\u0005M\u0017\u0005%AA\u0002\u0005%\u0005\"CAlCA\u0005\t\u0019AAn\u0011%\t\u0019/\tI\u0001\u0002\u0004\t9/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM&\u0006BAR\u0005\u0017\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003:*\"\u0011\u0011\u0007B\u0006\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003B*\"\u0011q\u0017B\u0006\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa\nabY8qs\u0012\"WMZ1vYR$\u0013(A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\nTC\u0001BgU\u0011\tYNa\u0003\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cI*\"Aa5+\t\u0005\u001d(1\u0002\u000b\u0005\u0005{\u00119\u000eC\u0005\u0003FA\n\t\u00111\u0001\u0002~Q!!1\fBn\u0011%\u0011)EMA\u0001\u0002\u0004\u0011i\u0004\u0006\u0003\u0003.\t}\u0007\"\u0003B#g\u0005\u0005\t\u0019AA?)\u0011\u0011YFa9\t\u0013\t\u0015c'!AA\u0002\tu\u0012\u0001F*fe&\fG.\u001b>fI*{WO\u001d8bYJ{w\u000fE\u0002\u0002lb\u001aR\u0001\u000fBv\u0005o\u0004bD!<\u0003t\u0006u\u0014\u0011RAE\u0003G\u000b\t$!\r\u00028\u0006u\u0014\u0011RAE\u00037\f9Oa\u001f\u000e\u0005\t=(\u0002\u0002By\u0003\u0013\tqA];oi&lW-\u0003\u0003\u0003v\n=(AE!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocI\u0002BA!?\u0003\u00006\u0011!1 \u0006\u0005\u0005{\fI$\u0001\u0002j_&!\u0011Q\u000fB~)\t\u00119/A\u0003baBd\u0017\u0010\u0006\u000e\u0003|\r\u001d1\u0011BB\u0006\u0007\u001b\u0019ya!\u0005\u0004\u0014\rU1qCB\r\u00077\u0019i\u0002C\u0004\u0002zm\u0002\r!! \t\u000f\u0005\u00155\b1\u0001\u0002\n\"9\u00111T\u001eA\u0002\u0005%\u0005bBAPw\u0001\u0007\u00111\u0015\u0005\b\u0003W[\u0004\u0019AA\u0019\u0011\u001d\tyk\u000fa\u0001\u0003cAq!a-<\u0001\u0004\t9\fC\u0004\u0002Ln\u0002\r!! \t\u000f\u0005=7\b1\u0001\u0002\n\"9\u00111[\u001eA\u0002\u0005%\u0005bBAlw\u0001\u0007\u00111\u001c\u0005\b\u0003G\\\u0004\u0019AAt\u0003\u001d)h.\u00199qYf$Baa\t\u0004,A1\u0011qAA]\u0007K\u0001B$a\u0002\u0004(\u0005u\u0014\u0011RAE\u0003G\u000b\t$!\r\u00028\u0006u\u0014\u0011RAE\u00037\f9/\u0003\u0003\u0004*\u0005%!a\u0002+va2,\u0017G\r\u0005\n\u0007[a\u0014\u0011!a\u0001\u0005w\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\u0019\u0004\u0005\u0003\u00030\rU\u0012\u0002BB\u001c\u0005c\u0011aa\u00142kK\u000e$\u0018aF*fe&\fG.\u001b>fI\u00163XM\u001c;NKR\fG-\u0019;b!\r\tY\u000fV\n\u0006)\u000e}\"q\u001f\t\r\u0005[\u001c\t%! \u0002\n\u0006u\u0016\u0011^\u0005\u0005\u0007\u0007\u0012yOA\tBEN$(/Y2u\rVt7\r^5p]N\"\"aa\u000f\u0015\u0011\u0005%8\u0011JB&\u0007\u001bBq!a3X\u0001\u0004\ti\bC\u0004\u0002P^\u0003\r!!#\t\u000f\u0005Mv\u000b1\u0001\u0002>R!1\u0011KB-!\u0019\t9!!/\u0004TAQ\u0011qAB+\u0003{\nI)!0\n\t\r]\u0013\u0011\u0002\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r5\u0002,!AA\u0002\u0005%\u0018\u0001\u0004:fC\u0012lU\r^1eCR\fG\u0003BAt\u0007?Bqa!\u0019[\u0001\u0004\u0019\u0019'A\u0002s_^\u0004Ba!\u001a\u0004p5\u00111q\r\u0006\u0005\u0007S\u001aY'A\u0002ta&T1!_B7\u0015\t\u0011i0\u0003\u0003\u0004r\r\u001d$a\u0001*po\"\u001a\u0011a!\u001e\u0011\t\r]41P\u0007\u0003\u0007sR1Aa\u0006}\u0013\u0011\u0019ih!\u001f\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0004\u0001\rU4cA.\u0002\u0006\u0005y!n\\;s]\u0006d7+\u001a;uS:<7\u000f\u0005\u0003\u0004\b\u000e%U\"\u0001=\n\u0007\r-\u0005PA\u0007Se\u0011\u00147mU3ui&twm]\u0001\u0012G>tg.Z2uS>tg)Y2u_JL\b\u0003BB3\u0007#KAaa%\u0004h\t\t2i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0002\u0005\u0015\u001c\u0007\u0003BBM\u0007?k!aa'\u000b\t\ru\u0015\u0011B\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BBQ\u00077\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rML8\u000f^3na\u0011\u00199ka/\u0011\r\r%61WB\\\u001b\t\u0019YK\u0003\u0003\u0004.\u000e=\u0016!\u0002;za\u0016$'bABYy\u0006)\u0011m\u0019;pe&!1QWBV\u0005-\t5\r^8s'f\u001cH/Z7\u0011\t\re61\u0018\u0007\u0001\t-\u0019ilXA\u0001\u0002\u0003\u0015\taa0\u0003\u0007}#\u0013'\u0005\u0003\u0004B\nu\u0002\u0003BA\u0004\u0007\u0007LAa!2\u0002\n\t9aj\u001c;iS:<GCBBe\u00073\u001cY\u000e\u0006\u0004\u0004L\u000e57q\u001a\t\u0003\u007fnCqa!&a\u0001\b\u00199\nC\u0004\u0004$\u0002\u0004\u001da!51\t\rM7q\u001b\t\u0007\u0007S\u001b\u0019l!6\u0011\t\re6q\u001b\u0003\r\u0007{\u001by-!A\u0001\u0002\u000b\u00051q\u0018\u0005\b\u0007\u0007\u0003\u0007\u0019ABC\u0011\u001d\u0019i\t\u0019a\u0001\u0007\u001f\u000ba\u0002]3sg&\u001cH/\u001a8dK\u0016CH/\u0006\u0002\u0004bB!11]Bs\u001b\u0005Q\u0018bABtu\nY\u0001+\u001a:tSN$XM\\2f\u0003=\u0001XM]:jgR,gnY3FqR\u0004\u0013!\u0004:3I\n\u001cW\t_3dkR|'/\u0006\u0002\u0004pB!\u00111JBy\u0013\u0011\u0019\u00190!\u0014\u0003\u001bI\u0013DMY2Fq\u0016\u001cW\u000f^8s\u00039\u0011(\u0007\u001a2d\u000bb,7-\u001e;pe\u0002\nAB[8ve:\fG\u000eV1cY\u0016\fQB[8ve:\fG\u000eV1cY\u0016\u0004\u0003\u0003CA\u0004\u0007{\fI)!#\n\t\r}\u0018\u0011\u0002\u0002\u0007)V\u0004H.\u001a\u001a\u0002I%t7/\u001a:u\u000bZ,g\u000e^,ji\"\u0004\u0016M]1nKR,'\u000fV5nKN$\u0018-\u001c9Tc2\fQ%\u001b8tKJ$XI^3oi^KG\u000f\u001b)be\u0006lW\r^3s)&lWm\u001d;b[B\u001c\u0016\u000f\u001c\u0011\u0002M%t7/\u001a:u\u000bZ,g\u000e^,ji\"$&/\u00198tC\u000e$\u0018n\u001c8US6,7\u000f^1naN\u000bH.A\u0014j]N,'\u000f^#wK:$x+\u001b;i)J\fgn]1di&|g\u000eV5nKN$\u0018-\u001c9Tc2\u0004\u0013AG:fY\u0016\u001cG\u000fS5hQ\u0016\u001cHoU3rk\u0016t7-\u001a(s'Fd\u0017aG:fY\u0016\u001cG\u000fS5hQ\u0016\u001cHoU3rk\u0016t7-\u001a(s'Fd\u0007%A\beK2,G/Z#wK:$8oU9m\u0003A!W\r\\3uK\u00163XM\u001c;t'Fd\u0007%A\u000bj]N,'\u000f\u001e#fY\u0016$X-T1sW\u0016\u00148+\u001d7\u0002-%t7/\u001a:u\t\u0016dW\r^3NCJ\\WM]*rY\u0002\n1b\u001e:ji\u0016,e/\u001a8ugR!A\u0011\u0004C\u0010!\u0019\u0019I\nb\u0007\u00022%!AQDBN\u0005\u00191U\u000f^;sK\"9A\u0011\u0005:A\u0002\u0011\r\u0012AB3wK:$8\u000f\u0005\u0004\u0002d\u0011\u0015B\u0011F\u0005\u0005\tO\t9HA\u0002TKF\u00042\u0001b\u000b\b\u001d\ty\b!A\u000bsK\u0006$\u0007*[4iKN$8+Z9vK:\u001cWM\u0014:\u0015\r\u0011EB1\u0007C\u001b!\u0019\u0019I\nb\u0007\u0002$\"9\u00111T:A\u0002\u0005%\u0005b\u0002C\u001cg\u0002\u0007\u00111U\u0001\u000fMJ|WnU3rk\u0016t7-\u001a(s\u0003A!W\r\\3uK6+7o]1hKN$v\u000e\u0006\u0004\u0005>\u0011\u0015Cq\t\t\u0007\u00073#Y\u0002b\u0010\u0011\t\u0005\u001dA\u0011I\u0005\u0005\t\u0007\nIA\u0001\u0003V]&$\bbBANi\u0002\u0007\u0011\u0011\u0012\u0005\b\t\u0013\"\b\u0019AAR\u00031!xnU3rk\u0016t7-\u001a(sQ\rY6Q\u000f")
@InternalApi
public class JournalDao {
    private final R2dbcSettings journalSettings;
    private final ExecutionContext ec;
    private final Persistence persistenceExt;
    private final R2dbcExecutor r2dbcExecutor;
    private final String journalTable;
    private final /* synthetic */ Tuple2 x$1;
    private final String insertEventWithParameterTimestampSql;
    private final String insertEventWithTransactionTimestampSql;
    private final String selectHighestSequenceNrSql;
    private final String deleteEventsSql;
    private final String insertDeleteMarkerSql;

    public static Option<SerializedEventMetadata> readMetadata(Row row) {
        return JournalDao$.MODULE$.readMetadata(row);
    }

    public static Instant EmptyDbTimestamp() {
        return JournalDao$.MODULE$.EmptyDbTimestamp();
    }

    public static Logger log() {
        return JournalDao$.MODULE$.log();
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    private String journalTable() {
        return this.journalTable;
    }

    private String insertEventWithParameterTimestampSql() {
        return this.insertEventWithParameterTimestampSql;
    }

    private String insertEventWithTransactionTimestampSql() {
        return this.insertEventWithTransactionTimestampSql;
    }

    private String selectHighestSequenceNrSql() {
        return this.selectHighestSequenceNrSql;
    }

    private String deleteEventsSql() {
        return this.deleteEventsSql;
    }

    private String insertDeleteMarkerSql() {
        return this.insertDeleteMarkerSql;
    }

    public Future<Instant> writeEvents(Seq<SerializedJournalRow> events) {
        Future future;
        Predef$.MODULE$.require(events.nonEmpty());
        String persistenceId = ((SerializedJournalRow)events.head()).persistenceId();
        long previousSeqNr = ((SerializedJournalRow)events.head()).seqNr() - 1L;
        Instant instant = ((SerializedJournalRow)events.head()).dbTimestamp();
        Instant instant2 = Instant.EPOCH;
        boolean useTimestampFromDb = !(instant != null ? !((Object)instant).equals(instant2) : instant2 != null);
        String insertSql = useTimestampFromDb ? this.insertEventWithTransactionTimestampSql() : this.insertEventWithParameterTimestampSql();
        int totalEvents = events.size();
        if (totalEvents == 1) {
            Future result = this.r2dbcExecutor().updateOneReturning(new StringBuilder(9).append("insert [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> this.bind$1(connection.createStatement(insertSql), (SerializedJournalRow)events.head(), useTimestampFromDb, previousSeqNr), (Function1 & Serializable)row -> (Instant)row.get(0, Instant.class));
            if (JournalDao$.MODULE$.log().isDebugEnabled()) {
                result.foreach((Function1 & Serializable)x$2 -> {
                    JournalDao.$anonfun$writeEvents$3(events, x$2);
                    return BoxedUnit.UNIT;
                }, this.ec);
            }
            future = result;
        } else {
            Future result = this.r2dbcExecutor().updateInBatchReturning(new StringBuilder(26).append("batch insert [").append(persistenceId).append("], [").append(totalEvents).append("] events").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> (Statement)events.foldLeft((Object)connection.createStatement(insertSql), (Function2 & Serializable)(stmt, write) -> {
                stmt.add();
                return this.bind$1((Statement)stmt, (SerializedJournalRow)write, useTimestampFromDb, previousSeqNr);
            }), (Function1 & Serializable)row -> (Instant)row.get(0, Instant.class));
            if (JournalDao$.MODULE$.log().isDebugEnabled()) {
                result.foreach((Function1 & Serializable)x$3 -> {
                    JournalDao.$anonfun$writeEvents$7(events, x$3);
                    return BoxedUnit.UNIT;
                }, this.ec);
            }
            future = result.map((Function1 & Serializable)x$4 -> (Instant)x$4.head(), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
        }
        return future;
    }

    public Future<Object> readHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(23).append("select highest seqNr [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectHighestSequenceNrSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr)), (Function1 & Serializable)row -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readHighestSequenceNr$2(row))).map((Function1 & Serializable)r -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readHighestSequenceNr$3(r)), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
            if (!JournalDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)seqNr -> JournalDao$.MODULE$.log().debug("Highest sequence nr for persistenceId [{}]: [{}]", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)seqNr)), this.ec);
        }
        return result;
    }

    public Future<BoxedUnit> deleteMessagesTo(String persistenceId, long toSequenceNr) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(persistenceId);
        int slice = this.persistenceExt().sliceForPersistenceId(persistenceId);
        Future deleteMarkerSeqNrFut = toSequenceNr == Long.MAX_VALUE ? this.readHighestSequenceNr(persistenceId, 0L) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)toSequenceNr));
        return deleteMarkerSeqNrFut.flatMap((Function1 & Serializable)deleteMarkerSeqNr -> JournalDao.$anonfun$deleteMessagesTo$1(this, slice, entityType, persistenceId, toSequenceNr, BoxesRunTime.unboxToLong((Object)deleteMarkerSeqNr)), this.ec);
    }

    private final String timestampSubSelect$1() {
        return new StringBuilder(40).append(new StringBuilder(55).append("(SELECT db_timestamp + '1 microsecond'::interval FROM ").append(this.journalTable()).append(" ").toString()).append("WHERE persistence_id = ? AND seq_nr = ?)").toString();
    }

    private final Statement bind$1(Statement stmt, SerializedJournalRow write, boolean useTimestampFromDb$1, long previousSeqNr$1) {
        Statement statement;
        stmt.bind(0, (Object)BoxesRunTime.boxToInteger((int)write.slice())).bind(1, (Object)write.entityType()).bind(2, (Object)write.persistenceId()).bind(3, (Object)BoxesRunTime.boxToLong((long)write.seqNr())).bind(4, (Object)write.writerUuid()).bind(5, (Object)"").bind(6, (Object)BoxesRunTime.boxToInteger((int)write.serId())).bind(7, (Object)write.serManifest()).bind(8, write.payload().get());
        Statement statement2 = write.tags().isEmpty() ? stmt.bindNull(9, String[].class) : stmt.bind(9, write.tags().toArray(ClassTag$.MODULE$.apply(String.class)));
        Option<SerializedEventMetadata> option = write.metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            SerializedEventMetadata m = (SerializedEventMetadata)some.value();
            statement = stmt.bind(10, (Object)BoxesRunTime.boxToInteger((int)m.serId())).bind(11, (Object)m.serManifest()).bind(12, (Object)m.payload());
        } else if (None$.MODULE$.equals(option)) {
            statement = stmt.bindNull(10, Integer.class).bindNull(11, String.class).bindNull(12, byte[].class);
        } else {
            throw new MatchError(option);
        }
        Object object = useTimestampFromDb$1 ? (!this.journalSettings.dbTimestampMonotonicIncreasing() ? stmt.bind(13, (Object)write.persistenceId()).bind(14, (Object)BoxesRunTime.boxToLong((long)previousSeqNr$1)) : BoxedUnit.UNIT) : (this.journalSettings.dbTimestampMonotonicIncreasing() ? stmt.bind(13, (Object)write.dbTimestamp()) : stmt.bind(13, (Object)write.dbTimestamp()).bind(14, (Object)write.persistenceId()).bind(15, (Object)BoxesRunTime.boxToLong((long)previousSeqNr$1)));
        return stmt;
    }

    public static final /* synthetic */ void $anonfun$writeEvents$3(Seq events$1, Instant x$2) {
        JournalDao$.MODULE$.log().debug("Wrote [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)1), (Object)((SerializedJournalRow)events$1.head()).persistenceId());
    }

    public static final /* synthetic */ void $anonfun$writeEvents$7(Seq events$1, IndexedSeq x$3) {
        JournalDao$.MODULE$.log().debug("Wrote [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)1), (Object)((SerializedJournalRow)events$1.head()).persistenceId());
    }

    public static final /* synthetic */ long $anonfun$readHighestSequenceNr$2(Row row) {
        Long seqNr = (Long)row.get(0, Long.class);
        return seqNr == null ? 0L : seqNr;
    }

    public static final /* synthetic */ long $anonfun$readHighestSequenceNr$3(IndexedSeq r) {
        return r.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)r.head());
    }

    private static final Statement bindDeleteMarker$1(Statement stmt, int slice$1, String entityType$1, String persistenceId$2, long deleteMarkerSeqNr$1) {
        return stmt.bind(0, (Object)BoxesRunTime.boxToInteger((int)slice$1)).bind(1, (Object)entityType$1).bind(2, (Object)persistenceId$2).bind(3, (Object)BoxesRunTime.boxToLong((long)deleteMarkerSeqNr$1)).bind(4, (Object)"").bind(5, (Object)"").bind(6, (Object)BoxesRunTime.boxToInteger((int)0)).bind(7, (Object)"").bind(8, (Object)Array$.MODULE$.emptyByteArray()).bind(9, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ void $anonfun$deleteMessagesTo$3(String persistenceId$2, IndexedSeq updatedRows) {
        JournalDao$.MODULE$.log().debug("Deleted [{}] events for persistenceId [{}]", updatedRows.head(), (Object)persistenceId$2);
    }

    public static final /* synthetic */ void $anonfun$deleteMessagesTo$4(IndexedSeq x$5) {
    }

    public static final /* synthetic */ Future $anonfun$deleteMessagesTo$1(JournalDao $this, int slice$1, String entityType$1, String persistenceId$2, long toSequenceNr$1, long deleteMarkerSeqNr) {
        Future<IndexedSeq<Object>> result;
        block0: {
            result = $this.r2dbcExecutor().update(new StringBuilder(9).append("delete [").append(persistenceId$2).append("]").toString(), (Function1<Connection, IndexedSeq<Statement>>)(Function1 & Serializable)connection -> (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Statement[]{connection.createStatement($this.deleteEventsSql()).bind(0, (Object)persistenceId$2).bind(1, (Object)BoxesRunTime.boxToLong((long)toSequenceNr$1)), JournalDao.bindDeleteMarker$1(connection.createStatement($this.insertDeleteMarkerSql()), slice$1, entityType$1, persistenceId$2, deleteMarkerSeqNr)})));
            if (!JournalDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)updatedRows -> {
                JournalDao.$anonfun$deleteMessagesTo$3(persistenceId$2, updatedRows);
                return BoxedUnit.UNIT;
            }, $this.ec);
        }
        return result.map((Function1 & Serializable)x$5 -> {
            JournalDao.$anonfun$deleteMessagesTo$4(x$5);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public JournalDao(R2dbcSettings journalSettings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.journalSettings = journalSettings;
        this.ec = ec;
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, JournalDao$.MODULE$.log(), journalSettings.logDbCallsExceeding(), ec, system);
        this.journalTable = journalSettings.journalTableWithSchema();
        String baseSql = new StringBuilder(233).append(new StringBuilder(13).append("INSERT INTO ").append(this.journalTable()).append(" ").toString()).append("(slice, entity_type, persistence_id, seq_nr, writer, adapter_manifest, event_ser_id, event_ser_manifest, event_payload, tags, meta_ser_id, meta_ser_manifest, meta_payload, db_timestamp) ").append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").toString();
        String insertEventWithParameterTimestampSql = journalSettings.dbTimestampMonotonicIncreasing() ? Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ?) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql})) : Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " GREATEST(?, ", ")) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql, this.timestampSubSelect$1()}));
        String insertEventWithTransactionTimestampSql = journalSettings.dbTimestampMonotonicIncreasing() ? Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " transaction_timestamp()) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql})) : Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " GREATEST(transaction_timestamp(), ", ")) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql, this.timestampSubSelect$1()}));
        Tuple2 tuple2 = new Tuple2((Object)insertEventWithParameterTimestampSql, (Object)insertEventWithTransactionTimestampSql);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String insertEventWithParameterTimestampSql2 = (String)tuple2._1();
        String insertEventWithTransactionTimestampSql2 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)insertEventWithParameterTimestampSql2, (Object)insertEventWithTransactionTimestampSql2);
        this.x$1 = tuple22;
        this.insertEventWithParameterTimestampSql = (String)this.x$1._1();
        this.insertEventWithTransactionTimestampSql = (String)this.x$1._2();
        this.selectHighestSequenceNrSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT MAX(seq_nr) from ", "\n    WHERE persistence_id = ? AND seq_nr >= ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.deleteEventsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    DELETE FROM ", "\n    WHERE persistence_id = ? AND seq_nr <= ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.insertDeleteMarkerSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    INSERT INTO ", "\n    (slice, entity_type, persistence_id, seq_nr, db_timestamp, writer, adapter_manifest, event_ser_id, event_ser_manifest, event_payload, deleted)\n    VALUES (?, ?, ?, ?, transaction_timestamp(), ?, ?, ?, ?, ?, ?)"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
    }

    public static final class SerializedEventMetadata
    implements Product,
    Serializable {
        private final int serId;
        private final String serManifest;
        private final byte[] payload;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int serId() {
            return this.serId;
        }

        public String serManifest() {
            return this.serManifest;
        }

        public byte[] payload() {
            return this.payload;
        }

        public SerializedEventMetadata copy(int serId, String serManifest, byte[] payload) {
            return new SerializedEventMetadata(serId, serManifest, payload);
        }

        public int copy$default$1() {
            return this.serId();
        }

        public String copy$default$2() {
            return this.serManifest();
        }

        public byte[] copy$default$3() {
            return this.payload();
        }

        public String productPrefix() {
            return "SerializedEventMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.serId());
                    break;
                }
                case 1: {
                    object = this.serManifest();
                    break;
                }
                case 2: {
                    object = this.payload();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedEventMetadata;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "serId";
                    break;
                }
                case 1: {
                    string = "serManifest";
                    break;
                }
                case 2: {
                    string = "payload";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.serId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedEventMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedEventMetadata serializedEventMetadata = (SerializedEventMetadata)x$1;
            if (this.serId() != serializedEventMetadata.serId()) return false;
            String string = this.serManifest();
            String string2 = serializedEventMetadata.serManifest();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.payload() != serializedEventMetadata.payload()) return false;
            return true;
        }

        public SerializedEventMetadata(int serId, String serManifest, byte[] payload) {
            this.serId = serId;
            this.serManifest = serManifest;
            this.payload = payload;
            Product.$init$((Product)this);
        }
    }

    public static final class SerializedJournalRow
    implements BySliceQuery.SerializedRow,
    Product,
    Serializable {
        private final int slice;
        private final String entityType;
        private final String persistenceId;
        private final long seqNr;
        private final Instant dbTimestamp;
        private final Instant readDbTimestamp;
        private final Option<byte[]> payload;
        private final int serId;
        private final String serManifest;
        private final String writerUuid;
        private final Set<String> tags;
        private final Option<SerializedEventMetadata> metadata;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int slice() {
            return this.slice;
        }

        public String entityType() {
            return this.entityType;
        }

        @Override
        public String persistenceId() {
            return this.persistenceId;
        }

        @Override
        public long seqNr() {
            return this.seqNr;
        }

        @Override
        public Instant dbTimestamp() {
            return this.dbTimestamp;
        }

        @Override
        public Instant readDbTimestamp() {
            return this.readDbTimestamp;
        }

        public Option<byte[]> payload() {
            return this.payload;
        }

        public int serId() {
            return this.serId;
        }

        public String serManifest() {
            return this.serManifest;
        }

        public String writerUuid() {
            return this.writerUuid;
        }

        public Set<String> tags() {
            return this.tags;
        }

        public Option<SerializedEventMetadata> metadata() {
            return this.metadata;
        }

        public SerializedJournalRow copy(int slice, String entityType, String persistenceId, long seqNr, Instant dbTimestamp, Instant readDbTimestamp, Option<byte[]> payload, int serId, String serManifest, String writerUuid, Set<String> tags, Option<SerializedEventMetadata> metadata) {
            return new SerializedJournalRow(slice, entityType, persistenceId, seqNr, dbTimestamp, readDbTimestamp, payload, serId, serManifest, writerUuid, tags, metadata);
        }

        public int copy$default$1() {
            return this.slice();
        }

        public String copy$default$10() {
            return this.writerUuid();
        }

        public Set<String> copy$default$11() {
            return this.tags();
        }

        public Option<SerializedEventMetadata> copy$default$12() {
            return this.metadata();
        }

        public String copy$default$2() {
            return this.entityType();
        }

        public String copy$default$3() {
            return this.persistenceId();
        }

        public long copy$default$4() {
            return this.seqNr();
        }

        public Instant copy$default$5() {
            return this.dbTimestamp();
        }

        public Instant copy$default$6() {
            return this.readDbTimestamp();
        }

        public Option<byte[]> copy$default$7() {
            return this.payload();
        }

        public int copy$default$8() {
            return this.serId();
        }

        public String copy$default$9() {
            return this.serManifest();
        }

        public String productPrefix() {
            return "SerializedJournalRow";
        }

        public int productArity() {
            return 12;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.slice());
                    break;
                }
                case 1: {
                    object = this.entityType();
                    break;
                }
                case 2: {
                    object = this.persistenceId();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.seqNr());
                    break;
                }
                case 4: {
                    object = this.dbTimestamp();
                    break;
                }
                case 5: {
                    object = this.readDbTimestamp();
                    break;
                }
                case 6: {
                    object = this.payload();
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToInteger((int)this.serId());
                    break;
                }
                case 8: {
                    object = this.serManifest();
                    break;
                }
                case 9: {
                    object = this.writerUuid();
                    break;
                }
                case 10: {
                    object = this.tags();
                    break;
                }
                case 11: {
                    object = this.metadata();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedJournalRow;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "slice";
                    break;
                }
                case 1: {
                    string = "entityType";
                    break;
                }
                case 2: {
                    string = "persistenceId";
                    break;
                }
                case 3: {
                    string = "seqNr";
                    break;
                }
                case 4: {
                    string = "dbTimestamp";
                    break;
                }
                case 5: {
                    string = "readDbTimestamp";
                    break;
                }
                case 6: {
                    string = "payload";
                    break;
                }
                case 7: {
                    string = "serId";
                    break;
                }
                case 8: {
                    string = "serManifest";
                    break;
                }
                case 9: {
                    string = "writerUuid";
                    break;
                }
                case 10: {
                    string = "tags";
                    break;
                }
                case 11: {
                    string = "metadata";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.slice());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.entityType()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNr()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.readDbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.payload()));
            n = Statics.mix((int)n, (int)this.serId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.writerUuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tags()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedJournalRow)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedJournalRow serializedJournalRow = (SerializedJournalRow)x$1;
            if (this.slice() != serializedJournalRow.slice()) return false;
            if (this.seqNr() != serializedJournalRow.seqNr()) return false;
            if (this.serId() != serializedJournalRow.serId()) return false;
            String string = this.entityType();
            String string2 = serializedJournalRow.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.persistenceId();
            String string4 = serializedJournalRow.persistenceId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Instant instant = this.dbTimestamp();
            Instant instant2 = serializedJournalRow.dbTimestamp();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Instant instant3 = this.readDbTimestamp();
            Instant instant4 = serializedJournalRow.readDbTimestamp();
            if (instant3 == null) {
                if (instant4 != null) {
                    return false;
                }
            } else if (!((Object)instant3).equals(instant4)) return false;
            Option<byte[]> option = this.payload();
            Option<byte[]> option2 = serializedJournalRow.payload();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string5 = this.serManifest();
            String string6 = serializedJournalRow.serManifest();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.writerUuid();
            String string8 = serializedJournalRow.writerUuid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            Set<String> set = this.tags();
            Set<String> set2 = serializedJournalRow.tags();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Option<SerializedEventMetadata> option3 = this.metadata();
            Option<SerializedEventMetadata> option4 = serializedJournalRow.metadata();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public SerializedJournalRow(int slice, String entityType, String persistenceId, long seqNr, Instant dbTimestamp, Instant readDbTimestamp, Option<byte[]> payload, int serId, String serManifest, String writerUuid, Set<String> tags, Option<SerializedEventMetadata> metadata) {
            this.slice = slice;
            this.entityType = entityType;
            this.persistenceId = persistenceId;
            this.seqNr = seqNr;
            this.dbTimestamp = dbTimestamp;
            this.readDbTimestamp = readDbTimestamp;
            this.payload = payload;
            this.serId = serId;
            this.serManifest = serManifest;
            this.writerUuid = writerUuid;
            this.tags = tags;
            this.metadata = metadata;
            Product.$init$((Product)this);
        }
    }
}

