/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.query.scaladsl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.pubsub.Topic;
import akka.actor.typed.scaladsl.adapter.package;
import akka.annotation.InternalApi;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.query.EventEnvelope$;
import akka.persistence.query.Offset;
import akka.persistence.query.TimestampOffset;
import akka.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.PagedPersistenceIdsQuery;
import akka.persistence.query.typed.EventEnvelope;
import akka.persistence.query.typed.scaladsl.CurrentEventsBySliceQuery;
import akka.persistence.query.typed.scaladsl.EventTimestampQuery;
import akka.persistence.query.typed.scaladsl.EventsBySliceQuery;
import akka.persistence.query.typed.scaladsl.LoadEventQuery;
import akka.persistence.r2dbc.ConnectionFactoryProvider;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.R2dbcSettings$;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.ContinuousQuery$;
import akka.persistence.r2dbc.internal.PubSub;
import akka.persistence.r2dbc.internal.PubSub$;
import akka.persistence.r2dbc.journal.JournalDao;
import akka.persistence.r2dbc.query.scaladsl.QueryDao;
import akka.persistence.r2dbc.query.scaladsl.R2dbcReadJournal$;
import akka.persistence.typed.PersistenceId$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.stream.Graph;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.config.Config;
import io.r2dbc.spi.ConnectionFactory;
import java.io.Serializable;
import java.time.Instant;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011mw!\u00024h\u0011\u0003\u0011h!\u0002;h\u0011\u0003)\b\"\u0002?\u0002\t\u0003i\bb\u0002@\u0002\u0005\u0004%\ta \u0005\t\u0003#\t\u0001\u0015!\u0003\u0002\u0002\u00191\u00111C\u0001G\u0003+A!\"!\u000e\u0006\u0005+\u0007I\u0011AA\u001c\u0011)\ty$\u0002B\tB\u0003%\u0011\u0011\b\u0005\u000b\u0003\u0003*!Q3A\u0005\u0002\u0005]\u0002BCA\"\u000b\tE\t\u0015!\u0003\u0002:!Q\u0011QI\u0003\u0003\u0016\u0004%\t!a\u0012\t\u0015\u0005=SA!E!\u0002\u0013\tI\u0005\u0003\u0004}\u000b\u0011\u0005\u0011\u0011\u000b\u0005\n\u0003;*\u0011\u0011!C\u0001\u0003?B\u0011\"a\u001a\u0006#\u0003%\t!!\u001b\t\u0013\u0005}T!%A\u0005\u0002\u0005%\u0004\"CAA\u000bE\u0005I\u0011AAB\u0011!\t9)BA\u0001\n\u0003z\b\"CAE\u000b\u0005\u0005I\u0011AA\u001c\u0011%\tY)BA\u0001\n\u0003\ti\tC\u0005\u0002\u001a\u0016\t\t\u0011\"\u0011\u0002\u001c\"I\u0011\u0011V\u0003\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003k+\u0011\u0011!C!\u0003oC\u0011\"a/\u0006\u0003\u0003%\t%!0\t\u0013\u0005}V!!A\u0005B\u0005\u0005\u0007\"CAb\u000b\u0005\u0005I\u0011IAc\u000f%\tI-AA\u0001\u0012\u0013\tYMB\u0005\u0002\u0014\u0005\t\t\u0011#\u0003\u0002N\"1Ap\u0007C\u0001\u0003KD\u0011\"a0\u001c\u0003\u0003%)%!1\t\u0013\u0005\u001d8$!A\u0005\u0002\u0006%\b\"CAy7\u0005\u0005I\u0011QAz\u0011%\u0011)aGA\u0001\n\u0013\u00119A\u0002\u0004\u0003\u0010\u00051%\u0011\u0003\u0005\u000b\u0003k\t#Q3A\u0005\u0002\u0005]\u0002BCA C\tE\t\u0015!\u0003\u0002:!Q\u0011\u0011I\u0011\u0003\u0016\u0004%\t!a\u000e\t\u0015\u0005\r\u0013E!E!\u0002\u0013\tI\u0004\u0003\u0006\u0003\u0014\u0005\u0012)\u001a!C\u0001\u0005+A!B!\n\"\u0005#\u0005\u000b\u0011\u0002B\f\u0011\u0019a\u0018\u0005\"\u0001\u0003(!I\u0011QL\u0011\u0002\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0003O\n\u0013\u0013!C\u0001\u0003SB\u0011\"a \"#\u0003%\t!!\u001b\t\u0013\u0005\u0005\u0015%%A\u0005\u0002\te\u0002\u0002CADC\u0005\u0005I\u0011I@\t\u0013\u0005%\u0015%!A\u0005\u0002\u0005]\u0002\"CAFC\u0005\u0005I\u0011\u0001B\u001f\u0011%\tI*IA\u0001\n\u0003\nY\nC\u0005\u0002*\u0006\n\t\u0011\"\u0001\u0003B!I\u0011QW\u0011\u0002\u0002\u0013\u0005#Q\t\u0005\n\u0003w\u000b\u0013\u0011!C!\u0003{C\u0011\"a0\"\u0003\u0003%\t%!1\t\u0013\u0005\r\u0017%!A\u0005B\t%s!\u0003B'\u0003\u0005\u0005\t\u0012\u0002B(\r%\u0011y!AA\u0001\u0012\u0013\u0011\t\u0006\u0003\u0004}o\u0011\u0005!Q\u000b\u0005\n\u0003\u007f;\u0014\u0011!C#\u0003\u0003D\u0011\"a:8\u0003\u0003%\tIa\u0016\t\u0013\u0005Ex'!A\u0005\u0002\n}\u0003\"\u0003B\u0003o\u0005\u0005I\u0011\u0002B\u0004\r\u0015!xM\u0001B4\u0011)\u0011i+\u0010B\u0001B\u0003%!q\u0016\u0005\u000b\u0005wk$\u0011!Q\u0001\n\tu\u0006B\u0003Bh{\t\u0005\t\u0015!\u0003\u0003\u0018!1A0\u0010C\u0001\u0005#D\u0011Ba7>\u0005\u0004%IA!8\t\u0011\t=X\b)A\u0005\u0005?D\u0001B!=>\u0005\u0004%Ia \u0005\t\u0005gl\u0004\u0015!\u0003\u0002\u0002!I!Q_\u001fC\u0002\u0013%!q\u001f\u0005\t\u0007\u0003i\u0004\u0015!\u0003\u0003z\"I11A\u001fC\u0002\u0013%1Q\u0001\u0005\t\u0007/i\u0004\u0015!\u0003\u0004\b!I1\u0011D\u001fC\u0002\u0013%11\u0004\u0005\t\u0007Oi\u0004\u0015!\u0003\u0004\u001e!I1\u0011F\u001fC\u0002\u0013%11\u0006\u0005\t\u0007ki\u0004\u0015!\u0003\u0004.!I1qG\u001fC\u0002\u0013%1\u0011\b\u0005\t\u0007\u0017j\u0004\u0015!\u0003\u0004<!I1QJ\u001fC\u0002\u0013%1q\n\u0005\t\u0007/j\u0004\u0015!\u0003\u0004R!I1\u0011L\u001fC\u0002\u0013%11\f\u0005\t\u0007'k\u0004\u0015!\u0003\u0004^!91QS\u001f\u0005\n\r]\u0005\"CBU{\t\u0007I\u0011BBV\u0011!\u0019),\u0010Q\u0001\n\r5\u0006bBB\\{\u0011\u00051\u0011\u0018\u0005\b\u0007\u007fkD\u0011IBa\u0011\u001d\u0019)-\u0010C!\u0007\u000fDqaa8>\t\u0003\u001a\t\u000fC\u0004\u0005\u001au\"\t\u0005b\u0007\t\u0011\u0011=R\b\"\u0001p\tcAq\u0001\"\u0015>\t\u0003\"\u0019\u0006\u0003\u0005\u0005fu\"\ta\u001bC4\u0011\u001d!\u0019(\u0010C!\tkBq\u0001b&>\t\u0003\"I\nC\u0004\u0005*v\"\t\u0005b+\t\u000f\u0011MV\b\"\u0003\u00056\"9A1Y\u001f\u0005\n\u0011\u0015\u0007b\u0002Ce{\u0011\u0005C1\u001a\u0005\b\t\u0013lD\u0011\tCm\u0003A\u0011&\u0007\u001a2d%\u0016\fGMS8ve:\fGN\u0003\u0002iS\u0006A1oY1mC\u0012\u001cHN\u0003\u0002kW\u0006)\u0011/^3ss*\u0011A.\\\u0001\u0006eJ\"'m\u0019\u0006\u0003]>\f1\u0002]3sg&\u001cH/\u001a8dK*\t\u0001/\u0001\u0003bW.\f7\u0001\u0001\t\u0003g\u0006i\u0011a\u001a\u0002\u0011%J\"'m\u0019*fC\u0012Tu.\u001e:oC2\u001c\"!\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!/\u0001\u0006JI\u0016tG/\u001b4jKJ,\"!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!A.\u00198h\u0015\t\tY!\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003\u000b\u0011aa\u0015;sS:<\u0017aC%eK:$\u0018NZ5fe\u0002\u0012ACQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ*uCR,7CB\u0003w\u0003/\ti\u0002E\u0002x\u00033I1!a\u0007y\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\b\u000209!\u0011\u0011EA\u0016\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014c\u00061AH]8pizJ\u0011!_\u0005\u0004\u0003[A\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003c\t\u0019D\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002.a\f!\"];fef\u001cu.\u001e8u+\t\tI\u0004E\u0002x\u0003wI1!!\u0010y\u0005\rIe\u000e^\u0001\fcV,'/_\"pk:$\b%\u0001\u0005s_^\u001cu.\u001e8u\u0003%\u0011xn^\"pk:$\b%A\u0006mCR,7\u000f^*fc:\u0013XCAA%!\r9\u00181J\u0005\u0004\u0003\u001bB(\u0001\u0002'p]\u001e\fA\u0002\\1uKN$8+Z9Oe\u0002\"\u0002\"a\u0015\u0002X\u0005e\u00131\f\t\u0004\u0003+*Q\"A\u0001\t\u000f\u0005UB\u00021\u0001\u0002:!9\u0011\u0011\t\u0007A\u0002\u0005e\u0002bBA#\u0019\u0001\u0007\u0011\u0011J\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002T\u0005\u0005\u00141MA3\u0011%\t)$\u0004I\u0001\u0002\u0004\tI\u0004C\u0005\u0002B5\u0001\n\u00111\u0001\u0002:!I\u0011QI\u0007\u0011\u0002\u0003\u0007\u0011\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYG\u000b\u0003\u0002:\u000554FAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u00040\u0001\u0006b]:|G/\u0019;j_:LA!! \u0002t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAACU\u0011\tI%!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a$\u0002\u0016B\u0019q/!%\n\u0007\u0005M\u0005PA\u0002B]fD\u0011\"a&\u0014\u0003\u0003\u0005\r!!\u000f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\n\u0005\u0004\u0002 \u0006\u0015\u0016qR\u0007\u0003\u0003CS1!a)y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\u000b\tK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAW\u0003g\u00032a^AX\u0013\r\t\t\f\u001f\u0002\b\u0005>|G.Z1o\u0011%\t9*FA\u0001\u0002\u0004\ty)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0001\u0003sC\u0011\"a&\u0017\u0003\u0003\u0005\r!!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0001\u0002\r\u0015\fX/\u00197t)\u0011\ti+a2\t\u0013\u0005]\u0015$!AA\u0002\u0005=\u0015\u0001\u0006\"z!\u0016\u00148/[:uK:\u001cW-\u00133Ti\u0006$X\rE\u0002\u0002Vm\u0019RaGAh\u00037\u0004B\"!5\u0002X\u0006e\u0012\u0011HA%\u0003'j!!a5\u000b\u0007\u0005U\u00070A\u0004sk:$\u0018.\\3\n\t\u0005e\u00171\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BAo\u0003Gl!!a8\u000b\t\u0005\u0005\u0018\u0011B\u0001\u0003S>LA!!\r\u0002`R\u0011\u00111Z\u0001\u0006CB\u0004H.\u001f\u000b\t\u0003'\nY/!<\u0002p\"9\u0011Q\u0007\u0010A\u0002\u0005e\u0002bBA!=\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u000br\u0002\u0019AA%\u0003\u001d)h.\u00199qYf$B!!>\u0003\u0002A)q/a>\u0002|&\u0019\u0011\u0011 =\u0003\r=\u0003H/[8o!%9\u0018Q`A\u001d\u0003s\tI%C\u0002\u0002\u0000b\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u0002?\u0005\u0005\t\u0019AA*\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0013\u0001B!a\u0001\u0003\f%!!QBA\u0003\u0005\u0019y%M[3di\nA\u0002+\u001a:tSN$XM\\2f\u0013\u0012\u001c\u0018+^3ssN#\u0018\r^3\u0014\r\u00052\u0018qCA\u000f\u0003%a\u0017\r^3tiBKG-\u0006\u0002\u0003\u0018A!!\u0011\u0004B\u0011\u001d\u0011\u0011YB!\b\u0011\u0007\u0005\r\u00020C\u0002\u0003 a\fa\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0005GQ1Aa\by\u0003)a\u0017\r^3tiBKG\r\t\u000b\t\u0005S\u0011YC!\f\u00030A\u0019\u0011QK\u0011\t\u000f\u0005U\u0002\u00061\u0001\u0002:!9\u0011\u0011\t\u0015A\u0002\u0005e\u0002b\u0002B\nQ\u0001\u0007!q\u0003\u000b\t\u0005S\u0011\u0019D!\u000e\u00038!I\u0011QG\u0015\u0011\u0002\u0003\u0007\u0011\u0011\b\u0005\n\u0003\u0003J\u0003\u0013!a\u0001\u0003sA\u0011Ba\u0005*!\u0003\u0005\rAa\u0006\u0016\u0005\tm\"\u0006\u0002B\f\u0003[\"B!a$\u0003@!I\u0011qS\u0018\u0002\u0002\u0003\u0007\u0011\u0011\b\u000b\u0005\u0003[\u0013\u0019\u0005C\u0005\u0002\u0018F\n\t\u00111\u0001\u0002\u0010R!\u0011\u0011\u0001B$\u0011%\t9JMA\u0001\u0002\u0004\tI\u0004\u0006\u0003\u0002.\n-\u0003\"CALk\u0005\u0005\t\u0019AAH\u0003a\u0001VM]:jgR,gnY3JIN\fV/\u001a:z'R\fG/\u001a\t\u0004\u0003+:4#B\u001c\u0003T\u0005m\u0007\u0003DAi\u0003/\fI$!\u000f\u0003\u0018\t%BC\u0001B()!\u0011IC!\u0017\u0003\\\tu\u0003bBA\u001bu\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u0003R\u0004\u0019AA\u001d\u0011\u001d\u0011\u0019B\u000fa\u0001\u0005/!BA!\u0019\u0003fA)q/a>\u0003dAIq/!@\u0002:\u0005e\"q\u0003\u0005\n\u0005\u0007Y\u0014\u0011!a\u0001\u0005S\u0019B#\u0010<\u0003j\tU$1\u0011BE\u0005\u001f\u0013)Ja'\u0003\"\n\u001d\u0006\u0003\u0002B6\u0005cj!A!\u001c\u000b\u0007!\u0014yG\u0003\u0002k[&!!1\u000fB7\u0005-\u0011V-\u00193K_V\u0014h.\u00197\u0011\t\t]$qP\u0007\u0003\u0005sR1\u0001\u001bB>\u0015\u0011\u0011iHa\u001c\u0002\u000bQL\b/\u001a3\n\t\t\u0005%\u0011\u0010\u0002\u001a\u0007V\u0014(/\u001a8u\u000bZ,g\u000e^:CsNc\u0017nY3Rk\u0016\u0014\u0018\u0010\u0005\u0003\u0003x\t\u0015\u0015\u0002\u0002BD\u0005s\u0012!#\u0012<f]R\u001c()_*mS\u000e,\u0017+^3ssB!!q\u000fBF\u0013\u0011\u0011iI!\u001f\u0003'\u00153XM\u001c;US6,7\u000f^1naF+XM]=\u0011\t\t]$\u0011S\u0005\u0005\u0005'\u0013IH\u0001\bM_\u0006$WI^3oiF+XM]=\u0011\t\t-$qS\u0005\u0005\u00053\u0013iGA\u0011DkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z!\u0016\u00148/[:uK:\u001cW-\u00133Rk\u0016\u0014\u0018\u0010\u0005\u0003\u0003l\tu\u0015\u0002\u0002BP\u0005[\u0012!$\u0012<f]R\u001c()\u001f)feNL7\u000f^3oG\u0016LE-U;fef\u0004BAa\u001b\u0003$&!!Q\u0015B7\u0005i\u0019UO\u001d:f]R\u0004VM]:jgR,gnY3JIN\fV/\u001a:z!\u0011\u0011YG!+\n\t\t-&Q\u000e\u0002\u0019!\u0006<W\r\u001a)feNL7\u000f^3oG\u0016LEm])vKJL\u0018AB:zgR,W\u000e\u0005\u0003\u00032\n]VB\u0001BZ\u0015\r\u0011)l\\\u0001\u0006C\u000e$xN]\u0005\u0005\u0005s\u0013\u0019LA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005\u007f\u0013Y-\u0004\u0002\u0003B*!!1\u0018Bb\u0015\u0011\u0011)Ma2\u0002\u0011QL\b/Z:bM\u0016T!A!3\u0002\u0007\r|W.\u0003\u0003\u0003N\n\u0005'AB\"p]\u001aLw-A\u0004dM\u001e\u0004\u0016\r\u001e5\u0015\u0011\tM'Q\u001bBl\u00053\u0004\"a]\u001f\t\u000f\t5\u0016\t1\u0001\u00030\"9!1X!A\u0002\tu\u0006b\u0002Bh\u0003\u0002\u0007!qC\u0001\u0004Y><WC\u0001Bp!\u0011\u0011\tOa;\u000e\u0005\t\r(\u0002\u0002Bs\u0005O\fQa\u001d7gi)T!A!;\u0002\u0007=\u0014x-\u0003\u0003\u0003n\n\r(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013\u0001E:iCJ,GmQ8oM&<\u0007+\u0019;i\u0003E\u0019\b.\u0019:fI\u000e{gNZ5h!\u0006$\b\u000eI\u0001\tg\u0016$H/\u001b8hgV\u0011!\u0011 \t\u0005\u0005w\u0014i0D\u0001l\u0013\r\u0011yp\u001b\u0002\u000e%J\"'mY*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013a\u0003;za\u0016$7+_:uK6,\"aa\u0002\u0011\r\r%1QBB\t\u001b\t\u0019YA\u0003\u0003\u0003~\tM\u0016\u0002BB\b\u0007\u0017\u00111\"Q2u_J\u001c\u0016p\u001d;f[B\u0019qoa\u0005\n\u0007\rU\u0001PA\u0004O_RD\u0017N\\4\u0002\u0019QL\b/\u001a3TsN$X-\u001c\u0011\u0002\u001bM,'/[1mSj\fG/[8o+\t\u0019i\u0002\u0005\u0003\u0004 \r\rRBAB\u0011\u0015\r\u0019Ib\\\u0005\u0005\u0007K\u0019\tCA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8!\u00039\u0001XM]:jgR,gnY3FqR,\"a!\f\u0011\t\r=2\u0011G\u0007\u0002[&\u001911G7\u0003\u0017A+'o]5ti\u0016t7-Z\u0001\u0010a\u0016\u00148/[:uK:\u001cW-\u0012=uA\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0016\u0005\rm\u0002\u0003BB\u001f\u0007\u000fj!aa\u0010\u000b\t\r\u000531I\u0001\u0004gBL'b\u00017\u0004F)\u0011\u0011\u0011]\u0005\u0005\u0007\u0013\u001ayDA\tD_:tWm\u0019;j_:4\u0015m\u0019;pef\f!cY8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:zA\u0005A\u0011/^3ss\u0012\u000bw.\u0006\u0002\u0004RA\u00191oa\u0015\n\u0007\rUsM\u0001\u0005Rk\u0016\u0014\u0018\u0010R1p\u0003%\tX/\u001a:z\t\u0006|\u0007%\u0001\u0005`Ef\u001cF.[2f+\t\u0019i\u0006\u0005\u0005\u0004`\r\u00154\u0011NBF\u001b\t\u0019\tGC\u0002\u0004d-\f\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0007O\u001a\tG\u0001\u0007CsNc\u0017nY3Rk\u0016\u0014\u0018\u0010\u0005\u0003\u0004l\r\u0015e\u0002BB7\u0007\u007frAaa\u001c\u0004|9!1\u0011OB=\u001d\u0011\u0019\u0019ha\u001e\u000f\t\u0005\r2QO\u0005\u0002a&\u0011an\\\u0005\u0003Y6L1a! l\u0003\u001dQw.\u001e:oC2LAa!!\u0004\u0004\u0006Q!j\\;s]\u0006dG)Y8\u000b\u0007\ru4.\u0003\u0003\u0004\b\u000e%%\u0001F*fe&\fG.\u001b>fI*{WO\u001d8bYJ{wO\u0003\u0003\u0004\u0002\u000e\r\u0005CBBG\u0007\u001f\u000by)\u0004\u0002\u0003|%!1\u0011\u0013B>\u00055)e/\u001a8u\u000b:4X\r\\8qK\u0006IqLY=TY&\u001cW\rI\u0001\bEf\u001cF.[2f+\u0011\u0019Ija)\u0016\u0005\rm\u0005\u0003CB0\u0007K\u001aIg!(\u0011\r\r55qRBP!\u0011\u0019\tka)\r\u0001\u001191Q\u0015+C\u0002\r\u001d&!B#wK:$\u0018\u0003BB\t\u0003\u001f\u000b!B[8ve:\fG\u000eR1p+\t\u0019i\u000b\u0005\u0003\u00040\u000eEVBABB\u0013\u0011\u0019\u0019la!\u0003\u0015){WO\u001d8bY\u0012\u000bw.A\u0006k_V\u0014h.\u00197EC>\u0004\u0013AI3yiJ\f7\r^#oi&$\u0018\u0010V=qK\u001a\u0013x.\u001c)feNL7\u000f^3oG\u0016LE\r\u0006\u0003\u0003\u0018\rm\u0006bBB_/\u0002\u0007!qC\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\u0002+Md\u0017nY3G_J\u0004VM]:jgR,gnY3JIR!\u0011\u0011HBb\u0011\u001d\u0019i\f\u0017a\u0001\u0005/\t1b\u001d7jG\u0016\u0014\u0016M\\4fgR!1\u0011ZBn!\u0019\u0019Ym!5\u0004V6\u00111Q\u001a\u0006\u0005\u0007\u001f\f\t+A\u0005j[6,H/\u00192mK&!11[Bg\u0005\r\u0019V-\u001d\t\u0005\u0003?\u00199.\u0003\u0003\u0004Z\u0006M\"!\u0002*b]\u001e,\u0007bBBo3\u0002\u0007\u0011\u0011H\u0001\u000f]Vl'-\u001a:PMJ\u000bgnZ3t\u0003U\u0019WO\u001d:f]R,e/\u001a8ug\nK8\u000b\\5dKN,Baa9\u0004xRQ1Q\u001dC\u0001\t\u000b!I\u0001\"\u0004\u0011\u0011\r\u001d8q^Bz\u0007sl!a!;\u000b\u0007!\u001cYOC\u0002\u0004n>\faa\u001d;sK\u0006l\u0017\u0002BBy\u0007S\u0014aaU8ve\u000e,\u0007CBBG\u0007\u001f\u001b)\u0010\u0005\u0003\u0004\"\u000e]HaBBS5\n\u00071q\u0015\t\u0005\u0007w\u001ci0D\u0001p\u0013\r\u0019yp\u001c\u0002\b\u001d>$Xk]3e\u0011\u001d!\u0019A\u0017a\u0001\u0005/\t!\"\u001a8uSRLH+\u001f9f\u0011\u001d!9A\u0017a\u0001\u0003s\t\u0001\"\\5o'2L7-\u001a\u0005\b\t\u0017Q\u0006\u0019AA\u001d\u0003!i\u0017\r_*mS\u000e,\u0007b\u0002C\b5\u0002\u0007A\u0011C\u0001\u0007_\u001a47/\u001a;\u0011\t\u0011MAQC\u0007\u0003\u0005_JA\u0001b\u0006\u0003p\t1qJ\u001a4tKR\fa\"\u001a<f]R\u001c()_*mS\u000e,7/\u0006\u0003\u0005\u001e\u0011\u0015BC\u0003C\u0010\tO!I\u0003b\u000b\u0005.AA1q]Bx\tC\u0019I\u0010\u0005\u0004\u0004\u000e\u000e=E1\u0005\t\u0005\u0007C#)\u0003B\u0004\u0004&n\u0013\raa*\t\u000f\u0011\r1\f1\u0001\u0003\u0018!9AqA.A\u0002\u0005e\u0002b\u0002C\u00067\u0002\u0007\u0011\u0011\b\u0005\b\t\u001fY\u0006\u0019\u0001C\t\u0003-!W\rZ;qY&\u001c\u0017\r^3\u0016\t\u0011MBq\b\u000b\u0005\tk!\t\u0005\u0005\u0006\u0004h\u0012]B1\bC\u001e\u0007sLA\u0001\"\u000f\u0004j\n!a\t\\8x!\u0019\u0019iia$\u0005>A!1\u0011\u0015C \t\u001d\u0019)\u000b\u0018b\u0001\u0007OCq\u0001b\u0011]\u0001\u0004\tI$\u0001\u0005dCB\f7-\u001b;zQ\raFq\t\t\u0005\t\u0013\"i%\u0004\u0002\u0005L)\u0019\u0011\u0011P8\n\t\u0011=C1\n\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0001\u000fdkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z!\u0016\u00148/[:uK:\u001cW-\u00133\u0015\u0011\u0011UC1\fC/\tC\u0002\u0002ba:\u0004p\u0012]3\u0011 \t\u0005\t'!I&\u0003\u0003\u0004\u0012\n=\u0004bBB_;\u0002\u0007!q\u0003\u0005\b\t?j\u0006\u0019AA%\u000391'o\\7TKF,XM\\2f\u001dJDq\u0001b\u0019^\u0001\u0004\tI%\u0001\u0007u_N+\u0017/^3oG\u0016t%/A\u000fj]R,'O\\1m\u000bZ,g\u000e^:CsB+'o]5ti\u0016t7-Z%e)!!I\u0007b\u001b\u0005n\u0011=\u0004\u0003CBt\u0007_\u001cIg!?\t\u000f\ruf\f1\u0001\u0003\u0018!9Aq\f0A\u0002\u0005%\u0003b\u0002C2=\u0002\u0007\u0011\u0011\n\u0015\u0004=\u0012\u001d\u0013a\u0003;j[\u0016\u001cH/Y7q\u001f\u001a$b\u0001b\u001e\u0005\u0012\u0012M\u0005C\u0002C=\t\u007f\"\u0019)\u0004\u0002\u0005|)\u0019AQ\u0010=\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0005\u0002\u0012m$A\u0002$viV\u0014X\rE\u0003x\u0003o$)\t\u0005\u0003\u0005\b\u00125UB\u0001CE\u0015\u0011!Y)!\u0003\u0002\tQLW.Z\u0005\u0005\t\u001f#IIA\u0004J]N$\u0018M\u001c;\t\u000f\ruv\f1\u0001\u0003\u0018!9AQS0A\u0002\u0005%\u0013AC:fcV,gnY3Oe\u0006aAn\\1e\u000b:4X\r\\8qKV!A1\u0014CR)\u0019!i\n\"*\u0005(B1A\u0011\u0010C@\t?\u0003ba!$\u0004\u0010\u0012\u0005\u0006\u0003BBQ\tG#qa!*a\u0005\u0004\u00199\u000bC\u0004\u0004>\u0002\u0004\rAa\u0006\t\u000f\u0011U\u0005\r1\u0001\u0002J\u0005)RM^3oiN\u0014\u0015\u0010U3sg&\u001cH/\u001a8dK&#G\u0003\u0003C+\t[#y\u000b\"-\t\u000f\ru\u0016\r1\u0001\u0003\u0018!9AqL1A\u0002\u0005%\u0003b\u0002C2C\u0002\u0007\u0011\u0011J\u0001\u0016I\u0016\u001cXM]5bY&TXMQ=TY&\u001cWMU8x+\u0011!9\f\"0\u0015\t\u0011eFq\u0018\t\u0007\u0007\u001b\u001by\tb/\u0011\t\r\u0005FQ\u0018\u0003\b\u0007K\u0013'\u0019ABT\u0011\u001d!\tM\u0019a\u0001\u0007S\n1A]8x\u00039!Wm]3sS\u0006d\u0017N_3S_^$B\u0001b\u0016\u0005H\"9A\u0011Y2A\u0002\r%\u0014!F2veJ,g\u000e\u001e)feNL7\u000f^3oG\u0016LEm\u001d\u000b\u0007\t\u001b$y\r\"6\u0011\u0011\r\u001d8q\u001eB\f\u0007sDq\u0001\"5e\u0001\u0004!\u0019.A\u0004bMR,'/\u00133\u0011\u000b]\f9Pa\u0006\t\u000f\u0011]G\r1\u0001\u0002J\u0005)A.[7jiR\u0011AQ\u001a")
public final class R2dbcReadJournal
implements CurrentEventsBySliceQuery,
EventsBySliceQuery,
EventTimestampQuery,
LoadEventQuery,
CurrentEventsByPersistenceIdQuery,
EventsByPersistenceIdQuery,
CurrentPersistenceIdsQuery,
PagedPersistenceIdsQuery {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String sharedConfigPath;
    private final R2dbcSettings settings;
    private final akka.actor.typed.ActorSystem<Nothing$> typedSystem;
    private final Serialization serialization;
    private final Persistence persistenceExt;
    private final ConnectionFactory connectionFactory;
    private final QueryDao queryDao;
    private final BySliceQuery<JournalDao.SerializedJournalRow, EventEnvelope<Object>> _bySlice;
    private final JournalDao journalDao;

    public static String Identifier() {
        return R2dbcReadJournal$.MODULE$.Identifier();
    }

    private Logger log() {
        return this.log;
    }

    private String sharedConfigPath() {
        return this.sharedConfigPath;
    }

    private R2dbcSettings settings() {
        return this.settings;
    }

    private akka.actor.typed.ActorSystem<Nothing$> typedSystem() {
        return this.typedSystem;
    }

    private Serialization serialization() {
        return this.serialization;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    private QueryDao queryDao() {
        return this.queryDao;
    }

    private BySliceQuery<JournalDao.SerializedJournalRow, EventEnvelope<Object>> _bySlice() {
        return this._bySlice;
    }

    private <Event> BySliceQuery<JournalDao.SerializedJournalRow, EventEnvelope<Event>> bySlice() {
        return this._bySlice();
    }

    private JournalDao journalDao() {
        return this.journalDao;
    }

    public String extractEntityTypeFromPersistenceId(String persistenceId) {
        return PersistenceId$.MODULE$.extractEntityType(persistenceId);
    }

    public int sliceForPersistenceId(String persistenceId) {
        return this.persistenceExt().sliceForPersistenceId(persistenceId);
    }

    public Seq<Range> sliceRanges(int numberOfRanges) {
        return this.persistenceExt().sliceRanges(numberOfRanges);
    }

    public <Event> Source<EventEnvelope<Event>, NotUsed> currentEventsBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        return this.bySlice().currentBySlices("currentEventsBySlices", entityType, minSlice, maxSlice, offset);
    }

    public <Event> Source<EventEnvelope<Event>, NotUsed> eventsBySlices(String entityType, int minSlice, int maxSlice, Offset offset) {
        Source source;
        Source dbSource = this.bySlice().liveBySlices("eventsBySlices", entityType, minSlice, maxSlice, offset);
        if (this.settings().journalPublishEvents()) {
            PubSub pubSub = (PubSub)PubSub$.MODULE$.apply(this.typedSystem());
            Source pubSubSource = Source$.MODULE$.actorRef(PartialFunction$.MODULE$.empty(), PartialFunction$.MODULE$.empty(), this.settings().querySettings().bufferSize(), OverflowStrategy$.MODULE$.dropNew()).mapMaterializedValue((Function1 & Serializable)ref -> {
                R2dbcReadJournal.$anonfun$eventsBySlices$1(minSlice, maxSlice, pubSub, entityType, ref);
                return BoxedUnit.UNIT;
            });
            source = ((Source)dbSource.merge((Graph)pubSubSource, dbSource.merge$default$2())).via(this.deduplicate(this.settings().querySettings().deduplicateCapacity()));
        } else {
            source = dbSource;
        }
        return source;
    }

    @InternalApi
    public <Event> Flow<EventEnvelope<Event>, EventEnvelope<Event>, NotUsed> deduplicate(int capacity) {
        Flow flow;
        if (capacity == 0) {
            flow = Flow$.MODULE$.apply();
        } else {
            int evictThreshold = (int)((double)capacity * 1.1);
            flow = (Flow)Flow$.MODULE$.apply().statefulMapConcat((Function0 & Serializable)() -> {
                ObjectRef seen = ObjectRef.create((Object)LinkedHashSet$.MODULE$.empty());
                return (Function1 & Serializable)env -> {
                    List list;
                    if (env.eventOption().isEmpty()) {
                        EventEnvelope eventEnvelope = env;
                        list = package$.MODULE$.Nil().$colon$colon((Object)eventEnvelope);
                    } else {
                        Nil$ result;
                        Nil$ nil$;
                        Tuple2 entry = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)env.persistenceId()), (Object)BoxesRunTime.boxToLong((long)env.sequenceNr()));
                        if (((LinkedHashSet)seen$1.elem).contains((Object)entry)) {
                            nil$ = package$.MODULE$.Nil();
                        } else {
                            ((LinkedHashSet)seen$1.elem).add((Object)entry);
                            EventEnvelope eventEnvelope = env;
                            nil$ = result = package$.MODULE$.Nil().$colon$colon((Object)eventEnvelope);
                        }
                        if (((LinkedHashSet)seen$1.elem).size() >= evictThreshold) {
                            seen$1.elem = (LinkedHashSet)((LinkedHashSet)seen$1.elem).drop(((LinkedHashSet)seen$1.elem).size() - capacity);
                        }
                        list = result;
                    }
                    return list;
                };
            });
        }
        return flow;
    }

    public Source<akka.persistence.query.EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        Future<Object> highestSeqNrFut = toSequenceNr == Long.MAX_VALUE ? this.journalDao().readHighestSequenceNr(persistenceId, fromSequenceNr) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)toSequenceNr));
        return ((Source)Source$.MODULE$.futureSource(highestSeqNrFut.map((Function1 & Serializable)highestSeqNr -> this.internalEventsByPersistenceId(persistenceId, fromSequenceNr, BoxesRunTime.unboxToLong((Object)highestSeqNr)), (ExecutionContext)this.typedSystem().executionContext())).map((Function1 & Serializable)row -> this.deserializeRow((JournalDao.SerializedJournalRow)row))).mapMaterializedValue((Function1 & Serializable)x$1 -> NotUsed$.MODULE$);
    }

    @InternalApi
    public Source<JournalDao.SerializedJournalRow, NotUsed> internalEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("currentEventsByPersistenceId query for persistenceId [{}], from [{}] to [{}].", new Object[]{persistenceId, BoxesRunTime.boxToLong((long)fromSequenceNr), BoxesRunTime.boxToLong((long)toSequenceNr)});
        }
        return ContinuousQuery$.MODULE$.apply(new ByPersistenceIdState(0, 0, fromSequenceNr - 1L), (Function2 & Serializable)(state, row) -> R2dbcReadJournal.updateState$1(state, row), (Function1 & Serializable)x$2 -> None$.MODULE$, (Function1 & Serializable)state -> this.nextQuery$1((ByPersistenceIdState)state, toSequenceNr, persistenceId), ContinuousQuery$.MODULE$.apply$default$5());
    }

    public Future<Option<Instant>> timestampOf(String persistenceId, long sequenceNr) {
        return this.queryDao().timestampOfEvent(persistenceId, sequenceNr);
    }

    public <Event> Future<EventEnvelope<Event>> loadEnvelope(String persistenceId, long sequenceNr) {
        return this.queryDao().loadEvent(persistenceId, sequenceNr).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new NoSuchElementException(new StringBuilder(56).append("Event with persistenceId [").append(persistenceId).append("] and sequenceNr [").append(sequenceNr).append("] not found.").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            JournalDao.SerializedJournalRow row = (JournalDao.SerializedJournalRow)some.value();
            EventEnvelope eventEnvelope = this.deserializeBySliceRow(row);
            return eventEnvelope;
        }, (ExecutionContext)this.typedSystem().executionContext());
    }

    public Source<akka.persistence.query.EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        this.log().debug("Starting eventsByPersistenceId query for persistenceId [{}], from [{}].", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr));
        return (Source)ContinuousQuery$.MODULE$.apply(new ByPersistenceIdState(0, 0, fromSequenceNr - 1L), (Function2 & Serializable)(state, row) -> R2dbcReadJournal.nextOffset$1(state, row), (Function1 & Serializable)state -> this.delayNextQuery$1((ByPersistenceIdState)state, persistenceId), (Function1 & Serializable)state -> this.nextQuery$2((ByPersistenceIdState)state, toSequenceNr, persistenceId), ContinuousQuery$.MODULE$.apply$default$5()).map((Function1 & Serializable)row -> this.deserializeRow((JournalDao.SerializedJournalRow)row));
    }

    private <Event> EventEnvelope<Event> deserializeBySliceRow(JournalDao.SerializedJournalRow row) {
        Option event = row.payload().map((Function1 & Serializable)payload -> this.serialization().deserialize(payload, row.serId(), row.serManifest()).get());
        TimestampOffset offset = new TimestampOffset(row.dbTimestamp(), row.readDbTimestamp(), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)row.persistenceId()), (Object)BoxesRunTime.boxToLong((long)row.seqNr()))})));
        Option metadata = row.metadata().map((Function1 & Serializable)meta -> this.serialization().deserialize(meta.payload(), meta.serId(), meta.serManifest()).get());
        return new EventEnvelope((Offset)offset, row.persistenceId(), row.seqNr(), event, row.dbTimestamp().toEpochMilli(), metadata, row.entityType(), row.slice());
    }

    private akka.persistence.query.EventEnvelope deserializeRow(JournalDao.SerializedJournalRow row) {
        akka.persistence.query.EventEnvelope eventEnvelope;
        Option event = row.payload().map((Function1 & Serializable)payload -> this.serialization().deserialize(payload, row.serId(), row.serManifest()).get());
        if (event.isEmpty()) {
            throw new IllegalStateException("Expected event payload to be loaded.");
        }
        TimestampOffset offset = new TimestampOffset(row.dbTimestamp(), row.readDbTimestamp(), (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)row.persistenceId()), (Object)BoxesRunTime.boxToLong((long)row.seqNr()))})));
        akka.persistence.query.EventEnvelope envelope = EventEnvelope$.MODULE$.apply((Offset)offset, row.persistenceId(), row.seqNr(), event.get(), row.dbTimestamp().toEpochMilli());
        Option<JournalDao.SerializedEventMetadata> option = row.metadata();
        if (None$.MODULE$.equals(option)) {
            eventEnvelope = envelope;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            JournalDao.SerializedEventMetadata meta = (JournalDao.SerializedEventMetadata)some.value();
            eventEnvelope = envelope.withMetadata(this.serialization().deserialize(meta.payload(), meta.serId(), meta.serManifest()).get());
        } else {
            throw new MatchError(option);
        }
        return eventEnvelope;
    }

    public Source<String, NotUsed> currentPersistenceIds(Option<String> afterId, long limit) {
        return this.queryDao().persistenceIds(afterId, limit);
    }

    public Source<String, NotUsed> currentPersistenceIds() {
        return ContinuousQuery$.MODULE$.apply(new PersistenceIdsQueryState(0, 0, ""), (Function2 & Serializable)(state, pid) -> R2dbcReadJournal.updateState$2(state, pid), (Function1 & Serializable)x$3 -> None$.MODULE$, (Function1 & Serializable)state -> this.nextQuery$3((PersistenceIdsQueryState)state), ContinuousQuery$.MODULE$.apply$default$5()).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$eventsBySlices$1(int minSlice$1, int maxSlice$1, PubSub pubSub$1, String entityType$1, ActorRef ref) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(minSlice$1), maxSlice$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)slice -> ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(pubSub$1.eventTopic(entityType$1, slice)), (Object)Topic.Subscribe$.MODULE$.apply(package.ClassicActorRefOps$.MODULE$.toTyped$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.ClassicActorRefOps(ref)))));
    }

    private static final ByPersistenceIdState updateState$1(ByPersistenceIdState state, JournalDao.SerializedJournalRow row) {
        int x$1 = state.rowCount() + 1;
        long x$2 = row.seqNr();
        int x$3 = state.copy$default$1();
        return state.copy(x$3, x$1, x$2);
    }

    private final Tuple2 nextQuery$1(ByPersistenceIdState state, long highestSeqNr, String persistenceId$2) {
        Tuple2 tuple2;
        if ((long)state.queryCount() == 0L || state.rowCount() >= this.settings().querySettings().bufferSize()) {
            boolean x$1 = false;
            int x$2 = state.queryCount() + 1;
            long x$3 = state.copy$default$3();
            ByPersistenceIdState newState = state.copy(x$2, 0, x$3);
            if (state.queryCount() != 0 && this.log().isDebugEnabled()) {
                this.log().debug("currentEventsByPersistenceId query [{}] for persistenceId [{}], from [{}] to [{}]. Found [{}] rows in previous query.", new Object[]{BoxesRunTime.boxToInteger((int)state.queryCount()), persistenceId$2, BoxesRunTime.boxToLong((long)(state.latestSeqNr() + 1L)), BoxesRunTime.boxToLong((long)highestSeqNr), BoxesRunTime.boxToInteger((int)state.rowCount())});
            }
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newState), (Object)new Some(this.queryDao().eventsByPersistenceId(persistenceId$2, state.latestSeqNr() + 1L, highestSeqNr)));
        } else {
            this.log().debug("currentEventsByPersistenceId query [{}] for persistenceId [{}] completed. Found [{}] rows in previous query.", new Object[]{BoxesRunTime.boxToInteger((int)state.queryCount()), persistenceId$2, BoxesRunTime.boxToInteger((int)state.rowCount())});
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    private static final ByPersistenceIdState nextOffset$1(ByPersistenceIdState state, JournalDao.SerializedJournalRow row) {
        int x$1 = state.rowCount() + 1;
        long x$2 = row.seqNr();
        int x$3 = state.copy$default$1();
        return state.copy(x$3, x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$eventsByPersistenceId$1(R2dbcReadJournal $this, ByPersistenceIdState state$1, String persistenceId$4, FiniteDuration d) {
        $this.log().debug("eventsByPersistenceId query [{}] for persistenceId [{}] delay next [{}] ms.", new Object[]{BoxesRunTime.boxToInteger((int)state$1.queryCount()), persistenceId$4, BoxesRunTime.boxToLong((long)d.toMillis())});
    }

    /*
     * WARNING - void declaration
     */
    private final Option delayNextQuery$1(ByPersistenceIdState state, String persistenceId$4) {
        void var3_3;
        Option<FiniteDuration> delay = ContinuousQuery$.MODULE$.adjustNextDelay(state.rowCount(), this.settings().querySettings().bufferSize(), this.settings().querySettings().refreshInterval());
        delay.foreach((Function1 & Serializable)d -> {
            R2dbcReadJournal.$anonfun$eventsByPersistenceId$1(this, state, persistenceId$4, d);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private final Tuple2 nextQuery$2(ByPersistenceIdState state, long toSequenceNr$2, String persistenceId$4) {
        Tuple2 tuple2;
        if (state.latestSeqNr() >= toSequenceNr$2) {
            this.log().debug("eventsByPersistenceId query [{}] for persistenceId [{}] completed. Found [{}] rows in previous query.", new Object[]{BoxesRunTime.boxToInteger((int)state.queryCount()), persistenceId$4, BoxesRunTime.boxToInteger((int)state.rowCount())});
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)None$.MODULE$);
        } else {
            boolean x$1 = false;
            int x$2 = state.queryCount() + 1;
            long x$3 = state.copy$default$3();
            ByPersistenceIdState newState = state.copy(x$2, 0, x$3);
            this.log().debug("eventsByPersistenceId query [{}] for persistenceId [{}], from [{}]. Found [{}] rows in previous query.", new Object[]{BoxesRunTime.boxToInteger((int)newState.queryCount()), persistenceId$4, BoxesRunTime.boxToInteger((int)state.rowCount())});
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newState), (Object)new Some(this.queryDao().eventsByPersistenceId(persistenceId$4, state.latestSeqNr() + 1L, toSequenceNr$2)));
        }
        return tuple2;
    }

    private static final PersistenceIdsQueryState updateState$2(PersistenceIdsQueryState state, String pid) {
        int x$1 = state.rowCount() + 1;
        String x$2 = pid;
        int x$3 = state.copy$default$1();
        return state.copy(x$3, x$1, x$2);
    }

    private final Tuple2 nextQuery$3(PersistenceIdsQueryState state) {
        Tuple2 tuple2;
        if ((long)state.queryCount() == 0L || state.rowCount() >= this.settings().querySettings().persistenceIdsBufferSize()) {
            boolean x$1 = false;
            int x$2 = state.queryCount() + 1;
            String x$3 = state.copy$default$3();
            PersistenceIdsQueryState newState = state.copy(x$2, 0, x$3);
            if (state.queryCount() != 0 && this.log().isDebugEnabled()) {
                this.log().debug("persistenceIds query [{}] after [{}]. Found [{}] rows in previous query.", new Object[]{BoxesRunTime.boxToInteger((int)state.queryCount()), state.latestPid(), BoxesRunTime.boxToInteger((int)state.rowCount())});
            }
            String string = state.latestPid();
            String string2 = "";
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newState), (Object)new Some(this.queryDao().persistenceIds((Option<String>)(!(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)state.latestPid())), this.settings().querySettings().persistenceIdsBufferSize())));
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("persistenceIds query [{}] completed. Found [{}] rows in previous query.", (Object)BoxesRunTime.boxToInteger((int)state.queryCount()), (Object)BoxesRunTime.boxToInteger((int)state.rowCount()));
            }
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public R2dbcReadJournal(ExtendedActorSystem system, Config config, String cfgPath) {
        this.sharedConfigPath = cfgPath.replaceAll("\\.query$", "");
        this.settings = R2dbcSettings$.MODULE$.apply(system.settings().config().getConfig(this.sharedConfigPath()));
        this.typedSystem = package.ClassicActorSystemOps$.MODULE$.toTyped$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.ClassicActorSystemOps((ActorSystem)system));
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system);
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply((ActorSystem)system);
        this.connectionFactory = ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(this.typedSystem())).connectionFactoryFor(new StringBuilder(19).append(this.sharedConfigPath()).append(".connection-factory").toString());
        this.queryDao = new QueryDao(this.settings(), this.connectionFactory(), (ExecutionContext)this.typedSystem().executionContext(), this.typedSystem());
        Function2 & Serializable createEnvelope = (Function2 & Serializable)(offset, row) -> {
            Option event = row.payload().map((Function1 & Serializable)payload -> this.serialization().deserialize(payload, row.serId(), row.serManifest()).get());
            Option metadata = row.metadata().map((Function1 & Serializable)meta -> this.serialization().deserialize(meta.payload(), meta.serId(), meta.serManifest()).get());
            return new EventEnvelope((Offset)offset, row.persistenceId(), row.seqNr(), event, row.dbTimestamp().toEpochMilli(), metadata, row.entityType(), row.slice());
        };
        Function1 & Serializable extractOffset = (Function1 & Serializable)env -> (TimestampOffset)env.offset();
        this._bySlice = new BySliceQuery(this.queryDao(), createEnvelope, extractOffset, this.settings(), this.log(), (ExecutionContext)this.typedSystem().executionContext());
        this.journalDao = new JournalDao(this.settings(), this.connectionFactory(), (ExecutionContext)this.typedSystem().executionContext(), this.typedSystem());
    }

    private static final class ByPersistenceIdState
    implements Product,
    Serializable {
        private final int queryCount;
        private final int rowCount;
        private final long latestSeqNr;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int queryCount() {
            return this.queryCount;
        }

        public int rowCount() {
            return this.rowCount;
        }

        public long latestSeqNr() {
            return this.latestSeqNr;
        }

        public ByPersistenceIdState copy(int queryCount, int rowCount, long latestSeqNr) {
            return new ByPersistenceIdState(queryCount, rowCount, latestSeqNr);
        }

        public int copy$default$1() {
            return this.queryCount();
        }

        public int copy$default$2() {
            return this.rowCount();
        }

        public long copy$default$3() {
            return this.latestSeqNr();
        }

        public String productPrefix() {
            return "ByPersistenceIdState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.queryCount());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.rowCount());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.latestSeqNr());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ByPersistenceIdState;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "queryCount";
                    break;
                }
                case 1: {
                    string = "rowCount";
                    break;
                }
                case 2: {
                    string = "latestSeqNr";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.queryCount());
            n = Statics.mix((int)n, (int)this.rowCount());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latestSeqNr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ByPersistenceIdState)) return false;
            boolean bl = true;
            if (!bl) return false;
            ByPersistenceIdState byPersistenceIdState = (ByPersistenceIdState)x$1;
            if (this.queryCount() != byPersistenceIdState.queryCount()) return false;
            if (this.rowCount() != byPersistenceIdState.rowCount()) return false;
            if (this.latestSeqNr() != byPersistenceIdState.latestSeqNr()) return false;
            return true;
        }

        public ByPersistenceIdState(int queryCount, int rowCount, long latestSeqNr) {
            this.queryCount = queryCount;
            this.rowCount = rowCount;
            this.latestSeqNr = latestSeqNr;
            Product.$init$((Product)this);
        }
    }

    private static final class PersistenceIdsQueryState
    implements Product,
    Serializable {
        private final int queryCount;
        private final int rowCount;
        private final String latestPid;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int queryCount() {
            return this.queryCount;
        }

        public int rowCount() {
            return this.rowCount;
        }

        public String latestPid() {
            return this.latestPid;
        }

        public PersistenceIdsQueryState copy(int queryCount, int rowCount, String latestPid) {
            return new PersistenceIdsQueryState(queryCount, rowCount, latestPid);
        }

        public int copy$default$1() {
            return this.queryCount();
        }

        public int copy$default$2() {
            return this.rowCount();
        }

        public String copy$default$3() {
            return this.latestPid();
        }

        public String productPrefix() {
            return "PersistenceIdsQueryState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.queryCount());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.rowCount());
                    break;
                }
                case 2: {
                    object = this.latestPid();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PersistenceIdsQueryState;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "queryCount";
                    break;
                }
                case 1: {
                    string = "rowCount";
                    break;
                }
                case 2: {
                    string = "latestPid";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.queryCount());
            n = Statics.mix((int)n, (int)this.rowCount());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.latestPid()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PersistenceIdsQueryState)) return false;
            boolean bl = true;
            if (!bl) return false;
            PersistenceIdsQueryState persistenceIdsQueryState = (PersistenceIdsQueryState)x$1;
            if (this.queryCount() != persistenceIdsQueryState.queryCount()) return false;
            if (this.rowCount() != persistenceIdsQueryState.rowCount()) return false;
            String string = this.latestPid();
            String string2 = persistenceIdsQueryState.latestPid();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public PersistenceIdsQueryState(int queryCount, int rowCount, String latestPid) {
            this.queryCount = queryCount;
            this.rowCount = rowCount;
            this.latestPid = latestPid;
            Product.$init$((Product)this);
        }
    }
}

