/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.state.scaladsl;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.r2dbc.Dialect;
import akka.persistence.r2dbc.Dialect$Postgres$;
import akka.persistence.r2dbc.Dialect$Yugabyte$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.BySliceQuery$Buckets$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.state.scaladsl.DurableStateDao$;
import akka.persistence.typed.PersistenceId$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011=rA\u0002-Z\u0011\u0003i6M\u0002\u0004f3\"\u0005QL\u001a\u0005\u0006[\u0006!\ta\u001c\u0005\ba\u0006\u0011\r\u0011\"\u0001r\u0011\u0019Q\u0018\u0001)A\u0005e\"910\u0001b\u0001\n\u0003a\bbBA\u0006\u0003\u0001\u0006I! \u0004\u0007\u0003\u001b\t!)a\u0004\t\u0015\u0005\rsA!f\u0001\n\u0003\t)\u0005\u0003\u0006\u0002X\u001d\u0011\t\u0012)A\u0005\u0003\u000fB!\"!\u0017\b\u0005+\u0007I\u0011AA.\u0011)\t\u0019g\u0002B\tB\u0003%\u0011Q\f\u0005\n\u0003K:!Q3A\u0005\u0002qD\u0011\"a\u001a\b\u0005#\u0005\u000b\u0011B?\t\u0013\u0005%tA!f\u0001\n\u0003a\b\"CA6\u000f\tE\t\u0015!\u0003~\u0011)\tig\u0002BK\u0002\u0013\u0005\u0011q\u000e\u0005\u000b\u0003{:!\u0011#Q\u0001\n\u0005E\u0004BCA@\u000f\tU\r\u0011\"\u0001\u0002\u0002\"Q\u0011\u0011R\u0004\u0003\u0012\u0003\u0006I!a!\t\u0015\u0005-uA!f\u0001\n\u0003\t)\u0005\u0003\u0006\u0002\u000e\u001e\u0011\t\u0012)A\u0005\u0003\u000fB!\"a$\b\u0005+\u0007I\u0011AAI\u0011)\tIj\u0002B\tB\u0003%\u00111\u0013\u0005\u0007[\u001e!\t!a'\t\u000f\u0005Ev\u0001\"\u0011\u0002\\!I\u00111W\u0004\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003\u000f<\u0011\u0013!C\u0001\u0003\u0013D\u0011\"a8\b#\u0003%\t!!9\t\u0013\u0005\u0015x!%A\u0005\u0002\u0005\u001d\b\"CAv\u000fE\u0005I\u0011AAt\u0011%\tioBI\u0001\n\u0003\ty\u000fC\u0005\u0002t\u001e\t\n\u0011\"\u0001\u0002v\"I\u0011\u0011`\u0004\u0012\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003w<\u0011\u0013!C\u0001\u0003{D\u0011B!\u0001\b\u0003\u0003%\tEa\u0001\t\u0013\t=q!!A\u0005\u0002\u0005\u0005\u0005\"\u0003B\t\u000f\u0005\u0005I\u0011\u0001B\n\u0011%\u0011ybBA\u0001\n\u0003\u0012\t\u0003C\u0005\u00030\u001d\t\t\u0011\"\u0001\u00032!I!1H\u0004\u0002\u0002\u0013\u0005#Q\b\u0005\n\u0005\u0003:\u0011\u0011!C!\u0005\u0007B\u0011B!\u0012\b\u0003\u0003%\tEa\u0012\t\u0013\t%s!!A\u0005B\t-s!\u0003B(\u0003\u0005\u0005\t\u0012\u0001B)\r%\ti!AA\u0001\u0012\u0003\u0011\u0019\u0006\u0003\u0004n[\u0011\u0005!1\u000e\u0005\n\u0005\u000bj\u0013\u0011!C#\u0005\u000fB\u0011B!\u001c.\u0003\u0003%\tIa\u001c\t\u0013\t\u0005U&!A\u0005\u0002\n\r\u0005\"\u0003BK[\u0005\u0005I\u0011\u0002BL\r\u0019)\u0017\fA/\u0003.\"Q!\u0011X\u001a\u0003\u0002\u0003\u0006IAa/\t\u0015\t\r7G!A!\u0002\u0013\u0011)\r\u0003\u0006\u0003VN\u0012\t\u0011)A\u0006\u0005/D!Ba94\u0005\u0003\u0005\u000b1\u0002Bs\u0011\u0019i7\u0007\"\u0001\u0004\b!I1QD\u001aC\u0002\u0013%1q\u0004\u0005\t\u0007S\u0019\u0004\u0015!\u0003\u0004\"!I11F\u001aC\u0002\u0013%1Q\u0006\u0005\t\u0007k\u0019\u0004\u0015!\u0003\u00040!I1qG\u001aC\u0002\u0013%\u0011Q\t\u0005\t\u0007s\u0019\u0004\u0015!\u0003\u0002H!I11H\u001aC\u0002\u0013%\u0011Q\t\u0005\t\u0007{\u0019\u0004\u0015!\u0003\u0002H!91qH\u001a\u0005\n\r\u0005\u0003bBB&g\u0011%1Q\n\u0005\n\u0007'\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u00164A\u0003%\u0011q\t\u0005\n\u0007/\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u00174A\u0003%\u0011q\t\u0005\n\u00077\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u00184A\u0003%\u0011q\t\u0005\n\u0007?\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u00194A\u0003%\u0011q\t\u0005\n\u0007G\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u001a4A\u0003%\u0011q\t\u0005\n\u0007O\u001a$\u0019!C\u0005\u0003\u000bB\u0001b!\u001b4A\u0003%\u0011q\t\u0005\b\u0007W\u001aD\u0011BB7\u0011\u001d\u0019Yi\rC\u0001\u0007\u001bCqa!'4\t\u0003\u0019Y\nC\u0004\u0004*N\"\taa+\t\u000f\r=6\u0007\"\u0011\u00042\"91QW\u001a\u0005B\r]\u0006bBBrg\u0011\u00051Q\u001d\u0005\b\u0007g\u001cD\u0011AB{\u0011\u001d\u00199p\rC!\u0007s\fq\u0002R;sC\ndWm\u0015;bi\u0016$\u0015m\u001c\u0006\u00035n\u000b\u0001b]2bY\u0006$7\u000f\u001c\u0006\u00039v\u000bQa\u001d;bi\u0016T!AX0\u0002\u000bI\u0014DMY2\u000b\u0005\u0001\f\u0017a\u00039feNL7\u000f^3oG\u0016T\u0011AY\u0001\u0005C.\\\u0017\r\u0005\u0002e\u00035\t\u0011LA\bEkJ\f'\r\\3Ti\u0006$X\rR1p'\t\tq\r\u0005\u0002iW6\t\u0011NC\u0001k\u0003\u0015\u00198-\u00197b\u0013\ta\u0017N\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t1-A\u0002m_\u001e,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fQa\u001d7gi)T\u0011a^\u0001\u0004_J<\u0017BA=u\u0005\u0019aunZ4fe\u0006!An\\4!\u0003A)U\u000e\u001d;z\t\n$\u0016.\\3ti\u0006l\u0007/F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u001dIen\u001d;b]R\f\u0011#R7qif$%\rV5nKN$\u0018-\u001c9!\u0005I\u0019VM]5bY&TX\rZ*uCR,'k\\<\u0014\u0011\u001d9\u0017\u0011CA\u0013\u0003W\u0001B!a\u0005\u0002 9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001au\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003;\t9\"\u0001\u0007CsNc\u0017nY3Rk\u0016\u0014\u00180\u0003\u0003\u0002\"\u0005\r\"!D*fe&\fG.\u001b>fIJ{wO\u0003\u0003\u0002\u001e\u0005]\u0001c\u00015\u0002(%\u0019\u0011\u0011F5\u0003\u000fA\u0013x\u000eZ;diB!\u0011QFA\u001f\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eo\u0003\u0019a$o\\8u}%\t!.C\u0002\u0002<%\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#\u0001D*fe&\fG.\u001b>bE2,'bAA\u001eS\u0006i\u0001/\u001a:tSN$XM\\2f\u0013\u0012,\"!a\u0012\u0011\t\u0005%\u0013\u0011\u000b\b\u0005\u0003\u0017\ni\u0005E\u0002\u00022%L1!a\u0014j\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011qJ5\u0002\u001dA,'o]5ti\u0016t7-Z%eA\u0005A!/\u001a<jg&|g.\u0006\u0002\u0002^A\u0019\u0001.a\u0018\n\u0007\u0005\u0005\u0014N\u0001\u0003M_:<\u0017!\u0003:fm&\u001c\u0018n\u001c8!\u0003-!'\rV5nKN$\u0018-\u001c9\u0002\u0019\u0011\u0014G+[7fgR\fW\u000e\u001d\u0011\u0002\u001fI,\u0017\r\u001a#c)&lWm\u001d;b[B\f\u0001C]3bI\u0012\u0013G+[7fgR\fW\u000e\u001d\u0011\u0002\u000fA\f\u0017\u0010\\8bIV\u0011\u0011\u0011\u000f\t\u0006Q\u0006M\u0014qO\u0005\u0004\u0003kJ'!B!se\u0006L\bc\u00015\u0002z%\u0019\u00111P5\u0003\t\tKH/Z\u0001\ta\u0006LHn\\1eA\u0005)1/\u001a:JIV\u0011\u00111\u0011\t\u0004Q\u0006\u0015\u0015bAADS\n\u0019\u0011J\u001c;\u0002\rM,'/\u00133!\u0003-\u0019XM]'b]&4Wm\u001d;\u0002\u0019M,'/T1oS\u001a,7\u000f\u001e\u0011\u0002\tQ\fwm]\u000b\u0003\u0003'\u0003b!!\u0013\u0002\u0016\u0006\u001d\u0013\u0002BAL\u0003+\u00121aU3u\u0003\u0015!\u0018mZ:!)I\ti*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi+a,\u0011\u0007\u0005}u!D\u0001\u0002\u0011\u001d\t\u0019\u0005\u0007a\u0001\u0003\u000fBq!!\u0017\u0019\u0001\u0004\ti\u0006\u0003\u0004\u0002fa\u0001\r! \u0005\u0007\u0003SB\u0002\u0019A?\t\u000f\u00055\u0004\u00041\u0001\u0002r!9\u0011q\u0010\rA\u0002\u0005\r\u0005bBAF1\u0001\u0007\u0011q\t\u0005\b\u0003\u001fC\u0002\u0019AAJ\u0003\u0015\u0019X-\u001d(s\u0003\u0011\u0019w\u000e]=\u0015%\u0005u\u0015qWA]\u0003w\u000bi,a0\u0002B\u0006\r\u0017Q\u0019\u0005\n\u0003\u0007R\u0002\u0013!a\u0001\u0003\u000fB\u0011\"!\u0017\u001b!\u0003\u0005\r!!\u0018\t\u0011\u0005\u0015$\u0004%AA\u0002uD\u0001\"!\u001b\u001b!\u0003\u0005\r! \u0005\n\u0003[R\u0002\u0013!a\u0001\u0003cB\u0011\"a \u001b!\u0003\u0005\r!a!\t\u0013\u0005-%\u0004%AA\u0002\u0005\u001d\u0003\"CAH5A\u0005\t\u0019AAJ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a3+\t\u0005\u001d\u0013QZ\u0016\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\\5\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002^\u0006M'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAArU\u0011\ti&!4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001e\u0016\u0004{\u00065\u0017AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\t\tP\u000b\u0003\u0002r\u00055\u0017AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0003oTC!a!\u0002N\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012:\u0014AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003\u007fTC!a%\u0002N\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002\u0004\u0005!A.\u00198h\u0013\u0011\t\u0019F!\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0003B\u000e!\rA'qC\u0005\u0004\u00053I'aA!os\"I!QD\u0013\u0002\u0002\u0003\u0007\u00111Q\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0002C\u0002B\u0013\u0005W\u0011)\"\u0004\u0002\u0003()\u0019!\u0011F5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003.\t\u001d\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\r\u0003:A\u0019\u0001N!\u000e\n\u0007\t]\u0012NA\u0004C_>dW-\u00198\t\u0013\tuq%!AA\u0002\tU\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0002\u0003@!I!Q\u0004\u0015\u0002\u0002\u0003\u0007\u00111Q\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111Q\u0001\ti>\u001cFO]5oOR\u0011!QA\u0001\u0007KF,\u0018\r\\:\u0015\t\tM\"Q\n\u0005\n\u0005;Y\u0013\u0011!a\u0001\u0005+\t!cU3sS\u0006d\u0017N_3e'R\fG/\u001a*poB\u0019\u0011qT\u0017\u0014\u000b5\u0012)F!\u0019\u0011)\t]#QLA$\u0003;jX0!\u001d\u0002\u0004\u0006\u001d\u00131SAO\u001b\t\u0011IFC\u0002\u0003\\%\fqA];oi&lW-\u0003\u0003\u0003`\te#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oqA!!1\rB5\u001b\t\u0011)G\u0003\u0003\u0003h\u0005\r\u0011AA5p\u0013\u0011\tyD!\u001a\u0015\u0005\tE\u0013!B1qa2LHCEAO\u0005c\u0012\u0019H!\u001e\u0003x\te$1\u0010B?\u0005\u007fBq!a\u00111\u0001\u0004\t9\u0005C\u0004\u0002ZA\u0002\r!!\u0018\t\r\u0005\u0015\u0004\u00071\u0001~\u0011\u0019\tI\u0007\ra\u0001{\"9\u0011Q\u000e\u0019A\u0002\u0005E\u0004bBA@a\u0001\u0007\u00111\u0011\u0005\b\u0003\u0017\u0003\u0004\u0019AA$\u0011\u001d\ty\t\ra\u0001\u0003'\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0006\nE\u0005#\u00025\u0003\b\n-\u0015b\u0001BES\n1q\n\u001d;j_:\u0004\u0012\u0003\u001bBG\u0003\u000f\ni&`?\u0002r\u0005\r\u0015qIAJ\u0013\r\u0011y)\u001b\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\tM\u0015'!AA\u0002\u0005u\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0014\t\u0005\u0005\u000f\u0011Y*\u0003\u0003\u0003\u001e\n%!AB(cU\u0016\u001cG\u000fK\u0002\u0002\u0005C\u0003BAa)\u0003(6\u0011!Q\u0015\u0006\u0004\u00033\f\u0017\u0002\u0002BU\u0005K\u00131\"\u00138uKJt\u0017\r\\!qS\"\u001a\u0001A!)\u0014\tM:'q\u0016\t\u0007\u0003'\u0011\tL!.\n\t\tM\u00161\u0005\u0002\u0004\t\u0006|\u0007c\u0001B\\\u000f9\u0011A\rA\u0001\tg\u0016$H/\u001b8hgB!!Q\u0018B`\u001b\u0005i\u0016b\u0001Ba;\ni!K\r3cGN+G\u000f^5oON\f\u0011cY8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z!\u0011\u00119M!5\u000e\u0005\t%'\u0002\u0002Bf\u0005\u001b\f1a\u001d9j\u0015\rq&q\u001a\u0006\u0003\u0005OJAAa5\u0003J\n\t2i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0002\u0005\u0015\u001c\u0007\u0003\u0002Bm\u0005?l!Aa7\u000b\u0007\tu\u0017.\u0001\u0006d_:\u001cWO\u001d:f]RLAA!9\u0003\\\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007gf\u001cH/Z71\t\t\u001d(1 \t\u0007\u0005S\u0014\u0019Pa>\u000e\u0005\t-(\u0002\u0002Bw\u0005_\fQ\u0001^=qK\u0012T1A!=b\u0003\u0015\t7\r^8s\u0013\u0011\u0011)Pa;\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\t\u0005\u0005s\u0014Y\u0010\u0004\u0001\u0005\u0017\tux'!A\u0001\u0002\u000b\u0005!q \u0002\u0004?\u0012\n\u0014\u0003BB\u0001\u0005+\u00012\u0001[B\u0002\u0013\r\u0019)!\u001b\u0002\b\u001d>$\b.\u001b8h)\u0019\u0019Ia!\u0007\u0004\u001cQ111BB\u0007\u0007\u001f\u0001\"\u0001Z\u001a\t\u000f\tU\u0007\bq\u0001\u0003X\"9!1\u001d\u001dA\u0004\rE\u0001\u0007BB\n\u0007/\u0001bA!;\u0003t\u000eU\u0001\u0003\u0002B}\u0007/!AB!@\u0004\u0010\u0005\u0005\t\u0011!B\u0001\u0005\u007fDqA!/9\u0001\u0004\u0011Y\fC\u0004\u0003Db\u0002\rA!2\u0002\u001dA,'o]5ti\u0016t7-Z#yiV\u00111\u0011\u0005\t\u0005\u0007G\u0019)#D\u0001`\u0013\r\u00199c\u0018\u0002\f!\u0016\u00148/[:uK:\u001cW-A\bqKJ\u001c\u0018n\u001d;f]\u000e,W\t\u001f;!\u00035\u0011(\u0007\u001a2d\u000bb,7-\u001e;peV\u00111q\u0006\t\u0005\u0003+\u0019\t$\u0003\u0003\u00044\u0005]!!\u0004*3I\n\u001cW\t_3dkR|'/\u0001\bse\u0011\u00147-\u0012=fGV$xN\u001d\u0011\u0002\u0015M$\u0018\r^3UC\ndW-A\u0006ti\u0006$X\rV1cY\u0016\u0004\u0013AD:fY\u0016\u001cGo\u0015;bi\u0016\u001c\u0016\u000f\\\u0001\u0010g\u0016dWm\u0019;Ti\u0006$XmU9mA\u0005\u00012/\u001a7fGR\u0014UoY6fiN\u001c\u0016\u000f\u001c\u000b\u0007\u0003\u000f\u001a\u0019ea\u0012\t\u000f\r\u0015\u0013\t1\u0001\u0002\u0004\u0006AQ.\u001b8TY&\u001cW\rC\u0004\u0004J\u0005\u0003\r!a!\u0002\u00115\f\u0007p\u00157jG\u0016\fab\u001d7jG\u0016\u001cuN\u001c3ji&|g\u000e\u0006\u0004\u0002H\r=3\u0011\u000b\u0005\b\u0007\u000b\u0012\u0005\u0019AAB\u0011\u001d\u0019IE\u0011a\u0001\u0003\u0007\u000ba\"\u001b8tKJ$8\u000b^1uKN\u000bH.A\bj]N,'\u000f^*uCR,7+\u001d7!\u00039)\b\u000fZ1uKN#\u0018\r^3Tc2\fq\"\u001e9eCR,7\u000b^1uKN\u000bH\u000eI\u0001\u000fI\u0016dW\r^3Ti\u0006$XmU9m\u0003=!W\r\\3uKN#\u0018\r^3Tc2\u0004\u0013!F2veJ,g\u000e\u001e#c)&lWm\u001d;b[B\u001c\u0016\u000f\\\u0001\u0017GV\u0014(/\u001a8u\t\n$\u0016.\\3ti\u0006l\u0007oU9mA\u0005!\u0012\r\u001c7QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ:Tc2\fQ#\u00197m!\u0016\u00148/[:uK:\u001cW-\u00133t'Fd\u0007%A\rbY2\u0004VM]:jgR,gnY3JIN\fe\r^3s'Fd\u0017AG1mYB+'o]5ti\u0016t7-Z%eg\u00063G/\u001a:Tc2\u0004\u0013!F:uCR,')_*mS\u000e,7OU1oO\u0016\u001c\u0016\u000f\u001c\u000b\r\u0003\u000f\u001ayga\u001d\u0004\u0004\u000e\u001d5\u0011\u0012\u0005\b\u0007cz\u0005\u0019\u0001B\u001a\u0003Mi\u0017\r\u001f#c)&lWm\u001d;b[B\u0004\u0016M]1n\u0011\u001d\u0019)h\u0014a\u0001\u0007o\n\u0011CY3iS:$7)\u001e:sK:$H+[7f!\u0011\u0019Iha \u000e\u0005\rm$\u0002BB?\u00057\f\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0007\u0003\u001bYH\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u000f\r\u0015u\n1\u0001\u00034\u0005a!-Y2liJ\f7m[5oO\"91QI(A\u0002\u0005\r\u0005bBB%\u001f\u0002\u0007\u00111Q\u0001\ne\u0016\fGm\u0015;bi\u0016$Baa$\u0004\u0018B1!\u0011\\BI\u0007+KAaa%\u0003\\\n1a)\u001e;ve\u0016\u0004R\u0001\u001bBD\u0005kCq!a\u0011Q\u0001\u0004\t9%\u0001\u0006xe&$Xm\u0015;bi\u0016$Ba!(\u0004(B1!\u0011\\BI\u0007?\u0003Ba!)\u0004$6\t\u0011-C\u0002\u0004&\u0006\u0014A\u0001R8oK\"1A,\u0015a\u0001\u0005k\u000b1\u0002Z3mKR,7\u000b^1uKR!1QTBW\u0011\u001d\t\u0019E\u0015a\u0001\u0003\u000f\n!cY;se\u0016tG\u000f\u00122US6,7\u000f^1naR\u001111\u0017\t\u0006\u00053\u001c\t*`\u0001\re><8OQ=TY&\u001cWm\u001d\u000b\u0011\u0007s\u001bim!5\u0004T\u000eU7\u0011\\Bp\u0007C\u0004\u0002ba/\u0004D\nU6qY\u0007\u0003\u0007{S1AWB`\u0015\r\u0019\t-Y\u0001\u0007gR\u0014X-Y7\n\t\r\u00157Q\u0018\u0002\u0007'>,(oY3\u0011\t\r\u00056\u0011Z\u0005\u0004\u0007\u0017\f'a\u0002(piV\u001bX\r\u001a\u0005\b\u0007\u001f$\u0006\u0019AA$\u0003))g\u000e^5usRK\b/\u001a\u0005\b\u0007\u000b\"\u0006\u0019AAB\u0011\u001d\u0019I\u0005\u0016a\u0001\u0003\u0007Caaa6U\u0001\u0004i\u0018!\u00044s_6$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0004\\R\u0003\ra!8\u0002\u0017Q|G+[7fgR\fW\u000e\u001d\t\u0005Q\n\u001dU\u0010C\u0004\u0004vQ\u0003\raa\u001e\t\u000f\r\u0015E\u000b1\u0001\u00034\u0005q\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u001cHCBBt\u0007S\u001cy\u000f\u0005\u0005\u0004<\u000e\r\u0017qIBd\u0011\u001d\u0019Y/\u0016a\u0001\u0007[\fq!\u00194uKJLE\rE\u0003i\u0005\u000f\u000b9\u0005C\u0004\u0004rV\u0003\r!!\u0018\u0002\u000b1LW.\u001b;\u0002+\r|WO\u001c;Ck\u000e\\W\r^:NCf\u001c\u0005.\u00198hKV\u0011!1G\u0001\rG>,h\u000e\u001e\"vG.,Go\u001d\u000b\r\u0007w$\u0019\u0003\"\n\u0005(\u0011%B1\u0006\t\u0007\u00053\u001c\tj!@\u0011\r\u000552q C\u0002\u0013\u0011!\t!!\u0011\u0003\u0007M+\u0017\u000f\u0005\u0003\u0005\u0006\u0011ua\u0002\u0002C\u0004\t3qA\u0001\"\u0003\u0002\u001c9!A1\u0002C\f\u001d\u0011!i\u0001\"\u0006\u000f\t\u0011=A1\u0003\b\u0005\u0003c!\t\"C\u0001c\u0013\t\u0001\u0017-\u0003\u0002_?&\u0019\u0011\u0011D/\n\t\u0011m\u00111E\u0001\b\u0005V\u001c7.\u001a;t\u0013\u0011!y\u0002\"\t\u0003\r\t+8m[3u\u0015\u0011!Y\"a\t\t\u000f\r=w\u000b1\u0001\u0002H!91QI,A\u0002\u0005\r\u0005bBB%/\u0002\u0007\u00111\u0011\u0005\u0007\u0007/<\u0006\u0019A?\t\u000f\rEx\u000b1\u0001\u0002\u0004\"\u001a1G!)")
@InternalApi
public class DurableStateDao
implements BySliceQuery.Dao<SerializedStateRow> {
    private final R2dbcSettings settings;
    private final ExecutionContext ec;
    private final Persistence persistenceExt;
    private final R2dbcExecutor r2dbcExecutor;
    private final String stateTable;
    private final String selectStateSql;
    private final String insertStateSql;
    private final String updateStateSql;
    private final String deleteStateSql;
    private final String currentDbTimestampSql;
    private final String allPersistenceIdsSql;
    private final String allPersistenceIdsAfterSql;

    public static Instant EmptyDbTimestamp() {
        return DurableStateDao$.MODULE$.EmptyDbTimestamp();
    }

    public static Logger log() {
        return DurableStateDao$.MODULE$.log();
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    private String stateTable() {
        return this.stateTable;
    }

    private String selectStateSql() {
        return this.selectStateSql;
    }

    private String selectBucketsSql(int minSlice, int maxSlice) {
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n     SELECT extract(EPOCH from db_timestamp)::BIGINT / 10 AS bucket, count(*) AS count\n     FROM ", "\n     WHERE entity_type = ?\n     AND ", "\n     AND db_timestamp >= ? AND db_timestamp <= ?\n     GROUP BY bucket ORDER BY bucket LIMIT ?\n     "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable(), this.sliceCondition(minSlice, maxSlice)}));
    }

    private String sliceCondition(int minSlice, int maxSlice) {
        String string;
        Dialect dialect = this.settings.dialect();
        if (Dialect$Yugabyte$.MODULE$.equals(dialect)) {
            string = new StringBuilder(19).append("slice BETWEEN ").append(minSlice).append(" AND ").append(maxSlice).toString();
        } else if (Dialect$Postgres$.MODULE$.equals(dialect)) {
            string = new StringBuilder(11).append("slice in (").append(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(minSlice), maxSlice).mkString(",")).append(")").toString();
        } else {
            throw new MatchError((Object)dialect);
        }
        return string;
    }

    private String insertStateSql() {
        return this.insertStateSql;
    }

    private String updateStateSql() {
        return this.updateStateSql;
    }

    private String deleteStateSql() {
        return this.deleteStateSql;
    }

    private String currentDbTimestampSql() {
        return this.currentDbTimestampSql;
    }

    private String allPersistenceIdsSql() {
        return this.allPersistenceIdsSql;
    }

    private String allPersistenceIdsAfterSql() {
        return this.allPersistenceIdsAfterSql;
    }

    private String stateBySlicesRangeSql(boolean maxDbTimestampParam, FiniteDuration behindCurrentTime, boolean backtracking, int minSlice, int maxSlice) {
        String selectColumns = backtracking ? "SELECT persistence_id, revision, db_timestamp, statement_timestamp() AS read_db_timestamp " : "SELECT persistence_id, revision, db_timestamp, statement_timestamp() AS read_db_timestamp, state_ser_id, state_ser_manifest, state_payload ";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      FROM ", "\n      WHERE entity_type = ?\n      AND ", "\n      AND db_timestamp >= ? ", " ", "\n      ORDER BY db_timestamp, revision\n      LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{selectColumns, this.stateTable(), this.sliceCondition(minSlice, maxSlice), DurableStateDao.maxDbTimestampParamCondition$1(maxDbTimestampParam), DurableStateDao.behindCurrentTimeIntervalCondition$1(behindCurrentTime)}));
    }

    public Future<Option<SerializedStateRow>> readState(String persistenceId) {
        return this.r2dbcExecutor().selectOne(new StringBuilder(9).append("select [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectStateSql()).bind(0, (Object)persistenceId), (Function1 & Serializable)row -> new SerializedStateRow(persistenceId, Predef$.MODULE$.Long2long((Long)row.get("revision", Long.class)), (Instant)row.get("db_timestamp", Instant.class), Instant.EPOCH, (byte[])row.get("state_payload", byte[].class), Predef$.MODULE$.Integer2int((Integer)row.get("state_ser_id", Integer.class)), (String)row.get("state_ser_manifest", String.class), (Set<String>)Predef$.MODULE$.Set().empty()));
    }

    public Future<Done> writeState(SerializedStateRow state) {
        Future future;
        Predef$.MODULE$.require(state.revision() > 0L);
        String entityType = PersistenceId$.MODULE$.extractEntityType(state.persistenceId());
        int slice = this.persistenceExt().sliceForPersistenceId(state.persistenceId());
        if (state.revision() == 1L) {
            future = this.r2dbcExecutor().updateOne(new StringBuilder(9).append("insert [").append(state.persistenceId()).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement stmt = connection.createStatement(this.insertStateSql()).bind(0, (Object)BoxesRunTime.boxToInteger((int)slice)).bind(1, (Object)entityType).bind(2, (Object)state.persistenceId()).bind(3, (Object)BoxesRunTime.boxToLong((long)state.revision())).bind(4, (Object)BoxesRunTime.boxToInteger((int)state.serId())).bind(5, (Object)state.serManifest()).bind(6, (Object)state.payload());
                return DurableStateDao.bindTags$1(stmt, 7, state);
            }).recoverWith((PartialFunction)new Serializable(null, state){
                private static final long serialVersionUID = 0L;
                private final SerializedStateRow state$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof R2dbcDataIntegrityViolationException ? Future$.MODULE$.failed((Throwable)new IllegalStateException(new StringBuilder(65).append("Insert failed: durable state for persistence id [").append(this.state$1.persistenceId()).append("] already exists").toString())) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof R2dbcDataIntegrityViolationException;
                    return bl;
                }
                {
                    this.state$1 = state$1;
                }
            }, this.ec);
        } else {
            long previousRevision = state.revision() - 1L;
            future = this.r2dbcExecutor().updateOne(new StringBuilder(9).append("update [").append(state.persistenceId()).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement statement;
                Statement stmt = connection.createStatement(this.updateStateSql()).bind(0, (Object)BoxesRunTime.boxToLong((long)state.revision())).bind(1, (Object)BoxesRunTime.boxToInteger((int)state.serId())).bind(2, (Object)state.serManifest()).bind(3, (Object)state.payload());
                DurableStateDao.bindTags$1(stmt, 4, state);
                if ($this.settings.dbTimestampMonotonicIncreasing()) {
                    statement = $this.settings.durableStateAssertSingleWriter() ? stmt.bind(5, (Object)state.persistenceId()).bind(6, (Object)BoxesRunTime.boxToLong((long)previousRevision)) : stmt.bind(5, (Object)state.persistenceId());
                } else {
                    stmt.bind(5, (Object)state.persistenceId()).bind(6, (Object)BoxesRunTime.boxToLong((long)previousRevision)).bind(7, (Object)state.persistenceId());
                    statement = $this.settings.durableStateAssertSingleWriter() ? stmt.bind(8, (Object)BoxesRunTime.boxToLong((long)previousRevision)) : stmt;
                }
                return statement;
            });
        }
        Future result = future;
        return result.map((Function1 & Serializable)updatedRows -> DurableStateDao.$anonfun$writeState$3(state, BoxesRunTime.unboxToInt((Object)updatedRows)), this.ec);
    }

    public Future<Done> deleteState(String persistenceId) {
        Future<Object> result;
        block0: {
            result = this.r2dbcExecutor().updateOne(new StringBuilder(9).append("delete [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.deleteStateSql()).bind(0, (Object)persistenceId));
            if (!DurableStateDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> DurableStateDao$.MODULE$.log().debug("Deleted durable state for persistenceId [{}]", (Object)persistenceId), this.ec);
        }
        return result.map((Function1 & Serializable)x$2 -> DurableStateDao.$anonfun$deleteState$3(BoxesRunTime.unboxToInt((Object)x$2)), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    @Override
    public Future<Instant> currentDbTimestamp() {
        return this.r2dbcExecutor().selectOne("select current db timestamp", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.currentDbTimestampSql()), (Function1 & Serializable)row -> (Instant)row.get("db_timestamp", Instant.class)).map((Function1 & Serializable)x0$1 -> {
            Instant time;
            Option option = x0$1;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(22).append("Expected one row for: ").append(this.currentDbTimestampSql()).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Instant instant = time = (Instant)some.value();
            return instant;
        }, this.ec);
    }

    @Override
    public Source<SerializedStateRow, NotUsed> rowsBySlices(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, Option<Instant> toTimestamp, FiniteDuration behindCurrentTime, boolean backtracking) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(26).append("select stateBySlices [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement statement;
                Statement stmt = connection.createStatement(this.stateBySlicesRangeSql(toTimestamp.isDefined(), behindCurrentTime, backtracking, minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp);
                Option option = toTimestamp;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant until = (Instant)some.value();
                    stmt.bind(2, (Object)until);
                    statement = stmt.bind(3, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else if (None$.MODULE$.equals(option)) {
                    statement = stmt.bind(2, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else {
                    throw new MatchError((Object)option);
                }
                return stmt;
            }, (Function1 & Serializable)row -> backtracking ? new SerializedStateRow((String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("revision", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), null, 0, "", (Set<String>)Predef$.MODULE$.Set().empty()) : new SerializedStateRow((String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("revision", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (byte[])row.get("state_payload", byte[].class), Predef$.MODULE$.Integer2int((Integer)row.get("state_ser_id", Integer.class)), (String)row.get("state_ser_manifest", String.class), (Set<String>)Predef$.MODULE$.Set().empty()));
            if (!DurableStateDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                DurableStateDao.$anonfun$rowsBySlices$3(minSlice, maxSlice, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$3 -> Source$.MODULE$.apply((Iterable)x$3), this.ec)).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public Source<String, NotUsed> persistenceIds(Option<String> afterId, long limit) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select("select persistenceIds", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement statement;
                Option option = afterId;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String after = (String)some.value();
                    statement = connection.createStatement(this.allPersistenceIdsAfterSql()).bind(0, (Object)after).bind(1, (Object)BoxesRunTime.boxToLong((long)limit));
                } else if (None$.MODULE$.equals(option)) {
                    statement = connection.createStatement(this.allPersistenceIdsSql()).bind(0, (Object)BoxesRunTime.boxToLong((long)limit));
                } else {
                    throw new MatchError((Object)option);
                }
                return statement;
            }, (Function1 & Serializable)row -> (String)row.get("persistence_id", String.class));
            if (!DurableStateDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                DurableStateDao.$anonfun$persistenceIds$3(rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$5 -> Source$.MODULE$.apply((Iterable)x$5), this.ec)).mapMaterializedValue((Function1 & Serializable)x$6 -> NotUsed$.MODULE$);
    }

    @Override
    public boolean countBucketsMayChange() {
        return true;
    }

    @Override
    public Future<Seq<BySliceQuery.Buckets.Bucket>> countBuckets(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, int limit) {
        Future result;
        block2: {
            Instant instant;
            Instant now = Instant.now();
            Instant instant2 = fromTimestamp;
            Instant instant3 = Instant.EPOCH;
            if (!(instant2 != null ? !((Object)instant2).equals(instant3) : instant3 != null)) {
                instant = now;
            } else {
                Instant t = fromTimestamp.plusSeconds(BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds() * limit + BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds());
                instant = t.isAfter(now) ? now : t;
            }
            Instant toTimestamp = instant;
            result = this.r2dbcExecutor().select(new StringBuilder(26).append("select bucket counts [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectBucketsSql(minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp).bind(2, (Object)toTimestamp).bind(3, (Object)BoxesRunTime.boxToInteger((int)limit)), (Function1 & Serializable)row -> {
                long bucketStartEpochSeconds = Predef$.MODULE$.Long2long((Long)row.get("bucket", Long.class)) * 10L;
                long count = Predef$.MODULE$.Long2long((Long)row.get("count", Long.class));
                return new BySliceQuery.Buckets.Bucket(bucketStartEpochSeconds, count);
            });
            if (!DurableStateDao$.MODULE$.log().isDebugEnabled()) break block2;
            result.foreach((Function1 & Serializable)rows -> {
                DurableStateDao.$anonfun$countBuckets$3(minSlice, maxSlice, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return result;
    }

    private static final String maxDbTimestampParamCondition$1(boolean maxDbTimestampParam$1) {
        return maxDbTimestampParam$1 ? "AND db_timestamp < ?" : "";
    }

    private static final String behindCurrentTimeIntervalCondition$1(FiniteDuration behindCurrentTime$1) {
        return behindCurrentTime$1.$greater((Object)Duration$.MODULE$.Zero()) ? new StringBuilder(69).append("AND db_timestamp < transaction_timestamp() - interval '").append(behindCurrentTime$1.toMillis()).append(" milliseconds'").toString() : "";
    }

    private static final Statement bindTags$1(Statement stmt, int i, SerializedStateRow state$1) {
        return state$1.tags().isEmpty() ? stmt.bindNull(i, String[].class) : stmt.bind(i, state$1.tags().toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ Done $anonfun$writeState$3(SerializedStateRow state$1, int updatedRows) {
        if (updatedRows != 1) {
            throw new IllegalStateException(new StringBuilder(86).append("Update failed: durable state for persistence id [").append(state$1.persistenceId()).append("] could not be updated to revision [").append(state$1.revision()).append("]").toString());
        }
        DurableStateDao$.MODULE$.log().debug("Updated durable state for persistenceId [{}] to revision [{}]", (Object)state$1.persistenceId(), (Object)BoxesRunTime.boxToLong((long)state$1.revision()));
        return Done$.MODULE$;
    }

    public static final /* synthetic */ Done$ $anonfun$deleteState$3(int x$2) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$rowsBySlices$3(int minSlice$1, int maxSlice$1, IndexedSeq rows) {
        DurableStateDao$.MODULE$.log().debug("Read [{}] durable states from slices [{} - {}]", new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice$1), BoxesRunTime.boxToInteger((int)maxSlice$1)});
    }

    public static final /* synthetic */ void $anonfun$persistenceIds$3(IndexedSeq rows) {
        DurableStateDao$.MODULE$.log().debug("Read [{}] persistence ids", (Object)BoxesRunTime.boxToInteger((int)rows.size()));
    }

    public static final /* synthetic */ void $anonfun$countBuckets$3(int minSlice$2, int maxSlice$2, IndexedSeq rows) {
        DurableStateDao$.MODULE$.log().debug("Read [{}] bucket counts from slices [{} - {}]", new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice$2), BoxesRunTime.boxToInteger((int)maxSlice$2)});
    }

    public DurableStateDao(R2dbcSettings settings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.settings = settings;
        this.ec = ec;
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, DurableStateDao$.MODULE$.log(), settings.logDbCallsExceeding(), ec, system);
        this.stateTable = settings.durableStateTableWithSchema();
        this.selectStateSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT revision, state_ser_id, state_ser_manifest, state_payload, db_timestamp\n    FROM ", " WHERE persistence_id = ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable()}));
        this.insertStateSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    INSERT INTO ", "\n    (slice, entity_type, persistence_id, revision, state_ser_id, state_ser_manifest, state_payload, tags, db_timestamp)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, transaction_timestamp())"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable()}));
        String timestamp = settings.dbTimestampMonotonicIncreasing() ? "transaction_timestamp()" : new StringBuilder(34).append("GREATEST(transaction_timestamp(), ").append(new StringBuilder(98).append("(SELECT db_timestamp + '1 microsecond'::interval FROM ").append(this.stateTable()).append(" WHERE persistence_id = ? AND revision = ?))").toString()).toString();
        String revisionCondition = settings.durableStateAssertSingleWriter() ? " AND revision = ?" : "";
        this.updateStateSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      UPDATE ", "\n      SET revision = ?, state_ser_id = ?, state_ser_manifest = ?, state_payload = ?, tags = ?, db_timestamp = ", "\n      WHERE persistence_id = ?\n      ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable(), timestamp, revisionCondition}));
        this.deleteStateSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE from ", " WHERE persistence_id = ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable()}));
        this.currentDbTimestampSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT transaction_timestamp() AS db_timestamp"}))), (Seq<Object>)Nil$.MODULE$);
        this.allPersistenceIdsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT persistence_id from ", " ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable()}));
        this.allPersistenceIdsAfterSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT persistence_id from ", " WHERE persistence_id > ? ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.stateTable()}));
    }

    public static final class SerializedStateRow
    implements BySliceQuery.SerializedRow,
    Product,
    Serializable {
        private final String persistenceId;
        private final long revision;
        private final Instant dbTimestamp;
        private final Instant readDbTimestamp;
        private final byte[] payload;
        private final int serId;
        private final String serManifest;
        private final Set<String> tags;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public String persistenceId() {
            return this.persistenceId;
        }

        public long revision() {
            return this.revision;
        }

        @Override
        public Instant dbTimestamp() {
            return this.dbTimestamp;
        }

        @Override
        public Instant readDbTimestamp() {
            return this.readDbTimestamp;
        }

        public byte[] payload() {
            return this.payload;
        }

        public int serId() {
            return this.serId;
        }

        public String serManifest() {
            return this.serManifest;
        }

        public Set<String> tags() {
            return this.tags;
        }

        @Override
        public long seqNr() {
            return this.revision();
        }

        public SerializedStateRow copy(String persistenceId, long revision, Instant dbTimestamp, Instant readDbTimestamp, byte[] payload, int serId, String serManifest, Set<String> tags) {
            return new SerializedStateRow(persistenceId, revision, dbTimestamp, readDbTimestamp, payload, serId, serManifest, tags);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.revision();
        }

        public Instant copy$default$3() {
            return this.dbTimestamp();
        }

        public Instant copy$default$4() {
            return this.readDbTimestamp();
        }

        public byte[] copy$default$5() {
            return this.payload();
        }

        public int copy$default$6() {
            return this.serId();
        }

        public String copy$default$7() {
            return this.serManifest();
        }

        public Set<String> copy$default$8() {
            return this.tags();
        }

        public String productPrefix() {
            return "SerializedStateRow";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.persistenceId();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.revision());
                    break;
                }
                case 2: {
                    object = this.dbTimestamp();
                    break;
                }
                case 3: {
                    object = this.readDbTimestamp();
                    break;
                }
                case 4: {
                    object = this.payload();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this.serId());
                    break;
                }
                case 6: {
                    object = this.serManifest();
                    break;
                }
                case 7: {
                    object = this.tags();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedStateRow;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "persistenceId";
                    break;
                }
                case 1: {
                    string = "revision";
                    break;
                }
                case 2: {
                    string = "dbTimestamp";
                    break;
                }
                case 3: {
                    string = "readDbTimestamp";
                    break;
                }
                case 4: {
                    string = "payload";
                    break;
                }
                case 5: {
                    string = "serId";
                    break;
                }
                case 6: {
                    string = "serManifest";
                    break;
                }
                case 7: {
                    string = "tags";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.revision()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.readDbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            n = Statics.mix((int)n, (int)this.serId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tags()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedStateRow)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedStateRow serializedStateRow = (SerializedStateRow)x$1;
            if (this.revision() != serializedStateRow.revision()) return false;
            if (this.serId() != serializedStateRow.serId()) return false;
            String string = this.persistenceId();
            String string2 = serializedStateRow.persistenceId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Instant instant = this.dbTimestamp();
            Instant instant2 = serializedStateRow.dbTimestamp();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Instant instant3 = this.readDbTimestamp();
            Instant instant4 = serializedStateRow.readDbTimestamp();
            if (instant3 == null) {
                if (instant4 != null) {
                    return false;
                }
            } else if (!((Object)instant3).equals(instant4)) return false;
            if (this.payload() != serializedStateRow.payload()) return false;
            String string3 = this.serManifest();
            String string4 = serializedStateRow.serManifest();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Set<String> set = this.tags();
            Set<String> set2 = serializedStateRow.tags();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public SerializedStateRow(String persistenceId, long revision, Instant dbTimestamp, Instant readDbTimestamp, byte[] payload, int serId, String serManifest, Set<String> tags) {
            this.persistenceId = persistenceId;
            this.revision = revision;
            this.dbTimestamp = dbTimestamp;
            this.readDbTimestamp = readDbTimestamp;
            this.payload = payload;
            this.serId = serId;
            this.serManifest = serManifest;
            this.tags = tags;
            Product.$init$((Product)this);
        }
    }
}

