/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.cleanup.scaladsl;

import akka.Done;
import akka.Done$;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.adapter.package;
import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.SnapshotSelectionCriteria$;
import akka.persistence.r2dbc.ConnectionFactoryProvider;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.R2dbcSettings$;
import akka.persistence.r2dbc.journal.JournalDao;
import akka.persistence.r2dbc.snapshot.SnapshotDao;
import io.r2dbc.spi.ConnectionFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u000f\u001f\u0005%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!)1\t\u0001C\u0001\t\")1\t\u0001C\u0001\u0013\"A1\n\u0001b\u0001\n\u00071C\n\u0003\u0004Y\u0001\u0001\u0006I!\u0014\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019\t\b\u0001)A\u0005S\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB>\u0001A\u0003%A\u000fC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005\u0015\u0001\u0001)A\u0005}\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\f!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002$!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u00026!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003S\u0002A\u0011AA=\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!a&\u0001\t\u0003\tI\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005u\u0005\u0001\"\u0001\u0002$\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAT\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003k\u0003A\u0011BA\\\u0005M)e/\u001a8u'>,(oY3e\u00072,\u0017M\\;q\u0015\ty\u0002%\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\t#%A\u0004dY\u0016\fg.\u001e9\u000b\u0005\r\"\u0013!\u0002:3I\n\u001c'BA\u0013'\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\nA!Y6lC\u000e\u00011C\u0001\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fM\u0006q1/_:uK6\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b'\u0003\u0015\t7\r^8s\u0013\t14G\u0001\u000eDY\u0006\u001c8/[2BGR|'oU=ti\u0016l\u0007K]8wS\u0012,'/\u0001\u0006d_:4\u0017n\u001a)bi\"\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e-\u001b\u0005a$BA\u001f)\u0003\u0019a$o\\8u}%\u0011q\bL\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@Y\u00051A(\u001b8jiz\"2!R$I!\t1\u0005!D\u0001\u001f\u0011\u0015\u00014\u00011\u00012\u0011\u001594\u00011\u00019)\t)%\nC\u00031\t\u0001\u0007\u0011'\u0001\u0004tsN$X-\\\u000b\u0002\u001bB\u0012aJ\u0016\t\u0004\u001fJ#V\"\u0001)\u000b\u0005E\u001b\u0014!\u0002;za\u0016$\u0017BA*Q\u0005-\t5\r^8s'f\u001cH/Z7\u0011\u0005U3F\u0002\u0001\u0003\n/\u001a\t\t\u0011!A\u0003\u0002\u0001\u00141a\u0018\u00132\u0003\u001d\u0019\u0018p\u001d;f[\u0002B#A\u0002.\u0011\u0005msV\"\u0001/\u000b\u0005u3\u0013AC1o]>$\u0018\r^5p]&\u0011q\f\u0018\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018.\u0005\u0002bIB\u00111FY\u0005\u0003G2\u0012qAT8uQ&tw\r\u0005\u0002,K&\u0011a\r\f\u0002\u0004\u0003:L\u0018a\u00017pOV\t\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006)1\u000f\u001c45U*\ta.A\u0002pe\u001eL!\u0001]6\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002!MD\u0017M]3e\u0007>tg-[4QCRDW#\u0001;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001\u00027b]\u001eT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002Bm\u0006\t2\u000f[1sK\u0012\u001cuN\u001c4jOB\u000bG\u000f\u001b\u0011\u0002\u0011M,G\u000f^5oON,\u0012A \t\u0004\u007f\u0006\u0005Q\"\u0001\u0012\n\u0007\u0005\r!EA\u0007Se\u0011\u00147mU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n\u0011cY8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005eQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0007M\u0004\u0018NC\u0002$\u0003+Q!!a\u0006\u0002\u0005%|\u0017\u0002BA\u000e\u0003\u001f\u0011\u0011cQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0003I\u0019wN\u001c8fGRLwN\u001c$bGR|'/\u001f\u0011\u0002\u0015)|WO\u001d8bY\u0012\u000bw.\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\t\nqA[8ve:\fG.\u0003\u0003\u0002.\u0005\u001d\"A\u0003&pkJt\u0017\r\u001c#b_\u0006Y!n\\;s]\u0006dG)Y8!\u0003-\u0019h.\u00199tQ>$H)Y8\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\"%\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\ty$!\u000f\u0003\u0017Ms\u0017\r]:i_R$\u0015m\\\u0001\rg:\f\u0007o\u001d5pi\u0012\u000bw\u000eI\u0001\u000fI\u0016dW\r^3Fm\u0016tGo\u001d+p)\u0019\t9%a\u0017\u0002`A1\u0011\u0011JA(\u0003'j!!a\u0013\u000b\u0007\u00055C&\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0015\u0002L\t1a)\u001e;ve\u0016\u0004B!!\u0016\u0002X5\ta%C\u0002\u0002Z\u0019\u0012A\u0001R8oK\"1\u0011QL\nA\u0002a\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007bBA1'\u0001\u0007\u00111M\u0001\ri>\u001cV-];f]\u000e,gJ\u001d\t\u0004W\u0005\u0015\u0014bAA4Y\t!Aj\u001c8h\u0003=!W\r\\3uK\u0006cG.\u0012<f]R\u001cHCBA$\u0003[\ny\u0007\u0003\u0004\u0002^Q\u0001\r\u0001\u000f\u0005\b\u0003c\"\u0002\u0019AA:\u0003M\u0011Xm]3u'\u0016\fX/\u001a8dK:+XNY3s!\rY\u0013QO\u0005\u0004\u0003ob#a\u0002\"p_2,\u0017M\u001c\u000b\u0007\u0003\u000f\nY(a$\t\u000f\u0005uT\u00031\u0001\u0002\u0000\u0005q\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u001c\b#BAA\u0003\u0017CTBAAB\u0015\u0011\t))a\"\u0002\u0013%lW.\u001e;bE2,'bAAEY\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0004'\u0016\f\bbBA9+\u0001\u0007\u00111O\u0001\u000fI\u0016dW\r^3T]\u0006\u00048\u000f[8u)\u0011\t9%!&\t\r\u0005uc\u00031\u00019\u0003=!W\r\\3uKNs\u0017\r]:i_R\u001cH\u0003BA$\u00037Cq!! \u0018\u0001\u0004\ty(A\u000bdY\u0016\fg.\u001e9CK\u001a|'/Z*oCB\u001c\bn\u001c;\u0015\t\u0005\u001d\u0013\u0011\u0015\u0005\u0007\u0003;B\u0002\u0019\u0001\u001d\u0015\t\u0005\u001d\u0013Q\u0015\u0005\b\u0003{J\u0002\u0019AA@\u0003%!W\r\\3uK\u0006cG\u000e\u0006\u0004\u0002H\u0005-\u0016Q\u0016\u0005\u0007\u0003;R\u0002\u0019\u0001\u001d\t\u000f\u0005E$\u00041\u0001\u0002tQ1\u0011qIAY\u0003gCq!! \u001c\u0001\u0004\ty\bC\u0004\u0002rm\u0001\r!a\u001d\u0002\u000f\u0019|'/Z1dQRA\u0011qIA]\u0003w\u000by\fC\u0004\u0002~q\u0001\r!a \t\r\u0005uF\u00041\u00019\u00035y\u0007/\u001a:bi&|gNT1nK\"9\u0011\u0011\u0019\u000fA\u0002\u0005\r\u0017\u0001\u00049jI>\u0003XM]1uS>t\u0007CB\u0016\u0002Fb\n9%C\u0002\u0002H2\u0012\u0011BR;oGRLwN\\\u0019)\u0007\u0001\tY\rE\u0002\\\u0003\u001bL1!a4]\u00051\t\u0005/['bs\u000eC\u0017M\\4f\u0001")
@ApiMayChange
public final class EventSourcedCleanup {
    @InternalApi
    private final ActorSystem<?> system;
    private final Logger log;
    private final String sharedConfigPath;
    private final R2dbcSettings settings;
    private final ConnectionFactory connectionFactory;
    private final JournalDao journalDao;
    private final SnapshotDao snapshotDao;

    public ActorSystem<?> system() {
        return this.system;
    }

    private Logger log() {
        return this.log;
    }

    private String sharedConfigPath() {
        return this.sharedConfigPath;
    }

    private R2dbcSettings settings() {
        return this.settings;
    }

    private ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    private JournalDao journalDao() {
        return this.journalDao;
    }

    private SnapshotDao snapshotDao() {
        return this.snapshotDao;
    }

    public Future<Done> deleteEventsTo(String persistenceId, long toSequenceNr) {
        this.log().debug("deleteEventsTo persistenceId [{}], toSequenceNr [{}]", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)toSequenceNr));
        return this.journalDao().deleteEventsTo(persistenceId, toSequenceNr, false).map((Function1 & Serializable)x$1 -> Done$.MODULE$, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> deleteAllEvents(String persistenceId, boolean resetSequenceNumber) {
        return this.journalDao().deleteEventsTo(persistenceId, Long.MAX_VALUE, resetSequenceNumber).map((Function1 & Serializable)x$2 -> Done$.MODULE$, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> deleteAllEvents(Seq<String> persistenceIds, boolean resetSequenceNumber) {
        return this.foreach(persistenceIds, "deleteAllEvents", (Function1<String, Future<Done>>)(Function1 & Serializable)pid -> this.deleteAllEvents((String)pid, resetSequenceNumber));
    }

    public Future<Done> deleteSnapshot(String persistenceId) {
        return this.snapshotDao().delete(persistenceId, new SnapshotSelectionCriteria(Long.MAX_VALUE, SnapshotSelectionCriteria$.MODULE$.apply$default$2(), SnapshotSelectionCriteria$.MODULE$.apply$default$3(), SnapshotSelectionCriteria$.MODULE$.apply$default$4())).map((Function1 & Serializable)x$3 -> Done$.MODULE$, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> deleteSnapshots(Seq<String> persistenceIds) {
        return this.foreach(persistenceIds, "deleteSnapshots", (Function1<String, Future<Done>>)(Function1 & Serializable)pid -> this.deleteSnapshot((String)pid));
    }

    public Future<Done> cleanupBeforeSnapshot(String persistenceId) {
        return this.snapshotDao().load(persistenceId, SnapshotSelectionCriteria$.MODULE$.Latest()).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                SnapshotDao.SerializedSnapshotRow snapshot = (SnapshotDao.SerializedSnapshotRow)some.value();
                return this.deleteEventsTo(persistenceId, snapshot.seqNr());
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> cleanupBeforeSnapshot(Seq<String> persistenceIds) {
        return this.foreach(persistenceIds, "cleanupBeforeSnapshot", (Function1<String, Future<Done>>)(Function1 & Serializable)pid -> this.cleanupBeforeSnapshot((String)pid));
    }

    public Future<Done> deleteAll(String persistenceId, boolean resetSequenceNumber) {
        return this.deleteAllEvents(persistenceId, resetSequenceNumber).flatMap((Function1 & Serializable)x$5 -> {
            Done done = x$5;
            return this.deleteSnapshot(persistenceId).map((Function1 & Serializable)x$4 -> {
                Done done = x$4;
                return Done$.MODULE$;
            }, (ExecutionContext)this.system().executionContext());
        }, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> deleteAll(Seq<String> persistenceIds, boolean resetSequenceNumber) {
        return this.foreach(persistenceIds, "deleteAll", (Function1<String, Future<Done>>)(Function1 & Serializable)pid -> this.deleteAll((String)pid, resetSequenceNumber));
    }

    private Future<Done> foreach(Seq<String> persistenceIds, String operationName, Function1<String, Future<Done>> pidOperation) {
        int size = persistenceIds.size();
        this.log().info("Cleanup started {} of [{}] persistenceId.", (Object)operationName, (Object)BoxesRunTime.boxToInteger((int)size));
        Future result = this.loop$1(persistenceIds.toList(), 1, pidOperation, operationName, size);
        result.onComplete((Function1 & Serializable)x0$1 -> {
            EventSourcedCleanup.$anonfun$foreach$2(this, operationName, size, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.system().executionContext());
        return result;
    }

    private final Future loop$1(List remaining, int n, Function1 pidOperation$1, String operationName$1, int size$1) {
        List list = remaining;
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String pid = (String)colon2.head();
            List tail = colon2.next$access$1();
            return ((Future)pidOperation$1.apply((Object)pid)).flatMap((Function1 & Serializable)x$6 -> {
                block0: {
                    if (n % this.settings().cleanupSettings().logProgressEvery() != 0) break block0;
                    package.LoggerOps$.MODULE$.infoN$extension(package$.MODULE$.LoggerOps(this.log()), "Cleanup {} [{}] of [{}].", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{operationName$1, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)size$1)}));
                }
                return this.loop$1(tail, n + 1, pidOperation$1, operationName$1, size$1);
            }, (ExecutionContext)this.system().executionContext());
        }
        throw new MatchError((Object)list);
    }

    public static final /* synthetic */ void $anonfun$foreach$2(EventSourcedCleanup $this, String operationName$1, int size$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            package.LoggerOps$.MODULE$.info2$extension(package$.MODULE$.LoggerOps($this.log()), "Cleanup completed {} of [{}] persistenceId.", (Object)operationName$1, (Object)BoxesRunTime.boxToInteger((int)size$1));
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.log().error(new StringBuilder(18).append("Cleanup {").append(operationName$1).append("} failed.").toString(), e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public EventSourcedCleanup(ClassicActorSystemProvider systemProvider, String configPath) {
        this.system = package.ClassicActorSystemOps$.MODULE$.toTyped$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.ClassicActorSystemOps(systemProvider.classicSystem()));
        this.log = LoggerFactory.getLogger(EventSourcedCleanup.class);
        this.sharedConfigPath = configPath.replaceAll("\\.cleanup$", "");
        this.settings = R2dbcSettings$.MODULE$.apply(this.system().settings().config().getConfig(this.sharedConfigPath()));
        this.connectionFactory = ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(this.system())).connectionFactoryFor(new StringBuilder(19).append(this.sharedConfigPath()).append(".connection-factory").toString());
        this.journalDao = new JournalDao(this.settings(), this.connectionFactory(), (ExecutionContext)this.system().executionContext(), this.system());
        this.snapshotDao = new SnapshotDao(this.settings(), this.connectionFactory(), (ExecutionContext)this.system().executionContext(), this.system());
    }

    public EventSourcedCleanup(ClassicActorSystemProvider systemProvider) {
        this(systemProvider, "akka.persistence.r2dbc.cleanup");
    }
}

