/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.internal;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Extension;
import akka.actor.typed.ExtensionId;
import akka.actor.typed.pubsub.Topic;
import akka.actor.typed.pubsub.Topic$;
import akka.annotation.InternalApi;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.Tagged;
import akka.persistence.query.Offset;
import akka.persistence.query.TimestampOffset;
import akka.persistence.query.typed.EventEnvelope;
import akka.persistence.r2dbc.PublishEventsDynamicSettings;
import akka.persistence.r2dbc.internal.EWMA;
import akka.persistence.r2dbc.internal.EWMA$;
import akka.persistence.r2dbc.internal.EnvelopeOrigin$;
import akka.persistence.r2dbc.internal.PubSub$;
import akka.persistence.typed.PersistenceId$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tesAB\u0012%\u0011\u0003QCF\u0002\u0004/I!\u0005!f\f\u0005\u0007)\u0006!\tA!\b\t\u0013\t}\u0011A1A\u0005\n\t\u0005\u0002\u0002\u0003B\u001a\u0003\u0001\u0006IAa\t\t\u000f\tU\u0012\u0001\"\u0001\u00038!9!QI\u0001\u0005\u0002\t\u001dc!\u0002\u0018%\u0001)J\u0004\u0002C\"\b\u0005\u0003\u0005\u000b\u0011B#\t\u000bQ;A\u0011A+\t\u000fm;!\u0019!C\u00059\"1Qo\u0002Q\u0001\nuCqA^\u0004C\u0002\u0013%q\u000f\u0003\u0004}\u000f\u0001\u0006I\u0001\u001f\u0005\b{\u001e\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t9a\u0002Q\u0001\n}D\u0011\"!\u0003\b\u0005\u0004%I!a\u0003\t\u0011\u0005=r\u0001)A\u0005\u0003\u001bA\u0011\"!\r\b\u0005\u0004%I!a\r\t\u0011\u0005ur\u0001)A\u0005\u0003kA\u0011\"a\u0010\b\u0005\u0004%I!!\u0011\t\u0011\u0005%s\u0001)A\u0005\u0003\u0007B\u0011\"a\u0013\b\u0005\u0004%I!!\u0014\t\u0011\u0005Us\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\b\u0005\u0004%I!!\u0017\t\u0011\u0005ms\u0001)A\u0005\u0003oA\u0011\"!\u0018\b\u0005\u0004%I!a\u0018\t\u0011\u00055t\u0001)A\u0005\u0003CB\u0011\"a\u001c\b\u0001\u0004%I!!\u001d\t\u0013\u0005et\u00011A\u0005\n\u0005m\u0004\u0002CAD\u000f\u0001\u0006K!a\u001d\t\u000f\u0005Eu\u0001\"\u0001\u0002\u0014\"9\u0011\u0011Z\u0004\u0005\u0002\u0005-\u0007bBAu\u000f\u0011%\u00111\u001e\u0005\b\u0003c<A\u0011AAz\u0003\u0019\u0001VOY*vE*\u0011QEJ\u0001\tS:$XM\u001d8bY*\u0011q\u0005K\u0001\u0006eJ\"'m\u0019\u0006\u0003S)\n1\u0002]3sg&\u001cH/\u001a8dK*\t1&\u0001\u0003bW.\f\u0007CA\u0017\u0002\u001b\u0005!#A\u0002)vEN+(m\u0005\u0002\u0002aA\u0019\u0011G\u000e\u001d\u000e\u0003IR!a\r\u001b\u0002\u000bQL\b/\u001a3\u000b\u0005UR\u0013!B1di>\u0014\u0018BA\u001c3\u0005-)\u0005\u0010^3og&|g.\u00133\u0011\u00055:1cA\u0004;\u0001B\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\u0004\"!M!\n\u0005\t\u0013$!C#yi\u0016t7/[8o\u0003\u0019\u0019\u0018p\u001d;f[\u000e\u0001\u0001G\u0001$L!\r\tt)S\u0005\u0003\u0011J\u00121\"Q2u_J\u001c\u0016p\u001d;f[B\u0011!j\u0013\u0007\u0001\t%a\u0005\"!A\u0001\u0002\u000b\u0005QJA\u0002`IM\n\"AT)\u0011\u0005mz\u0015B\u0001)=\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u000f*\n\u0005Mc$aA!os\u00061A(\u001b8jiz\"\"\u0001\u000f,\t\u000b\rK\u0001\u0019A,1\u0005aS\u0006cA\u0019H3B\u0011!J\u0017\u0003\n\u0019Z\u000b\t\u0011!A\u0003\u00025\u000ba\u0001^8qS\u000e\u001cX#A/\u0011\ty+wM]\u0007\u0002?*\u0011\u0001-Y\u0001\u000bG>t7-\u001e:sK:$(B\u00012d\u0003\u0011)H/\u001b7\u000b\u0003\u0011\fAA[1wC&\u0011am\u0018\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u00015p\u001d\tIW\u000e\u0005\u0002ky5\t1N\u0003\u0002m\t\u00061AH]8pizJ!A\u001c\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]r\u00022!M:R\u0013\t!(G\u0001\u0005BGR|'OU3g\u0003\u001d!x\u000e]5dg\u0002\na\u0002]3sg&\u001cH/\u001a8dK\u0016CH/F\u0001y!\tI(0D\u0001)\u0013\tY\bFA\u0006QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u00049feNL7\u000f^3oG\u0016,\u0005\u0010\u001e\u0011\u0002\u0011M,G\u000f^5oON,\u0012a \t\u0005\u0003\u0003\t\u0019!D\u0001'\u0013\r\t)A\n\u0002\u001d!V\u0014G.[:i\u000bZ,g\u000e^:Es:\fW.[2TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0006tY&\u001cWMU1oO\u0016\u001cXCAA\u0007!\u0019\ty!!\u0007\u0002\u001e5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0005j[6,H/\u00192mK*\u0019\u0011q\u0003\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001c\u0005E!AC%oI\u0016DX\rZ*fcB!\u0011qDA\u0015\u001d\u0011\t\t#!\n\u000f\u0007)\f\u0019#C\u0001>\u0013\r\t9\u0003P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY#!\f\u0003\u000bI\u000bgnZ3\u000b\u0007\u0005\u001dB(\u0001\u0007tY&\u001cWMU1oO\u0016\u001c\b%\u0001\ttY&\u001cWMU1oO\u0016dun\\6vaV\u0011\u0011Q\u0007\t\u0007=\u0016\f9$!\b\u0011\u0007m\nI$C\u0002\u0002<q\u00121!\u00138u\u0003E\u0019H.[2f%\u0006tw-\u001a'p_.,\b\u000fI\u0001 i\"\u0014x.^4iaV$8i\u001c7mK\u000e$\u0018J\u001c;feZ\fG.T5mY&\u001cXCAA\"!\rY\u0014QI\u0005\u0004\u0003\u000fb$\u0001\u0002'p]\u001e\f\u0001\u0005\u001e5s_V<\u0007\u000e];u\u0007>dG.Z2u\u0013:$XM\u001d<bY6KG\u000e\\5tA\u0005\u0019B\u000f\u001b:pk\u001eD\u0007/\u001e;UQJ,7\u000f[8mIV\u0011\u0011q\n\t\u0004w\u0005E\u0013bAA*y\t1Ai\\;cY\u0016\fA\u0003\u001e5s_V<\u0007\u000e];u)\"\u0014Xm\u001d5pY\u0012\u0004\u0013!\u0005;ie>,x\r\u001b9viN\u000bW\u000e\u001d7feV\u0011\u0011qG\u0001\u0013i\"\u0014x.^4iaV$8+Y7qY\u0016\u0014\b%A\tuQJ|Wo\u001a5qkR\u001cu.\u001e8uKJ,\"!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a`\u0003\u0019\tGo\\7jG&!\u00111NA3\u0005)\tEo\\7jG2{gnZ\u0001\u0013i\"\u0014x.^4iaV$8i\\;oi\u0016\u0014\b%\u0001\u0006uQJ|Wo\u001a5qkR,\"!a\u001d\u0011\u00075\n)(C\u0002\u0002x\u0011\u0012A!R,N\u0003\u0006qA\u000f\u001b:pk\u001eD\u0007/\u001e;`I\u0015\fH\u0003BA?\u0003\u0007\u00032aOA@\u0013\r\t\t\t\u0010\u0002\u0005+:LG\u000fC\u0005\u0002\u0006v\t\t\u00111\u0001\u0002t\u0005\u0019\u0001\u0010J\u0019\u0002\u0017QD'o\\;hQB,H\u000f\t\u0015\u0004=\u0005-\u0005cA\u001e\u0002\u000e&\u0019\u0011q\u0012\u001f\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001a<f]R$v\u000e]5d+\u0011\t)*!0\u0015\r\u0005]\u0015\u0011YAc!\u0011\t4/!'\u0011\r\u0005m\u0015qUAW\u001d\u0011\ti*a)\u000e\u0005\u0005}%bAAQe\u00051\u0001/\u001e2tk\nLA!!*\u0002 \u0006)Ak\u001c9jG&!\u0011\u0011VAV\u0005\u001d\u0019u.\\7b]\u0012TA!!*\u0002 B1\u0011qVA\\\u0003wk!!!-\u000b\u0007M\n\u0019LC\u0002\u00026\"\nQ!];fefLA!!/\u00022\niQI^3oi\u0016sg/\u001a7pa\u0016\u00042ASA_\t\u0019\tyl\bb\u0001\u001b\n)QI^3oi\"1\u00111Y\u0010A\u0002\u001d\f!\"\u001a8uSRLH+\u001f9f\u0011\u001d\t9m\ba\u0001\u0003o\tQa\u001d7jG\u0016\f1\"\u001a<f]R$v\u000e]5dgV!\u0011QZAo)!\ty-a8\u0002b\u0006\u0015\b#\u00025\u0002R\u0006U\u0017bAAjc\n\u00191+\u001a;\u0011\tE\u001a\u0018q\u001b\t\u0007\u00037\u000b9+!7\u0011\r\u0005=\u0016qWAn!\rQ\u0015Q\u001c\u0003\u0007\u0003\u007f\u0003#\u0019A'\t\r\u0005\r\u0007\u00051\u0001h\u0011\u001d\t\u0019\u000f\ta\u0001\u0003o\t\u0001\"\\5o'2L7-\u001a\u0005\b\u0003O\u0004\u0003\u0019AA\u001c\u0003!i\u0017\r_*mS\u000e,\u0017!\u0003;pa&\u001cg*Y7f)\u00159\u0017Q^Ax\u0011\u0019\t\u0019-\ta\u0001O\"9\u0011qY\u0011A\u0002\u0005]\u0012a\u00029vE2L7\u000f\u001b\u000b\u0007\u0003{\n)0a@\t\u000f\u0005](\u00051\u0001\u0002z\u0006\u0011\u0001O\u001d\t\u0004s\u0006m\u0018bAA\u007fQ\tq\u0001+\u001a:tSN$XM\u001c;SKB\u0014\bb\u0002B\u0001E\u0001\u0007!1A\u0001\ni&lWm\u001d;b[B\u0004BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u0013\u0019\u0017\u0001\u0002;j[\u0016LAA!\u0004\u0003\b\t9\u0011J\\:uC:$\bfA\u0004\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018)\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YB!\u0006\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u000b\u0002Y\u0005\u0019An\\4\u0016\u0005\t\r\u0002\u0003\u0002B\u0013\u0005_i!Aa\n\u000b\t\t%\"1F\u0001\u0006g24GG\u001b\u0006\u0003\u0005[\t1a\u001c:h\u0013\u0011\u0011\tDa\n\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u001f\r\u0014X-\u0019;f\u000bb$XM\\:j_:$2\u0001\u000fB\u001d\u0011\u0019\u0019U\u00011\u0001\u0003<A\"!Q\bB!!\u0011\ttIa\u0010\u0011\u0007)\u0013\t\u0005B\u0006\u0003D\te\u0012\u0011!A\u0001\u0006\u0003i%aA0%c\u0005\u0019q-\u001a;\u0015\u0007a\u0012I\u0005\u0003\u0004D\r\u0001\u0007!1\n\u0019\u0005\u0005\u001b\u0012\t\u0006\u0005\u00032\u000f\n=\u0003c\u0001&\u0003R\u0011Y!1\u000bB%\u0003\u0003\u0005\tQ!\u0001N\u0005\ryFE\r\u0015\u0004\u0003\tE\u0001f\u0001\u0001\u0003\u0012\u0001")
@InternalApi
public class PubSub
implements Extension {
    private final ActorSystem<?> system;
    private final ConcurrentHashMap<String, ActorRef<Object>> topics;
    private final Persistence persistenceExt;
    private final PublishEventsDynamicSettings settings;
    private final IndexedSeq<Range> sliceRanges;
    private final ConcurrentHashMap<Object, Range> sliceRangeLookup;
    private final long throughputCollectIntervalMillis;
    private final double throughputThreshold;
    private final int throughputSampler;
    private final AtomicLong throughputCounter;
    private volatile EWMA throughput;

    public static PubSub get(ActorSystem<?> system) {
        return PubSub$.MODULE$.get(system);
    }

    public static PubSub createExtension(ActorSystem<?> system) {
        return PubSub$.MODULE$.createExtension((ActorSystem)system);
    }

    public static ExtensionId<PubSub> id() {
        return PubSub$.MODULE$.id();
    }

    public static Extension apply(ActorSystem system) {
        return PubSub$.MODULE$.apply(system);
    }

    private ConcurrentHashMap<String, ActorRef<Object>> topics() {
        return this.topics;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private PublishEventsDynamicSettings settings() {
        return this.settings;
    }

    private IndexedSeq<Range> sliceRanges() {
        return this.sliceRanges;
    }

    private ConcurrentHashMap<Object, Range> sliceRangeLookup() {
        return this.sliceRangeLookup;
    }

    private long throughputCollectIntervalMillis() {
        return this.throughputCollectIntervalMillis;
    }

    private double throughputThreshold() {
        return this.throughputThreshold;
    }

    private int throughputSampler() {
        return this.throughputSampler;
    }

    private AtomicLong throughputCounter() {
        return this.throughputCounter;
    }

    private EWMA throughput() {
        return this.throughput;
    }

    private void throughput_$eq(EWMA x$1) {
        this.throughput = x$1;
    }

    public <Event> ActorRef<Topic.Command<EventEnvelope<Event>>> eventTopic(String entityType, int slice) {
        String name = this.topicName(entityType, slice);
        return this.topics().computeIfAbsent(name, x$1 -> $this.system.systemActorOf(Topic$.MODULE$.apply(name, ClassTag$.MODULE$.apply(EventEnvelope.class)), name, $this.system.systemActorOf$default$3()).unsafeUpcast()).narrow();
    }

    public <Event> Set<ActorRef<Topic.Command<EventEnvelope<Event>>>> eventTopics(String entityType, int minSlice, int maxSlice) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(minSlice), maxSlice).map((Function1 & Serializable)x$2 -> this.eventTopic(entityType, BoxesRunTime.unboxToInt((Object)x$2))).toSet();
    }

    private String topicName(String entityType, int slice) {
        Range range = this.sliceRangeLookup().computeIfAbsent(BoxesRunTime.boxToInteger((int)slice), x$3 -> PubSub.$anonfun$topicName$1(this, slice, BoxesRunTime.unboxToInt((Object)x$3)));
        return URLEncoder.encode(new StringBuilder(8).append("r2dbc-").append(entityType).append("-").append(range.min((Ordering)Ordering.Int$.MODULE$)).append("-").append(range.max((Ordering)Ordering.Int$.MODULE$)).toString(), StandardCharsets.UTF_8.name());
    }

    public void publish(PersistentRepr pr, Instant timestamp) {
        long n = this.throughputCounter().incrementAndGet();
        if (n % (long)this.throughputSampler() == 0L) {
            EWMA ewma = this.throughput();
            long durationMillis = (System.nanoTime() - ewma.nanoTime()) / 1000L / 1000L;
            if (durationMillis >= this.throughputCollectIntervalMillis()) {
                this.throughputCounter().set(0L);
                double rps = (double)n * 1000.0 / (double)durationMillis;
                EWMA newEwma = ewma.$colon$plus(rps);
                this.throughput_$eq(newEwma);
                if (ewma.value() < this.throughputThreshold() && newEwma.value() >= this.throughputThreshold()) {
                    PubSub$.MODULE$.akka$persistence$r2dbc$internal$PubSub$$log().info("Disabled publishing of events. Throughput greater than [{}] events/s", (Object)BoxesRunTime.boxToDouble((double)this.throughputThreshold()));
                } else if (ewma.value() >= this.throughputThreshold() && newEwma.value() < this.throughputThreshold()) {
                    PubSub$.MODULE$.akka$persistence$r2dbc$internal$PubSub$$log().info("Enabled publishing of events. Throughput less than [{}] events/s", (Object)BoxesRunTime.boxToDouble((double)this.throughputThreshold()));
                } else {
                    PubSub$.MODULE$.akka$persistence$r2dbc$internal$PubSub$$log().debug("Publishing of events is {}. Throughput is [{}] events/s", (Object)(newEwma.value() < this.throughputThreshold() ? "enabled" : "disabled"), (Object)BoxesRunTime.boxToDouble((double)newEwma.value()));
                }
            }
        }
        if (this.throughput().value() < this.throughputThreshold()) {
            Tuple2 tuple2;
            Tuple2 tuple22;
            String pid = pr.persistenceId();
            String entityType = PersistenceId$.MODULE$.extractEntityType(pid);
            int slice = this.persistenceExt().sliceForPersistenceId(pid);
            TimestampOffset offset = new TimestampOffset(timestamp, timestamp, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pid), (Object)BoxesRunTime.boxToLong((long)pr.sequenceNr()))})));
            Object object = pr.payload();
            if (object instanceof Tagged) {
                Tagged tagged = (Tagged)object;
                Object payload = tagged.payload();
                Set tags = tagged.tags();
                tuple22 = new Tuple2(payload, (Object)tags);
            } else {
                tuple22 = tuple2 = new Tuple2(object, (Object)Predef$.MODULE$.Set().empty());
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object event = tuple2._1();
            Set tags = (Set)tuple2._2();
            Tuple2 tuple23 = new Tuple2(event, (Object)tags);
            Object event2 = tuple23._1();
            Set tags2 = (Set)tuple23._2();
            EventEnvelope envelope = new EventEnvelope((Offset)offset, pid, pr.sequenceNr(), Option$.MODULE$.apply(event2), timestamp.toEpochMilli(), pr.metadata(), entityType, slice, false, EnvelopeOrigin$.MODULE$.SourcePubSub(), tags2);
            ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(this.eventTopic(entityType, slice)), (Object)Topic.Publish$.MODULE$.apply((Object)envelope));
            return;
        }
    }

    public static final /* synthetic */ Range $anonfun$topicName$1(PubSub $this, int slice$1, int x$3) {
        return (Range)$this.sliceRanges().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(slice$1))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(37).append("Slice [").append(slice$1).append("] not found in ").append("slice ranges [").append($this.sliceRanges().mkString(", ")).append("]").toString());
        });
    }

    public PubSub(ActorSystem<?> system) {
        this.system = system;
        this.topics = new ConcurrentHashMap();
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.settings = new PublishEventsDynamicSettings(system.settings().config().getConfig("akka.persistence.r2dbc.journal.publish-events-dynamic"));
        int numberOfTopics = system.settings().config().getInt("akka.persistence.r2dbc.journal.publish-events-number-of-topics");
        this.sliceRanges = this.persistenceExt().sliceRanges(numberOfTopics);
        this.sliceRangeLookup = new ConcurrentHashMap();
        this.throughputCollectIntervalMillis = this.settings().throughputCollectInterval().toMillis();
        this.throughputThreshold = this.settings().throughputThreshold();
        this.throughputSampler = package$.MODULE$.min(1000, package$.MODULE$.max(1, this.settings().throughputThreshold() / 10));
        this.throughputCounter = new AtomicLong();
        this.throughput = new EWMA(0.0, EWMA$.MODULE$.alpha(this.settings().throughputCollectInterval().$times(2L), this.settings().throughputCollectInterval()));
    }
}

