/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.journal;

import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.package;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.PayloadCodec;
import akka.persistence.r2dbc.internal.PayloadCodec$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.journal.JournalDao$;
import akka.persistence.typed.PersistenceId$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011-ua\u0002?~\u0011\u0003y\u00181\u0002\u0004\t\u0003\u001fi\b\u0012A@\u0002\u0012!9\u0011qD\u0001\u0005\u0002\u0005\r\u0002\"CA\u0013\u0003\t\u0007I\u0011AA\u0014\u0011!\tI$\u0001Q\u0001\n\u0005%\u0002\"CA\u001e\u0003\t\u0007I\u0011AA\u001f\u0011!\ty%\u0001Q\u0001\n\u0005}bABA)\u0003\t\u000b\u0019\u0006\u0003\u0006\u0002\b\u001e\u0011)\u001a!C\u0001\u0003\u0013C!\"!%\b\u0005#\u0005\u000b\u0011BAF\u0011)\t\u0019j\u0002BK\u0002\u0013\u0005\u0011Q\u0013\u0005\u000b\u0003O;!\u0011#Q\u0001\n\u0005]\u0005BCAU\u000f\tU\r\u0011\"\u0001\u0002\u0016\"Q\u00111V\u0004\u0003\u0012\u0003\u0006I!a&\t\u0015\u00055vA!f\u0001\n\u0003\ty\u000b\u0003\u0006\u00028\u001e\u0011\t\u0012)A\u0005\u0003cC!\"!/\b\u0005+\u0007I\u0011AA\u001f\u0011)\tYl\u0002B\tB\u0003%\u0011q\b\u0005\u000b\u0003{;!Q3A\u0005\u0002\u0005u\u0002BCA`\u000f\tE\t\u0015!\u0003\u0002@!Q\u0011\u0011Y\u0004\u0003\u0016\u0004%\t!a1\t\u0015\u0005]wA!E!\u0002\u0013\t)\r\u0003\u0006\u0002Z\u001e\u0011)\u001a!C\u0001\u0003\u0013C!\"a7\b\u0005#\u0005\u000b\u0011BAF\u0011)\tin\u0002BK\u0002\u0013\u0005\u0011Q\u0013\u0005\u000b\u0003?<!\u0011#Q\u0001\n\u0005]\u0005BCAq\u000f\tU\r\u0011\"\u0001\u0002\u0016\"Q\u00111]\u0004\u0003\u0012\u0003\u0006I!a&\t\u0015\u0005\u0015xA!f\u0001\n\u0003\t9\u000f\u0003\u0006\u0002p\u001e\u0011\t\u0012)A\u0005\u0003SD!\"!=\b\u0005+\u0007I\u0011AAz\u0011)\u0011)i\u0002B\tB\u0003%\u0011Q\u001f\u0005\b\u0003?9A\u0011\u0001BD\u0011%\u0011IaBA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0003\u0014\u001d\t\n\u0011\"\u0001\u0003\u0016!I!1F\u0004\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c9\u0011\u0013!C\u0001\u0005[A\u0011B!0\b#\u0003%\tAa0\t\u0013\t\rw!%A\u0005\u0002\t\u0015\u0007\"\u0003Be\u000fE\u0005I\u0011\u0001Bc\u0011%\u0011YmBI\u0001\n\u0003\u0011i\rC\u0005\u0003R\u001e\t\n\u0011\"\u0001\u0003\u0016!I!1[\u0004\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005+<\u0011\u0013!C\u0001\u0005[A\u0011Ba6\b#\u0003%\tA!7\t\u0013\tuw!%A\u0005\u0002\t}\u0007\"\u0003B\u001c\u000f\u0005\u0005I\u0011\tB\u001d\u0011%\u0011)eBA\u0001\n\u0003\tI\tC\u0005\u0003H\u001d\t\t\u0011\"\u0001\u0003d\"I!QK\u0004\u0002\u0002\u0013\u0005#q\u000b\u0005\n\u0005K:\u0011\u0011!C\u0001\u0005OD\u0011B!\u001d\b\u0003\u0003%\tEa;\t\u0013\t]t!!A\u0005B\te\u0004\"\u0003B>\u000f\u0005\u0005I\u0011\tB?\u0011%\u0011yhBA\u0001\n\u0003\u0012yoB\u0005\u0003t\u0006\t\t\u0011#\u0001\u0003v\u001aI\u0011\u0011K\u0001\u0002\u0002#\u0005!q\u001f\u0005\b\u0003?AD\u0011AB\b\u0011%\u0011Y\bOA\u0001\n\u000b\u0012i\bC\u0005\u0004\u0012a\n\t\u0011\"!\u0004\u0014!I1Q\u0006\u001d\u0002\u0002\u0013\u00055q\u0006\u0005\n\u0007{A\u0014\u0011!C\u0005\u0007\u007f1a!a?\u0002\u0005\u0006u\bBCAm}\tU\r\u0011\"\u0001\u0002\n\"Q\u00111\u001c \u0003\u0012\u0003\u0006I!a#\t\u0015\u0005ugH!f\u0001\n\u0003\t)\n\u0003\u0006\u0002`z\u0012\t\u0012)A\u0005\u0003/C!\"!1?\u0005+\u0007I\u0011AA\u0000\u0011)\t9N\u0010B\tB\u0003%\u00111\u001a\u0005\b\u0003?qD\u0011\u0001B\u0001\u0011%\u0011IAPA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0014y\n\n\u0011\"\u0001\u0003\u0016!I!1\u0006 \u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005cq\u0014\u0013!C\u0001\u0005gA\u0011Ba\u000e?\u0003\u0003%\tE!\u000f\t\u0013\t\u0015c(!A\u0005\u0002\u0005%\u0005\"\u0003B$}\u0005\u0005I\u0011\u0001B%\u0011%\u0011)FPA\u0001\n\u0003\u00129\u0006C\u0005\u0003fy\n\t\u0011\"\u0001\u0003h!I!\u0011\u000f \u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005or\u0014\u0011!C!\u0005sB\u0011Ba\u001f?\u0003\u0003%\tE! \t\u0013\t}d(!A\u0005B\t\u0005u!CB$\u0003\u0005\u0005\t\u0012AB%\r%\tY0AA\u0001\u0012\u0003\u0019Y\u0005C\u0004\u0002 Q#\taa\u0015\t\u0013\tmD+!A\u0005F\tu\u0004\"CB\t)\u0006\u0005I\u0011QB+\u0011%\u0019i\u0003VA\u0001\n\u0003\u001bi\u0006C\u0005\u0004>Q\u000b\t\u0011\"\u0003\u0004@!91\u0011N\u0001\u0005\u0002\r-daBA\b{\u0002y8q\u0012\u0005\u000b\u0007#[&\u0011!Q\u0001\n\rM\u0005BCBN7\n\u0005\t\u0015!\u0003\u0004\u001e\"Q11U.\u0003\u0002\u0003\u0006Ya!*\t\u0015\rE6L!A!\u0002\u0017\u0019\u0019\fC\u0004\u0002 m#\ta!6\t\u0013\r-8L1A\u0005\n\r5\b\u0002CB|7\u0002\u0006Iaa<\t\u0013\re8L1A\u0005\n\rm\b\u0002\u0003C\u00027\u0002\u0006Ia!@\t\u0013\u0011\u00151L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00047\u0002\u0006I!a&\t\u0013\u0011%1L1A\u0005\f\u0011-\u0001\u0002\u0003C\n7\u0002\u0006I\u0001\"\u0004\t\u0019\tM3\f%A\u0001\u0004\u0003\u0006I\u0001\"\u0006\t\u0013\u0011m1L1A\u0005\n\u0005U\u0005\u0002\u0003C\u000f7\u0002\u0006I!a&\t\u0013\u0011}1L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00117\u0002\u0006I!a&\t\u0013\u0011\r2L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00137\u0002\u0006I!a&\t\u0013\u0011\u001d2L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00157\u0002\u0006I!a&\t\u0013\u0011-2L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00177\u0002\u0006I!a&\t\u0013\u0011=2L1A\u0005\n\u0005U\u0005\u0002\u0003C\u00197\u0002\u0006I!a&\t\u000f\u0011M2\f\"\u0001\u00056!9A1J.\u0005\u0002\u00115\u0003b\u0002C,7\u0012\u0005A\u0011\f\u0005\b\t;ZF\u0011\u0002C0\u0011\u001d!9g\u0017C\u0005\tSBq\u0001\"\u001e\\\t\u0003!9(\u0001\u0006K_V\u0014h.\u00197EC>T!A`@\u0002\u000f)|WO\u001d8bY*!\u0011\u0011AA\u0002\u0003\u0015\u0011(\u0007\u001a2d\u0015\u0011\t)!a\u0002\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u0003\u0013\tA!Y6lCB\u0019\u0011QB\u0001\u000e\u0003u\u0014!BS8ve:\fG\u000eR1p'\r\t\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0011\u0011\u0011D\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003;\t9B\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\u0011\u00111B\u0001\u0004Y><WCAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tQa\u001d7gi)T!!a\r\u0002\u0007=\u0014x-\u0003\u0003\u00028\u00055\"A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013\u0001E#naRLHI\u0019+j[\u0016\u001cH/Y7q+\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\tQLW.\u001a\u0006\u0003\u0003\u0013\nAA[1wC&!\u0011QJA\"\u0005\u001dIen\u001d;b]R\f\u0011#R7qif$%\rV5nKN$\u0018-\u001c9!\u0005Q\u0019VM]5bY&TX\r\u001a&pkJt\u0017\r\u001c*poNIq!a\u0005\u0002V\u0005%\u0014q\u000e\t\u0005\u0003/\n\u0019G\u0004\u0003\u0002Z\u0005}SBAA.\u0015\r\tif`\u0001\tS:$XM\u001d8bY&!\u0011\u0011MA.\u00031\u0011\u0015p\u00157jG\u0016\fV/\u001a:z\u0013\u0011\t)'a\u001a\u0003\u001bM+'/[1mSj,GMU8x\u0015\u0011\t\t'a\u0017\u0011\t\u0005U\u00111N\u0005\u0005\u0003[\n9BA\u0004Qe>$Wo\u0019;\u0011\t\u0005E\u0014\u0011\u0011\b\u0005\u0003g\niH\u0004\u0003\u0002v\u0005mTBAA<\u0015\u0011\tI(!\t\u0002\rq\u0012xn\u001c;?\u0013\t\tI\"\u0003\u0003\u0002\u0000\u0005]\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0003\u0002\u0000\u0005]\u0011!B:mS\u000e,WCAAF!\u0011\t)\"!$\n\t\u0005=\u0015q\u0003\u0002\u0004\u0013:$\u0018AB:mS\u000e,\u0007%\u0001\u0006f]RLG/\u001f+za\u0016,\"!a&\u0011\t\u0005e\u0015\u0011\u0015\b\u0005\u00037\u000bi\n\u0005\u0003\u0002v\u0005]\u0011\u0002BAP\u0003/\ta\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'\u0002BAP\u0003/\t1\"\u001a8uSRLH+\u001f9fA\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\fa\u0002]3sg&\u001cH/\u001a8dK&#\u0007%A\u0003tKFt%/\u0006\u0002\u00022B!\u0011QCAZ\u0013\u0011\t),a\u0006\u0003\t1{gnZ\u0001\u0007g\u0016\fhJ\u001d\u0011\u0002\u0017\u0011\u0014G+[7fgR\fW\u000e]\u0001\rI\n$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0010e\u0016\fG\r\u00122US6,7\u000f^1na\u0006\u0001\"/Z1e\t\n$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\ba\u0006LHn\\1e+\t\t)\r\u0005\u0004\u0002\u0016\u0005\u001d\u00171Z\u0005\u0005\u0003\u0013\f9B\u0001\u0004PaRLwN\u001c\t\u0007\u0003+\ti-!5\n\t\u0005=\u0017q\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003+\t\u0019.\u0003\u0003\u0002V\u0006]!\u0001\u0002\"zi\u0016\f\u0001\u0002]1zY>\fG\rI\u0001\u0006g\u0016\u0014\u0018\nZ\u0001\u0007g\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017M,'/T1oS\u001a,7\u000f^\u0001\rg\u0016\u0014X*\u00198jM\u0016\u001cH\u000fI\u0001\u000boJLG/\u001a:Vk&$\u0017aC<sSR,'/V;jI\u0002\nA\u0001^1hgV\u0011\u0011\u0011\u001e\t\u0007\u00033\u000bY/a&\n\t\u00055\u0018Q\u0015\u0002\u0004'\u0016$\u0018!\u0002;bON\u0004\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005U\bCBA\u000b\u0003\u000f\f9\u0010E\u0002\u0002zzj\u0011!\u0001\u0002\u0018'\u0016\u0014\u0018.\u00197ju\u0016$WI^3oi6+G/\u00193bi\u0006\u001crAPA\n\u0003S\ny'\u0006\u0002\u0002LRA\u0011q\u001fB\u0002\u0005\u000b\u00119\u0001C\u0004\u0002Z\u0016\u0003\r!a#\t\u000f\u0005uW\t1\u0001\u0002\u0018\"9\u0011\u0011Y#A\u0002\u0005-\u0017\u0001B2paf$\u0002\"a>\u0003\u000e\t=!\u0011\u0003\u0005\n\u000334\u0005\u0013!a\u0001\u0003\u0017C\u0011\"!8G!\u0003\u0005\r!a&\t\u0013\u0005\u0005g\t%AA\u0002\u0005-\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005/QC!a#\u0003\u001a-\u0012!1\u0004\t\u0005\u0005;\u00119#\u0004\u0002\u0003 )!!\u0011\u0005B\u0012\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003&\u0005]\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0006B\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yC\u000b\u0003\u0002\u0018\ne\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005kQC!a3\u0003\u001a\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u000f\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQAA!\u0011\u0002H\u0005!A.\u00198h\u0013\u0011\t\u0019Ka\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\nB)!\u0011\t)B!\u0014\n\t\t=\u0013q\u0003\u0002\u0004\u0003:L\b\"\u0003B*\u0019\u0006\u0005\t\u0019AAF\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\f\t\u0007\u00057\u0012\tGa\u0013\u000e\u0005\tu#\u0002\u0002B0\u0003/\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019G!\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005S\u0012y\u0007\u0005\u0003\u0002\u0016\t-\u0014\u0002\u0002B7\u0003/\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0003T9\u000b\t\u00111\u0001\u0003L\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011YD!\u001e\t\u0013\tMs*!AA\u0002\u0005-\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tm\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003j\t\r\u0005\"\u0003B*%\u0006\u0005\t\u0019\u0001B&\u0003%iW\r^1eCR\f\u0007\u0005\u0006\u000e\u0003\n\n-%Q\u0012BH\u0005#\u0013\u0019J!&\u0003\u0018\ne%1\u0014BO\u0005?\u0013\t\u000bE\u0002\u0002z\u001eAq!a\"!\u0001\u0004\tY\tC\u0004\u0002\u0014\u0002\u0002\r!a&\t\u000f\u0005%\u0006\u00051\u0001\u0002\u0018\"9\u0011Q\u0016\u0011A\u0002\u0005E\u0006bBA]A\u0001\u0007\u0011q\b\u0005\b\u0003{\u0003\u0003\u0019AA \u0011\u001d\t\t\r\ta\u0001\u0003\u000bDq!!7!\u0001\u0004\tY\tC\u0004\u0002^\u0002\u0002\r!a&\t\u000f\u0005\u0005\b\u00051\u0001\u0002\u0018\"9\u0011Q\u001d\u0011A\u0002\u0005%\bbBAyA\u0001\u0007\u0011Q\u001f\u000b\u001b\u0005\u0013\u0013)Ka*\u0003*\n-&Q\u0016BX\u0005c\u0013\u0019L!.\u00038\ne&1\u0018\u0005\n\u0003\u000f\u000b\u0003\u0013!a\u0001\u0003\u0017C\u0011\"a%\"!\u0003\u0005\r!a&\t\u0013\u0005%\u0016\u0005%AA\u0002\u0005]\u0005\"CAWCA\u0005\t\u0019AAY\u0011%\tI,\tI\u0001\u0002\u0004\ty\u0004C\u0005\u0002>\u0006\u0002\n\u00111\u0001\u0002@!I\u0011\u0011Y\u0011\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\n\u00033\f\u0003\u0013!a\u0001\u0003\u0017C\u0011\"!8\"!\u0003\u0005\r!a&\t\u0013\u0005\u0005\u0018\u0005%AA\u0002\u0005]\u0005\"CAsCA\u0005\t\u0019AAu\u0011%\t\t0\tI\u0001\u0002\u0004\t)0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005'\u0006BAY\u00053\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003H*\"\u0011q\bB\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003P*\"\u0011Q\u0019B\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa\nabY8qs\u0012\"WMZ1vYR$\u0013(A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\nTC\u0001BnU\u0011\tIO!\u0007\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cI*\"A!9+\t\u0005U(\u0011\u0004\u000b\u0005\u0005\u0017\u0012)\u000fC\u0005\u0003TA\n\t\u00111\u0001\u0002\fR!!\u0011\u000eBu\u0011%\u0011\u0019FMA\u0001\u0002\u0004\u0011Y\u0005\u0006\u0003\u0003<\t5\b\"\u0003B*g\u0005\u0005\t\u0019AAF)\u0011\u0011IG!=\t\u0013\tMc'!AA\u0002\t-\u0013\u0001F*fe&\fG.\u001b>fI*{WO\u001d8bYJ{w\u000fE\u0002\u0002zb\u001aR\u0001\u000fB}\u0007\u000b\u0001bDa?\u0004\u0002\u0005-\u0015qSAL\u0003c\u000by$a\u0010\u0002F\u0006-\u0015qSAL\u0003S\f)P!#\u000e\u0005\tu(\u0002\u0002B\u0000\u0003/\tqA];oi&lW-\u0003\u0003\u0004\u0004\tu(AE!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocI\u0002Baa\u0002\u0004\u000e5\u00111\u0011\u0002\u0006\u0005\u0007\u0017\t9%\u0001\u0002j_&!\u00111QB\u0005)\t\u0011)0A\u0003baBd\u0017\u0010\u0006\u000e\u0003\n\u000eU1qCB\r\u00077\u0019iba\b\u0004\"\r\r2QEB\u0014\u0007S\u0019Y\u0003C\u0004\u0002\bn\u0002\r!a#\t\u000f\u0005M5\b1\u0001\u0002\u0018\"9\u0011\u0011V\u001eA\u0002\u0005]\u0005bBAWw\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003s[\u0004\u0019AA \u0011\u001d\til\u000fa\u0001\u0003\u007fAq!!1<\u0001\u0004\t)\rC\u0004\u0002Zn\u0002\r!a#\t\u000f\u0005u7\b1\u0001\u0002\u0018\"9\u0011\u0011]\u001eA\u0002\u0005]\u0005bBAsw\u0001\u0007\u0011\u0011\u001e\u0005\b\u0003c\\\u0004\u0019AA{\u0003\u001d)h.\u00199qYf$Ba!\r\u0004:A1\u0011QCAd\u0007g\u0001B$!\u0006\u00046\u0005-\u0015qSAL\u0003c\u000by$a\u0010\u0002F\u0006-\u0015qSAL\u0003S\f)0\u0003\u0003\u00048\u0005]!a\u0002+va2,\u0017G\r\u0005\n\u0007wa\u0014\u0011!a\u0001\u0005\u0013\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\t\u0005\u0005\u0003\u0003>\r\r\u0013\u0002BB#\u0005\u007f\u0011aa\u00142kK\u000e$\u0018aF*fe&\fG.\u001b>fI\u00163XM\u001c;NKR\fG-\u0019;b!\r\tI\u0010V\n\u0006)\u000e53Q\u0001\t\r\u0005w\u001cy%a#\u0002\u0018\u0006-\u0017q_\u0005\u0005\u0007#\u0012iPA\tBEN$(/Y2u\rVt7\r^5p]N\"\"a!\u0013\u0015\u0011\u0005]8qKB-\u00077Bq!!7X\u0001\u0004\tY\tC\u0004\u0002^^\u0003\r!a&\t\u000f\u0005\u0005w\u000b1\u0001\u0002LR!1qLB4!\u0019\t)\"a2\u0004bAQ\u0011QCB2\u0003\u0017\u000b9*a3\n\t\r\u0015\u0014q\u0003\u0002\u0007)V\u0004H.Z\u001a\t\u0013\rm\u0002,!AA\u0002\u0005]\u0018\u0001\u0004:fC\u0012lU\r^1eCR\fG\u0003BA{\u0007[Bqaa\u001c[\u0001\u0004\u0019\t(A\u0002s_^\u0004Baa\u001d\u0004~5\u00111Q\u000f\u0006\u0005\u0007o\u001aI(A\u0002ta&TA!!\u0001\u0004|)\u001111B\u0005\u0005\u0007\u007f\u001a)HA\u0002S_^D3!ABB!\u0011\u0019)i!#\u000e\u0005\r\u001d%\u0002\u0002B\u0013\u0003\u000fIAaa#\u0004\b\nY\u0011J\u001c;fe:\fG.\u00119jQ\r\u000111Q\n\u00047\u0006M\u0011a\u00046pkJt\u0017\r\\*fiRLgnZ:\u0011\t\rU5qS\u0007\u0002\u007f&\u00191\u0011T@\u0003\u001bI\u0013DMY2TKR$\u0018N\\4t\u0003E\u0019wN\u001c8fGRLwN\u001c$bGR|'/\u001f\t\u0005\u0007g\u001ay*\u0003\u0003\u0004\"\u000eU$!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\u0006\u0011Qm\u0019\t\u0005\u0007O\u001bi+\u0004\u0002\u0004**!11VA\f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0007_\u001bIK\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u000611/_:uK6\u0004Da!.\u0004JB11qWBa\u0007\u000bl!a!/\u000b\t\rm6QX\u0001\u0006if\u0004X\r\u001a\u0006\u0005\u0007\u007f\u000b9!A\u0003bGR|'/\u0003\u0003\u0004D\u000ee&aC!di>\u00148+_:uK6\u0004Baa2\u0004J2\u0001AaCBf?\u0006\u0005\t\u0011!B\u0001\u0007\u001b\u00141a\u0018\u00132#\u0011\u0019yMa\u0013\u0011\t\u0005U1\u0011[\u0005\u0005\u0007'\f9BA\u0004O_RD\u0017N\\4\u0015\r\r]7q]Bu)\u0019\u0019Ina7\u0004^B\u0019\u0011QB.\t\u000f\r\r\u0006\rq\u0001\u0004&\"91\u0011\u00171A\u0004\r}\u0007\u0007BBq\u0007K\u0004baa.\u0004B\u000e\r\b\u0003BBd\u0007K$Aba3\u0004^\u0006\u0005\t\u0011!B\u0001\u0007\u001bDqa!%a\u0001\u0004\u0019\u0019\nC\u0004\u0004\u001c\u0002\u0004\ra!(\u0002\u001dA,'o]5ti\u0016t7-Z#yiV\u00111q\u001e\t\u0005\u0007c\u001c\u00190\u0004\u0002\u0002\u0004%!1Q_A\u0002\u0005-\u0001VM]:jgR,gnY3\u0002\u001fA,'o]5ti\u0016t7-Z#yi\u0002\nQB\u001d\u001aeE\u000e,\u00050Z2vi>\u0014XCAB\u007f!\u0011\tIfa@\n\t\u0011\u0005\u00111\f\u0002\u000e%J\"'mY#yK\u000e,Ho\u001c:\u0002\u001dI\u0014DMY2Fq\u0016\u001cW\u000f^8sA\u0005a!n\\;s]\u0006dG+\u00192mK\u0006i!n\\;s]\u0006dG+\u00192mK\u0002\n1C[8ve:\fG\u000eU1zY>\fGmQ8eK\u000e,\"\u0001\"\u0004\u0011\t\u0005eCqB\u0005\u0005\t#\tYF\u0001\u0007QCfdw.\u00193D_\u0012,7-\u0001\u000bk_V\u0014h.\u00197QCfdw.\u00193D_\u0012,7\r\t\t\t\u0003+!9\"a&\u0002\u0018&!A\u0011DA\f\u0005\u0019!V\u000f\u001d7fe\u0005!\u0013N\\:feR,e/\u001a8u/&$\b\u000eU1sC6,G/\u001a:US6,7\u000f^1naN\u000bH.A\u0013j]N,'\u000f^#wK:$x+\u001b;i!\u0006\u0014\u0018-\\3uKJ$\u0016.\\3ti\u0006l\u0007oU9mA\u00051\u0013N\\:feR,e/\u001a8u/&$\b\u000e\u0016:b]N\f7\r^5p]RKW.Z:uC6\u00048+\u001d7\u0002O%t7/\u001a:u\u000bZ,g\u000e^,ji\"$&/\u00198tC\u000e$\u0018n\u001c8US6,7\u000f^1naN\u000bH\u000eI\u0001\u001bg\u0016dWm\u0019;IS\u001eDWm\u001d;TKF,XM\\2f\u001dJ\u001c\u0016\u000f\\\u0001\u001cg\u0016dWm\u0019;IS\u001eDWm\u001d;TKF,XM\\2f\u001dJ\u001c\u0016\u000f\u001c\u0011\u00023M,G.Z2u\u0019><Xm\u001d;TKF,XM\\2f\u001dJ\u001c\u0016\u000f\\\u0001\u001bg\u0016dWm\u0019;M_^,7\u000f^*fcV,gnY3OeN\u000bH\u000eI\u0001\u0010I\u0016dW\r^3Fm\u0016tGo]*rY\u0006\u0001B-\u001a7fi\u0016,e/\u001a8ugN\u000bH\u000eI\u0001\u0016S:\u001cXM\u001d;EK2,G/Z'be.,'oU9m\u0003YIgn]3si\u0012+G.\u001a;f\u001b\u0006\u00148.\u001a:Tc2\u0004\u0013aC<sSR,WI^3oiN$B\u0001b\u000e\u0005>A11q\u0015C\u001d\u0003\u007fIA\u0001b\u000f\u0004*\n1a)\u001e;ve\u0016Dq\u0001b\u0010w\u0001\u0004!\t%\u0001\u0004fm\u0016tGo\u001d\t\u0007\u0003c\"\u0019\u0005b\u0012\n\t\u0011\u0015\u0013Q\u0011\u0002\u0004'\u0016\f\bc\u0001C%\u000f9\u0019\u0011Q\u0002\u0001\u0002+I,\u0017\r\u001a%jO\",7\u000f^*fcV,gnY3OeR1Aq\nC)\t'\u0002baa*\u0005:\u0005E\u0006bBAUo\u0002\u0007\u0011q\u0013\u0005\b\t+:\b\u0019AAY\u000391'o\\7TKF,XM\\2f\u001dJ\fAC]3bI2{w/Z:u'\u0016\fX/\u001a8dK:\u0013H\u0003\u0002C(\t7Bq!!+y\u0001\u0004\t9*A\u000biS\u001eDWm\u001d;TKFt%OR8s\t\u0016dW\r^3\u0015\r\u0011=C\u0011\rC2\u0011\u001d\tI+\u001fa\u0001\u0003/Cq\u0001\"\u001az\u0001\u0004\t\t,\u0001\u0007u_N+\u0017/^3oG\u0016t%/A\rm_^,7\u000f^*fcV,gnY3Oe\u001a{'\u000fR3mKR,G\u0003\u0003C(\tW\"i\u0007\"\u001d\t\u000f\u0005%&\u00101\u0001\u0002\u0018\"9Aq\u000e>A\u0002\u0005E\u0016a\u0002;p'\u0016\fhJ\u001d\u0005\b\tgR\b\u0019AAF\u0003%\u0011\u0017\r^2i'&TX-\u0001\beK2,G/Z#wK:$8\u000fV8\u0015\u0011\u0011eD\u0011\u0011CB\t\u000b\u0003baa*\u0005:\u0011m\u0004\u0003BA\u000b\t{JA\u0001b \u0002\u0018\t!QK\\5u\u0011\u001d\tIk\u001fa\u0001\u0003/Cq\u0001\"\u001a|\u0001\u0004\t\t\fC\u0004\u0005\bn\u0004\rA!\u001b\u0002'I,7/\u001a;TKF,XM\\2f\u001dVl'-\u001a:)\u0007m\u001b\u0019\t")
@InternalApi
public class JournalDao {
    private final R2dbcSettings journalSettings;
    private final ExecutionContext ec;
    private final Persistence persistenceExt;
    private final R2dbcExecutor r2dbcExecutor;
    private final String journalTable;
    private final PayloadCodec journalPayloadCodec;
    private final /* synthetic */ Tuple2 x$1;
    private final String insertEventWithParameterTimestampSql;
    private final String insertEventWithTransactionTimestampSql;
    private final String selectHighestSequenceNrSql;
    private final String selectLowestSequenceNrSql;
    private final String deleteEventsSql;
    private final String insertDeleteMarkerSql;

    public static Option<SerializedEventMetadata> readMetadata(Row row) {
        return JournalDao$.MODULE$.readMetadata(row);
    }

    public static Instant EmptyDbTimestamp() {
        return JournalDao$.MODULE$.EmptyDbTimestamp();
    }

    public static Logger log() {
        return JournalDao$.MODULE$.log();
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    private String journalTable() {
        return this.journalTable;
    }

    private PayloadCodec journalPayloadCodec() {
        return this.journalPayloadCodec;
    }

    private String insertEventWithParameterTimestampSql() {
        return this.insertEventWithParameterTimestampSql;
    }

    private String insertEventWithTransactionTimestampSql() {
        return this.insertEventWithTransactionTimestampSql;
    }

    private String selectHighestSequenceNrSql() {
        return this.selectHighestSequenceNrSql;
    }

    private String selectLowestSequenceNrSql() {
        return this.selectLowestSequenceNrSql;
    }

    private String deleteEventsSql() {
        return this.deleteEventsSql;
    }

    private String insertDeleteMarkerSql() {
        return this.insertDeleteMarkerSql;
    }

    public Future<Instant> writeEvents(Seq<SerializedJournalRow> events) {
        Future result;
        block2: {
            Predef$.MODULE$.require(events.nonEmpty());
            String persistenceId = ((SerializedJournalRow)events.head()).persistenceId();
            long previousSeqNr = ((SerializedJournalRow)events.head()).seqNr() - 1L;
            Instant instant = ((SerializedJournalRow)events.head()).dbTimestamp();
            Instant instant2 = Instant.EPOCH;
            boolean useTimestampFromDb = !(instant != null ? !((Object)instant).equals(instant2) : instant2 != null);
            String insertSql = useTimestampFromDb ? this.insertEventWithTransactionTimestampSql() : this.insertEventWithParameterTimestampSql();
            int totalEvents = events.size();
            if (totalEvents == 1) {
                Future result2 = this.r2dbcExecutor().updateOneReturning(new StringBuilder(9).append("insert [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> this.bind$1(connection.createStatement(insertSql), (SerializedJournalRow)events.head(), useTimestampFromDb, previousSeqNr), (Function1 & Serializable)row -> (Instant)row.get(0, Instant.class));
                if (JournalDao$.MODULE$.log().isDebugEnabled()) {
                    result2.foreach((Function1 & Serializable)x$2 -> {
                        JournalDao.$anonfun$writeEvents$3(events, x$2);
                        return BoxedUnit.UNIT;
                    }, this.ec);
                }
                return result2;
            }
            result = this.r2dbcExecutor().updateInBatchReturning(new StringBuilder(26).append("batch insert [").append(persistenceId).append("], [").append(totalEvents).append("] events").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> (Statement)events.foldLeft((Object)connection.createStatement(insertSql), (Function2 & Serializable)(stmt, write) -> {
                stmt.add();
                return this.bind$1((Statement)stmt, (SerializedJournalRow)write, useTimestampFromDb, previousSeqNr);
            }), (Function1 & Serializable)row -> (Instant)row.get(0, Instant.class));
            if (!JournalDao$.MODULE$.log().isDebugEnabled()) break block2;
            result.foreach((Function1 & Serializable)x$3 -> {
                JournalDao.$anonfun$writeEvents$7(events, x$3);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return result.map((Function1 & Serializable)x$4 -> (Instant)x$4.head(), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<Object> readHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(23).append("select highest seqNr [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectHighestSequenceNrSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr)), (Function1 & Serializable)row -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readHighestSequenceNr$2(row))).map((Function1 & Serializable)r -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readHighestSequenceNr$3(r)), ExecutionContexts$.MODULE$.parasitic());
            if (!JournalDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)seqNr -> JournalDao$.MODULE$.log().debug("Highest sequence nr for persistenceId [{}]: [{}]", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)seqNr)), this.ec);
        }
        return result;
    }

    public Future<Object> readLowestSequenceNr(String persistenceId) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(22).append("select lowest seqNr [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectLowestSequenceNrSql()).bind(0, (Object)persistenceId), (Function1 & Serializable)row -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readLowestSequenceNr$2(row))).map((Function1 & Serializable)r -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$readLowestSequenceNr$3(r)), ExecutionContexts$.MODULE$.parasitic());
            if (!JournalDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)seqNr -> JournalDao$.MODULE$.log().debug("Lowest sequence nr for persistenceId [{}]: [{}]", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)seqNr)), this.ec);
        }
        return result;
    }

    private Future<Object> highestSeqNrForDelete(String persistenceId, long toSequenceNr) {
        if (toSequenceNr == Long.MAX_VALUE) {
            return this.readHighestSequenceNr(persistenceId, 0L);
        }
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)toSequenceNr));
    }

    private Future<Object> lowestSequenceNrForDelete(String persistenceId, long toSeqNr, int batchSize) {
        if (toSeqNr <= (long)batchSize) {
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)1L));
        }
        return this.readLowestSequenceNr(persistenceId);
    }

    public Future<BoxedUnit> deleteEventsTo(String persistenceId, long toSequenceNr, boolean resetSequenceNumber) {
        int batchSize = this.journalSettings.cleanupSettings().eventsJournalDeleteBatchSize();
        return this.highestSeqNrForDelete(persistenceId, toSequenceNr).flatMap((Function1 & Serializable)toSeqNr -> JournalDao.$anonfun$deleteEventsTo$6(this, persistenceId, batchSize, resetSequenceNumber, BoxesRunTime.unboxToLong((Object)toSeqNr)), this.ec);
    }

    private final String timestampSubSelect$1() {
        return new StringBuilder(95).append("(SELECT db_timestamp + '1 microsecond'::interval FROM ").append(this.journalTable()).append(" ").append("WHERE persistence_id = ? AND seq_nr = ?)").toString();
    }

    private final Statement bind$1(Statement stmt, SerializedJournalRow write, boolean useTimestampFromDb$1, long previousSeqNr$1) {
        PayloadCodec$.MODULE$.RichStatement(stmt.bind(0, (Object)BoxesRunTime.boxToInteger((int)write.slice())).bind(1, (Object)write.entityType()).bind(2, (Object)write.persistenceId()).bind(3, (Object)BoxesRunTime.boxToLong((long)write.seqNr())).bind(4, (Object)write.writerUuid()).bind(5, (Object)"").bind(6, (Object)BoxesRunTime.boxToInteger((int)write.serId())).bind(7, (Object)write.serManifest()), this.journalPayloadCodec()).bindPayload(8, (byte[])write.payload().get());
        Statement statement = write.tags().isEmpty() ? stmt.bindNull(9, String[].class) : stmt.bind(9, write.tags().toArray(ClassTag$.MODULE$.apply(String.class)));
        Option<SerializedEventMetadata> option = write.metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            SerializedEventMetadata m = (SerializedEventMetadata)some.value();
            stmt.bind(10, (Object)BoxesRunTime.boxToInteger((int)m.serId())).bind(11, (Object)m.serManifest()).bind(12, (Object)m.payload());
        } else if (None$.MODULE$.equals(option)) {
            stmt.bindNull(10, Integer.class).bindNull(11, String.class).bindNull(12, byte[].class);
        } else {
            throw new MatchError(option);
        }
        Object object = useTimestampFromDb$1 ? (!this.journalSettings.dbTimestampMonotonicIncreasing() ? stmt.bind(13, (Object)write.persistenceId()).bind(14, (Object)BoxesRunTime.boxToLong((long)previousSeqNr$1)) : BoxedUnit.UNIT) : (this.journalSettings.dbTimestampMonotonicIncreasing() ? stmt.bind(13, (Object)write.dbTimestamp()) : stmt.bind(13, (Object)write.dbTimestamp()).bind(14, (Object)write.persistenceId()).bind(15, (Object)BoxesRunTime.boxToLong((long)previousSeqNr$1)));
        return stmt;
    }

    public static final /* synthetic */ void $anonfun$writeEvents$3(Seq events$1, Instant x$2) {
        JournalDao$.MODULE$.log().debug("Wrote [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)1), (Object)((SerializedJournalRow)events$1.head()).persistenceId());
    }

    public static final /* synthetic */ void $anonfun$writeEvents$7(Seq events$1, IndexedSeq x$3) {
        JournalDao$.MODULE$.log().debug("Wrote [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)1), (Object)((SerializedJournalRow)events$1.head()).persistenceId());
    }

    public static final /* synthetic */ long $anonfun$readHighestSequenceNr$2(Row row) {
        Long seqNr = (Long)row.get(0, Long.class);
        if (seqNr == null) {
            return 0L;
        }
        return seqNr;
    }

    public static final /* synthetic */ long $anonfun$readHighestSequenceNr$3(IndexedSeq r) {
        if (r.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)r.head());
    }

    public static final /* synthetic */ long $anonfun$readLowestSequenceNr$2(Row row) {
        Long seqNr = (Long)row.get(0, Long.class);
        if (seqNr == null) {
            return 0L;
        }
        return seqNr;
    }

    public static final /* synthetic */ long $anonfun$readLowestSequenceNr$3(IndexedSeq r) {
        if (r.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)r.head());
    }

    private final Statement insertDeleteMarkerStmt$1(long deleteMarkerSeqNr, Connection connection, String persistenceId$3) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(persistenceId$3);
        int slice = this.persistenceExt().sliceForPersistenceId(persistenceId$3);
        return PayloadCodec$.MODULE$.RichStatement(connection.createStatement(this.insertDeleteMarkerSql()).bind(0, (Object)BoxesRunTime.boxToInteger((int)slice)).bind(1, (Object)entityType).bind(2, (Object)persistenceId$3).bind(3, (Object)BoxesRunTime.boxToLong((long)deleteMarkerSeqNr)).bind(4, (Object)"").bind(5, (Object)"").bind(6, (Object)BoxesRunTime.boxToInteger((int)0)).bind(7, (Object)""), this.journalPayloadCodec()).bindPayloadOption(8, (Option<byte[]>)None$.MODULE$).bind(9, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ long $anonfun$deleteEventsTo$2(IndexedSeq x$5) {
        return BoxesRunTime.unboxToLong((Object)x$5.head());
    }

    private final Future deleteBatch$1(long from, long to, boolean lastBatch, boolean resetSequenceNumber$1, String persistenceId$3) {
        return (lastBatch && !resetSequenceNumber$1 ? this.r2dbcExecutor().update(new StringBuilder(27).append("delete [").append(persistenceId$3).append("] and insert marker").toString(), (Function1<Connection, IndexedSeq<Statement>>)(Function1 & Serializable)connection -> (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Statement[]{connection.createStatement(this.deleteEventsSql()).bind(0, (Object)persistenceId$3).bind(1, (Object)BoxesRunTime.boxToLong((long)from)).bind(2, (Object)BoxesRunTime.boxToLong((long)to)), this.insertDeleteMarkerStmt$1(to, (Connection)connection, persistenceId$3)}))).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)JournalDao.$anonfun$deleteEventsTo$2(x$5)), this.ec) : this.r2dbcExecutor().updateOne(new StringBuilder(9).append("delete [").append(persistenceId$3).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.deleteEventsSql()).bind(0, (Object)persistenceId$3).bind(1, (Object)BoxesRunTime.boxToLong((long)from)).bind(2, (Object)BoxesRunTime.boxToLong((long)to)))).map((Function1)(JFunction1.mcVJ.sp & Serializable)deletedRows -> {
            if (JournalDao$.MODULE$.log().isDebugEnabled()) {
                package.LoggerOps$.MODULE$.debugN$extension(akka.actor.typed.scaladsl.package$.MODULE$.LoggerOps(JournalDao$.MODULE$.log()), "Deleted [{}] events for persistenceId [{}], from seq num [{}] to [{}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)deletedRows), persistenceId$3, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}));
                return;
            }
        }, ExecutionContexts$.MODULE$.parasitic());
    }

    private final Future deleteInBatches$1(long from, long maxTo, int batchSize$1, boolean resetSequenceNumber$1, String persistenceId$3) {
        if (from + (long)batchSize$1 > maxTo) {
            return this.deleteBatch$1(from, maxTo, true, resetSequenceNumber$1, persistenceId$3);
        }
        long to = from + (long)batchSize$1 - 1L;
        return this.deleteBatch$1(from, to, false, resetSequenceNumber$1, persistenceId$3).flatMap((Function1 & Serializable)x$6 -> this.deleteInBatches$1(to + 1L, maxTo, batchSize$1, resetSequenceNumber$1, persistenceId$3), this.ec);
    }

    public static final /* synthetic */ Future $anonfun$deleteEventsTo$7(JournalDao $this, long toSeqNr$1, int batchSize$1, boolean resetSequenceNumber$1, String persistenceId$3, long fromSeqNr) {
        return $this.deleteInBatches$1(fromSeqNr, toSeqNr$1, batchSize$1, resetSequenceNumber$1, persistenceId$3).map((Function1 & Serializable)x$7 -> {
            boxedUnit = x$7;
            return BoxedUnit.UNIT;
        }, $this.ec);
    }

    public static final /* synthetic */ Future $anonfun$deleteEventsTo$6(JournalDao $this, String persistenceId$3, int batchSize$1, boolean resetSequenceNumber$1, long toSeqNr) {
        return $this.lowestSequenceNrForDelete(persistenceId$3, toSeqNr, batchSize$1).flatMap((Function1 & Serializable)fromSeqNr -> JournalDao.$anonfun$deleteEventsTo$7($this, toSeqNr, batchSize$1, resetSequenceNumber$1, persistenceId$3, BoxesRunTime.unboxToLong((Object)fromSeqNr)), $this.ec);
    }

    public JournalDao(R2dbcSettings journalSettings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.journalSettings = journalSettings;
        this.ec = ec;
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, JournalDao$.MODULE$.log(), journalSettings.logDbCallsExceeding(), ec, system);
        this.journalTable = journalSettings.journalTableWithSchema();
        this.journalPayloadCodec = journalSettings.journalPayloadCodec();
        String baseSql = new StringBuilder(246).append("INSERT INTO ").append(this.journalTable()).append(" ").append("(slice, entity_type, persistence_id, seq_nr, writer, adapter_manifest, event_ser_id, event_ser_manifest, event_payload, tags, meta_ser_id, meta_ser_manifest, meta_payload, db_timestamp) ").append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ").toString();
        String insertEventWithParameterTimestampSql = journalSettings.dbTimestampMonotonicIncreasing() ? Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ?) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql})) : Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " GREATEST(?, ", ")) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql, this.timestampSubSelect$1()}));
        String insertEventWithTransactionTimestampSql = journalSettings.dbTimestampMonotonicIncreasing() ? Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " transaction_timestamp()) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql})) : Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " GREATEST(transaction_timestamp(), ", ")) RETURNING db_timestamp"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{baseSql, this.timestampSubSelect$1()}));
        Tuple2 tuple2 = new Tuple2((Object)insertEventWithParameterTimestampSql, (Object)insertEventWithTransactionTimestampSql);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String insertEventWithParameterTimestampSql2 = (String)tuple2._1();
        String insertEventWithTransactionTimestampSql2 = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)insertEventWithParameterTimestampSql2, (Object)insertEventWithTransactionTimestampSql2);
        this.insertEventWithParameterTimestampSql = (String)this.x$1._1();
        this.insertEventWithTransactionTimestampSql = (String)this.x$1._2();
        this.selectHighestSequenceNrSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT MAX(seq_nr) from ", "\n    WHERE persistence_id = ? AND seq_nr >= ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.selectLowestSequenceNrSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT MIN(seq_nr) from ", "\n    WHERE persistence_id = ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.deleteEventsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    DELETE FROM ", "\n    WHERE persistence_id = ? AND seq_nr >= ? AND seq_nr <= ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.insertDeleteMarkerSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    INSERT INTO ", "\n    (slice, entity_type, persistence_id, seq_nr, db_timestamp, writer, adapter_manifest, event_ser_id, event_ser_manifest, event_payload, deleted)\n    VALUES (?, ?, ?, ?, transaction_timestamp(), ?, ?, ?, ?, ?, ?)"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
    }

    public static final class SerializedEventMetadata
    implements Product,
    Serializable {
        private final int serId;
        private final String serManifest;
        private final byte[] payload;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int serId() {
            return this.serId;
        }

        public String serManifest() {
            return this.serManifest;
        }

        public byte[] payload() {
            return this.payload;
        }

        public SerializedEventMetadata copy(int serId, String serManifest, byte[] payload) {
            return new SerializedEventMetadata(serId, serManifest, payload);
        }

        public int copy$default$1() {
            return this.serId();
        }

        public String copy$default$2() {
            return this.serManifest();
        }

        public byte[] copy$default$3() {
            return this.payload();
        }

        public String productPrefix() {
            return "SerializedEventMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.serId());
                }
                case 1: {
                    return this.serManifest();
                }
                case 2: {
                    return this.payload();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedEventMetadata;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "serId";
                }
                case 1: {
                    return "serManifest";
                }
                case 2: {
                    return "payload";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.serId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedEventMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedEventMetadata serializedEventMetadata = (SerializedEventMetadata)x$1;
            if (this.serId() != serializedEventMetadata.serId()) return false;
            String string = this.serManifest();
            String string2 = serializedEventMetadata.serManifest();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.payload() != serializedEventMetadata.payload()) return false;
            return true;
        }

        public SerializedEventMetadata(int serId, String serManifest, byte[] payload) {
            this.serId = serId;
            this.serManifest = serManifest;
            this.payload = payload;
            Product.$init$((Product)this);
        }
    }

    public static final class SerializedJournalRow
    implements BySliceQuery.SerializedRow,
    Product,
    Serializable {
        private final int slice;
        private final String entityType;
        private final String persistenceId;
        private final long seqNr;
        private final Instant dbTimestamp;
        private final Instant readDbTimestamp;
        private final Option<byte[]> payload;
        private final int serId;
        private final String serManifest;
        private final String writerUuid;
        private final Set<String> tags;
        private final Option<SerializedEventMetadata> metadata;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int slice() {
            return this.slice;
        }

        public String entityType() {
            return this.entityType;
        }

        @Override
        public String persistenceId() {
            return this.persistenceId;
        }

        @Override
        public long seqNr() {
            return this.seqNr;
        }

        @Override
        public Instant dbTimestamp() {
            return this.dbTimestamp;
        }

        @Override
        public Instant readDbTimestamp() {
            return this.readDbTimestamp;
        }

        public Option<byte[]> payload() {
            return this.payload;
        }

        public int serId() {
            return this.serId;
        }

        public String serManifest() {
            return this.serManifest;
        }

        public String writerUuid() {
            return this.writerUuid;
        }

        public Set<String> tags() {
            return this.tags;
        }

        public Option<SerializedEventMetadata> metadata() {
            return this.metadata;
        }

        public SerializedJournalRow copy(int slice, String entityType, String persistenceId, long seqNr, Instant dbTimestamp, Instant readDbTimestamp, Option<byte[]> payload, int serId, String serManifest, String writerUuid, Set<String> tags, Option<SerializedEventMetadata> metadata) {
            return new SerializedJournalRow(slice, entityType, persistenceId, seqNr, dbTimestamp, readDbTimestamp, payload, serId, serManifest, writerUuid, tags, metadata);
        }

        public int copy$default$1() {
            return this.slice();
        }

        public String copy$default$10() {
            return this.writerUuid();
        }

        public Set<String> copy$default$11() {
            return this.tags();
        }

        public Option<SerializedEventMetadata> copy$default$12() {
            return this.metadata();
        }

        public String copy$default$2() {
            return this.entityType();
        }

        public String copy$default$3() {
            return this.persistenceId();
        }

        public long copy$default$4() {
            return this.seqNr();
        }

        public Instant copy$default$5() {
            return this.dbTimestamp();
        }

        public Instant copy$default$6() {
            return this.readDbTimestamp();
        }

        public Option<byte[]> copy$default$7() {
            return this.payload();
        }

        public int copy$default$8() {
            return this.serId();
        }

        public String copy$default$9() {
            return this.serManifest();
        }

        public String productPrefix() {
            return "SerializedJournalRow";
        }

        public int productArity() {
            return 12;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.slice());
                }
                case 1: {
                    return this.entityType();
                }
                case 2: {
                    return this.persistenceId();
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.seqNr());
                }
                case 4: {
                    return this.dbTimestamp();
                }
                case 5: {
                    return this.readDbTimestamp();
                }
                case 6: {
                    return this.payload();
                }
                case 7: {
                    return BoxesRunTime.boxToInteger((int)this.serId());
                }
                case 8: {
                    return this.serManifest();
                }
                case 9: {
                    return this.writerUuid();
                }
                case 10: {
                    return this.tags();
                }
                case 11: {
                    return this.metadata();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedJournalRow;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "slice";
                }
                case 1: {
                    return "entityType";
                }
                case 2: {
                    return "persistenceId";
                }
                case 3: {
                    return "seqNr";
                }
                case 4: {
                    return "dbTimestamp";
                }
                case 5: {
                    return "readDbTimestamp";
                }
                case 6: {
                    return "payload";
                }
                case 7: {
                    return "serId";
                }
                case 8: {
                    return "serManifest";
                }
                case 9: {
                    return "writerUuid";
                }
                case 10: {
                    return "tags";
                }
                case 11: {
                    return "metadata";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.slice());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.entityType()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNr()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.readDbTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.payload()));
            n = Statics.mix((int)n, (int)this.serId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.writerUuid()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tags()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedJournalRow)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedJournalRow serializedJournalRow = (SerializedJournalRow)x$1;
            if (this.slice() != serializedJournalRow.slice()) return false;
            if (this.seqNr() != serializedJournalRow.seqNr()) return false;
            if (this.serId() != serializedJournalRow.serId()) return false;
            String string = this.entityType();
            String string2 = serializedJournalRow.entityType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.persistenceId();
            String string4 = serializedJournalRow.persistenceId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Instant instant = this.dbTimestamp();
            Instant instant2 = serializedJournalRow.dbTimestamp();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Instant instant3 = this.readDbTimestamp();
            Instant instant4 = serializedJournalRow.readDbTimestamp();
            if (instant3 == null) {
                if (instant4 != null) {
                    return false;
                }
            } else if (!((Object)instant3).equals(instant4)) return false;
            Option<byte[]> option = this.payload();
            Option<byte[]> option2 = serializedJournalRow.payload();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string5 = this.serManifest();
            String string6 = serializedJournalRow.serManifest();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.writerUuid();
            String string8 = serializedJournalRow.writerUuid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            Set<String> set = this.tags();
            Set<String> set2 = serializedJournalRow.tags();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Option<SerializedEventMetadata> option3 = this.metadata();
            Option<SerializedEventMetadata> option4 = serializedJournalRow.metadata();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public SerializedJournalRow(int slice, String entityType, String persistenceId, long seqNr, Instant dbTimestamp, Instant readDbTimestamp, Option<byte[]> payload, int serId, String serManifest, String writerUuid, Set<String> tags, Option<SerializedEventMetadata> metadata) {
            this.slice = slice;
            this.entityType = entityType;
            this.persistenceId = persistenceId;
            this.seqNr = seqNr;
            this.dbTimestamp = dbTimestamp;
            this.readDbTimestamp = readDbTimestamp;
            this.payload = payload;
            this.serId = serId;
            this.serManifest = serManifest;
            this.writerUuid = writerUuid;
            this.tags = tags;
            this.metadata = metadata;
            Product.$init$((Product)this);
        }
    }
}

