/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.snapshot;

import akka.actor.typed.ActorSystem;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.PayloadCodec;
import akka.persistence.r2dbc.internal.PayloadCodec$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.snapshot.SnapshotDao$;
import akka.persistence.typed.PersistenceId$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r-vAB0a\u0011\u0003\u0011\u0007N\u0002\u0004kA\"\u0005!m\u001b\u0005\u0006e\u0006!\t\u0001\u001e\u0005\bk\u0006\u0011\r\u0011\"\u0003w\u0011\u0019y\u0018\u0001)A\u0005o\u001a1\u0011\u0011A\u0001C\u0003\u0007A!\"a\t\u0006\u0005+\u0007I\u0011AA\u0013\u0011)\t9$\u0002B\tB\u0003%\u0011q\u0005\u0005\u000b\u0003s)!Q3A\u0005\u0002\u0005m\u0002BCA\"\u000b\tE\t\u0015!\u0003\u0002>!Q\u0011QI\u0003\u0003\u0016\u0004%\t!a\u000f\t\u0015\u0005\u001dSA!E!\u0002\u0013\ti\u0004C\u0005b\u000b\tU\r\u0011\"\u0001\u0002J!Q\u0011qK\u0003\u0003\u0012\u0003\u0006I!a\u0013\t\u0015\u0005eSA!f\u0001\n\u0003\tY\u0006\u0003\u0006\u0002d\u0015\u0011\t\u0012)A\u0005\u0003;B!\"!\u001a\u0006\u0005+\u0007I\u0011AA\u0013\u0011)\t9'\u0002B\tB\u0003%\u0011q\u0005\u0005\u000b\u0003S*!Q3A\u0005\u0002\u0005-\u0004B\u0003B\u0004\u000b\tE\t\u0015!\u0003\u0002n!1!/\u0002C\u0001\u0005\u0013A\u0011\"a\"\u0006\u0003\u0003%\tAa\u0007\t\u0013\u0005EU!%A\u0005\u0002\u0005E\u0006\"CAU\u000bE\u0005I\u0011\u0001B\u0016\u0011%\ty+BI\u0001\n\u0003\u0011Y\u0003C\u0005\u00030\u0015\t\n\u0011\"\u0001\u0002\u0014\"I!\u0011G\u0003\u0012\u0002\u0013\u0005\u00111\u0016\u0005\n\u0005g)\u0011\u0013!C\u0001\u0003cC\u0011B!\u000e\u0006#\u0003%\tAa\u000e\t\u0013\u0005UV!!A\u0005B\u0005]\u0006\"CAd\u000b\u0005\u0005I\u0011AA.\u0011%\tI-BA\u0001\n\u0003\u0011Y\u0004C\u0005\u0002X\u0016\t\t\u0011\"\u0011\u0002Z\"I\u0011q]\u0003\u0002\u0002\u0013\u0005!q\b\u0005\n\u0003g,\u0011\u0011!C!\u0005\u0007B\u0011\"!?\u0006\u0003\u0003%\t%a?\t\u0013\u0005uX!!A\u0005B\u0005}\b\"\u0003B\u0001\u000b\u0005\u0005I\u0011\tB$\u000f%\u0011Y%AA\u0001\u0012\u0003\u0011iEB\u0005\u0002\u0002\u0005\t\t\u0011#\u0001\u0003P!1!o\nC\u0001\u0005OB\u0011\"!@(\u0003\u0003%)%a@\t\u0013\t%t%!A\u0005\u0002\n-\u0004\"\u0003B>O\u0005\u0005I\u0011\u0011B?\u0011%\u0011YiJA\u0001\n\u0013\u0011iI\u0002\u0004\u0002x\u0005\u0011\u0015\u0011\u0010\u0005\u000b\u0003wj#Q3A\u0005\u0002\u0005%\u0003BCA?[\tE\t\u0015!\u0003\u0002L!Q\u0011\u0011L\u0017\u0003\u0016\u0004%\t!a\u0017\t\u0015\u0005\rTF!E!\u0002\u0013\ti\u0006\u0003\u0006\u0002f5\u0012)\u001a!C\u0001\u0003KA!\"a\u001a.\u0005#\u0005\u000b\u0011BA\u0014\u0011\u0019\u0011X\u0006\"\u0001\u0002\u0000!I\u0011qQ\u0017\u0002\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003#k\u0013\u0013!C\u0001\u0003'C\u0011\"!+.#\u0003%\t!a+\t\u0013\u0005=V&%A\u0005\u0002\u0005E\u0006\"CA[[\u0005\u0005I\u0011IA\\\u0011%\t9-LA\u0001\n\u0003\tY\u0006C\u0005\u0002J6\n\t\u0011\"\u0001\u0002L\"I\u0011q[\u0017\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0003Ol\u0013\u0011!C\u0001\u0003SD\u0011\"a=.\u0003\u0003%\t%!>\t\u0013\u0005eX&!A\u0005B\u0005m\b\"CA\u007f[\u0005\u0005I\u0011IA\u0000\u0011%\u0011\t!LA\u0001\n\u0003\u0012\u0019aB\u0005\u0003\u0016\u0006\t\t\u0011#\u0001\u0003\u0018\u001aI\u0011qO\u0001\u0002\u0002#\u0005!\u0011\u0014\u0005\u0007e\u000e#\tA!)\t\u0013\u0005u8)!A\u0005F\u0005}\b\"\u0003B5\u0007\u0006\u0005I\u0011\u0011BR\u0011%\u0011YhQA\u0001\n\u0003\u0013Y\u000bC\u0005\u0003\f\u000e\u000b\t\u0011\"\u0003\u0003\u000e\u001a1!\u000e\u0019\u0002c\u0005oC!B!/J\u0005\u0003\u0005\u000b\u0011\u0002B^\u0011)\u0011\u0019-\u0013B\u0001B\u0003%!Q\u0019\u0005\u000b\u0005+L%\u0011!Q\u0001\f\t]\u0007B\u0003Br\u0013\n\u0005\t\u0015a\u0003\u0003f\"1!/\u0013C\u0001\u0007\u000fA\u0011b!\bJ\u0005\u0004%I!!\n\t\u0011\r}\u0011\n)A\u0005\u0003OA\u0011b!\tJ\u0005\u0004%Yaa\t\t\u0011\rE\u0012\n)A\u0005\u0007KA\u0011ba\rJ\u0005\u0004%Ia!\u000e\t\u0011\r}\u0012\n)A\u0005\u0007oA\u0011b!\u0011J\u0005\u0004%Iaa\u0011\t\u0011\r-\u0013\n)A\u0005\u0007\u000bB\u0011b!\u0014J\u0005\u0004%I!!\n\t\u0011\r=\u0013\n)A\u0005\u0003OAqa!\u0015J\t\u0013\u0019\u0019\u0006C\u0004\u0004`%#Ia!\u0019\t\u000f\r\u0015\u0014\n\"\u0003\u0004h!91qO%\u0005\u0002\re\u0004bBBD\u0013\u0012\u00051\u0011\u0012\u0005\b\u0007/KE\u0011ABM\u0003-\u0019f.\u00199tQ>$H)Y8\u000b\u0005\u0005\u0014\u0017\u0001C:oCB\u001c\bn\u001c;\u000b\u0005\r$\u0017!\u0002:3I\n\u001c'BA3g\u0003-\u0001XM]:jgR,gnY3\u000b\u0003\u001d\fA!Y6lCB\u0011\u0011.A\u0007\u0002A\nY1K\\1qg\"|G\u000fR1p'\t\tA\u000e\u0005\u0002na6\taNC\u0001p\u0003\u0015\u00198-\u00197b\u0013\t\thN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001.A\u0002m_\u001e,\u0012a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\fQa\u001d7gi)T\u0011\u0001`\u0001\u0004_J<\u0017B\u0001@z\u0005\u0019aunZ4fe\u0006!An\\4!\u0005U\u0019VM]5bY&TX\rZ*oCB\u001c\bn\u001c;S_^\u001cb!\u00027\u0002\u0006\u0005-\u0001cA7\u0002\b%\u0019\u0011\u0011\u00028\u0003\u000fA\u0013x\u000eZ;diB!\u0011QBA\u000f\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006t\u0003\u0019a$o\\8u}%\tq.C\u0002\u0002\u001c9\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"\u0001D*fe&\fG.\u001b>bE2,'bAA\u000e]\u0006i\u0001/\u001a:tSN$XM\\2f\u0013\u0012,\"!a\n\u0011\t\u0005%\u0012\u0011\u0007\b\u0005\u0003W\ti\u0003E\u0002\u0002\u00129L1!a\fo\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u00068\u0002\u001dA,'o]5ti\u0016t7-Z%eA\u0005)1/Z9OeV\u0011\u0011Q\b\t\u0004[\u0006}\u0012bAA!]\n!Aj\u001c8h\u0003\u0019\u0019X-\u001d(sA\u0005qqO]5uKRKW.Z:uC6\u0004\u0018aD<sSR,G+[7fgR\fW\u000e\u001d\u0011\u0016\u0005\u0005-\u0003#B7\u0002N\u0005E\u0013bAA(]\n)\u0011I\u001d:bsB\u0019Q.a\u0015\n\u0007\u0005UcN\u0001\u0003CsR,\u0017!C:oCB\u001c\bn\u001c;!\u00031\u0019XM]5bY&TXM]%e+\t\ti\u0006E\u0002n\u0003?J1!!\u0019o\u0005\rIe\u000e^\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\n\u001a\u0011\u0002%M,'/[1mSj,'/T1oS\u001a,7\u000f^\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198jM\u0016\u001cH\u000fI\u0001\t[\u0016$\u0018\rZ1uCV\u0011\u0011Q\u000e\t\u0006[\u0006=\u00141O\u0005\u0004\u0003cr'AB(qi&|g\u000eE\u0002\u0002v5j\u0011!\u0001\u0002\u001b'\u0016\u0014\u0018.\u00197ju\u0016$7K\\1qg\"|G/T3uC\u0012\fG/Y\n\u0007[1\f)!a\u0003\u0002\u000fA\f\u0017\u0010\\8bI\u0006A\u0001/Y=m_\u0006$\u0007\u0005\u0006\u0005\u0002t\u0005\u0005\u00151QAC\u0011\u001d\tY\b\u000ea\u0001\u0003\u0017Bq!!\u00175\u0001\u0004\ti\u0006C\u0004\u0002fQ\u0002\r!a\n\u0002\t\r|\u0007/\u001f\u000b\t\u0003g\nY)!$\u0002\u0010\"I\u00111P\u001b\u0011\u0002\u0003\u0007\u00111\n\u0005\n\u00033*\u0004\u0013!a\u0001\u0003;B\u0011\"!\u001a6!\u0003\u0005\r!a\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0013\u0016\u0005\u0003\u0017\n9j\u000b\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016!C;oG\",7m[3e\u0015\r\t\u0019K\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAT\u0003;\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!,+\t\u0005u\u0013qS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019L\u000b\u0003\u0002(\u0005]\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017\u0001\u00027b]\u001eT!!a1\u0002\t)\fg/Y\u0005\u0005\u0003g\ti,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00171\u001b\t\u0004[\u0006=\u0017bAAi]\n\u0019\u0011I\\=\t\u0013\u0005U7(!AA\u0002\u0005u\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\\B1\u0011Q\\Ar\u0003\u001bl!!a8\u000b\u0007\u0005\u0005h.\u0001\u0006d_2dWm\u0019;j_:LA!!:\u0002`\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY/!=\u0011\u00075\fi/C\u0002\u0002p:\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002Vv\n\t\u00111\u0001\u0002N\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI,a>\t\u0013\u0005Ug(!AA\u0002\u0005u\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002l\n\u0015\u0001\"CAk\u0003\u0006\u0005\t\u0019AAg\u0003%iW\r^1eCR\f\u0007\u0005\u0006\t\u0003\f\t5!q\u0002B\t\u0005'\u0011)Ba\u0006\u0003\u001aA\u0019\u0011QO\u0003\t\u000f\u0005\rB\u00031\u0001\u0002(!9\u0011\u0011\b\u000bA\u0002\u0005u\u0002bBA#)\u0001\u0007\u0011Q\b\u0005\u0007CR\u0001\r!a\u0013\t\u000f\u0005eC\u00031\u0001\u0002^!9\u0011Q\r\u000bA\u0002\u0005\u001d\u0002bBA5)\u0001\u0007\u0011Q\u000e\u000b\u0011\u0005\u0017\u0011iBa\b\u0003\"\t\r\"Q\u0005B\u0014\u0005SA\u0011\"a\t\u0016!\u0003\u0005\r!a\n\t\u0013\u0005eR\u0003%AA\u0002\u0005u\u0002\"CA#+A\u0005\t\u0019AA\u001f\u0011!\tW\u0003%AA\u0002\u0005-\u0003\"CA-+A\u0005\t\u0019AA/\u0011%\t)'\u0006I\u0001\u0002\u0004\t9\u0003C\u0005\u0002jU\u0001\n\u00111\u0001\u0002nU\u0011!Q\u0006\u0016\u0005\u0003{\t9*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u0005sQC!!\u001c\u0002\u0018R!\u0011Q\u001aB\u001f\u0011%\t)nHA\u0001\u0002\u0004\ti\u0006\u0006\u0003\u0002l\n\u0005\u0003\"CAkC\u0005\u0005\t\u0019AAg)\u0011\tIL!\u0012\t\u0013\u0005U'%!AA\u0002\u0005uC\u0003BAv\u0005\u0013B\u0011\"!6&\u0003\u0003\u0005\r!!4\u0002+M+'/[1mSj,Gm\u00158baNDw\u000e\u001e*poB\u0019\u0011QO\u0014\u0014\u000b\u001d\u0012\tF!\u0018\u0011)\tM#\u0011LA\u0014\u0003{\ti$a\u0013\u0002^\u0005\u001d\u0012Q\u000eB\u0006\u001b\t\u0011)FC\u0002\u0003X9\fqA];oi&lW-\u0003\u0003\u0003\\\tU#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ooA!!q\fB3\u001b\t\u0011\tG\u0003\u0003\u0003d\u0005\u0005\u0017AA5p\u0013\u0011\tyB!\u0019\u0015\u0005\t5\u0013!B1qa2LH\u0003\u0005B\u0006\u0005[\u0012yG!\u001d\u0003t\tU$q\u000fB=\u0011\u001d\t\u0019C\u000ba\u0001\u0003OAq!!\u000f+\u0001\u0004\ti\u0004C\u0004\u0002F)\u0002\r!!\u0010\t\r\u0005T\u0003\u0019AA&\u0011\u001d\tIF\u000ba\u0001\u0003;Bq!!\u001a+\u0001\u0004\t9\u0003C\u0004\u0002j)\u0002\r!!\u001c\u0002\u000fUt\u0017\r\u001d9msR!!q\u0010BD!\u0015i\u0017q\u000eBA!Ei'1QA\u0014\u0003{\ti$a\u0013\u0002^\u0005\u001d\u0012QN\u0005\u0004\u0005\u000bs'A\u0002+va2,w\u0007C\u0005\u0003\n.\n\t\u00111\u0001\u0003\f\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0005\u0003BA^\u0005#KAAa%\u0002>\n1qJ\u00196fGR\f!dU3sS\u0006d\u0017N_3e':\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u00042!!\u001eD'\u0015\u0019%1\u0014B/!1\u0011\u0019F!(\u0002L\u0005u\u0013qEA:\u0013\u0011\u0011yJ!\u0016\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003\u0018RA\u00111\u000fBS\u0005O\u0013I\u000bC\u0004\u0002|\u0019\u0003\r!a\u0013\t\u000f\u0005ec\t1\u0001\u0002^!9\u0011Q\r$A\u0002\u0005\u001dB\u0003\u0002BW\u0005k\u0003R!\\A8\u0005_\u0003\u0012\"\u001cBY\u0003\u0017\ni&a\n\n\u0007\tMfN\u0001\u0004UkBdWm\r\u0005\n\u0005\u0013;\u0015\u0011!a\u0001\u0003g\u001a\"!\u00137\u0002\u0011M,G\u000f^5oON\u0004BA!0\u0003@6\t!-C\u0002\u0003B\n\u0014QB\u0015\u001aeE\u000e\u001cV\r\u001e;j]\u001e\u001c\u0018!E2p]:,7\r^5p]\u001a\u000b7\r^8ssB!!q\u0019Bi\u001b\t\u0011IM\u0003\u0003\u0003L\n5\u0017aA:qS*\u00191Ma4\u000b\u0005\t\r\u0014\u0002\u0002Bj\u0005\u0013\u0014\u0011cQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0003\t)7\r\u0005\u0003\u0003Z\n}WB\u0001Bn\u0015\r\u0011iN\\\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002Bq\u00057\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rML8\u000f^3na\u0011\u00119Oa?\u0011\r\t%(1\u001fB|\u001b\t\u0011YO\u0003\u0003\u0003n\n=\u0018!\u0002;za\u0016$'b\u0001ByM\u0006)\u0011m\u0019;pe&!!Q\u001fBv\u0005-\t5\r^8s'f\u001cH/Z7\u0011\t\te(1 \u0007\u0001\t-\u0011i0TA\u0001\u0002\u0003\u0015\tAa@\u0003\u0007}#\u0013'\u0005\u0003\u0004\u0002\u00055\u0007cA7\u0004\u0004%\u00191Q\u00018\u0003\u000f9{G\u000f[5oOR11\u0011BB\r\u00077!baa\u0003\u0004\u000e\r=\u0001CA5J\u0011\u001d\u0011)N\u0014a\u0002\u0005/DqAa9O\u0001\b\u0019\t\u0002\r\u0003\u0004\u0014\r]\u0001C\u0002Bu\u0005g\u001c)\u0002\u0005\u0003\u0003z\u000e]A\u0001\u0004B\u007f\u0007\u001f\t\t\u0011!A\u0003\u0002\t}\bb\u0002B]\u001d\u0002\u0007!1\u0018\u0005\b\u0005\u0007t\u0005\u0019\u0001Bc\u00035\u0019h.\u00199tQ>$H+\u00192mK\u0006q1O\\1qg\"|G\u000fV1cY\u0016\u0004\u0013\u0001F:oCB\u001c\bn\u001c;QCfdw.\u00193D_\u0012,7-\u0006\u0002\u0004&A!1qEB\u0017\u001b\t\u0019ICC\u0002\u0004,\t\f\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0007_\u0019IC\u0001\u0007QCfdw.\u00193D_\u0012,7-A\u000bt]\u0006\u00048\u000f[8u!\u0006LHn\\1e\u0007>$Wm\u0019\u0011\u0002\u001dA,'o]5ti\u0016t7-Z#yiV\u00111q\u0007\t\u0005\u0007s\u0019Y$D\u0001e\u0013\r\u0019i\u0004\u001a\u0002\f!\u0016\u00148/[:uK:\u001cW-A\bqKJ\u001c\u0018n\u001d;f]\u000e,W\t\u001f;!\u00035\u0011(\u0007\u001a2d\u000bb,7-\u001e;peV\u00111Q\t\t\u0005\u0007O\u00199%\u0003\u0003\u0004J\r%\"!\u0004*3I\n\u001cW\t_3dkR|'/\u0001\bse\u0011\u00147-\u0012=fGV$xN\u001d\u0011\u0002\u0013U\u00048/\u001a:u'Fd\u0017AC;qg\u0016\u0014HoU9mA\u0005I1/\u001a7fGR\u001c\u0016\u000f\u001c\u000b\u0005\u0003O\u0019)\u0006C\u0004\u0004Xe\u0003\ra!\u0017\u0002\u0011\r\u0014\u0018\u000e^3sS\u0006\u0004Ba!\u000f\u0004\\%\u00191Q\f3\u00033Ms\u0017\r]:i_R\u001cV\r\\3di&|gn\u0011:ji\u0016\u0014\u0018.Y\u0001\nI\u0016dW\r^3Tc2$B!a\n\u0004d!91q\u000b.A\u0002\re\u0013!G2pY2,7\r^*fe&\fG.\u001b>fINs\u0017\r]:i_R$Ba!\u001b\u0004nA\u001911N\u0003\u000f\u0005%\u0004\u0001bBB87\u0002\u00071\u0011O\u0001\u0004e><\b\u0003\u0002Bd\u0007gJAa!\u001e\u0003J\n\u0019!k\\<\u0002\t1|\u0017\r\u001a\u000b\u0007\u0007w\u001a\u0019i!\"\u0011\r\te7QPBA\u0013\u0011\u0019yHa7\u0003\r\u0019+H/\u001e:f!\u0015i\u0017qNB5\u0011\u001d\t\u0019\u0003\u0018a\u0001\u0003OAqaa\u0016]\u0001\u0004\u0019I&A\u0003ti>\u0014X\r\u0006\u0003\u0004\f\u000eM\u0005C\u0002Bm\u0007{\u001ai\tE\u0002n\u0007\u001fK1a!%o\u0005\u0011)f.\u001b;\t\u000f\rUU\f1\u0001\u0004j\u0005i1/\u001a:jC2L'0\u001a3S_^\fa\u0001Z3mKR,GCBBF\u00077\u001bi\nC\u0004\u0002$y\u0003\r!a\n\t\u000f\r]c\f1\u0001\u0004Z!\u001a\u0011j!)\u0011\t\r\r6qU\u0007\u0003\u0007KS1!a)g\u0013\u0011\u0019Ik!*\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public final class SnapshotDao {
    private final String snapshotTable;
    private final PayloadCodec snapshotPayloadCodec;
    private final Persistence persistenceExt;
    private final R2dbcExecutor r2dbcExecutor;
    private final String upsertSql;

    private String snapshotTable() {
        return this.snapshotTable;
    }

    private PayloadCodec snapshotPayloadCodec() {
        return this.snapshotPayloadCodec;
    }

    private Persistence persistenceExt() {
        return this.persistenceExt;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    private String upsertSql() {
        return this.upsertSql;
    }

    private String selectSql(SnapshotSelectionCriteria criteria) {
        String maxSeqNrCondition = criteria.maxSequenceNr() != Long.MAX_VALUE ? " AND seq_nr <= ?" : "";
        String minSeqNrCondition = criteria.minSequenceNr() > 0L ? " AND seq_nr >= ?" : "";
        String maxTimestampCondition = criteria.maxTimestamp() != Long.MAX_VALUE ? " AND write_timestamp <= ?" : "";
        String minTimestampCondition = criteria.minTimestamp() != 0L ? " AND write_timestamp >= ?" : "";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT persistence_id, seq_nr, write_timestamp, snapshot, ser_id, ser_manifest, meta_payload, meta_ser_id, meta_ser_manifest\n      FROM ", "\n      WHERE persistence_id = ?\n      ", " ", " ", " ", "\n      LIMIT 1"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable(), maxSeqNrCondition, minSeqNrCondition, maxTimestampCondition, minTimestampCondition}));
    }

    private String deleteSql(SnapshotSelectionCriteria criteria) {
        String maxSeqNrCondition = criteria.maxSequenceNr() != Long.MAX_VALUE ? " AND seq_nr <= ?" : "";
        String minSeqNrCondition = criteria.minSequenceNr() > 0L ? " AND seq_nr >= ?" : "";
        String maxTimestampCondition = criteria.maxTimestamp() != Long.MAX_VALUE ? " AND write_timestamp <= ?" : "";
        String minTimestampCondition = criteria.minTimestamp() != 0L ? " AND write_timestamp >= ?" : "";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      DELETE FROM ", "\n      WHERE persistence_id = ?\n      ", " ", " ", " ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable(), maxSeqNrCondition, minSeqNrCondition, maxTimestampCondition, minTimestampCondition}));
    }

    private SerializedSnapshotRow collectSerializedSnapshot(Row row) {
        Integer metaSerializerId;
        return new SerializedSnapshotRow((String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), Predef$.MODULE$.Long2long((Long)row.get("write_timestamp", Long.class)), PayloadCodec$.MODULE$.RichRow(row, this.snapshotPayloadCodec()).getPayload("snapshot"), Predef$.MODULE$.Integer2int((Integer)row.get("ser_id", Integer.class)), (String)row.get("ser_manifest", String.class), (Option<SerializedSnapshotMetadata>)((metaSerializerId = (Integer)row.get("meta_ser_id", Integer.class)) == null ? None$.MODULE$ : new Some((Object)new SerializedSnapshotMetadata((byte[])row.get("meta_payload", byte[].class), Predef$.MODULE$.Integer2int(metaSerializerId), (String)row.get("meta_ser_manifest", String.class)))));
    }

    public Future<Option<SerializedSnapshotRow>> load(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.r2dbcExecutor().select(new StringBuilder(32).append("select snapshot [").append(persistenceId).append("], criteria: [").append(criteria).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Statement statement = connection.createStatement(this.selectSql(criteria)).bind(0, (Object)persistenceId);
            int bindIdx = 0;
            Object object = criteria.maxSequenceNr() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxSequenceNr())) : BoxedUnit.UNIT;
            Object object2 = criteria.minSequenceNr() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minSequenceNr())) : BoxedUnit.UNIT;
            Object object3 = criteria.maxTimestamp() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxTimestamp())) : BoxedUnit.UNIT;
            Object object4 = criteria.minTimestamp() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minTimestamp())) : BoxedUnit.UNIT;
            return statement;
        }, (Function1 & Serializable)row -> this.collectSerializedSnapshot((Row)row)).map((Function1 & Serializable)x$1 -> x$1.headOption(), ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<BoxedUnit> store(SerializedSnapshotRow serializedRow) {
        String entityType = PersistenceId$.MODULE$.extractEntityType(serializedRow.persistenceId());
        int slice = this.persistenceExt().sliceForPersistenceId(serializedRow.persistenceId());
        return this.r2dbcExecutor().updateOne(new StringBuilder(38).append("upsert snapshot [").append(serializedRow.persistenceId()).append("], sequence number [").append(serializedRow.seqNr()).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Some some;
            SerializedSnapshotMetadata serializedSnapshotMetadata;
            Statement statement = PayloadCodec$.MODULE$.RichStatement(connection.createStatement(this.upsertSql()).bind(0, (Object)BoxesRunTime.boxToInteger((int)slice)).bind(1, (Object)entityType).bind(2, (Object)serializedRow.persistenceId()).bind(3, (Object)BoxesRunTime.boxToLong((long)serializedRow.seqNr())).bind(4, (Object)BoxesRunTime.boxToLong((long)serializedRow.writeTimestamp())), this.snapshotPayloadCodec()).bindPayload(5, serializedRow.snapshot()).bind(6, (Object)BoxesRunTime.boxToInteger((int)serializedRow.serializerId())).bind(7, (Object)serializedRow.serializerManifest());
            Option<SerializedSnapshotMetadata> option = serializedRow.metadata();
            if (option instanceof Some && (serializedSnapshotMetadata = (SerializedSnapshotMetadata)(some = (Some)option).value()) != null) {
                byte[] serializedMeta = serializedSnapshotMetadata.payload();
                int serializerId = serializedSnapshotMetadata.serializerId();
                String serializerManifest = serializedSnapshotMetadata.serializerManifest();
                statement.bind(8, (Object)serializedMeta).bind(9, (Object)BoxesRunTime.boxToInteger((int)serializerId)).bind(10, (Object)serializerManifest);
            } else if (None$.MODULE$.equals(option)) {
                statement.bindNull(8, byte[].class).bindNull(9, Integer.class).bindNull(10, String.class);
            } else {
                throw new MatchError(option);
            }
            return statement;
        }).map((Function1)(JFunction1.mcVJ.sp & Serializable)x$2 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public Future<BoxedUnit> delete(String persistenceId, SnapshotSelectionCriteria criteria) {
        return this.r2dbcExecutor().updateOne(new StringBuilder(31).append("delete snapshot [").append(persistenceId).append("], criteria [").append(criteria).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
            Statement statement = connection.createStatement(this.deleteSql(criteria)).bind(0, (Object)persistenceId);
            int bindIdx = 0;
            Object object = criteria.maxSequenceNr() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxSequenceNr())) : BoxedUnit.UNIT;
            Object object2 = criteria.minSequenceNr() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minSequenceNr())) : BoxedUnit.UNIT;
            Object object3 = criteria.maxTimestamp() != Long.MAX_VALUE ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.maxTimestamp())) : BoxedUnit.UNIT;
            Object object4 = criteria.minTimestamp() > 0L ? statement.bind(++bindIdx, (Object)BoxesRunTime.boxToLong((long)criteria.minTimestamp())) : BoxedUnit.UNIT;
            return statement;
        }).map((Function1)(JFunction1.mcVJ.sp & Serializable)x$3 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public SnapshotDao(R2dbcSettings settings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.snapshotTable = settings.snapshotsTableWithSchema();
        this.snapshotPayloadCodec = settings.snapshotPayloadCodec();
        this.persistenceExt = (Persistence)Persistence$.MODULE$.apply(system);
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, SnapshotDao$.MODULE$.akka$persistence$r2dbc$snapshot$SnapshotDao$$log(), settings.logDbCallsExceeding(), ec, system);
        this.upsertSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    INSERT INTO ", "\n    (slice, entity_type, persistence_id, seq_nr, write_timestamp, snapshot, ser_id, ser_manifest, meta_payload, meta_ser_id, meta_ser_manifest)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT (persistence_id)\n    DO UPDATE SET\n      seq_nr = excluded.seq_nr,\n      write_timestamp = excluded.write_timestamp,\n      snapshot = excluded.snapshot,\n      ser_id = excluded.ser_id,\n      ser_manifest = excluded.ser_manifest,\n      meta_payload = excluded.meta_payload,\n      meta_ser_id = excluded.meta_ser_id,\n      meta_ser_manifest = excluded.meta_ser_manifest"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshotTable()}));
    }

    public static final class SerializedSnapshotMetadata
    implements Product,
    Serializable {
        private final byte[] payload;
        private final int serializerId;
        private final String serializerManifest;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public byte[] payload() {
            return this.payload;
        }

        public int serializerId() {
            return this.serializerId;
        }

        public String serializerManifest() {
            return this.serializerManifest;
        }

        public SerializedSnapshotMetadata copy(byte[] payload, int serializerId, String serializerManifest) {
            return new SerializedSnapshotMetadata(payload, serializerId, serializerManifest);
        }

        public byte[] copy$default$1() {
            return this.payload();
        }

        public int copy$default$2() {
            return this.serializerId();
        }

        public String copy$default$3() {
            return this.serializerManifest();
        }

        public String productPrefix() {
            return "SerializedSnapshotMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.payload();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.serializerId());
                }
                case 2: {
                    return this.serializerManifest();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedSnapshotMetadata;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "payload";
                }
                case 1: {
                    return "serializerId";
                }
                case 2: {
                    return "serializerManifest";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            n = Statics.mix((int)n, (int)this.serializerId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serializerManifest()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedSnapshotMetadata)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedSnapshotMetadata serializedSnapshotMetadata = (SerializedSnapshotMetadata)x$1;
            if (this.serializerId() != serializedSnapshotMetadata.serializerId()) return false;
            if (this.payload() != serializedSnapshotMetadata.payload()) return false;
            String string = this.serializerManifest();
            String string2 = serializedSnapshotMetadata.serializerManifest();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public SerializedSnapshotMetadata(byte[] payload, int serializerId, String serializerManifest) {
            this.payload = payload;
            this.serializerId = serializerId;
            this.serializerManifest = serializerManifest;
            Product.$init$((Product)this);
        }
    }

    public static final class SerializedSnapshotRow
    implements Product,
    Serializable {
        private final String persistenceId;
        private final long seqNr;
        private final long writeTimestamp;
        private final byte[] snapshot;
        private final int serializerId;
        private final String serializerManifest;
        private final Option<SerializedSnapshotMetadata> metadata;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String persistenceId() {
            return this.persistenceId;
        }

        public long seqNr() {
            return this.seqNr;
        }

        public long writeTimestamp() {
            return this.writeTimestamp;
        }

        public byte[] snapshot() {
            return this.snapshot;
        }

        public int serializerId() {
            return this.serializerId;
        }

        public String serializerManifest() {
            return this.serializerManifest;
        }

        public Option<SerializedSnapshotMetadata> metadata() {
            return this.metadata;
        }

        public SerializedSnapshotRow copy(String persistenceId, long seqNr, long writeTimestamp, byte[] snapshot, int serializerId, String serializerManifest, Option<SerializedSnapshotMetadata> metadata) {
            return new SerializedSnapshotRow(persistenceId, seqNr, writeTimestamp, snapshot, serializerId, serializerManifest, metadata);
        }

        public String copy$default$1() {
            return this.persistenceId();
        }

        public long copy$default$2() {
            return this.seqNr();
        }

        public long copy$default$3() {
            return this.writeTimestamp();
        }

        public byte[] copy$default$4() {
            return this.snapshot();
        }

        public int copy$default$5() {
            return this.serializerId();
        }

        public String copy$default$6() {
            return this.serializerManifest();
        }

        public Option<SerializedSnapshotMetadata> copy$default$7() {
            return this.metadata();
        }

        public String productPrefix() {
            return "SerializedSnapshotRow";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.persistenceId();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.seqNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.writeTimestamp());
                }
                case 3: {
                    return this.snapshot();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.serializerId());
                }
                case 5: {
                    return this.serializerManifest();
                }
                case 6: {
                    return this.metadata();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializedSnapshotRow;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "persistenceId";
                }
                case 1: {
                    return "seqNr";
                }
                case 2: {
                    return "writeTimestamp";
                }
                case 3: {
                    return "snapshot";
                }
                case 4: {
                    return "serializerId";
                }
                case 5: {
                    return "serializerManifest";
                }
                case 6: {
                    return "metadata";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persistenceId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.writeTimestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.snapshot()));
            n = Statics.mix((int)n, (int)this.serializerId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serializerManifest()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.metadata()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializedSnapshotRow)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializedSnapshotRow serializedSnapshotRow = (SerializedSnapshotRow)x$1;
            if (this.seqNr() != serializedSnapshotRow.seqNr()) return false;
            if (this.writeTimestamp() != serializedSnapshotRow.writeTimestamp()) return false;
            if (this.serializerId() != serializedSnapshotRow.serializerId()) return false;
            String string = this.persistenceId();
            String string2 = serializedSnapshotRow.persistenceId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.snapshot() != serializedSnapshotRow.snapshot()) return false;
            String string3 = this.serializerManifest();
            String string4 = serializedSnapshotRow.serializerManifest();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<SerializedSnapshotMetadata> option = this.metadata();
            Option<SerializedSnapshotMetadata> option2 = serializedSnapshotRow.metadata();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public SerializedSnapshotRow(String persistenceId, long seqNr, long writeTimestamp, byte[] snapshot, int serializerId, String serializerManifest, Option<SerializedSnapshotMetadata> metadata) {
            this.persistenceId = persistenceId;
            this.seqNr = seqNr;
            this.writeTimestamp = writeTimestamp;
            this.snapshot = snapshot;
            this.serializerId = serializerId;
            this.serializerManifest = serializerManifest;
            this.metadata = metadata;
            Product.$init$((Product)this);
        }
    }
}

