/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc;

import akka.Done$;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Extension;
import akka.actor.typed.ExtensionId;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.ConnectionFactorySettings;
import akka.persistence.r2dbc.internal.R2dbcExecutor$;
import akka.persistence.r2dbc.internal.R2dbcExecutor$PublisherOps$;
import akka.util.JavaDurationConverters;
import akka.util.JavaDurationConverters$;
import com.typesafe.config.Config;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactoryProvider;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mq!B\u0007\u000f\u0011\u0003)b!B\f\u000f\u0011\u0003A\u0002\"\u0002\u001f\u0002\t\u0003A\b\"B=\u0002\t\u0003Q\bbBA\u0002\u0003\u0011\u0005\u0011Q\u0001\u0004\u0005/9\u0001!\u0005\u0003\u0005-\u000b\t\u0005\t\u0015!\u0003.\u0011\u0015aT\u0001\"\u0001>\u0011\u001d\u0019UA1A\u0005\n\u0011CaaY\u0003!\u0002\u0013)\u0005\"\u00023\u0006\t\u0003)\u0007\"\u00028\u0006\t\u0013y\u0007\"B;\u0006\t\u00131\u0018!G\"p]:,7\r^5p]\u001a\u000b7\r^8ssB\u0013xN^5eKJT!a\u0004\t\u0002\u000bI\u0014DMY2\u000b\u0005E\u0011\u0012a\u00039feNL7\u000f^3oG\u0016T\u0011aE\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005Y\tQ\"\u0001\b\u00033\r{gN\\3di&|gNR1di>\u0014\u0018\u0010\u0015:pm&$WM]\n\u0003\u0003e\u00012AG\u0010\"\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0015!\u0018\u0010]3e\u0015\tq\"#A\u0003bGR|'/\u0003\u0002!7\tYQ\t\u001f;f]NLwN\\%e!\t1RaE\u0002\u0006G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u000e+\u0013\tY3DA\u0005FqR,gn]5p]\u000611/_:uK6\u0004$AL\u001a\u0011\u0007iy\u0013'\u0003\u000217\tY\u0011i\u0019;peNK8\u000f^3n!\t\u00114\u0007\u0004\u0001\u0005\u0013Q2\u0011\u0011!A\u0001\u0006\u0003)$aA0%gE\u0011a'\u000f\t\u0003I]J!\u0001O\u0013\u0003\u000f9{G\u000f[5oOB\u0011AEO\u0005\u0003w\u0015\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\u0010\u0005\u0006Y\u001d\u0001\ra\u0010\u0019\u0003\u0001\n\u00032AG\u0018B!\t\u0011$\tB\u00055}\u0005\u0005\t\u0011!B\u0001k\u0005A1/Z:tS>t7/F\u0001F!\u00111Uj\u0014.\u000e\u0003\u001dS!\u0001S%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT$\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%\u0016j\u0011a\u0015\u0006\u0003)R\ta\u0001\u0010:p_Rt\u0014B\u0001,&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y+\u0003CA.b\u001b\u0005a&BA/_\u0003\u0011\u0001xn\u001c7\u000b\u0005=y&\"\u00011\u0002\u0005%|\u0017B\u00012]\u00059\u0019uN\u001c8fGRLwN\u001c)p_2\f\u0011b]3tg&|gn\u001d\u0011\u0002)\r|gN\\3di&|gNR1di>\u0014\u0018PR8s)\t1G\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j=\u0006\u00191\u000f]5\n\u0005-D'!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\")QN\u0003a\u0001\u001f\u0006q1m\u001c8gS\u001edunY1uS>t\u0017aF2sK\u0006$XmQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z)\t1\u0007\u000fC\u0003r\u0017\u0001\u0007!/\u0001\u0005tKR$\u0018N\\4t!\t12/\u0003\u0002u\u001d\tI2i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=TKR$\u0018N\\4t\u0003m\u0019'/Z1uK\u000e{gN\\3di&|g\u000eU8pY\u001a\u000b7\r^8ssR\u0011!l\u001e\u0005\u0006c2\u0001\rA\u001d\u000b\u0002+\u0005y1M]3bi\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0002\"w\")Af\u0001a\u0001yB\u0012Qp \t\u00045=r\bC\u0001\u001a\u0000\t)\t\ta_A\u0001\u0002\u0003\u0015\t!\u000e\u0002\u0004?\u0012\n\u0014aA4fiR\u0019\u0011%a\u0002\t\r1\"\u0001\u0019AA\u0005a\u0011\tY!a\u0004\u0011\tiy\u0013Q\u0002\t\u0004e\u0005=AaCA\t\u0003\u000f\t\t\u0011!A\u0003\u0002U\u00121a\u0018\u00133\u0001")
public class ConnectionFactoryProvider
implements Extension {
    private final ActorSystem<?> system;
    private final ConcurrentHashMap<String, ConnectionPool> sessions;

    public static ConnectionFactoryProvider get(ActorSystem<?> system) {
        return ConnectionFactoryProvider$.MODULE$.get(system);
    }

    public static ConnectionFactoryProvider createExtension(ActorSystem<?> system) {
        return ConnectionFactoryProvider$.MODULE$.createExtension((ActorSystem)system);
    }

    public static ExtensionId<ConnectionFactoryProvider> id() {
        return ConnectionFactoryProvider$.MODULE$.id();
    }

    public static Extension apply(ActorSystem system) {
        return ConnectionFactoryProvider$.MODULE$.apply(system);
    }

    private ConcurrentHashMap<String, ConnectionPool> sessions() {
        return this.sessions;
    }

    public ConnectionFactory connectionFactoryFor(String configLocation2) {
        return (ConnectionFactory)this.sessions().computeIfAbsent(configLocation2, configLocation -> {
            Config config = $this.system.settings().config().getConfig(configLocation);
            ConnectionFactorySettings settings = new ConnectionFactorySettings(config);
            return this.createConnectionPoolFactory(settings);
        });
    }

    private ConnectionFactory createConnectionFactory(ConnectionFactorySettings settings) {
        Object object;
        ConnectionFactoryOptions.Builder builder;
        Option<String> option = settings.urlOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            String url = (String)some.value();
            builder = ConnectionFactoryOptions.builder().from(ConnectionFactoryOptions.parse((CharSequence)url));
        } else {
            builder = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.DRIVER, (Object)settings.driver()).option(ConnectionFactoryOptions.HOST, (Object)settings.host()).option(ConnectionFactoryOptions.PORT, (Object)settings.port()).option(ConnectionFactoryOptions.USER, (Object)settings.user()).option(ConnectionFactoryOptions.PASSWORD, (Object)settings.password()).option(ConnectionFactoryOptions.DATABASE, (Object)settings.database()).option(ConnectionFactoryOptions.CONNECT_TIMEOUT, (Object)java.time.Duration.ofMillis(settings.connectTimeout().toMillis()));
        }
        ConnectionFactoryOptions.Builder builder2 = builder;
        builder2.option(PostgresqlConnectionFactoryProvider.FORCE_BINARY, (Object)Boolean.TRUE).option(PostgresqlConnectionFactoryProvider.PREFER_ATTACHED_BUFFERS, (Object)Boolean.TRUE).option(PostgresqlConnectionFactoryProvider.PREPARED_STATEMENT_CACHE_QUERIES, (Object)settings.statementCacheSize());
        settings.statementTimeout().foreach((Function1 & Serializable)timeout -> builder2.option(PostgresqlConnectionFactoryProvider.STATEMENT_TIMEOUT, (Object)JavaDurationConverters.ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps((Duration)timeout))));
        if (settings.sslEnabled()) {
            builder2.option(ConnectionFactoryOptions.SSL, (Object)Boolean.TRUE);
            Object object2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.sslMode())) ? builder2.option(PostgresqlConnectionFactoryProvider.SSL_MODE, (Object)SSLMode.fromValue((String)settings.sslMode())) : BoxedUnit.UNIT;
            Object object3 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.sslRootCert())) ? builder2.option(PostgresqlConnectionFactoryProvider.SSL_ROOT_CERT, (Object)settings.sslRootCert()) : BoxedUnit.UNIT;
            Object object4 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.sslCert())) ? builder2.option(PostgresqlConnectionFactoryProvider.SSL_CERT, (Object)settings.sslCert()) : BoxedUnit.UNIT;
            Object object5 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.sslKey())) ? builder2.option(PostgresqlConnectionFactoryProvider.SSL_KEY, (Object)settings.sslKey()) : BoxedUnit.UNIT;
            object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.sslPassword())) ? builder2.option(PostgresqlConnectionFactoryProvider.SSL_PASSWORD, (Object)settings.sslPassword()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return ConnectionFactories.get((ConnectionFactoryOptions)builder2.build());
    }

    private ConnectionPool createConnectionPoolFactory(ConnectionFactorySettings settings) {
        ConnectionFactory connectionFactory = this.createConnectionFactory(settings);
        java.time.Duration evictionInterval = settings.maxIdleTime().$less$eq((Object)Duration$.MODULE$.Zero()) && settings.maxLifeTime().$less$eq((Object)Duration$.MODULE$.Zero()) ? java.time.Duration.ZERO : (settings.maxIdleTime().$less$eq((Object)Duration$.MODULE$.Zero()) ? java.time.Duration.ofMillis(settings.maxLifeTime().$div(4L).toMillis()) : (settings.maxLifeTime().$less$eq((Object)Duration$.MODULE$.Zero()) ? java.time.Duration.ofMillis(settings.maxIdleTime().$div(4L).toMillis()) : java.time.Duration.ofMillis(settings.maxIdleTime().min(settings.maxIdleTime()).$div(4L).toMillis())));
        ConnectionPoolConfiguration.Builder poolConfiguration = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).initialSize(settings.initialSize()).maxSize(settings.maxSize()).maxAcquireTime(java.time.Duration.ofMillis(settings.acquireTimeout().toMillis())).acquireRetry(settings.acquireRetry()).maxIdleTime(java.time.Duration.ofMillis(settings.maxIdleTime().toMillis())).maxLifeTime(java.time.Duration.ofMillis(settings.maxLifeTime().toMillis())).backgroundEvictionInterval(evictionInterval);
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(settings.validationQuery())) ? poolConfiguration.validationQuery(settings.validationQuery()) : BoxedUnit.UNIT;
        ConnectionPool pool = new ConnectionPool(poolConfiguration.build());
        R2dbcExecutor$PublisherOps$.MODULE$.asFutureDone$extension(R2dbcExecutor$.MODULE$.PublisherOps(pool.warmup()));
        return pool;
    }

    public ConnectionFactoryProvider(ActorSystem<?> system) {
        this.system = system;
        this.sessions = new ConcurrentHashMap();
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system)).addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "close connection pools", (Function0 & Serializable)() -> Future$.MODULE$.sequence((IterableOnce)((MapOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.sessions()).asScala()).values().map((Function1 & Serializable)x$1 -> R2dbcExecutor$PublisherOps$.MODULE$.asFutureDone$extension(R2dbcExecutor$.MODULE$.PublisherOps(x$1.disposeLater()))), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)$this.system.executionContext()).map((Function1 & Serializable)x$2 -> Done$.MODULE$, (ExecutionContext)$this.system.executionContext()));
    }
}

