/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.cleanup.scaladsl;

import akka.Done;
import akka.Done$;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.adapter.package;
import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.annotation.ApiMayChange;
import akka.annotation.InternalApi;
import akka.persistence.r2dbc.ConnectionFactoryProvider;
import akka.persistence.r2dbc.ConnectionFactoryProvider$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.R2dbcSettings$;
import akka.persistence.r2dbc.state.scaladsl.DurableStateDao;
import io.r2dbc.spi.ConnectionFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000b\u0016\u0005\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\b\u0001C\u0001w!)!\b\u0001C\u0001\u0001\"A!\t\u0001b\u0001\n\u0007i2\t\u0003\u0004P\u0001\u0001\u0006I\u0001\u0012\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019A\u0007\u0001)A\u0005A\"9\u0011\u000e\u0001b\u0001\n\u0013Q\u0007B\u0002:\u0001A\u0003%1\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\re\u0004\u0001\u0015!\u0003v\u0011\u001dQ\bA1A\u0005\nmDq!a\u0003\u0001A\u0003%A\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u0011\u0011\r\u0001\u0005\n\u0005\r$a\u0005#ve\u0006\u0014G.Z*uCR,7\t\\3b]V\u0004(B\u0001\f\u0018\u0003!\u00198-\u00197bINd'B\u0001\r\u001a\u0003\u001d\u0019G.Z1okBT!AG\u000e\u0002\u000bI\u0014DMY2\u000b\u0005qi\u0012a\u00039feNL7\u000f^3oG\u0016T\u0011AH\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\btsN$X-\u001c)s_ZLG-\u001a:\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-j\u0012!B1di>\u0014\u0018BA\u0017+\u0005i\u0019E.Y:tS\u000e\f5\r^8s'f\u001cH/Z7Qe>4\u0018\u000eZ3s\u0003)\u0019wN\u001c4jOB\u000bG\u000f\u001b\t\u0003a]r!!M\u001b\u0011\u0005I\u001aS\"A\u001a\u000b\u0005Qz\u0012A\u0002\u001fs_>$h(\u0003\u00027G\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t14%\u0001\u0004=S:LGO\u0010\u000b\u0004yyz\u0004CA\u001f\u0001\u001b\u0005)\u0002\"B\u0014\u0004\u0001\u0004A\u0003\"\u0002\u0018\u0004\u0001\u0004yCC\u0001\u001fB\u0011\u00159C\u00011\u0001)\u0003\u0019\u0019\u0018p\u001d;f[V\tA\t\r\u0002F\u001bB\u0019a)S&\u000e\u0003\u001dS!\u0001\u0013\u0016\u0002\u000bQL\b/\u001a3\n\u0005);%aC!di>\u00148+_:uK6\u0004\"\u0001T'\r\u0001\u0011IaJBA\u0001\u0002\u0003\u0015\ta\u0016\u0002\u0004?\u0012\n\u0014aB:zgR,W\u000e\t\u0015\u0003\rE\u0003\"AU+\u000e\u0003MS!\u0001V\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002W'\nY\u0011J\u001c;fe:\fG.\u00119j#\tA6\f\u0005\u0002#3&\u0011!l\t\u0002\b\u001d>$\b.\u001b8h!\t\u0011C,\u0003\u0002^G\t\u0019\u0011I\\=\u0002\u00071|w-F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-A\u0003tY\u001a$$NC\u0001f\u0003\ry'oZ\u0005\u0003O\n\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0001c\u001d5be\u0016$7i\u001c8gS\u001e\u0004\u0016\r\u001e5\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\t1\fgn\u001a\u0006\u0002a\u0006!!.\u0019<b\u0013\tAT.A\ttQ\u0006\u0014X\rZ\"p]\u001aLw\rU1uQ\u0002\n\u0001b]3ui&twm]\u000b\u0002kB\u0011ao^\u0007\u00023%\u0011\u00010\u0007\u0002\u000e%J\"'mY*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013!E2p]:,7\r^5p]\u001a\u000b7\r^8ssV\tA\u0010E\u0002~\u0003\u000fi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011aA:qS*\u0019!$a\u0001\u000b\u0005\u0005\u0015\u0011AA5p\u0013\r\tIA \u0002\u0012\u0007>tg.Z2uS>tg)Y2u_JL\u0018AE2p]:,7\r^5p]\u001a\u000b7\r^8ss\u0002\n\u0001b\u001d;bi\u0016$\u0015m\\\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001c5\u0011\u0011Q\u0003\u0006\u0004-\u0005]!bAA\r3\u0005)1\u000f^1uK&!\u0011QDA\u000b\u0005=!UO]1cY\u0016\u001cF/\u0019;f\t\u0006|\u0017!C:uCR,G)Y8!\u0003-!W\r\\3uKN#\u0018\r^3\u0015\r\u0005\u0015\u0012\u0011HA\u001f!\u0019\t9#!\f\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0019\u0013AC2p]\u000e,(O]3oi&!\u0011qFA\u0015\u0005\u00191U\u000f^;sKB!\u00111GA\u001b\u001b\u0005i\u0012bAA\u001c;\t!Ai\u001c8f\u0011\u0019\tY$\u0005a\u0001_\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012Dq!a\u0010\u0012\u0001\u0004\t\t%A\nsKN,GOU3wSNLwN\u001c(v[\n,'\u000fE\u0002#\u0003\u0007J1!!\u0012$\u0005\u001d\u0011un\u001c7fC:\fA\u0002Z3mKR,7\u000b^1uKN$b!!\n\u0002L\u0005}\u0003bBA'%\u0001\u0007\u0011qJ\u0001\u000fa\u0016\u00148/[:uK:\u001cW-\u00133t!\u0015\t\t&a\u00170\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!C5n[V$\u0018M\u00197f\u0015\r\tIfI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003'\u00121aU3r\u0011\u001d\tyD\u0005a\u0001\u0003\u0003\nqAZ8sK\u0006\u001c\u0007\u000e\u0006\u0005\u0002&\u0005\u0015\u0014qMA6\u0011\u001d\tie\u0005a\u0001\u0003\u001fBa!!\u001b\u0014\u0001\u0004y\u0013!D8qKJ\fG/[8o\u001d\u0006lW\rC\u0004\u0002nM\u0001\r!a\u001c\u0002\u0019ALGm\u00149fe\u0006$\u0018n\u001c8\u0011\r\t\n\thLA\u0013\u0013\r\t\u0019h\t\u0002\n\rVt7\r^5p]FB3\u0001AA<!\r\u0011\u0016\u0011P\u0005\u0004\u0003w\u001a&\u0001D!qS6\u000b\u0017p\u00115b]\u001e,\u0007")
@ApiMayChange
public final class DurableStateCleanup {
    @InternalApi
    private final ActorSystem<?> system;
    private final Logger log;
    private final String sharedConfigPath;
    private final R2dbcSettings settings;
    private final ConnectionFactory connectionFactory;
    private final DurableStateDao stateDao;

    public ActorSystem<?> system() {
        return this.system;
    }

    private Logger log() {
        return this.log;
    }

    private String sharedConfigPath() {
        return this.sharedConfigPath;
    }

    private R2dbcSettings settings() {
        return this.settings;
    }

    private ConnectionFactory connectionFactory() {
        return this.connectionFactory;
    }

    private DurableStateDao stateDao() {
        return this.stateDao;
    }

    public Future<Done> deleteState(String persistenceId, boolean resetRevisionNumber) {
        if (resetRevisionNumber) {
            return this.stateDao().deleteState(persistenceId, 0L);
        }
        return this.stateDao().readState(persistenceId).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                DurableStateDao.SerializedStateRow s = (DurableStateDao.SerializedStateRow)some.value();
                return this.stateDao().deleteState(persistenceId, s.revision() + 1L);
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)this.system().executionContext());
    }

    public Future<Done> deleteStates(Seq<String> persistenceIds, boolean resetRevisionNumber) {
        return this.foreach(persistenceIds, "deleteStates", (Function1<String, Future<Done>>)(Function1 & Serializable)pid -> this.deleteState((String)pid, resetRevisionNumber));
    }

    private Future<Done> foreach(Seq<String> persistenceIds, String operationName, Function1<String, Future<Done>> pidOperation) {
        int size = persistenceIds.size();
        this.log().info("Cleanup started {} of [{}] persistenceId.", (Object)operationName, (Object)BoxesRunTime.boxToInteger((int)size));
        Future result = this.loop$1(persistenceIds.toList(), 1, pidOperation, operationName, size);
        result.onComplete((Function1 & Serializable)x0$1 -> {
            DurableStateCleanup.$anonfun$foreach$2(this, operationName, size, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.system().executionContext());
        return result;
    }

    private final Future loop$1(List remaining, int n, Function1 pidOperation$1, String operationName$1, int size$1) {
        List list = remaining;
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String pid = (String)colon2.head();
            List tail = colon2.next$access$1();
            return ((Future)pidOperation$1.apply((Object)pid)).flatMap((Function1 & Serializable)x$1 -> {
                block0: {
                    if (n % this.settings().cleanupSettings().logProgressEvery() != 0) break block0;
                    package.LoggerOps$.MODULE$.infoN$extension(package$.MODULE$.LoggerOps(this.log()), "Cleanup {} [{}] of [{}].", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{operationName$1, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)size$1)}));
                }
                return this.loop$1(tail, n + 1, pidOperation$1, operationName$1, size$1);
            }, (ExecutionContext)this.system().executionContext());
        }
        throw new MatchError((Object)list);
    }

    public static final /* synthetic */ void $anonfun$foreach$2(DurableStateCleanup $this, String operationName$1, int size$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            package.LoggerOps$.MODULE$.info2$extension(package$.MODULE$.LoggerOps($this.log()), "Cleanup completed {} of [{}] persistenceId.", (Object)operationName$1, (Object)BoxesRunTime.boxToInteger((int)size$1));
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.log().error(new StringBuilder(18).append("Cleanup {").append(operationName$1).append("} failed.").toString(), e);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public DurableStateCleanup(ClassicActorSystemProvider systemProvider, String configPath) {
        this.system = package.ClassicActorSystemOps$.MODULE$.toTyped$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.ClassicActorSystemOps(systemProvider.classicSystem()));
        this.log = LoggerFactory.getLogger(DurableStateCleanup.class);
        this.sharedConfigPath = configPath.replaceAll("\\.cleanup$", "");
        this.settings = R2dbcSettings$.MODULE$.apply(this.system().settings().config().getConfig(this.sharedConfigPath()));
        this.connectionFactory = ((ConnectionFactoryProvider)ConnectionFactoryProvider$.MODULE$.apply(this.system())).connectionFactoryFor(new StringBuilder(19).append(this.sharedConfigPath()).append(".connection-factory").toString());
        this.stateDao = new DurableStateDao(this.settings(), this.connectionFactory(), (ExecutionContext)this.system().executionContext(), this.system());
    }

    public DurableStateCleanup(ClassicActorSystemProvider systemProvider) {
        this(systemProvider, "akka.persistence.r2dbc.cleanup");
    }
}

