/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.r2dbc.query.scaladsl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.scaladsl.package;
import akka.actor.typed.scaladsl.package$;
import akka.annotation.InternalApi;
import akka.persistence.r2dbc.Dialect;
import akka.persistence.r2dbc.Dialect$Postgres$;
import akka.persistence.r2dbc.Dialect$Yugabyte$;
import akka.persistence.r2dbc.R2dbcSettings;
import akka.persistence.r2dbc.internal.BySliceQuery;
import akka.persistence.r2dbc.internal.BySliceQuery$Buckets$;
import akka.persistence.r2dbc.internal.InstantFactory$;
import akka.persistence.r2dbc.internal.PayloadCodec;
import akka.persistence.r2dbc.internal.PayloadCodec$;
import akka.persistence.r2dbc.internal.R2dbcExecutor;
import akka.persistence.r2dbc.internal.Sql$;
import akka.persistence.r2dbc.internal.Sql$Interpolation$;
import akka.persistence.r2dbc.journal.JournalDao;
import akka.persistence.r2dbc.journal.JournalDao$;
import akka.persistence.r2dbc.query.scaladsl.QueryDao$;
import akka.persistence.typed.PersistenceId$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}w!\u0002\u00180\u0011\u0003Qd!\u0002\u001f0\u0011\u0003i\u0004\"\u0002#\u0002\t\u0003)\u0005b\u0002$\u0002\u0005\u0004%\ta\u0012\u0005\u0007!\u0006\u0001\u000b\u0011\u0002%\t\u000bE\u000bA\u0011\u0002*\u0007\u000bqz\u0003aM8\t\u0015\u0005]aA!A!\u0002\u0013\tI\u0002\u0003\u0006\u0002\"\u0019\u0011\t\u0011)A\u0005\u0003GA!\"!\u000e\u0007\u0005\u0003\u0005\u000b1BA\u001c\u0011)\t\u0019E\u0002B\u0001B\u0003-\u0011Q\t\u0005\u0007\t\u001a!\t!!\u0018\t\u0013\u0005MdA1A\u0005\n\u0005U\u0004\u0002CA?\r\u0001\u0006I!a\u001e\t\u0013\u0005}dA1A\u0005\f\u0005\u0005\u0005\u0002CAE\r\u0001\u0006I!a!\t\u0013\u0005-eA1A\u0005\n\u00055\u0005\u0002CAO\r\u0001\u0006I!a$\t\u000f\u0005}e\u0001\"\u0003\u0002\"\"9\u0011q\u001a\u0004\u0005\n\u0005E\u0007bBAl\r\u0011%\u0011\u0011\u001c\u0005\n\u0003?4!\u0019!C\u0005\u0003kB\u0001\"!9\u0007A\u0003%\u0011q\u000f\u0005\n\u0003G4!\u0019!C\u0005\u0003kB\u0001\"!:\u0007A\u0003%\u0011q\u000f\u0005\n\u0003O4!\u0019!C\u0005\u0003kB\u0001\"!;\u0007A\u0003%\u0011q\u000f\u0005\n\u0003W4!\u0019!C\u0005\u0003kB\u0001\"!<\u0007A\u0003%\u0011q\u000f\u0005\n\u0003_4!\u0019!C\u0005\u0003kB\u0001\"!=\u0007A\u0003%\u0011q\u000f\u0005\n\u0003g4!\u0019!C\u0005\u0003kB\u0001\"!>\u0007A\u0003%\u0011q\u000f\u0005\n\u0003o4!\u0019!C\u0005\u0003kB\u0001\"!?\u0007A\u0003%\u0011q\u000f\u0005\n\u0003w4!\u0019!C\u0005\u0003{D\u0001B!\u0002\u0007A\u0003%\u0011q \u0005\b\u0005\u000f1A\u0011\u0001B\u0005\u0011\u001d\u0011iB\u0002C\u0001\u0005?AqA!\u0015\u0007\t\u0003\u0012\u0019\u0006C\u0004\u0003\n\u001a!\tEa#\t\u000f\t5e\u0001\"\u0001\u0003\u0010\"9!\u0011\u0015\u0004\u0005\u0002\t\r\u0006b\u0002BW\r\u0011\u0005!q\u0016\u0005\b\u0005w3A\u0011\u0001B_\u0011\u001d\u0011YL\u0002C\u0001\u0005\u0017\f\u0001\"U;fef$\u0015m\u001c\u0006\u0003aE\n\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003eM\nQ!];fefT!\u0001N\u001b\u0002\u000bI\u0014DMY2\u000b\u0005Y:\u0014a\u00039feNL7\u000f^3oG\u0016T\u0011\u0001O\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005m\nQ\"A\u0018\u0003\u0011E+XM]=EC>\u001c\"!\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!(A\u0002m_\u001e,\u0012\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000bQa\u001d7gi)T\u0011!T\u0001\u0004_J<\u0017BA(K\u0005\u0019aunZ4fe\u0006!An\\4!\u0003%\u0019X\r\u001e$s_6$%-\u0006\u0002TCR\u0011AK\u001b\t\u0004+r{fB\u0001,[!\t9\u0006)D\u0001Y\u0015\tI\u0016(\u0001\u0004=e>|GOP\u0005\u00037\u0002\u000ba\u0001\u0015:fI\u00164\u0017BA/_\u0005\r\u0019V\r\u001e\u0006\u00037\u0002\u0003\"\u0001Y1\r\u0001\u0011)!-\u0002b\u0001G\n\tA+\u0005\u0002eOB\u0011q(Z\u0005\u0003M\u0002\u0013qAT8uQ&tw\r\u0005\u0002@Q&\u0011\u0011\u000e\u0011\u0002\u0004\u0003:L\b\"B6\u0006\u0001\u0004a\u0017!B1se\u0006L\bcA n?&\u0011a\u000e\u0011\u0002\u0006\u0003J\u0014\u0018-_\n\u0004\ry\u0002\bcA9xu:\u0011!/^\u0007\u0002g*\u0011AoM\u0001\tS:$XM\u001d8bY&\u0011ao]\u0001\r\u0005f\u001cF.[2f#V,'/_\u0005\u0003qf\u00141\u0001R1p\u0015\t18\u000fE\u0002|\u0003#q1\u0001`A\u0006\u001d\ri\u0018q\u0001\b\u0004}\u0006\u0015abA@\u0002\u00049\u0019q+!\u0001\n\u0003aJ!AN\u001c\n\u0005Q*\u0014bAA\u0005g\u00059!n\\;s]\u0006d\u0017\u0002BA\u0007\u0003\u001f\t!BS8ve:\fG\u000eR1p\u0015\r\tIaM\u0005\u0005\u0003'\t)B\u0001\u000bTKJL\u0017\r\\5{K\u0012Tu.\u001e:oC2\u0014vn\u001e\u0006\u0005\u0003\u001b\ty!\u0001\u0005tKR$\u0018N\\4t!\u0011\tY\"!\b\u000e\u0003MJ1!a\b4\u00055\u0011&\u0007\u001a2d'\u0016$H/\u001b8hg\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0011\t\u0005\u0015\u0012\u0011G\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005\u00191\u000f]5\u000b\u0007Q\niC\u0003\u0002\u00020\u0005\u0011\u0011n\\\u0005\u0005\u0003g\t9CA\tD_:tWm\u0019;j_:4\u0015m\u0019;pef\f!!Z2\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010A\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0003\nYD\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u000611/_:uK6\u0004D!a\u0012\u0002ZA1\u0011\u0011JA*\u0003/j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0006if\u0004X\r\u001a\u0006\u0004\u0003#:\u0014!B1di>\u0014\u0018\u0002BA+\u0003\u0017\u00121\"Q2u_J\u001c\u0016p\u001d;f[B\u0019\u0001-!\u0017\u0005\u0015\u0005m#\"!A\u0001\u0002\u000b\u00051MA\u0002`IE\"b!a\u0018\u0002p\u0005EDCBA1\u0003G\n)\u0007\u0005\u0002<\r!9\u0011QG\u0006A\u0004\u0005]\u0002bBA\"\u0017\u0001\u000f\u0011q\r\u0019\u0005\u0003S\ni\u0007\u0005\u0004\u0002J\u0005M\u00131\u000e\t\u0004A\u00065DaCA.\u0003K\n\t\u0011!A\u0003\u0002\rDq!a\u0006\f\u0001\u0004\tI\u0002C\u0004\u0002\"-\u0001\r!a\t\u0002\u0019)|WO\u001d8bYR\u000b'\r\\3\u0016\u0005\u0005]\u0004cA+\u0002z%\u0019\u00111\u00100\u0003\rM#(/\u001b8h\u00035Qw.\u001e:oC2$\u0016M\u00197fA\u0005\u0019\"n\\;s]\u0006d\u0007+Y=m_\u0006$7i\u001c3fGV\u0011\u00111\u0011\t\u0004e\u0006\u0015\u0015bAADg\na\u0001+Y=m_\u0006$7i\u001c3fG\u0006!\"n\\;s]\u0006d\u0007+Y=m_\u0006$7i\u001c3fG\u0002\nQcY;se\u0016tG\u000f\u00122US6,7\u000f^1naN\u000bH.\u0006\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00027b]\u001eT!!!'\u0002\t)\fg/Y\u0005\u0005\u0003w\n\u0019*\u0001\fdkJ\u0014XM\u001c;EERKW.Z:uC6\u00048+\u001d7!\u0003Y)g/\u001a8ug\nK8\u000b\\5dKN\u0014\u0016M\\4f'FdG\u0003DA<\u0003G\u000bi+!0\u0002B\u0006-\u0007bBAS%\u0001\u0007\u0011qU\u0001\u0013i>$%\rV5nKN$\u0018-\u001c9QCJ\fW\u000eE\u0002@\u0003SK1!a+A\u0005\u001d\u0011un\u001c7fC:Dq!a,\u0013\u0001\u0004\t\t,A\tcK\"Lg\u000eZ\"veJ,g\u000e\u001e+j[\u0016\u0004B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bY$\u0001\u0005ekJ\fG/[8o\u0013\u0011\tY,!.\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"9\u0011q\u0018\nA\u0002\u0005\u001d\u0016\u0001\u00042bG.$(/Y2lS:<\u0007bBAb%\u0001\u0007\u0011QY\u0001\t[&t7\u000b\\5dKB\u0019q(a2\n\u0007\u0005%\u0007IA\u0002J]RDq!!4\u0013\u0001\u0004\t)-\u0001\u0005nCb\u001cF.[2f\u00039\u0019H.[2f\u0007>tG-\u001b;j_:$b!a\u001e\u0002T\u0006U\u0007bBAb'\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u001b\u001c\u0002\u0019AAc\u0003A\u0019X\r\\3di\n+8m[3ugN\u000bH\u000e\u0006\u0004\u0002x\u0005m\u0017Q\u001c\u0005\b\u0003\u0007$\u0002\u0019AAc\u0011\u001d\ti\r\u0006a\u0001\u0003\u000b\f\u0011d]3mK\u000e$H+[7fgR\fW\u000e](g\u000bZ,g\u000e^*rY\u0006Q2/\u001a7fGR$\u0016.\\3ti\u0006l\u0007o\u00144Fm\u0016tGoU9mA\u0005\t2/\u001a7fGR|e.Z#wK:$8+\u001d7\u0002%M,G.Z2u\u001f:,WI^3oiN\u000bH\u000eI\u0001\u0010g\u0016dWm\u0019;Fm\u0016tGo]*rY\u0006\u00012/\u001a7fGR,e/\u001a8ugN\u000bH\u000eI\u0001\u0015C2d\u0007+\u001a:tSN$XM\\2f\u0013\u0012\u001c8+\u001d7\u0002+\u0005dG\u000eU3sg&\u001cH/\u001a8dK&#7oU9mA\u0005q\u0002/\u001a:tSN$XM\\2f\u0013\u0012\u001chi\u001c:F]RLG/\u001f+za\u0016\u001c\u0016\u000f\\\u0001 a\u0016\u00148/[:uK:\u001cW-\u00133t\r>\u0014XI\u001c;jif$\u0016\u0010]3Tc2\u0004\u0013!G1mYB+'o]5ti\u0016t7-Z%eg\u00063G/\u001a:Tc2\f!$\u00197m!\u0016\u00148/[:uK:\u001cW-\u00133t\u0003\u001a$XM]*rY\u0002\n1\u0005]3sg&\u001cH/\u001a8dK&#7OR8s\u000b:$\u0018\u000e^=UsB,\u0017I\u001a;feN\u000bH.\u0001\u0013qKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ:G_J,e\u000e^5usRK\b/Z!gi\u0016\u00148+\u001d7!\u00035\u0011(\u0007\u001a2d\u000bb,7-\u001e;peV\u0011\u0011q \t\u0004e\n\u0005\u0011b\u0001B\u0002g\ni!K\r3cG\u0016CXmY;u_J\faB\u001d\u001aeE\u000e,\u00050Z2vi>\u0014\b%\u0001\ndkJ\u0014XM\u001c;EERKW.Z:uC6\u0004HC\u0001B\u0006!\u0019\tID!\u0004\u0003\u0012%!!qBA\u001e\u0005\u00191U\u000f^;sKB!!1\u0003B\r\u001b\t\u0011)B\u0003\u0003\u0003\u0018\u0005]\u0015\u0001\u0002;j[\u0016LAAa\u0007\u0003\u0016\t9\u0011J\\:uC:$\u0018\u0001\u0004:poN\u0014\u0015p\u00157jG\u0016\u001cH\u0003\u0005B\u0011\u0005o\u0011YD!\u0010\u0003@\t\r#Q\nB(!\u001d\u0011\u0019Ca\u000b{\u0005_i!A!\n\u000b\u0007A\u00129CC\u0002\u0003*]\naa\u001d;sK\u0006l\u0017\u0002\u0002B\u0017\u0005K\u0011aaU8ve\u000e,\u0007\u0003\u0002B\u0019\u0005gi\u0011aN\u0005\u0004\u0005k9$a\u0002(piV\u001bX\r\u001a\u0005\b\u0005s1\u0003\u0019AA<\u0003))g\u000e^5usRK\b/\u001a\u0005\b\u0003\u00074\u0003\u0019AAc\u0011\u001d\tiM\na\u0001\u0003\u000bDqA!\u0011'\u0001\u0004\u0011\t\"A\u0007ge>lG+[7fgR\fW\u000e\u001d\u0005\b\u0005\u000b2\u0003\u0019\u0001B$\u0003-!x\u000eV5nKN$\u0018-\u001c9\u0011\u000b}\u0012IE!\u0005\n\u0007\t-\u0003I\u0001\u0004PaRLwN\u001c\u0005\b\u0003_3\u0003\u0019AAY\u0011\u001d\tyL\na\u0001\u0003O\u000bAbY8v]R\u0014UoY6fiN$BB!\u0016\u0003~\t}$\u0011\u0011BB\u0005\u000b\u0003b!!\u000f\u0003\u000e\t]\u0003C\u0002B-\u0005G\u0012IG\u0004\u0003\u0003\\\t}cbA,\u0003^%\t\u0011)C\u0002\u0003b\u0001\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003f\t\u001d$aA*fc*\u0019!\u0011\r!\u0011\t\t-$q\u000f\b\u0005\u0005[\u0012\u0019HD\u0002\u0003pUt1! B9\u0013\t!8'C\u0002\u0003ve\fqAQ;dW\u0016$8/\u0003\u0003\u0003z\tm$A\u0002\"vG.,GOC\u0002\u0003veDqA!\u000f(\u0001\u0004\t9\bC\u0004\u0002D\u001e\u0002\r!!2\t\u000f\u00055w\u00051\u0001\u0002F\"9!\u0011I\u0014A\u0002\tE\u0001b\u0002BDO\u0001\u0007\u0011QY\u0001\u0006Y&l\u0017\u000e^\u0001\u0016G>,h\u000e\u001e\"vG.,Go]'bs\u000eC\u0017M\\4f+\t\t9+\u0001\tuS6,7\u000f^1na>3WI^3oiR1!\u0011\u0013BJ\u0005/\u0003b!!\u000f\u0003\u000e\t\u001d\u0003b\u0002BKS\u0001\u0007\u0011qO\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\t\u000f\te\u0015\u00061\u0001\u0003\u001c\u0006)1/Z9OeB\u0019qH!(\n\u0007\t}\u0005I\u0001\u0003M_:<\u0017!\u00037pC\u0012,e/\u001a8u)\u0019\u0011)K!+\u0003,B1\u0011\u0011\bB\u0007\u0005O\u0003Ba\u0010B%u\"9!Q\u0013\u0016A\u0002\u0005]\u0004b\u0002BMU\u0001\u0007!1T\u0001\u0016KZ,g\u000e^:CsB+'o]5ti\u0016t7-Z%e)!\u0011\tC!-\u00034\n]\u0006b\u0002BKW\u0001\u0007\u0011q\u000f\u0005\b\u0005k[\u0003\u0019\u0001BN\u000391'o\\7TKF,XM\\2f\u001dJDqA!/,\u0001\u0004\u0011Y*\u0001\u0007u_N+\u0017/^3oG\u0016t%/\u0001\bqKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ:\u0015\u0011\t}&\u0011\u0019Bb\u0005\u0013\u0004\u0002Ba\t\u0003,\u0005]$q\u0006\u0005\b\u0005sa\u0003\u0019AA<\u0011\u001d\u0011)\r\fa\u0001\u0005\u000f\fq!\u00194uKJLE\rE\u0003@\u0005\u0013\n9\bC\u0004\u0003\b2\u0002\rAa'\u0015\r\t}&Q\u001aBh\u0011\u001d\u0011)-\fa\u0001\u0005\u000fDqAa\".\u0001\u0004\u0011Y\nK\u0002\u0007\u0005'\u0004BA!6\u0003\\6\u0011!q\u001b\u0006\u0004\u00053<\u0014AC1o]>$\u0018\r^5p]&!!Q\u001cBl\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public class QueryDao
implements BySliceQuery.Dao<JournalDao.SerializedJournalRow> {
    private final R2dbcSettings settings;
    private final ExecutionContext ec;
    private final String journalTable;
    private final PayloadCodec journalPayloadCodec;
    private final String currentDbTimestampSql;
    private final String selectTimestampOfEventSql;
    private final String selectOneEventSql;
    private final String selectEventsSql;
    private final String allPersistenceIdsSql;
    private final String persistenceIdsForEntityTypeSql;
    private final String allPersistenceIdsAfterSql;
    private final String persistenceIdsForEntityTypeAfterSql;
    private final R2dbcExecutor r2dbcExecutor;

    public static Logger log() {
        return QueryDao$.MODULE$.log();
    }

    private String journalTable() {
        return this.journalTable;
    }

    private PayloadCodec journalPayloadCodec() {
        return this.journalPayloadCodec;
    }

    private String currentDbTimestampSql() {
        return this.currentDbTimestampSql;
    }

    private String eventsBySlicesRangeSql(boolean toDbTimestampParam, FiniteDuration behindCurrentTime, boolean backtracking, int minSlice, int maxSlice) {
        String selectColumns = backtracking ? "SELECT slice, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp, tags " : "SELECT slice, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp, tags, event_ser_id, event_ser_manifest, event_payload, meta_ser_id, meta_ser_manifest, meta_payload ";
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      FROM ", "\n      WHERE entity_type = ?\n      AND ", "\n      AND db_timestamp >= ? ", " ", "\n      AND deleted = false\n      ORDER BY db_timestamp, seq_nr\n      LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{selectColumns, this.journalTable(), this.sliceCondition(minSlice, maxSlice), QueryDao.toDbTimestampParamCondition$1(toDbTimestampParam), QueryDao.behindCurrentTimeIntervalCondition$1(behindCurrentTime)}));
    }

    private String sliceCondition(int minSlice, int maxSlice) {
        Dialect dialect = this.settings.dialect();
        if (Dialect$Yugabyte$.MODULE$.equals(dialect)) {
            return new StringBuilder(19).append("slice BETWEEN ").append(minSlice).append(" AND ").append(maxSlice).toString();
        }
        if (Dialect$Postgres$.MODULE$.equals(dialect)) {
            return new StringBuilder(11).append("slice in (").append(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(minSlice), maxSlice).mkString(",")).append(")").toString();
        }
        throw new MatchError((Object)dialect);
    }

    private String selectBucketsSql(int minSlice, int maxSlice) {
        return Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT extract(EPOCH from db_timestamp)::BIGINT / 10 AS bucket, count(*) AS count\n      FROM ", "\n      WHERE entity_type = ?\n      AND ", "\n      AND db_timestamp >= ? AND db_timestamp <= ?\n      AND deleted = false\n      GROUP BY bucket ORDER BY bucket LIMIT ?\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable(), this.sliceCondition(minSlice, maxSlice)}));
    }

    private String selectTimestampOfEventSql() {
        return this.selectTimestampOfEventSql;
    }

    private String selectOneEventSql() {
        return this.selectOneEventSql;
    }

    private String selectEventsSql() {
        return this.selectEventsSql;
    }

    private String allPersistenceIdsSql() {
        return this.allPersistenceIdsSql;
    }

    private String persistenceIdsForEntityTypeSql() {
        return this.persistenceIdsForEntityTypeSql;
    }

    private String allPersistenceIdsAfterSql() {
        return this.allPersistenceIdsAfterSql;
    }

    private String persistenceIdsForEntityTypeAfterSql() {
        return this.persistenceIdsForEntityTypeAfterSql;
    }

    private R2dbcExecutor r2dbcExecutor() {
        return this.r2dbcExecutor;
    }

    @Override
    public Future<Instant> currentDbTimestamp() {
        return this.r2dbcExecutor().selectOne("select current db timestamp", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.currentDbTimestampSql()), (Function1 & Serializable)row -> (Instant)row.get("db_timestamp", Instant.class)).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Instant time = (Instant)some.value();
                return time;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(22).append("Expected one row for: ").append(this.currentDbTimestampSql()).toString());
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    @Override
    public Source<JournalDao.SerializedJournalRow, NotUsed> rowsBySlices(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, Option<Instant> toTimestamp, FiniteDuration behindCurrentTime, boolean backtracking) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(27).append("select eventsBySlices [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Statement stmt = connection.createStatement(this.eventsBySlicesRangeSql(toTimestamp.isDefined(), behindCurrentTime, backtracking, minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp);
                Option option = toTimestamp;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant until = (Instant)some.value();
                    stmt.bind(2, (Object)until);
                    stmt.bind(3, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else if (None$.MODULE$.equals(option)) {
                    stmt.bind(2, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize()));
                } else {
                    throw new MatchError((Object)option);
                }
                return stmt;
            }, (Function1 & Serializable)row -> {
                if (backtracking) {
                    return new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), entityType, (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)None$.MODULE$, 0, "", "", QueryDao$.MODULE$.akka$persistence$r2dbc$query$scaladsl$QueryDao$$setFromDb(row.get("tags", String[].class)), (Option<JournalDao.SerializedEventMetadata>)None$.MODULE$);
                }
                return new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), entityType, (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some((Object)PayloadCodec$.MODULE$.RichRow((Row)row, this.journalPayloadCodec()).getPayload("event_payload")), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), "", QueryDao$.MODULE$.akka$persistence$r2dbc$query$scaladsl$QueryDao$$setFromDb(row.get("tags", String[].class)), JournalDao$.MODULE$.readMetadata((Row)row));
            });
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                package.LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(QueryDao$.MODULE$.log()), "Read [{}] events from slices [{} - {}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice), BoxesRunTime.boxToInteger((int)maxSlice)}));
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$1 -> Source$.MODULE$.apply((Iterable)x$1), this.ec)).mapMaterializedValue((Function1 & Serializable)x$2 -> NotUsed$.MODULE$);
    }

    @Override
    public Future<Seq<BySliceQuery.Buckets.Bucket>> countBuckets(String entityType, int minSlice, int maxSlice, Instant fromTimestamp, int limit) {
        Future result;
        block2: {
            Instant instant;
            Instant now = InstantFactory$.MODULE$.now();
            Instant instant2 = fromTimestamp;
            Instant instant3 = Instant.EPOCH;
            if (!(instant2 != null ? !((Object)instant2).equals(instant3) : instant3 != null)) {
                instant = now;
            } else {
                Instant t = fromTimestamp.plusSeconds(BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds() * limit + BySliceQuery$Buckets$.MODULE$.BucketDurationSeconds());
                instant = t.isAfter(now) ? now : t;
            }
            Instant toTimestamp = instant;
            result = this.r2dbcExecutor().select(new StringBuilder(26).append("select bucket counts [").append(minSlice).append(" - ").append(maxSlice).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectBucketsSql(minSlice, maxSlice)).bind(0, (Object)entityType).bind(1, (Object)fromTimestamp).bind(2, (Object)toTimestamp).bind(3, (Object)BoxesRunTime.boxToInteger((int)limit)), (Function1 & Serializable)row -> {
                long bucketStartEpochSeconds = Predef$.MODULE$.Long2long((Long)row.get("bucket", Long.class)) * 10L;
                long count = Predef$.MODULE$.Long2long((Long)row.get("count", Long.class));
                return new BySliceQuery.Buckets.Bucket(bucketStartEpochSeconds, count);
            });
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block2;
            result.foreach((Function1 & Serializable)rows -> {
                package.LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(QueryDao$.MODULE$.log()), "Read [{}] bucket counts from slices [{} - {}]", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rows.size()), BoxesRunTime.boxToInteger((int)minSlice), BoxesRunTime.boxToInteger((int)maxSlice)}));
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return result;
    }

    @Override
    public boolean countBucketsMayChange() {
        return false;
    }

    public Future<Option<Instant>> timestampOfEvent(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().selectOne("select timestampOfEvent", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectTimestampOfEventSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr)), (Function1 & Serializable)row -> (Instant)row.get("db_timestamp", Instant.class));
    }

    public Future<Option<JournalDao.SerializedJournalRow>> loadEvent(String persistenceId, long seqNr) {
        return this.r2dbcExecutor().selectOne("select one event", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectOneEventSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)seqNr)), (Function1 & Serializable)row -> new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), (String)row.get("entity_type", String.class), persistenceId, seqNr, (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some((Object)PayloadCodec$.MODULE$.RichRow((Row)row, this.journalPayloadCodec()).getPayload("event_payload")), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), "", QueryDao$.MODULE$.akka$persistence$r2dbc$query$scaladsl$QueryDao$$setFromDb(row.get("tags", String[].class)), JournalDao$.MODULE$.readMetadata((Row)row)));
    }

    public Source<JournalDao.SerializedJournalRow, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select(new StringBuilder(31).append("select eventsByPersistenceId [").append(persistenceId).append("]").toString(), (Function1<Connection, Statement>)(Function1 & Serializable)connection -> connection.createStatement(this.selectEventsSql()).bind(0, (Object)persistenceId).bind(1, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr)).bind(2, (Object)BoxesRunTime.boxToLong((long)toSequenceNr)).bind(3, (Object)BoxesRunTime.boxToInteger((int)$this.settings.querySettings().bufferSize())), (Function1 & Serializable)row -> new JournalDao.SerializedJournalRow(Predef$.MODULE$.Integer2int((Integer)row.get("slice", Integer.class)), (String)row.get("entity_type", String.class), (String)row.get("persistence_id", String.class), Predef$.MODULE$.Long2long((Long)row.get("seq_nr", Long.class)), (Instant)row.get("db_timestamp", Instant.class), (Instant)row.get("read_db_timestamp", Instant.class), (Option<byte[]>)new Some((Object)PayloadCodec$.MODULE$.RichRow((Row)row, this.journalPayloadCodec()).getPayload("event_payload")), Predef$.MODULE$.Integer2int((Integer)row.get("event_ser_id", Integer.class)), (String)row.get("event_ser_manifest", String.class), (String)row.get("writer", String.class), QueryDao$.MODULE$.akka$persistence$r2dbc$query$scaladsl$QueryDao$$setFromDb(row.get("tags", String[].class)), JournalDao$.MODULE$.readMetadata((Row)row)));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$eventsByPersistenceId$3(persistenceId, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$3 -> Source$.MODULE$.apply((Iterable)x$3), this.ec)).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$);
    }

    public Source<String, NotUsed> persistenceIds(String entityType, Option<String> afterId, long limit) {
        Future result;
        block0: {
            String likeStmtPostfix = new StringBuilder(1).append(PersistenceId$.MODULE$.DefaultSeparator()).append("%").toString();
            result = this.r2dbcExecutor().select("select persistenceIds by entity type", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Option option = afterId;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String after = (String)some.value();
                    return connection.createStatement(this.persistenceIdsForEntityTypeAfterSql()).bind(0, (Object)new StringBuilder(0).append(entityType).append(likeStmtPostfix).toString()).bind(1, (Object)after).bind(2, (Object)BoxesRunTime.boxToLong((long)limit));
                }
                if (None$.MODULE$.equals(option)) {
                    return connection.createStatement(this.persistenceIdsForEntityTypeSql()).bind(0, (Object)new StringBuilder(0).append(entityType).append(likeStmtPostfix).toString()).bind(1, (Object)BoxesRunTime.boxToLong((long)limit));
                }
                throw new MatchError((Object)option);
            }, (Function1 & Serializable)row -> (String)row.get("persistence_id", String.class));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$persistenceIds$3(entityType, rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$5 -> Source$.MODULE$.apply((Iterable)x$5), this.ec)).mapMaterializedValue((Function1 & Serializable)x$6 -> NotUsed$.MODULE$);
    }

    public Source<String, NotUsed> persistenceIds(Option<String> afterId, long limit) {
        Future result;
        block0: {
            result = this.r2dbcExecutor().select("select persistenceIds", (Function1<Connection, Statement>)(Function1 & Serializable)connection -> {
                Option option = afterId;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String after = (String)some.value();
                    return connection.createStatement(this.allPersistenceIdsAfterSql()).bind(0, (Object)after).bind(1, (Object)BoxesRunTime.boxToLong((long)limit));
                }
                if (None$.MODULE$.equals(option)) {
                    return connection.createStatement(this.allPersistenceIdsSql()).bind(0, (Object)BoxesRunTime.boxToLong((long)limit));
                }
                throw new MatchError((Object)option);
            }, (Function1 & Serializable)row -> (String)row.get("persistence_id", String.class));
            if (!QueryDao$.MODULE$.log().isDebugEnabled()) break block0;
            result.foreach((Function1 & Serializable)rows -> {
                QueryDao.$anonfun$persistenceIds$8(rows);
                return BoxedUnit.UNIT;
            }, this.ec);
        }
        return Source$.MODULE$.futureSource(result.map((Function1 & Serializable)x$7 -> Source$.MODULE$.apply((Iterable)x$7), this.ec)).mapMaterializedValue((Function1 & Serializable)x$8 -> NotUsed$.MODULE$);
    }

    private static final String toDbTimestampParamCondition$1(boolean toDbTimestampParam$1) {
        if (toDbTimestampParam$1) {
            return "AND db_timestamp <= ?";
        }
        return "";
    }

    private static final String behindCurrentTimeIntervalCondition$1(FiniteDuration behindCurrentTime$1) {
        if (behindCurrentTime$1.$greater((Object)Duration$.MODULE$.Zero())) {
            return new StringBuilder(69).append("AND db_timestamp < transaction_timestamp() - interval '").append(behindCurrentTime$1.toMillis()).append(" milliseconds'").toString();
        }
        return "";
    }

    public static final /* synthetic */ void $anonfun$eventsByPersistenceId$3(String persistenceId$3, IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] events for persistenceId [{}]", (Object)BoxesRunTime.boxToInteger((int)rows.size()), (Object)persistenceId$3);
    }

    public static final /* synthetic */ void $anonfun$persistenceIds$3(String entityType$3, IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] persistence ids by entity type [{}]", (Object)BoxesRunTime.boxToInteger((int)rows.size()), (Object)entityType$3);
    }

    public static final /* synthetic */ void $anonfun$persistenceIds$8(IndexedSeq rows) {
        QueryDao$.MODULE$.log().debug("Read [{}] persistence ids", (Object)BoxesRunTime.boxToInteger((int)rows.size()));
    }

    public QueryDao(R2dbcSettings settings, ConnectionFactory connectionFactory, ExecutionContext ec, ActorSystem<?> system) {
        this.settings = settings;
        this.ec = ec;
        this.journalTable = settings.journalTableWithSchema();
        this.journalPayloadCodec = settings.journalPayloadCodec();
        this.currentDbTimestampSql = "SELECT transaction_timestamp() AS db_timestamp";
        this.selectTimestampOfEventSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT db_timestamp FROM ", "\n    WHERE persistence_id = ? AND seq_nr = ? AND deleted = false"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.selectOneEventSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT slice, entity_type, db_timestamp, statement_timestamp() AS read_db_timestamp, event_ser_id, event_ser_manifest, event_payload, meta_ser_id, meta_ser_manifest, meta_payload, tags\n    FROM ", "\n    WHERE persistence_id = ? AND seq_nr = ? AND deleted = false"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.selectEventsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    SELECT slice, entity_type, persistence_id, seq_nr, db_timestamp, statement_timestamp() AS read_db_timestamp, event_ser_id, event_ser_manifest, event_payload, writer, adapter_manifest, meta_ser_id, meta_ser_manifest, meta_payload, tags\n    from ", "\n    WHERE persistence_id = ? AND seq_nr >= ? AND seq_nr <= ?\n    AND deleted = false\n    ORDER BY seq_nr\n    LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.allPersistenceIdsSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.persistenceIdsForEntityTypeSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " WHERE persistence_id LIKE ? ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.allPersistenceIdsAfterSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " WHERE persistence_id > ? ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.persistenceIdsForEntityTypeAfterSql = Sql$Interpolation$.MODULE$.sql$extension(Sql$.MODULE$.Interpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT DISTINCT(persistence_id) from ", " WHERE persistence_id LIKE ? AND persistence_id > ? ORDER BY persistence_id LIMIT ?"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.journalTable()}));
        this.r2dbcExecutor = new R2dbcExecutor(connectionFactory, QueryDao$.MODULE$.log(), settings.logDbCallsExceeding(), settings.connectionFactorySettings().closeCallsExceeding(), ec, system);
    }
}

